/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IDccOspfArea;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.IOspfAreaRange;
import cerent.cms.model.OspfAreaRange;
import cerent.cms.model.OspfLanConfigModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.OspfAreaRangeCreateDialog;
import cerent.cms.ui.shelf.OspfAreaRangeEditDialog;
import cerent.cms.ui.shelf.SppNetworkPane;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.AbstractTableModel;

public class OspfAreaRangePane
extends AbstractShelfEditTablePane {
    public static final int RANGE_ADDRESS = 0;
    public static final int AREA_RANGE = 1;
    public static final int MASK_LENGTH = 2;
    public static final int MASK_STRING = 3;
    public static final int ADVERTISE = 4;
    private OspfLanConfigModel ospfLanConfigModel;
    private static final SDebug db = new SDebug((KDebug)SppNetworkPane.db, "OspfAreaRangePane");
    static /* synthetic */ Class class$java$lang$Boolean;

    public OspfAreaRangePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    protected void initModels() {
        this.model = new OspfAreaRangeTableModel();
    }

    protected void populateTableData() {
        IOspfAreaRange[] iOspfAreaRangeArray = this.ospfLanConfigModel.getDccOspfAreaRanges();
        int n = iOspfAreaRangeArray.length;
        for (int i = 0; i < n; ++i) {
            this.tableData.add(iOspfAreaRangeArray[i]);
        }
    }

    public void destroy() {
        if (this.ospfLanConfigModel != null) {
            this.ospfLanConfigModel.deleteObserver((Observer)((Object)this));
            this.ospfLanConfigModel = null;
        }
        super.destroy();
        this.nodeModel = null;
    }

    public void createEntryIfEmptyTable() {
        if (this.table.getRowCount() < 1) {
            if (db.on()) {
                db.println("No rows; adding default row");
            }
            IIpConfig iIpConfig = this.nodeModel.getIpConfig();
            IIpAddr iIpAddr = iIpConfig.getIpAddress();
            short s = iIpConfig.getNetMaskPrefixLength();
            IIpAddr iIpAddr2 = InetUtil.makeIpAddr(InetUtil.makeNetMask(s));
            IDccOspfArea[] iDccOspfAreaArray = this.ospfLanConfigModel.getDccOspfAreaIdArray();
            int n = InetUtil.makeIpV4(iIpAddr);
            int n2 = InetUtil.makeIpV4(iIpAddr2);
            int n3 = n & n2;
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < iDccOspfAreaArray.length; ++i) {
                IIpAddr iIpAddr3 = iDccOspfAreaArray[i].getAreaId();
                String string = InetUtil.makeDottedString(iIpAddr3);
                if (hashSet.contains(string)) {
                    if (!db.on()) continue;
                    db.println("already got area ID" + i + string);
                    continue;
                }
                hashSet.add(string);
                if (db.on()) {
                    db.println("Creating entry for empty area range table");
                    db.println("\tRange Addr: " + InetUtil.makeDottedString(iIpAddr));
                    db.println("\tMask: " + InetUtil.makeDottedString(iIpAddr2));
                    db.println("\tresult: " + InetUtil.makeDottedString(n3));
                    db.println("\tArea ID: " + InetUtil.makeDottedString(iIpAddr3));
                }
                OspfAreaRange ospfAreaRange = new OspfAreaRange(iIpAddr3, InetUtil.makeIpAddr(n3), s, false);
                try {
                    this.ospfLanConfigModel.setOspfAreaRange(ospfAreaRange);
                    continue;
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)((Object)this), EMC.EID_OSPF_AREA_RANGE_SET_PARAM_2, InetUtil.makeDottedString(n3), new Short(s).toString());
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        } else if (db.on()) {
            db.println("Got rows; not adding default row");
        }
    }

    public void setEditDeleteEnabled(boolean bl) {
        super.setEditDeleteEnabled(bl);
        boolean bl2 = false;
        if (this.ospfLanConfigModel != null) {
            String string = InetUtil.makeDottedString(this.ospfLanConfigModel.getLanOspfConf().getAreaId());
            IDccOspfArea[] iDccOspfAreaArray = this.ospfLanConfigModel.getDccOspfAreaIdArray();
            if (iDccOspfAreaArray != null && iDccOspfAreaArray.length > 0) {
                for (int i = 0; i < iDccOspfAreaArray.length; ++i) {
                    String string2 = InetUtil.makeDottedString(iDccOspfAreaArray[i].getAreaId());
                    if (string == null || string.equals(string2)) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        this.createButton.setEnabled(bl2 && this.isUserAuthorized());
    }

    protected void createTableEntry() {
        OspfAreaRangeCreateDialog.instance(this).show();
    }

    protected void deleteSelectedTableEntry(int n) {
        IOspfAreaRange iOspfAreaRange = ((OspfAreaRangeTableModel)this.model).getAreaRange(n);
        if (CerentDialog.yesNoDialog((Component)((Object)this), (String)"Are you sure you want to delete this Area Range?", (String)"Confirmation Dialog")) {
            this.setEditDeleteEnabled(false);
            if (this.ospfLanConfigModel != null) {
                this.ospfLanConfigModel.deleteOspfAreaRange(iOspfAreaRange.getRangeAddress(), iOspfAreaRange.getRangeAreaId());
            } else if (db.on()) {
                db.println("deleteSelectedAreaRange: ospfLanConfigModel is null");
            }
        }
    }

    protected void editSelectedTableEntry(int n) {
        IOspfAreaRange iOspfAreaRange = ((OspfAreaRangeTableModel)this.model).getAreaRange(n);
        OspfAreaRangeEditDialog ospfAreaRangeEditDialog = OspfAreaRangeEditDialog.instance(this);
        if (iOspfAreaRange != null) {
            ospfAreaRangeEditDialog.setAreaRange(iOspfAreaRange);
        }
        ospfAreaRangeEditDialog.show();
        ospfAreaRangeEditDialog.dispose();
    }

    protected void registerWithModels() {
        this.ospfLanConfigModel = (OspfLanConfigModel)this.nodeModel.getOspfLanConfigModel();
        if (this.ospfLanConfigModel != null) {
            this.getObservableManager().addObservable((Observable)((Object)this.ospfLanConfigModel));
        } else {
            db.println("could not register model; ospfLanConfigModel is null");
        }
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OspfAreaRangeTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{"Range Address", "Range Area ID", "Mask Length", "Mask", "Advertise"};

        public Class getColumnClass(int n) {
            switch (n) {
                case 4: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = OspfAreaRangePane.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
            }
            return super.getColumnClass(n);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            int n = OspfAreaRangePane.this.tableData.size();
            return OspfAreaRangePane.this.tableData.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public IOspfAreaRange getAreaRange(int n) {
            OspfAreaRange ospfAreaRange = null;
            if (n < OspfAreaRangePane.this.tableData.size()) {
                String string = (String)this.getValueAt(n, 0);
                String string2 = (String)this.getValueAt(n, 1);
                String string3 = (String)this.getValueAt(n, 2);
                Boolean bl = (Boolean)this.getValueAt(n, 4);
                IIpAddr iIpAddr = InetUtil.makeIpAddr(string);
                IIpAddr iIpAddr2 = InetUtil.makeIpAddr(string2);
                Integer n2 = new Integer(string3);
                short s = n2.shortValue();
                boolean bl2 = bl;
                ospfAreaRange = new OspfAreaRange(iIpAddr2, iIpAddr, s, bl2);
            }
            return ospfAreaRange;
        }

        public Object getValueAt(int n, int n2) {
            String string = "Test";
            if (n < OspfAreaRangePane.this.tableData.size()) {
                IOspfAreaRange iOspfAreaRange = (IOspfAreaRange)OspfAreaRangePane.this.tableData.get(n);
                switch (n2) {
                    case 0: {
                        string = InetUtil.makeDottedString(iOspfAreaRange.getRangeAddress());
                        break;
                    }
                    case 1: {
                        string = InetUtil.makeDottedString(iOspfAreaRange.getRangeAreaId());
                        break;
                    }
                    case 2: {
                        Integer n3 = new Integer(iOspfAreaRange.getMaskLength());
                        string = n3.toString();
                        break;
                    }
                    case 3: {
                        int n4 = InetUtil.makeNetMask(iOspfAreaRange.getMaskLength());
                        string = InetUtil.makeDottedString(n4);
                        break;
                    }
                    case 4: {
                        Boolean bl = new Boolean(iOspfAreaRange.getAdvertise());
                        return bl;
                    }
                }
            }
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        boolean initedOM = false;

        private void initObservableManager() {
            OspfAreaRangePane.this.resetObservableManager();
            OspfAreaRangePane.this.registerWithModels();
            OspfAreaRangePane.this.setObservableManagerActive();
            this.initedOM = true;
            if (db.on()) {
                db.println("initObservabledManager() done");
            }
        }

        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            if (!this.initedOM) {
                this.initObservableManager();
            } else if (db.on()) {
                db.println("did not call initObservableManager()");
            }
            OspfAreaRangePane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)OspfAreaRangePane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

