/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sRevertiveBehavior;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eProtectionType;
import cerent.cms.idl.SonetTopology.eOnePlusOneType;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.ElementModel;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.RevertiveBehaviorFactory;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.EntityComparator;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.RevertiveBehaviorPanel;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.FixedLengthField;
import cerent.util.gui.GridPanel;
import cerent.util.gui.UComboBox;
import cerent.util.gui.UScrollPane;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PgAttrsPane
extends NodeProvPane
implements ActionListener,
DocumentListener,
ListSelectionListener {
    public static final String[] rgTimerStrings = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    public static final String[] vgTimerStrings = new String[]{"0.5", "1"};
    public static final String[] dgTimerStrings = new String[]{"0", "0.05", "0.1", "0.5", "1", "2", "3", "4", "5"};
    protected NodeModelDelegate nodeModel;
    protected FixedLengthField nameTF;
    protected JComboBox protTypeCB;
    protected JComboBox protectCB;
    protected SortableEntityListModel availListModel;
    protected SortableEntityListModel mainListModel;
    private JList availList;
    protected JList mainList;
    private JButton toMainPB;
    private JButton fromMainPB;
    protected JCheckBox bidirCB;
    protected RevertiveBehaviorPanel rbPanel;
    protected JComboBox reversionTimer;
    protected JComboBox vgTimer;
    protected JComboBox dgTimer;
    protected JComboBox rgTimer;
    protected EntityTableModel entityTableModel = null;
    private EntityCellRenderer entityCellRenderer = new EntityCellRenderer("slot ");
    static final int ONE_FOR_ONE = 0;
    static final int ONE_FOR_N = 1;
    static final int ONE_PLUS_ONE = 2;
    static final int OPT_ONE_PLUS_ONE = 3;
    static final int Y_CABLE = 4;
    static final int SPLITTER = 5;
    static final int MAX_PROT_TYPES = 6;
    static final String OPT_ONE_PLUS_ONE_CARD = "OPT_ONE_PLUS_ONE_CARD";
    static final String NON_OPT_ONE_PLUS_ONE_CARD = "NON_OPT_ONE_PLUS_ONE_CARD";
    private static final String LONGEST_PORT_NAME = "slot 14 (ASAP_4), port 4-4-1 (OC48)";
    static final String[] protTypeStrings = new String[]{"1:1 (card)", "1:N (card)", "1+1 (port)", "1+1 Optimized (port)", "Y Cable (port)", "Splitter (port)"};
    int protType;
    EntityModel protectEntity;
    boolean autoSetName = true;
    static final String[] entNames = new String[]{"card", "port"};
    static final String[] entNamesCap = new String[]{"Card", "Port"};
    static final int CARD_INDEX = 0;
    static final int PORT_INDEX = 1;
    int maxMainEntities;
    int entNameIndex;
    JLabel protLB;
    JPanel availPanel;
    JPanel mainPanel;
    private CardLayout bottomPanelLayout;
    private JPanel bottomPanel;

    protected PgAttrsPane(String string, NodeModelDelegate nodeModelDelegate, TabbedView tabbedView) {
        super(string, nodeModelDelegate, tabbedView);
        if (db.on()) {
            db.println("<init>: start");
        }
        this.nodeModel = nodeModelDelegate;
        this.add(this.createAttrsPanel(), "Center");
        if (db.on()) {
            db.println("<init>: finish");
        }
    }

    public boolean hasSubTabs() {
        return true;
    }

    private JPanel createAttrsPanel() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 5, 5));
        Dimension dimension = new Dimension(100, 20);
        JPanel jPanel4 = PgAttrsPane.createHorizontalPanel(null);
        JLabel jLabel = new JLabel("Name: ");
        jLabel.setPreferredSize(dimension);
        jLabel.setMinimumSize(dimension);
        this.nameTF = new FixedLengthField(32);
        this.nameTF.getDocument().addDocumentListener(this);
        jPanel4.add(Box.createHorizontalStrut(5));
        jPanel4.add(jLabel);
        jPanel4.add(this.nameTF);
        jPanel4.add(Box.createHorizontalStrut(5));
        this.initProtTypeCB();
        jPanel4.add(new JLabel("Type: "));
        jPanel4.add(this.protTypeCB);
        jPanel3.add(jPanel4);
        jPanel4 = PgAttrsPane.createHorizontalPanel(null);
        jPanel4.add(Box.createHorizontalStrut(5));
        this.protLB = new JLabel("Protect Entity: ");
        this.protLB.setPreferredSize(dimension);
        this.protLB.setMinimumSize(dimension);
        jPanel4.add(this.protLB);
        this.protectCB = new JComboBox();
        jPanel4.add(this.protectCB);
        this.protectCB.setRenderer(this.entityCellRenderer);
        this.protectCB.addActionListener(this);
        jPanel3.add(jPanel4);
        jPanel2.add((Component)jPanel3, "North");
        jPanel4 = PgAttrsPane.createHorizontalPanel(null);
        this.availPanel = jPanel = PgAttrsPane.createVerticalPanel("Available Entities");
        this.availListModel = new SortableEntityListModel();
        this.availList = new JList(this.availListModel);
        this.availList.setName("Available Entities");
        jPanel.add((Component)new UScrollPane((Component)this.availList));
        this.availList.setCellRenderer(this.entityCellRenderer);
        this.availList.setPrototypeCellValue(LONGEST_PORT_NAME);
        this.availList.setVisibleRowCount(5);
        this.availList.addListSelectionListener(this);
        this.availList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PgAttrsPane.this.moveMainEntities(PgAttrsPane.this.availList, PgAttrsPane.this.mainList);
                    PgAttrsPane.this.toMainPB.setEnabled(false);
                }
            }
        });
        jPanel4.add(jPanel);
        jPanel = PgAttrsPane.createVerticalPanel(null);
        jPanel.add(Box.createVerticalGlue());
        this.toMainPB = new JButton(">>");
        jPanel.add(this.toMainPB);
        this.toMainPB.addActionListener(this);
        jPanel.add(Box.createVerticalGlue());
        this.fromMainPB = new JButton("<<");
        jPanel.add(this.fromMainPB);
        this.fromMainPB.addActionListener(this);
        jPanel.add(Box.createVerticalGlue());
        jPanel4.add(jPanel);
        this.mainPanel = jPanel = PgAttrsPane.createVerticalPanel("Working Entities");
        this.mainListModel = new SortableEntityListModel();
        this.mainList = new JList(this.mainListModel);
        this.mainList.setName("Working Entities");
        jPanel.add((Component)new UScrollPane((Component)this.mainList));
        this.mainList.setPrototypeCellValue(LONGEST_PORT_NAME);
        this.mainList.setCellRenderer(this.entityCellRenderer);
        this.mainList.setVisibleRowCount(5);
        this.mainList.addListSelectionListener(this);
        this.mainList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PgAttrsPane.this.moveMainEntities(PgAttrsPane.this.mainList, PgAttrsPane.this.availList);
                    PgAttrsPane.this.fromMainPB.setEnabled(false);
                }
            }
        });
        jPanel4.add(jPanel);
        jPanel2.add((Component)jPanel4, "Center");
        this.enableToFromButtons();
        this.bottomPanel = new JPanel();
        this.bottomPanelLayout = new CardLayout();
        this.bottomPanel.setLayout(this.bottomPanelLayout);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 1, 5, 0));
        jPanel4 = PgAttrsPane.createHorizontalPanel(null);
        jPanel4.add(Box.createHorizontalStrut(5));
        this.bidirCB = new JCheckBox("Bidirectional switching");
        jPanel4.add(this.bidirCB);
        this.bidirCB.setEnabled(false);
        this.bidirCB.addActionListener(this);
        jPanel5.add(jPanel4);
        this.rbPanel = new RevertiveBehaviorPanel(this);
        jPanel5.add(this.rbPanel);
        this.bottomPanel.add((Component)jPanel5, NON_OPT_ONE_PLUS_ONE_CARD);
        JPanel jPanel6 = new JPanel(new GridLayout(1, 2, 5, 5));
        GridPanel gridPanel = new GridPanel(10, 10);
        this.reversionTimer = new UComboBox((Object[])RevertiveBehaviorPanel.reversionTimes, 50);
        this.reversionTimer.addActionListener(this);
        this.reversionTimer.setSelectedItem(RevertiveBehaviorPanel.getReversionTime(300));
        gridPanel.addRow("Reversion time (min):", (JComponent)this.reversionTimer);
        this.rgTimer = new UComboBox((Object[])rgTimerStrings, 50);
        this.rgTimer.addActionListener(this);
        gridPanel.addRow("Recovery guard time (sec):", (JComponent)this.rgTimer);
        jPanel6.add((Component)gridPanel);
        GridPanel gridPanel2 = new GridPanel(10, 10);
        this.vgTimer = new UComboBox((Object[])vgTimerStrings, 50);
        this.vgTimer.addActionListener(this);
        gridPanel2.addRow("Verification guard time (sec):", (JComponent)this.vgTimer);
        this.dgTimer = new UComboBox((Object[])dgTimerStrings, 50);
        this.dgTimer.addActionListener(this);
        gridPanel2.addRow("Detection guard time (sec):", (JComponent)this.dgTimer);
        jPanel6.add((Component)gridPanel2);
        this.bottomPanel.add((Component)jPanel6, OPT_ONE_PLUS_ONE_CARD);
        jPanel2.add((Component)this.bottomPanel, "South");
        return jPanel2;
    }

    private void moveMainEntities(JList jList, JList jList2) {
        SortableEntityListModel sortableEntityListModel = (SortableEntityListModel)jList.getModel();
        SortableEntityListModel sortableEntityListModel2 = (SortableEntityListModel)jList2.getModel();
        ListSelectionModel listSelectionModel = jList.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        while (n <= listSelectionModel.getMaxSelectionIndex()) {
            if (listSelectionModel.isSelectedIndex(n)) {
                if (jList2 == this.mainList && this.mainListModel.getSize() >= this.maxMainEntities) {
                    if (!db.on()) break;
                    db.println("already >= " + this.maxMainEntities + " main entities");
                    break;
                }
                this.setDirty();
                sortableEntityListModel2.addElement(sortableEntityListModel.getElementAt(n));
                sortableEntityListModel.removeElementAt(n);
                continue;
            }
            ++n;
        }
        listSelectionModel.clearSelection();
    }

    private void resetProtectCB() {
        DefaultComboBoxModel<Object> defaultComboBoxModel = null;
        if (this.entityTableModel == null) {
            this.entityTableModel = this.nodeModel.getEntityTableModel();
        }
        switch (this.protType) {
            case 0: 
            case 1: {
                defaultComboBoxModel = new DefaultComboBoxModel<IModuleModel>(this.entityTableModel.getAvailableProtectModules(this.getProtectionType()));
                break;
            }
            case 2: {
                defaultComboBoxModel = new DefaultComboBoxModel<ITdmPortModel>(this.entityTableModel.getAvailableOnePlusOnePorts(eOnePlusOneType.ONEPLUSONE_STANDARD));
                break;
            }
            case 3: {
                defaultComboBoxModel = new DefaultComboBoxModel<ITdmPortModel>(this.entityTableModel.getAvailableOnePlusOnePorts(eOnePlusOneType.ONEPLUSONE_OPTIMIZED));
                break;
            }
            case 4: {
                defaultComboBoxModel = new DefaultComboBoxModel<IDwdmPortModel>(this.entityTableModel.getAvailableYCablePorts());
                break;
            }
            case 5: {
                defaultComboBoxModel = new DefaultComboBoxModel();
            }
        }
        this.protectCB.setModel(defaultComboBoxModel);
        this.protectCB.setSelectedItem(null);
        this.protectCB.setSelectedItem(this.protectEntity);
        this.protectEntity = (EntityModel)this.protectCB.getSelectedItem();
        this.rbPanel.updateReversionTimes(this.protectEntity);
        this.setListsEnabled(false);
    }

    private void resetListModels() {
        if (db.on()) {
            db.println("resetListModels: protectEntity = " + this.protectEntity);
        }
        if (this.protectEntity == null) {
            this.availListModel.removeAllElements();
            this.mainListModel.removeAllElements();
            this.setListsEnabled(false);
            return;
        }
        EntityModel[] entityModelArray = new EntityModel[]{};
        if (this.entityTableModel == null) {
            this.entityTableModel = this.nodeModel.getEntityTableModel();
        }
        switch (this.protType) {
            case 0: 
            case 1: {
                entityModelArray = (EntityModel[])this.entityTableModel.getCompatibleMainModules((ModuleModel)this.protectEntity, this.getProtectionType());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                try {
                    ElementModel elementModel = this.nodeModel.getElementModelsDelegate().getElementModel(this.protectEntity);
                    Set set = null;
                    set = this.protType == 2 || this.protType == 3 ? this.nodeModel.getElementModelsDelegate().getOnePlusOneCompatibleEntities(elementModel) : this.nodeModel.getElementModelsDelegate().getYCableCompatibleEntities(elementModel);
                    entityModelArray = set.toArray(new EntityModel[0]);
                    break;
                }
                catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                    db.finer("AbstractCmsNoSuchElementException in resetListModels() " + (Object)((Object)abstractCmsNoSuchElementException));
                }
            }
        }
        this.mainListModel.removeAllElements();
        this.availListModel.removeAllElements();
        for (int i = 0; i < entityModelArray.length; ++i) {
            if (this.mainListModel.contains(entityModelArray[i])) continue;
            this.availListModel.addElement(entityModelArray[i]);
        }
        this.setListsEnabled(true);
    }

    protected void setListsEnabled(boolean bl) {
        if (db.on()) {
            db.println("setListsEnabled " + bl);
        }
        this.availList.setEnabled(bl);
        this.mainList.setEnabled(bl);
        this.enableToFromButtons();
    }

    protected void enableToFromButtons() {
        boolean bl = this.availList != null && this.availList.getModel() != null && this.availList.isEnabled() && this.availList.getModel().getSize() > 0 && !this.availList.isSelectionEmpty();
        boolean bl2 = this.mainList != null && this.mainList.getModel() != null && this.mainList.isEnabled() && this.mainList.getModel().getSize() > 0 && !this.mainList.isSelectionEmpty();
        this.toMainPB.setEnabled(bl);
        this.fromMainPB.setEnabled(bl2);
    }

    public boolean onValidate() {
        try {
            this.validateFields();
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    protected void validateFields() throws Exception {
        if (this.nameTF.getText().length() == 0) {
            throw new Exception("Protection group must have a name");
        }
        if (this.nameTF.getText().length() > 32) {
            throw new Exception("Protection group name is too long, maximum length is 32 characters.");
        }
        if (this.protTypeCB.getSelectedItem() == null) {
            throw new Exception("Protection group must have a type");
        }
        if (this.protectCB.getSelectedItem() == null) {
            throw new Exception("Protection group must have a protect " + entNames[this.entNameIndex]);
        }
        if (this.mainListModel.getSize() == 0) {
            throw new Exception("Protection group must have working " + entNames[this.entNameIndex] + "(s)");
        }
        this.rbPanel.validate();
    }

    protected eProtectionType getProtectionType() {
        switch (this.protType) {
            case 0: {
                return eProtectionType.ONE_FOR_ONE;
            }
            case 1: {
                return eProtectionType.ONE_FOR_N;
            }
            case 2: 
            case 4: 
            case 5: {
                return eProtectionType.NOT_PROTECTED;
            }
        }
        return eProtectionType.NOT_PROTECTED;
    }

    protected void setProtectionType(int n) {
        this.protType = n;
        switch (this.protType) {
            case 0: {
                this.setEntNameIndex(0);
                this.maxMainEntities = 1;
                break;
            }
            case 1: {
                this.setEntNameIndex(0);
                this.maxMainEntities = 5;
                break;
            }
            default: {
                this.setEntNameIndex(1);
                this.maxMainEntities = 1;
            }
        }
        this.protTypeCB.setSelectedItem(protTypeStrings[this.protType]);
    }

    private void setEntNameIndex(int n) {
        this.entNameIndex = n;
        this.protLB.setText("Protect " + entNamesCap[n] + ": ");
        ((TitledBorder)this.availPanel.getBorder()).setTitle("Available " + entNamesCap[n] + "s");
        ((TitledBorder)this.mainPanel.getBorder()).setTitle("Working " + entNamesCap[n] + "s");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        this.setDirty();
        if (object == this.protTypeCB) {
            if (db.on()) {
                db.println("actionPerformed: protTypeCB");
            }
            this.protType = -1;
            String string = (String)this.protTypeCB.getSelectedItem();
            for (int i = 0; string != null && i < 6; ++i) {
                if (!string.equals(protTypeStrings[i])) continue;
                this.protType = i;
                break;
            }
            if (this.protType >= 0) {
                this.bottomPanelLayout.show(this.bottomPanel, this.protType == 3 ? OPT_ONE_PLUS_ONE_CARD : NON_OPT_ONE_PLUS_ONE_CARD);
                if (this.protType == 1) {
                    this.maxMainEntities = 5;
                    this.rbPanel.setRevertive(true);
                    this.rbPanel.setRevertiveEnabled(false);
                } else {
                    this.maxMainEntities = 1;
                    if (this.protType != 3) {
                        this.rbPanel.setRevertiveEnabled(true);
                    }
                }
                if (this.protType == 2) {
                    this.setEntNameIndex(1);
                    this.bidirCB.setEnabled(true);
                    try {
                        NeDefaultsModel neDefaultsModel = this.nodeModel.getDefaultsManager().getNeDefaultsModel();
                        this.bidirCB.setSelected(neDefaultsModel.getDefOnePlusOneBidir());
                        sRevertiveBehavior sRevertiveBehavior2 = neDefaultsModel.getDefOnePlusOneRev();
                        this.rbPanel.setRevertiveBehavior(RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior2));
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                } else if (this.protType == 3) {
                    this.setEntNameIndex(1);
                    try {
                        NeDefaultsModel neDefaultsModel = this.nodeModel.getDefaultsManager().getNeDefaultsModel();
                        sRevertiveBehavior sRevertiveBehavior3 = neDefaultsModel.getDefOnePlusOneRev();
                        this.reversionTimer.setSelectedItem(RevertiveBehaviorPanel.getReversionTime(sRevertiveBehavior3.reversionTime));
                        this.rgTimer.setSelectedIndex(neDefaultsModel.getDefRecoveryGuardTimer().value());
                        this.vgTimer.setSelectedIndex(neDefaultsModel.getDefVerifyGuardTimer().value());
                        this.dgTimer.setSelectedIndex(neDefaultsModel.getDefDetectionGuardTimer().value());
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                } else if (this.protType == 4) {
                    this.setEntNameIndex(1);
                    this.bidirCB.setEnabled(false);
                    this.bidirCB.setSelected(false);
                    try {
                        NeDefaultsModel neDefaultsModel = this.nodeModel.getDefaultsManager().getNeDefaultsModel();
                        this.bidirCB.setSelected(neDefaultsModel.getDefYCableBidir());
                        sRevertiveBehavior sRevertiveBehavior4 = neDefaultsModel.getDefYCableRev();
                        this.rbPanel.setRevertiveBehavior(RevertiveBehaviorFactory.getIRevertiveBehavior(sRevertiveBehavior4));
                    }
                    catch (Exception exception) {
                        SDebug.printStackTrace((Throwable)exception);
                    }
                } else {
                    this.setEntNameIndex(0);
                    this.bidirCB.setEnabled(false);
                    this.bidirCB.setSelected(false);
                }
                this.resetProtectCB();
            }
        } else if (object == this.protectCB) {
            if (db.on()) {
                db.println("actionPerformed: protectCB");
            }
            this.protectEntity = (EntityModel)this.protectCB.getSelectedItem();
            if (this.protectEntity != null && this.protType == 1) {
                this.maxMainEntities = ((ModuleModel)this.protectEntity).getEqTypeEnum() == eEqType.DS3XM12_LINE_CARD ? 7 : 5;
            }
            if (this.autoSetName) {
                EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
                String string = "";
                if (this.protectEntity != null && (string = entityCellRenderer.getString(this.protectEntity, "slot ")).length() > 32) {
                    string = entityCellRenderer.getTruncatedString(string);
                }
                this.nameTF.setText(string);
                this.autoSetName = true;
            }
            this.resetListModels();
            this.rbPanel.updateReversionTimes(this.protectEntity);
        } else if (object == this.toMainPB) {
            if (db.on()) {
                db.println("actionPerformed: toMainPB");
            }
            this.moveMainEntities(this.availList, this.mainList);
            this.toMainPB.setEnabled(false);
        } else if (object == this.fromMainPB) {
            if (db.on()) {
                db.println("actionPerformed: fromMainPB");
            }
            this.moveMainEntities(this.mainList, this.availList);
            this.fromMainPB.setEnabled(false);
        } else if (object == this.bidirCB) {
            // empty if block
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.nameChanged();
    }

    private void nameChanged() {
        this.autoSetName = false;
        this.setDirty();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (listSelectionEvent.getSource() == this.availList) {
                if (db.on()) {
                    db.println("valueChanged: availList selection set");
                }
                this.toMainPB.setEnabled(!this.availList.getSelectionModel().isSelectionEmpty() && this.mainListModel.getSize() < this.maxMainEntities);
            } else if (listSelectionEvent.getSource() == this.mainList) {
                if (db.on()) {
                    db.println("valueChanged: mainList selection set");
                }
                this.fromMainPB.setEnabled(!this.mainList.getSelectionModel().isSelectionEmpty());
            }
        } else if (db.on()) {
            db.println("valueChanged: value is adjusting");
        }
    }

    private void initProtTypeCB() {
        this.protTypeCB = new JComboBox();
        if (this.pci.is600() || this.pci.is310cl() || this.pci.is327()) {
            this.protTypeCB.addItem(protTypeStrings[2]);
        } else {
            this.protTypeCB.addItem(protTypeStrings[1]);
            this.protTypeCB.addItem(protTypeStrings[0]);
            this.protTypeCB.addItem(protTypeStrings[2]);
            if (this.pci.is454()) {
                this.protTypeCB.addItem(protTypeStrings[3]);
            }
            this.protTypeCB.addItem(protTypeStrings[4]);
        }
        this.protTypeCB.setAlignmentY(0.5f);
        this.protTypeCB.setSelectedItem(null);
        this.protTypeCB.addActionListener(this);
    }

    public class SortableEntityListModel
    extends AbstractListModel {
        ArrayList theList = new ArrayList();

        public Object getElementAt(int n) {
            return this.theList.get(n);
        }

        public int getSize() {
            return this.theList.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElement(Object object) {
            int n = 0;
            EntityModel entityModel = (EntityModel)object;
            if (entityModel != null) {
                String string = PgAttrsPane.this.entityCellRenderer.getString(entityModel, "slot ");
                ArrayList arrayList = this.theList;
                synchronized (arrayList) {
                    EntityModel entityModel2;
                    EntityComparator entityComparator;
                    for (int i = 0; i < this.theList.size() && (entityComparator = new EntityComparator()).compare(entityModel, entityModel2 = (EntityModel)this.theList.get(i)) >= 0; ++i) {
                        if (entityComparator.compare(entityModel, entityModel2) == 0) {
                            return;
                        }
                        ++n;
                    }
                    this.add(n, object);
                }
            }
        }

        public boolean contains(Object object) {
            return this.theList.contains(object);
        }

        private void add(int n, Object object) {
            this.theList.add(n, object);
            this.fireIntervalAdded(this, n, n);
        }

        public void remove(Object object) {
            int n = this.theList.indexOf(object);
            this.theList.remove(object);
            if (n >= 0) {
                this.fireIntervalRemoved(this, n, n);
            }
        }

        public void removeElementAt(int n) {
            this.theList.remove(n);
            this.fireIntervalRemoved(this, n, n);
        }

        public void removeAllElements() {
            int n = this.theList.size() - 1;
            this.theList.clear();
            if (n >= 0) {
                this.fireIntervalRemoved(this, 0, n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyInto(Object[] objectArray) {
            ArrayList arrayList = this.theList;
            synchronized (arrayList) {
                for (int i = 0; i < this.theList.size(); ++i) {
                    objectArray[i] = this.theList.get(i);
                }
            }
        }
    }
}

