/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.model.IIpAddr;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRipAddressSummary;
import cerent.cms.model.RipAddressSummary;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractProvPane;
import cerent.cms.ui.LeavePageException;
import cerent.util.Debug;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.gui.SpinPropertyEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RipAddressSummaryAttributesPane
extends AbstractProvPane
implements DocumentListener,
PropertyChangeListener {
    private static final Debug db = new Debug("RipAddrSummAttrPane");
    static final String DEFAULT_IP_ADDRESS = "";
    boolean editOnly = false;
    protected INodeModel nodeModel;
    protected IRipAddressSummary mySummary = new RipAddressSummary();
    protected JTextField summaryTF;
    protected JTextField costTF;
    protected SpinPropertyEditor maskEdit;
    protected JLabel summaryLbl;
    protected JLabel maskProps;
    protected JLabel maskLengthLbl;
    protected JLabel costLbl;

    public void setSummary(IRipAddressSummary iRipAddressSummary) {
        this.mySummary = iRipAddressSummary;
        this.refresh();
    }

    public IRipAddressSummary getSummary() {
        return this.mySummary;
    }

    protected RipAddressSummaryAttributesPane(String string, INodeModel iNodeModel) {
        super(string, (IModel)iNodeModel, null);
        this.setNodeModel(iNodeModel);
        this.add(this.createAttributesPanel(), "Center");
    }

    public boolean hasSubTabs() {
        return true;
    }

    public void destroy() {
        this.nodeModel = null;
        super.destroy();
    }

    protected void customInit() {
        this.summaryLbl = new JLabel("Summary Address: ", 4);
        this.maskProps = new JLabel("Mask Length: ", 4);
        this.maskLengthLbl = new JLabel("??????", 4);
        this.costLbl = new JLabel("Cost: ", 4);
        this.summaryTF = new JTextField(DEFAULT_IP_ADDRESS);
        this.summaryTF.setPreferredSize(new Dimension(105, 21));
        this.maskEdit = new SpinPropertyEditor(DEFAULT_IP_ADDRESS, 1, 8, 32);
        this.costTF = new JTextField();
    }

    protected void setEditOnly() {
        this.summaryLbl.setEnabled(false);
        this.summaryTF.setEnabled(false);
        this.maskProps.setEnabled(false);
        this.maskLengthLbl.setEnabled(false);
        this.maskEdit.setEnabled(false);
        this.editOnly = true;
    }

    protected JPanel buildAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        jPanel.add(this.summaryLbl);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout());
        jPanel2.add(this.summaryTF);
        jPanel.add(jPanel2);
        return jPanel;
    }

    protected JPanel createAttributesPanel() {
        this.customInit();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        this.summaryLbl.setSize(130, 21);
        this.summaryLbl.setLocation(0, 0);
        this.summaryTF.setSize(100, 21);
        this.summaryTF.setLocation(140, 0);
        jPanel.add(this.summaryLbl);
        jPanel.add(this.summaryTF);
        this.maskProps.setSize(130, 21);
        this.maskProps.setLocation(0, 30);
        this.maskEdit.setSize(60, 21);
        this.maskEdit.setLocation(140, 30);
        this.maskLengthLbl.setSize(100, 21);
        this.maskLengthLbl.setLocation(200, 30);
        this.maskLengthLbl.setAlignmentX(0.0f);
        jPanel.add(this.maskProps);
        jPanel.add(this.maskEdit);
        jPanel.add(this.maskLengthLbl);
        this.costLbl.setSize(130, 21);
        this.costLbl.setLocation(0, 60);
        this.costTF.setSize(50, 21);
        this.costTF.setLocation(140, 60);
        jPanel.add(this.costLbl);
        jPanel.add(this.costTF);
        this.summaryTF.getDocument().addDocumentListener(this);
        this.costTF.getDocument().addDocumentListener(this);
        this.maskEdit.addPropertyChangeListener(this);
        return jPanel;
    }

    public void setNodeModel(INodeModel iNodeModel) {
        this.nodeModel = iNodeModel;
        boolean bl = this.isUserAuthorized((IModel)this.nodeModel);
    }

    public boolean onValidate() {
        try {
            this.validateFields();
        }
        catch (Exception exception) {
            Debug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    protected void validateFields() throws Exception {
        int n;
        IIpAddr iIpAddr;
        try {
            iIpAddr = InetUtil.makeIpAddr(this.summaryTF.getText());
            this.mySummary.setSummaryAddress(iIpAddr);
        }
        catch (Exception exception) {
            throw new Exception("Improper Summary Address");
        }
        try {
            n = Integer.parseInt((String)this.maskEdit.getValue());
            this.mySummary.setMaskLength((short)n);
            int n2 = Integer.parseInt(this.costTF.getText());
            if (n2 > 15) {
                throw new Exception("Cost may not be > 15");
            }
            this.mySummary.setCost((short)n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Improper Mask Length");
        }
        catch (Exception exception) {
            if (db.on()) {
                Debug.printStackTrace((Throwable)exception);
            }
            throw exception;
        }
        if (db.on() && iIpAddr != null) {
            int n3 = InetUtil.makeIpV4(iIpAddr);
            IIpAddr iIpAddr2 = InetUtil.makeIpAddr(InetUtil.makeNetMask(n));
            int n4 = InetUtil.makeIpV4(iIpAddr2);
            db.println("summary & mask: " + (n3 & n4));
        }
    }

    public void refreshFromModel() throws Exception {
        String string = InetUtil.makeDottedString(this.mySummary.getSummaryAddress());
        short s = this.mySummary.getMaskLength();
        short s2 = this.mySummary.getCost();
        this.summaryTF.setText(string);
        this.maskEdit.setValue(String.valueOf(s));
        this.updateMaskLabel();
        this.costTF.setText(String.valueOf(s2));
        super.refreshFromModel();
    }

    protected void updateMaskLabel() {
        try {
            int n = Integer.parseInt((String)this.maskEdit.getValue());
            int n2 = InetUtil.makeNetMask(n);
            this.maskLengthLbl.setText(InetUtil.makeDottedString(n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object instanceof SpinPropertyEditor) {
            this.updateMaskLabel();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
    }

    public void removeUpdate(DocumentEvent documentEvent) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 110);
    }

    protected AbstractLeavePageException createLeavePageException(String string) {
        if (db.on()) {
            db.println("createLeavePageException");
        }
        return new LeavePageException(string);
    }
}

