/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.model.AdminState;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IServiceState;
import cerent.cms.model.MfgEntityModel;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.ui.shelf.ShelfInventoryPane;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;

class ShelfInventoryRowObject {
    MfgEntityModel entity;
    String location;
    String eqType;
    sMfgData_2_01 mfgData;
    AdminState adminState;
    IServiceState serviceState;
    TDMTerminology terms;
    protected boolean[] isDirty;
    private boolean isModule = false;
    private static final SDebug db = new SDebug((KDebug)ShelfInventoryPane.db, "ShelfInventoryRowObject");
    public static final int USER_CODE_INDEX = 0;
    public static final int ADMIN_STATE_INDEX = 1;
    private static final int NUM_DIRTY_FIELDS = 2;

    public ShelfInventoryRowObject(MfgEntityModel mfgEntityModel) {
        if (db.on()) {
            db.println("<init>");
        }
        this.entity = mfgEntityModel;
        this.location = mfgEntityModel.getLocation();
        this.eqType = EntityModel.eqType2Name(mfgEntityModel.getNodeModel().getTDMTerminology(), mfgEntityModel.getEqType());
        this.terms = mfgEntityModel.getNodeModel().getTDMTerminology();
        this.mfgData = mfgEntityModel.getMfgData();
        this.determineIsModule(this.entity);
        this.adminState = this.getAdminStateFromModel();
        this.serviceState = this.getServiceStateFromModel();
        this.isDirty = new boolean[2];
        this.resetDirtyBits();
    }

    private void determineIsModule(MfgEntityModel mfgEntityModel) {
        this.isModule = mfgEntityModel.getGenericClass() == 6;
    }

    public TDMTerminology getTerms() {
        return this.terms;
    }

    boolean isModule() {
        return this.isModule;
    }

    public void setDirty(int n, boolean bl) {
        if (n >= 0 && n < 2) {
            this.isDirty[n] = bl;
        }
    }

    public boolean isDirty() {
        for (int i = 0; i < 2; ++i) {
            if (!this.isDirty[i]) continue;
            return true;
        }
        return false;
    }

    public boolean isDirty(int n) {
        return n >= 0 && n < 2 && this.isDirty[n];
    }

    public String getUserCode() {
        return this.mfgData.userCode;
    }

    public void setUserCode(String string) {
        if (!this.getUserCode().equals(string)) {
            this.mfgData.userCode = string;
            this.setDirty(0, true);
        }
    }

    public AdminState getAdminState() {
        return this.adminState;
    }

    public boolean adminStateChanged() {
        return this.getAdminState() != this.getAdminStateFromModel();
    }

    public String getAdminStateString() {
        return this.getAdminState().toString(this.getTerms());
    }

    public void setAdminState(AdminState adminState) {
        if (!this.getAdminState().equals(adminState)) {
            this.adminState = adminState;
            this.setDirty(1, true);
        }
    }

    public IServiceState getServiceState() {
        return this.serviceState;
    }

    public String getServiceStateString() {
        return this.getServiceState().toString(this.getTerms());
    }

    public AdminState getAdminStateFromModel() {
        if (!this.isModule()) {
            return AdminState.NULL_STATE;
        }
        eAdminState eAdminState2 = this.entity.getAdminStateEnum();
        return AdminState.enumToAdminState(eAdminState2);
    }

    private IServiceState getServiceStateFromModel() {
        if (!this.isModule()) {
            return ServiceStateFactory.getServiceState(null);
        }
        sServiceState sServiceState2 = this.entity.getServiceState();
        if (db.on()) {
            db.println("primary service state = " + sServiceState2.pst.value());
        }
        return ServiceStateFactory.getServiceState(sServiceState2);
    }

    private void resetDirtyBits() {
        for (int i = 0; i < 2; ++i) {
            this.isDirty[i] = false;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShelfInventoryRowObject)) {
            return false;
        }
        ShelfInventoryRowObject shelfInventoryRowObject = (ShelfInventoryRowObject)object;
        return this.location.equals(shelfInventoryRowObject.location) && this.eqType.equals(shelfInventoryRowObject.eqType) && this.entity.equals(shelfInventoryRowObject.entity) && this.mfgData.equals(this.mfgData);
    }

    private int getFramingType() {
        return this.entity.getNodeModel().getFramingType();
    }
}

