/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Synchronization.eManSwitchType;
import cerent.cms.idl.Synchronization.eRef;
import cerent.cms.idl.Synchronization.sInfo;
import cerent.cms.idl.Synchronization.sRefSwitchStatus;
import cerent.cms.idl.Synchronization.xBadQuality;
import cerent.cms.idl.Synchronization.xBadReference;
import cerent.cms.idl.Synchronization.xBusy;
import cerent.cms.idl.Synchronization.xInvalidClockSource;
import cerent.cms.idl.Synchronization.xNoSwitchCommandActive;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.EntityModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.SynchronizationModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.GridBagPanel;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class SmpTimingSourcePane
extends NodeProvPane {
    public static final String[] actionStrings = new String[]{"NONE", "MANUAL", "FORCE", "CLEAR"};
    private static final int NONE_INDEX = 0;
    private static final int MANUAL_INDEX = 1;
    private static final int FORCE_INDEX = 2;
    private static final int CLEAR_INDEX = 3;
    private static final String NORMAL_STRING = "Normal";
    private static final String MANUAL_STRING = "Manual";
    private static final String FORCE_STRING = "Force";
    private static final String NONE_STRING = "None";
    private static final String INTERNAL_STRING = "Internal";
    private SynchronizationModel model;
    private TimingRow[] rows;
    private int numRows;
    private static final SDebug db = new SDebug("SmpTimingSourcePane");

    public SmpTimingSourcePane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
        this.setDefaultPrivilegeLevel(SecurityLevel.MAINTENANCE);
        this.model = ((NodeModelDelegate)this.getUiModel()).getSynchronizationModel();
        this.numRows = this.pci.getNumberOfTimingOutRef();
        this.rows = new TimingRow[this.numRows];
        if (this.model != null) {
            this.model.addObserver((Observer)((Object)this));
        }
        UScrollPane uScrollPane = new UScrollPane(this.createRowsPanel());
        uScrollPane.getViewport().setLayout(new FlowLayout(0));
        this.add((Component)uScrollPane, "Center");
    }

    private Component createRowsPanel() {
        int n;
        GridBagPanel gridBagPanel = new GridBagPanel();
        gridBagPanel.fillHorizontal();
        gridBagPanel.inset(5, 5);
        int n2 = 0;
        gridBagPanel.add("Clock", 0, n2);
        gridBagPanel.add("Reference", 1, n2);
        gridBagPanel.add("Operation", 2, n2);
        gridBagPanel.add("Status", 3, n2);
        ++n2;
        for (n = 0; n < 4; ++n) {
            gridBagPanel.add((Component)new JSeparator(), n, n2);
        }
        ++n2;
        for (n = 0; n < this.numRows; ++n) {
            this.rows[n] = new TimingRow(this.model, gridBagPanel, this.getRef(n), n2);
            ++n2;
        }
        return gridBagPanel;
    }

    private eRef getRef(int n) {
        eRef eRef2 = null;
        switch (n) {
            case 0: {
                eRef2 = eRef.NE;
                break;
            }
            case 1: {
                eRef2 = eRef.EXT_1;
                break;
            }
            case 2: {
                eRef2 = eRef.EXT_2;
            }
        }
        return eRef2;
    }

    public void destroy() {
        this.model.deleteObserver((Observer)((Object)this));
        for (int i = 0; i < this.numRows; ++i) {
            this.rows[i].destroy();
        }
        super.destroy();
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numRows; ++i) {
            this.rows[i].refreshFromModel();
            this.rows[i].resetDirty();
        }
    }

    public void applyChangesToModel() {
        int n;
        for (n = 0; n < this.numRows; ++n) {
            if (!this.rows[n].isDirty()) continue;
            this.rows[n].requestApply();
        }
        for (n = 0; n < this.numRows; ++n) {
            if (!this.rows[n].isDirty()) continue;
            this.rows[n].applyChangesToModel();
            this.rows[n].resetDirty();
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SmpTimingSourcePane;
    }

    protected void updatePaneDirty() {
        boolean bl = this.isProvPaneDirty();
        boolean bl2 = false;
        for (int i = 0; !bl2 && i < this.numRows; ++i) {
            bl2 = this.rows[i].isDirty();
            if (!db.on()) continue;
            db.println("updatePaneDirty: row " + i + ", dirty = " + bl2);
        }
        if (bl != bl2) {
            this.setDirty(bl2);
        }
    }

    private class TimingRow
    implements ItemListener {
        private eRef ref;
        private JComboBox refCB;
        private JLabel statLB;
        private JComboBox opCB;
        private SynchronizationModel model;
        private boolean dirty = false;
        private boolean applying = false;

        TimingRow(SynchronizationModel synchronizationModel, GridBagPanel gridBagPanel, eRef eRef2, int n) {
            this.model = synchronizationModel;
            this.ref = eRef2;
            this.refCB = new JComboBox();
            this.getRefs();
            this.refCB.setRenderer(new EntityCellRenderer("slot ", true));
            this.refCB.addItemListener(this);
            this.statLB = new JLabel(SmpTimingSourcePane.NORMAL_STRING);
            this.setStatusLabel();
            this.opCB = new JComboBox<String>(actionStrings);
            this.opCB.addItemListener(this);
            this.setEnabled(SmpTimingSourcePane.this.isUserAuthorized());
            gridBagPanel.add("  " + this.getRefName() + ":", 0, n);
            gridBagPanel.add((Component)this.refCB, 1, n);
            gridBagPanel.add((Component)this.opCB, 2, n);
            gridBagPanel.add((Component)this.statLB, 3, n);
        }

        void destroy() {
            if (this.refCB != null) {
                this.refCB.removeItemListener(this);
            }
            if (this.opCB != null) {
                this.opCB.removeItemListener(this);
            }
        }

        private void setDirty() {
            this.dirty = true;
            SmpTimingSourcePane.this.updatePaneDirty();
        }

        void resetDirty() {
            if (!this.applying) {
                this.dirty = false;
                SmpTimingSourcePane.this.updatePaneDirty();
            }
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.setDirty();
        }

        void requestApply() {
            this.applying = true;
        }

        void applyChangesToModel() {
            int n;
            int n2 = this.opCB.getSelectedIndex();
            Object object = this.refCB.getSelectedItem();
            int n3 = n = object instanceof EntityModel ? ((EntityModel)object).getIndex() : -1;
            if (n2 == 3) {
                this.performClear(object);
            } else if ((n2 == 1 || n2 == 2) && n != -1) {
                this.performManual(n2, object, n);
            } else {
                db.println("Unrecognized operation in applyChanges...");
                if (db.on()) {
                    db;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
            this.applying = false;
        }

        private void performManual(int n, Object object, int n2) {
            String string = "Timing Reference Switch Failed";
            if (CerentDialog.yesNoDialog((Component)((Object)SmpTimingSourcePane.this), (String)("Are you sure you want to perform the " + (n == 1 ? "manual" : "force") + " switch for the " + this.getRefName() + " clock?"), (String)"Switching Timing Source")) {
                try {
                    if (this.okToApply(object, n)) {
                        this.model.switchRefSource(this.ref, n2, n == 1 ? eManSwitchType.MANUAL : eManSwitchType.FORCE);
                    } else {
                        ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_UPDATE_REJECT);
                    }
                }
                catch (xInvalidClockSource xInvalidClockSource2) {
                    ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_REF_OOS);
                }
                catch (xBadQuality xBadQuality2) {
                    ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_INFERIOR_SWITCH);
                }
                catch (xBusy xBusy2) {
                    ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_HIGH_PRIO_ACTIVE);
                }
                catch (xBadReference xBadReference2) {
                    ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_BAD_REFERENCE);
                }
            }
        }

        private void performClear(Object object) {
            String string = "Timing Reference Switch Failed";
            if (CerentDialog.yesNoDialog((Component)((Object)SmpTimingSourcePane.this), (String)("Are you sure you want to perform the clear for the " + this.getRefName() + " clock?"), (String)"Clear Timing Source")) {
                try {
                    if (this.okToApply(object, 3)) {
                        this.model.releaseRefSource(this.ref);
                    } else {
                        ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_UPDATE_REJECT);
                    }
                }
                catch (xNoSwitchCommandActive xNoSwitchCommandActive2) {
                    ErrorMsg.displayError((Component)((Object)SmpTimingSourcePane.this), (EID)EMC.EID_TIMING_NO_ACTIVE_SWITCH);
                }
            }
        }

        void refreshFromModel() {
            this.opCB.removeItemListener(this);
            this.refCB.removeItemListener(this);
            this.getRefs();
            if (this.setStatusLabel() || !this.applying) {
                this.opCB.setSelectedIndex(0);
            }
            this.opCB.addItemListener(this);
            this.refCB.addItemListener(this);
        }

        void setEnabled(boolean bl) {
            this.refCB.setEnabled(bl);
            this.opCB.setEnabled(bl);
        }

        boolean setStatusLabel() {
            boolean bl;
            block6: {
                sRefSwitchStatus sRefSwitchStatus2 = this.model.getManualSwitchStatus(this.ref);
                String string = !sRefSwitchStatus2.manualSwitchActive ? SmpTimingSourcePane.NORMAL_STRING : (sRefSwitchStatus2.swType.equals(eManSwitchType.FORCE) ? SmpTimingSourcePane.FORCE_STRING : SmpTimingSourcePane.MANUAL_STRING);
                boolean bl2 = bl = !this.statLB.getText().equals(string);
                if (db.on()) {
                    db.println("For ref " + this.getRefName() + ", oldStat = " + this.statLB.getText() + ", newStat = " + string + ", changed = " + bl);
                }
                if (bl) {
                    this.statLB.setText(string);
                    if (sRefSwitchStatus2.manualSwitchActive) {
                        try {
                            EntityModel entityModel = this.model.getEntityModelByIndex(sRefSwitchStatus2.manualReference);
                            if (entityModel != null) {
                                this.refCB.setSelectedItem(entityModel);
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            db.println("Caught NoSuchEntity in setStatusLabel!");
                            if (!db.on()) break block6;
                            db;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            }
            return bl;
        }

        private void getRefs() {
            int n;
            Object object;
            block14: {
                object = this.applying ? this.refCB.getSelectedItem() : null;
                int n2 = -1;
                if (this.refCB.getItemCount() > 0) {
                    this.refCB.removeAllItems();
                }
                sInfo[] sInfoArray = this.model.getRefSources(this.ref);
                int n3 = this.model.getActiveRefSource(this.ref);
                if (sInfoArray.length == 0) {
                    this.refCB.addItem(SmpTimingSourcePane.NONE_STRING);
                } else {
                    for (n = 0; n < sInfoArray.length; ++n) {
                        try {
                            EntityModel entityModel = this.model.getEntityModelByIndex(sInfoArray[n].line);
                            this.refCB.addItem(entityModel);
                            if (entityModel.getIndex() != n3) continue;
                            this.refCB.setSelectedIndex(n);
                            n2 = n;
                            continue;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (db.on) {
                                db.println("Caught NoSuchEntity Exception");
                            }
                            this.refCB.addItem("Unknown " + sInfoArray[n].line);
                        }
                    }
                    if (n2 == -1) {
                        try {
                            EntityModel entityModel = null;
                            if (this.ref.equals(eRef.NE)) {
                                entityModel = this.model.getEntityModelByIndex(this.model.INT_CLOCK);
                            } else {
                                entityModel = this.model.getEntityModelByIndex(this.model.NO_CLOCK);
                                this.refCB.addItem(entityModel);
                            }
                            this.refCB.setSelectedItem(entityModel);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!db.on) break block14;
                            db.println("Caught NoSuchEntity " + (Object)((Object)abstractCmsNoSuchEntityException));
                            db;
                            SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                        }
                    }
                }
            }
            if (object != null) {
                for (n = 0; n < this.refCB.getItemCount(); ++n) {
                    if (!this.refCB.getItemAt(n).equals(object)) continue;
                    this.refCB.setSelectedIndex(n);
                }
            }
        }

        private String getRefName() {
            String string = null;
            switch (this.ref.value()) {
                case 0: {
                    string = "NE";
                    break;
                }
                case 1: {
                    string = "BITS-1 Out";
                    break;
                }
                case 2: {
                    string = "BITS-2 Out";
                }
            }
            return string;
        }

        private boolean okToApply(Object object, int n) {
            return n == this.opCB.getSelectedIndex() && object.equals(this.refCB.getSelectedItem());
        }
    }
}

