/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.IPlatform;
import cerent.cms.idl.Equipment.xInUse;
import cerent.cms.idl.SonetTopology.eElementType;
import cerent.cms.idl.SonetTopology.xBusy;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.DwdmCliLineModel;
import cerent.cms.model.ElementModelsDelegate;
import cerent.cms.model.EntityModel;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OnePlusOneModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.cms.model.ProtectionGroupModels;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.YCableModel;
import cerent.cms.ui.AbstractRoDataSourceControl;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfEditTablePane;
import cerent.cms.ui.shelf.PgColumnRenderer;
import cerent.cms.ui.shelf.PgCreationDialog;
import cerent.cms.ui.shelf.PgEditDialog;
import cerent.cms.ui.shelf.PgRowObject;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.IObservableManager;
import cerent.util.ObservableManager;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.WindowHelper;
import cerent.util.gui.row.AbstractRowDataSource;
import cerent.util.gui.row.RowDataSource;
import cerent.util.gui.row.SortableRowTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SppProtectionPane
extends AbstractShelfEditTablePane
implements MouseListener {
    private EntityTableModel entityTableModel = null;
    private ProtectionGroupModels protectionGroupModels = null;
    private ElementModelsDelegate elementModelsDelegate = null;
    private JDialog currentDialog = null;
    protected static final SDebug db = new SDebug("SppProtectionPane");
    static /* synthetic */ Class class$cerent$cms$ui$shelf$PgRowObject;

    public SppProtectionPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    private boolean isOPGSwitched(OnePlusOneModel onePlusOneModel) {
        try {
            PortModel portModel;
            InterfaceModel interfaceModel;
            EntityModel entityModel = (EntityModel)onePlusOneModel.getProtectEntityModel();
            if (entityModel instanceof PortModel && (interfaceModel = (InterfaceModel)(portModel = (PortModel)entityModel).getInterfaceModel()) instanceof TdmLineModel) {
                TdmLineModel tdmLineModel = (TdmLineModel)interfaceModel;
                return tdmLineModel.isCurrentlyActive();
            }
            return false;
        }
        catch (Exception exception) {
            db.println("Caught exception in isOPGSwitched");
            SDebug.printStackTrace((Throwable)exception);
            return false;
        }
    }

    private boolean isYPGSwitched(YCableModel yCableModel) {
        boolean bl = false;
        try {
            PortModel portModel;
            InterfaceModel interfaceModel;
            EntityModel entityModel = (EntityModel)yCableModel.getProtectEntityModel();
            if (entityModel instanceof PortModel && (interfaceModel = (InterfaceModel)(portModel = (PortModel)entityModel).getInterfaceModel()) instanceof DwdmCliLineModel) {
                DwdmCliLineModel dwdmCliLineModel = (DwdmCliLineModel)interfaceModel;
                bl = dwdmCliLineModel.isCurrentlyActive();
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in isOPGSwitched");
            SDebug.printStackTrace((Throwable)exception);
            bl = false;
        }
        return bl;
    }

    private boolean isProtectionGroupDeleteable(Model model) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        return !(nodeModelDelegate.getPlatform().is327() && model instanceof ProtectionGroupModel && ((ProtectionGroupModel)model).getName().equals("XTCPROTGRP") || model instanceof YCableModel && ((YCableModel)model).getType() == 5);
    }

    protected void initModels() {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        this.entityTableModel = nodeModelDelegate.getEntityTableModel();
        this.protectionGroupModels = nodeModelDelegate.getProtectionGroupModels();
        this.elementModelsDelegate = nodeModelDelegate.getElementModelsDelegate();
        PgRowDataSource pgRowDataSource = new PgRowDataSource();
        this.model = new SortableRowTableModel((RowDataSource)pgRowDataSource, PgColumnRenderer.createColumnRenderers());
    }

    protected void localInit() {
        super.localInit();
        this.table.addMouseListener(this);
        IPlatform iPlatform = ((NodeModelDelegate)this.getUiModel().getNodeModel()).getPlatform();
        if (!iPlatform.is454()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            TableColumn tableColumn = null;
            tableColumn = this.table.getColumn(this.model.getColumnName(7));
            tableColumnModel.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.model.getColumnName(8));
            tableColumnModel.removeColumn(tableColumn);
            tableColumn = this.table.getColumn(this.model.getColumnName(9));
            tableColumnModel.removeColumn(tableColumn);
        }
    }

    protected void createTableEntry() {
        this.currentDialog = PgCreationDialog.instance(this);
        this.currentDialog.show();
        this.currentDialog = null;
    }

    protected void editSelectedTableEntry(int n) {
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        if (!nodeModelDelegate.isUserAuthorized(SecurityLevel.PROVISIONING)) {
            return;
        }
        PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
        this.currentDialog = new PgEditDialog(this, (NodeModelDelegate)this.getUiModel(), pgRowObject.model, db);
        this.currentDialog.show();
        this.currentDialog = null;
    }

    protected void deleteSelectedTableEntry(int n) {
        block21: {
            PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
            ProtectionGroupModel protectionGroupModel = null;
            OnePlusOneModel onePlusOneModel = null;
            YCableModel yCableModel = null;
            String string = "";
            String string2 = "";
            if (pgRowObject.model instanceof ProtectionGroupModel) {
                protectionGroupModel = (ProtectionGroupModel)pgRowObject.model;
                string = protectionGroupModel.getName();
            } else if (pgRowObject.model instanceof OnePlusOneModel) {
                onePlusOneModel = (OnePlusOneModel)pgRowObject.model;
                string = onePlusOneModel.getName();
                if (this.isOPGSwitched(onePlusOneModel)) {
                    string2 = "The protect port is active.\nYou may lose traffic if you proceed.\n";
                }
            } else if (pgRowObject.model instanceof YCableModel) {
                yCableModel = (YCableModel)pgRowObject.model;
                string = yCableModel.getName();
                if (this.isYPGSwitched(yCableModel)) {
                    string2 = "The protect port is active.\nYou may lose traffic if you proceed.\n";
                }
            }
            if (CerentDialog.yesNoDialog((Component)((Object)this), (String)(string2 + "Really delete " + string + " Protection Group?"), (String)"Delete Protection Group")) {
                this.setEditDeleteEnabled(false);
                try {
                    if (protectionGroupModel != null) {
                        try {
                            protectionGroupModel.delete();
                            break block21;
                        }
                        catch (xInUse xInUse2) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_PROTECT_IN_USE);
                            return;
                        }
                    }
                    if (onePlusOneModel != null) {
                        try {
                            onePlusOneModel.delete();
                        }
                        catch (CmsObjectNotExistException cmsObjectNotExistException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_ONE_PLUS_ONE_NOT_EXIST);
                        }
                    } else if (yCableModel != null) {
                        try {
                            yCableModel.delete();
                        }
                        catch (CmsObjectNotExistException cmsObjectNotExistException) {
                            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_Y_CABLE_NOT_EXIST);
                        }
                    }
                }
                catch (xBusy xBusy2) {
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_TOPO_ELE_IN_USE);
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_FAIL_DELETE_PROT_GROUP);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateTableData() {
        ArrayList<ProtectionGroupModel> arrayList = new ArrayList<ProtectionGroupModel>();
        if (db.on()) {
            db.println("Retrieving electrical protection groups");
        }
        arrayList.addAll(Arrays.asList(this.entityTableModel.getProtectionGroupModelArray()));
        if (db.on()) {
            db.println("Retrieving 1+1 protection groups");
        }
        arrayList.addAll(this.elementModelsDelegate.getElementsOfType(eElementType.ONE_PLUS_ONE.value()));
        if (db.on()) {
            db.println("Retrieving Y-Cable protection groups");
        }
        arrayList.addAll(this.elementModelsDelegate.getElementsOfType(eElementType.Y_CABLE.value()));
        if (db.on()) {
            db.println("Retrieving Splitter protection groups");
        }
        arrayList.addAll(this.elementModelsDelegate.getElementsOfType(eElementType.SPLITTER.value()));
        if (db.on()) {
            db.println("Preparing PgRowObject containers count=" + arrayList.size());
        }
        ArrayList arrayList2 = this.tableData;
        synchronized (arrayList2) {
            this.tableData.clear();
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    this.tableData.add(new PgRowObject((Model)arrayList.get(i), db));
                    continue;
                }
                catch (CmsObjectNotExistException cmsObjectNotExistException) {
                    if (!db.on()) continue;
                    db.println("Protection group deleted during update");
                }
            }
            Collections.sort(this.tableData);
        }
        if (db.on()) {
            db.println("Registering...");
        }
        this.registerWithModels();
        if (db.on()) {
            db.println("Retrieval/update completed");
        }
    }

    protected void registerWithModels() {
        IObservableManager iObservableManager = this.getObservableManager();
        iObservableManager.reset();
        iObservableManager.addObservable((Observable)((Object)this.elementModelsDelegate));
        iObservableManager.addObservable((Observable)((Object)this.entityTableModel));
        iObservableManager.addObservable((Observable)((Object)this.protectionGroupModels));
        for (int i = 0; i < this.tableData.size(); ++i) {
            PgRowObject pgRowObject = (PgRowObject)this.tableData.get(i);
            iObservableManager.addObservable((Observable)((Object)pgRowObject.model));
        }
        iObservableManager.setActive(true);
    }

    protected void setDataSourceControl() {
        this.setDataSourceControl(new InnerDsc());
    }

    public void setEditDeleteEnabled(boolean bl) {
        int n;
        super.setEditDeleteEnabled(bl);
        if (this.deleteButton.isEnabled() && (n = this.table.getSelectedRow()) >= 0 && n < this.model.getRowCount()) {
            PgRowObject pgRowObject = (PgRowObject)this.model.getValueAt(n, 0);
            if (!this.isProtectionGroupDeleteable(pgRowObject.model)) {
                WindowHelper.setEnabled((JComponent)this.deleteButton, (boolean)false);
            }
        }
    }

    public void destroy() {
        if (this.currentDialog != null) {
            try {
                this.currentDialog.dispose();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        super.destroy();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n;
        if (mouseEvent.getClickCount() == 2 && (n = this.table.rowAtPoint(mouseEvent.getPoint())) != -1) {
            this.table.setRowSelectionInterval(n, n);
            this.editSelectedTableEntry(n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppProtectionPane;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class PgRowDataSource
    extends AbstractRowDataSource {
        PgRowDataSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObjectAtRow(int n) {
            Object var2_2 = null;
            ArrayList arrayList = SppProtectionPane.this.tableData;
            synchronized (arrayList) {
                var2_2 = SppProtectionPane.this.tableData.get(n);
            }
            return var2_2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRowCount() {
            int n = -1;
            ArrayList arrayList = SppProtectionPane.this.tableData;
            synchronized (arrayList) {
                n = SppProtectionPane.this.tableData.size();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection getAllObjects() {
            ArrayList arrayList = SppProtectionPane.this.tableData;
            synchronized (arrayList) {
                return SppProtectionPane.this.tableData;
            }
        }

        public Class getRowObjectClass() {
            return class$cerent$cms$ui$shelf$PgRowObject == null ? (class$cerent$cms$ui$shelf$PgRowObject = SppProtectionPane.class$("cerent.cms.ui.shelf.PgRowObject")) : class$cerent$cms$ui$shelf$PgRowObject;
        }
    }

    public class InnerDsc
    extends AbstractRoDataSourceControl {
        public void refreshFromModel() throws Exception {
            if (db.on()) {
                db.println("InnerDsc::refreshFromModel()");
            }
            SppProtectionPane.this.repopulateTable();
        }

        public IObservableManager getObservableManager() {
            if (this.dscObservableManager == null) {
                this.dscObservableManager = new ObservableManager((Observer)((Object)SppProtectionPane.this), true);
            }
            return this.dscObservableManager;
        }
    }
}

