/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.ISecureIpConfig;
import cerent.cms.model.IpConfigError;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.shelf.AbstractShelfProvPane;
import cerent.cms.ui.shelf.IpAddrPanel;
import cerent.cms.ui.shelf.SecurityConfigDialog;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.ImageLoader;
import cerent.util.gui.UScrollPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Observable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SppSecurityConfigPane
extends NodeProvPane
implements ActionListener,
PropertyChangeListener,
DocumentListener {
    protected static final SDebug db = new SDebug((KDebug)AbstractShelfProvPane.db, "SppSecurityConfigPane");
    private static final Dimension TABSIZE = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 300);
    private static final Dimension TABSIZE_SHORT = new Dimension(TabbedView.TABBED_VIEW_DIM.width, 180);
    private static final int PORT_LENGTH = 4;
    private boolean bInit;
    private JPanel tab;
    private JPanel ipPanel;
    private static final String WIZARD_TITLE = "Change Secure Mode";
    private static final String CONFIGURE = "Change Mode..";
    private static final String LOCK = "Lock..";
    private static final String SECURE_IP = "Secure IP Config";
    private static final String SEC_LOCK_TXT = "Mode permanently locked and cannot be unlocked";
    private static final String SEC_NO_LOCK_TXT = "Mode not locked";
    private String SEC_ON_TXT;
    private String SEC_OFF_TXT;
    private static final ImageIcon check = new ImageIcon(ImageLoader.loadImage("/images/check_blue.gif"));
    private static final ImageIcon clean = new ImageIcon(ImageLoader.loadImage("/images/clean_square.gif"));
    JButton configureButton = new JButton("Change Mode..");
    JButton lockButton = new JButton("Lock..");
    JLabel secLockLB = new JLabel("Mode permanently locked and cannot be unlocked");
    JLabel secNoLockLB = new JLabel("Mode not locked");
    JLabel secOnLB;
    JLabel secOffLB;
    private boolean isSecureMode = false;
    private boolean userMode = false;
    private boolean isLocked = false;
    private boolean mustReboot = false;
    SecurityConfigDialog configDialog;
    IpAddrPanel ipAddrPanel;

    public SppSecurityConfigPane(String string, TabbedView tabbedView) {
        super(string, tabbedView);
    }

    public boolean hasSubTabs() {
        return false;
    }

    private void init() {
        if (db.on()) {
            db.println("init: start");
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.SUPERUSER);
        this.tab = new JPanel();
        UScrollPane uScrollPane = new UScrollPane((Component)this.tab);
        uScrollPane.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
        this.registerWithModel();
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        TDMTerminology tDMTerminology = nodeModelDelegate.getTDMTerminology();
        String string = tDMTerminology.getBackplaneTerm(false);
        this.SEC_ON_TXT = "Secure ( separate IP addresses for TCC and " + string + " Ethernet ports, with no connectivity between ports)";
        this.SEC_OFF_TXT = "Normal ( one IP address shared by the TCC and " + string + " Ethernet ports, with full connectivity between ports)";
        this.secOnLB = new JLabel(this.SEC_ON_TXT);
        this.secOffLB = new JLabel(this.SEC_OFF_TXT);
        this.tab.setLayout(new BoxLayout(this.tab, 1));
        this.add((Component)uScrollPane);
        JPanel jPanel = this.getModePanel();
        jPanel.setAlignmentX(0.0f);
        this.tab.add(jPanel);
        if (nodeModelDelegate.isSecureMode()) {
            this.tab.add(this.getIpPanel());
        }
        this.bInit = true;
    }

    private JPanel getIpPanel() {
        if (this.ipPanel == null) {
            this.ipPanel = SppSecurityConfigPane.createHorizontalPanel("Backplane Ethernet Port");
        }
        if (this.ipAddrPanel == null) {
            this.ipAddrPanel = new IpAddrPanel(this, false);
        }
        this.ipPanel.add(this.ipAddrPanel);
        Dimension dimension = new Dimension(TabbedView.TABBED_VIEW_DIM.width - 100, 120);
        this.ipPanel.setPreferredSize(dimension);
        this.ipPanel.setMaximumSize(dimension);
        this.ipPanel.setAlignmentX(0.0f);
        return this.ipPanel;
    }

    private JPanel getModePanel() {
        JPanel jPanel = SppSecurityConfigPane.createHorizontalPanel("TCP/IP Mode");
        Dimension dimension = new Dimension(TabbedView.TABBED_VIEW_DIM.width - 100, 180);
        jPanel.setPreferredSize(dimension);
        jPanel.setMaximumSize(dimension);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.secOffLB);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(25));
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(this.secOnLB);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(25));
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(20, 10)));
        jPanel2.add(this.secNoLockLB);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(25));
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(20, 10)));
        jPanel2.add(this.secLockLB);
        jPanel.add(jPanel2);
        jPanel.add(Box.createHorizontalStrut(25));
        Dimension dimension2 = new Dimension(100, 20);
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.configureButton.addActionListener(this);
        this.configureButton.setEnabled(true);
        jPanel2.add(this.configureButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.lockButton.addActionListener(this);
        this.lockButton.setToolTipText("The secure mode must be set in order to enable this button");
        jPanel2.add(this.lockButton);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private static JPanel createAttributePanel(String string, Dimension dimension) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        if (string != null) {
            JLabel jLabel = new JLabel();
            jLabel.setText(string);
            jLabel.setMaximumSize(dimension);
            jPanel.add(jLabel);
        }
        return jPanel;
    }

    public boolean onValidate() {
        boolean bl = true;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        if (this.ipAddrPanel.mustReboot()) {
            this.mustReboot = true;
        }
        try {
            if (this.mustReboot) {
                if (!nodeModelDelegate.isRestAllowed()) {
                    ErrorMsg.displayWarning((Component)((Object)this), (EID)EMC.WID_SOFTWARE_UPGRADE_DENIED);
                    return false;
                }
                if (!CerentDialog.yesNoDialog((Component)((Object)this), (String)("Changing the network configuration will cause a reboot or\nprotection switch of the active " + this.pci.getControlCardName() + " and may lead to loss\n" + "of communication with the node.\n \n" + "Make the change anyway?"), (String)"Change Network Configuration?")) {
                    return false;
                }
            }
            this.ipAddrPanel.validatePanel();
            iSecureIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            iIpConfig.setDefaultRouter(this.ipAddrPanel.getDefaultRouterAddr());
            iSecureIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            InetUtil.validateIpConfig(iSecureIpConfig, iIpConfig, "Backplane LAN port");
        }
        catch (IpConfigError ipConfigError) {
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONFIG_PARAM_1, (Object)ipConfigError.getMessage());
            return false;
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_VALIDATION_ERROR);
            return false;
        }
        return true;
    }

    public void applyChangesToModel() throws Exception {
        if (db.on()) {
            db.println("applyChangesToModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        boolean bl = false;
        if (nodeModelDelegate.provides(Feature.IDL_LCDIp)) {
            nodeModelDelegate.setLcdIpSetting(this.ipAddrPanel.getLcdIpSetting(), bl);
        }
        boolean bl2 = this.ipAddrPanel.getCtcIpSuppressed();
        if (nodeModelDelegate.getCtcIpDisplaySuppression(bl) != bl2) {
            nodeModelDelegate.setCtcIpDisplaySuppression(bl, bl2);
        }
        if (this.mustReboot) {
            iSecureIpConfig.setIpAddress(this.ipAddrPanel.getIpAddr());
            try {
                iSecureIpConfig.setNetMaskPrefixLength(this.ipAddrPanel.getNetmaskPrefixLength());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                nodeModelDelegate.setSecureIpConfig(iIpConfig, iSecureIpConfig);
            }
            catch (Exception exception) {
                if (db.on()) {
                    db.println("applyChangesToModel: Error setting IP address");
                }
                throw new Exception(exception.getMessage());
            }
        }
        if (db.on()) {
            db.println("applyChangesToModel: end");
        }
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshFromModel: start");
        }
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        ISecureIpConfig iSecureIpConfig = nodeModelDelegate.getSecureIpConfig();
        IIpConfig iIpConfig = nodeModelDelegate.getIpConfig();
        boolean bl = true;
        if (iSecureIpConfig != null) {
            this.isSecureMode = nodeModelDelegate.isSecureMode();
            this.isLocked = iSecureIpConfig.isPermanentSecureMode();
            this.setSecurityUI(this.isSecureMode, this.isLocked);
            if (this.isSecureMode) {
                if (this.ipAddrPanel == null) {
                    this.tab.add(this.getIpPanel());
                }
                this.ipAddrPanel.setIpConfig(nodeModelDelegate, iSecureIpConfig.getIpAddress(), iIpConfig.getDefaultRouter(), iSecureIpConfig.getNetMaskPrefixLength());
            } else if (this.ipPanel != null) {
                this.ipPanel.setVisible(false);
                this.ipAddrPanel.setVisible(false);
            }
        }
        if (db.on()) {
            db.println("refreshFromModel: finish");
        }
    }

    public void setSecurityUI(boolean bl, boolean bl2) {
        if (bl) {
            this.secOffLB.setEnabled(false);
            this.secOnLB.setEnabled(true);
            this.secOnLB.setIcon(check);
            this.secOffLB.setIcon(clean);
            if (!bl2) {
                this.secLockLB.setEnabled(false);
                this.secLockLB.setDisabledIcon(clean);
                this.secNoLockLB.setEnabled(true);
                this.secNoLockLB.setIcon(check);
                this.lockButton.setVisible(true);
                this.lockButton.setEnabled(true);
                this.configureButton.setEnabled(true);
            } else {
                this.secLockLB.setEnabled(true);
                this.secLockLB.setIcon(check);
                this.secNoLockLB.setEnabled(false);
                this.secNoLockLB.setDisabledIcon(clean);
                this.lockButton.setVisible(false);
                this.configureButton.setVisible(false);
            }
        } else {
            this.secOffLB.setIcon(check);
            this.secOffLB.setEnabled(true);
            this.secOnLB.setIcon(clean);
            this.secOnLB.setEnabled(false);
            this.secLockLB.setIcon(clean);
            this.secLockLB.setEnabled(false);
            this.secNoLockLB.setIcon(clean);
            this.secNoLockLB.setEnabled(false);
            this.lockButton.setVisible(true);
            this.lockButton.setEnabled(false);
        }
    }

    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.println("update: start");
        }
        this.requestRefresh(this, null);
    }

    public void enteringPage() throws Exception {
        if (!this.bInit) {
            this.init();
        }
        super.enteringPage();
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.SppSecurityConfigPane;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Object object = actionEvent.getSource();
        if (object.equals(this.configureButton)) {
            this.userMode = !this.isSecureMode;
            boolean bl = true;
            if (this.userMode) {
                bl = this.tccSupportsSecureMode();
            }
            if (bl) {
                this.configDialog = SecurityConfigDialog.instance((JComponent)((Object)this), WIZARD_TITLE, this.userMode);
                this.configDialog.show();
            } else {
                ErrorMsg.displayError((Component)((Object)this), (EID)EMC.EID_INVALID_CONTROLLER_CARD);
            }
        } else if (object.equals(this.lockButton) && CerentDialog.yesNoWarningDialog((Component)((Object)this), (String)(string = ErrorMsg.getString((EID)EMC.WID_MAKE_PERMANENT)), (String)"Confirm Lock Secure Mode")) {
            NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
            nodeModelDelegate.makeSecurityPermanent();
        }
    }

    private boolean tccSupportsSecureMode() {
        EntityTableModel entityTableModel;
        boolean bl = false;
        NodeModelDelegate nodeModelDelegate = (NodeModelDelegate)this.getUiModel();
        if (nodeModelDelegate != null && (entityTableModel = nodeModelDelegate.getEntityTableModel()) != null && entityTableModel.hasActiveTCC2P()) {
            if (entityTableModel.hasStandbyControllerCard(eEqType.TCC_CARD)) {
                if (entityTableModel.isStandbyTCC2P()) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setDirty();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.setDirty();
    }
}

