/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.shelf;

import cerent.cms.idl.Common.sIpAddr;
import cerent.cms.idl.Common.sIpSubnet;
import cerent.cms.idl.Common.sIpTunnel;
import cerent.cms.model.IpAddrFactory;
import cerent.cms.ui.Pane;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.SpinPropertyEditor;
import cerent.util.gui.UDialog;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TunnelsDialog
extends UDialog {
    private static final SDebug db = new SDebug("TunnelsDialog");
    public static final String TITLE = "Create Tunnel";
    private JButton okButton;
    private JButton cancelButton;
    private Pane parent;
    TunnelCreatePane createPane;
    private boolean ok = false;

    public static TunnelsDialog instance(Pane pane) {
        Frame frame = JOptionPane.getFrameForComponent((Component)pane);
        return new TunnelsDialog(frame, TITLE, pane);
    }

    private TunnelsDialog(Frame frame, String string, Object object) {
        super(frame, string, true, object);
    }

    protected void initContentPane(JPanel jPanel, Object object) {
        this.ok = false;
        this.parent = (Pane)object;
        jPanel.add((Component)this.getCreatePanel(), "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
    }

    public void dispose() {
        this.parent = null;
        super.dispose();
    }

    private void doOk() {
        if (this.apply()) {
            this.ok = true;
            this.dispose();
        }
    }

    private void doCancel() {
        this.dispose();
    }

    protected boolean apply() {
        return this.validateFields();
    }

    public boolean ok() {
        return this.ok;
    }

    private sIpAddr getIpAddr(String string) {
        return IpAddrFactory.getIpAddr(InetUtil.makeIpAddr(string));
    }

    private sIpSubnet getSourceSubnet() {
        return new sIpSubnet(this.getIpAddr(this.createPane.getSourceAddress()), this.getIpAddr(this.createPane.getSourceMask()));
    }

    private sIpSubnet getDestinationSubnet() {
        return new sIpSubnet(this.getIpAddr(this.createPane.getDestinationAddress()), this.getIpAddr(this.createPane.getDestinationMask()));
    }

    public sIpTunnel getTunnel() {
        return new sIpTunnel(this.getSourceSubnet(), this.getDestinationSubnet());
    }

    private JPanel getCreatePanel() {
        this.createPane = new TunnelCreatePane();
        return this.createPane;
    }

    private JPanel getButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 5));
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TunnelsDialog.this.doOk();
            }
        });
        jPanel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TunnelsDialog.this.doCancel();
            }
        });
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    private String exceptionMessage(NumberFormatException numberFormatException) {
        String string = numberFormatException.getMessage();
        int n = string.indexOf(58);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if (Character.isUpperCase(string.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
            stringBuffer.append(string.substring(1));
            string = stringBuffer.toString();
        }
        return string;
    }

    private boolean validateFields() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            InetUtil.parseDottedString(this.createPane.getSourceAddress());
        }
        catch (NumberFormatException numberFormatException) {
            stringBuffer.append("Invalid source subnet address: " + this.exceptionMessage(numberFormatException));
        }
        try {
            InetUtil.parseDottedString(this.createPane.getSourceMask());
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Invalid source subnet mask: " + this.exceptionMessage(numberFormatException));
        }
        try {
            InetUtil.parseDottedString(this.createPane.getDestinationAddress());
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Invalid destination subnet address: " + this.exceptionMessage(numberFormatException));
        }
        try {
            InetUtil.parseDottedString(this.createPane.getDestinationMask());
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Invalid destination subnet mask: " + this.exceptionMessage(numberFormatException));
        }
        if (stringBuffer.length() > 0) {
            CerentDialog.errorDialog((Component)((Object)this), (String)stringBuffer.toString());
        }
        return stringBuffer.length() == 0;
    }

    private static class TunnelCreatePane
    extends JPanel {
        private JTextField _srcAddress;
        private JTextField _srcMask;
        private SpinPropertyEditor _srcLength;
        private JTextField _dstAddress;
        private JTextField _dstMask;
        private SpinPropertyEditor _dstLength;

        TunnelCreatePane() {
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(0, 5, 5));
            jPanel.add(new JLabel("Source Address:"));
            this._srcAddress = new JTextField(16);
            jPanel.add(this._srcAddress);
            this._srcLength = new SpinPropertyEditor("Length: ", 1, 0, 32);
            jPanel.add(this._srcLength);
            jPanel.add(new JLabel("Mask:"));
            this._srcMask = new JTextField(16);
            jPanel.add(this._srcMask);
            this.add(jPanel);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(0, 5, 5));
            jPanel2.add(new JLabel("Destination Address:"));
            this._dstAddress = new JTextField(16);
            jPanel2.add(this._dstAddress);
            this._dstLength = new SpinPropertyEditor("Length: ", 1, 0, 32);
            jPanel2.add(this._dstLength);
            jPanel2.add(new JLabel("Mask:"));
            this._dstMask = new JTextField(16);
            jPanel2.add(this._dstMask);
            this.add(jPanel2);
            this._srcMask.setEditable(false);
            this._srcMask.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._dstMask.setEditable(false);
            this._dstMask.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._srcLength.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ TunnelCreatePane this$0;
                {
                    this.this$0 = tunnelCreatePane;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TunnelCreatePane.access$200(this.this$0);
                }
            });
            this._dstLength.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ TunnelCreatePane this$0;
                {
                    this.this$0 = tunnelCreatePane;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TunnelCreatePane.access$300(this.this$0);
                }
            });
            this._srcLength.setValue("24");
            this._dstLength.setValue("24");
            this.updateSourceMask();
            this.updateDestinationMask();
        }

        String getSourceAddress() {
            return this._srcAddress.getText();
        }

        String getDestinationAddress() {
            return this._dstAddress.getText();
        }

        String getSourceMask() {
            return this._srcMask.getText();
        }

        String getDestinationMask() {
            return this._dstMask.getText();
        }

        private String getLength(SpinPropertyEditor spinPropertyEditor) {
            int n = Integer.parseInt((String)spinPropertyEditor.getValue());
            return InetUtil.makeDottedString(InetUtil.makeNetMask(n));
        }

        private void updateSourceMask() {
            try {
                this._srcMask.setText(this.getLength(this._srcLength));
            }
            catch (NumberFormatException numberFormatException) {
                db.finer("updateSourceMask() failed: " + numberFormatException);
            }
        }

        private void updateDestinationMask() {
            try {
                this._dstMask.setText(this.getLength(this._dstLength));
            }
            catch (NumberFormatException numberFormatException) {
                db.finer("updateDestinationMask() failed: " + numberFormatException);
            }
        }

        static /* synthetic */ void access$200(TunnelCreatePane tunnelCreatePane) {
            tunnelCreatePane.updateSourceMask();
        }

        static /* synthetic */ void access$300(TunnelCreatePane tunnelCreatePane) {
            tunnelCreatePane.updateDestinationMask();
        }
    }
}

