/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sLineThresholds600;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.sonet.TdmTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;

public class CxcTdmLinePmThresholdsTableModel
extends TdmTableModel {
    protected boolean[] rowDirty = null;
    protected sLineThresholds600[] statsVal;
    protected eIntervalType intervalType;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int ES_INDEX = 2;
    public static final int SES_INDEX = 3;
    public static final int FC_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PSC_INDEX = 6;
    public static final int PSD_INDEX = 7;
    public static final int PSCW_INDEX = 8;
    public static final int PSDW_INDEX = 9;
    public static final int PSCS_INDEX = 10;
    public static final int PSDS_INDEX = 11;
    public static final int PSCR_INDEX = 12;
    public static final int PSDR_INDEX = 13;
    public static String[] columnNames = new String[]{"Port", "CV", "ES", "SES", "FC", "UAS", "PSC", "PSD", "PSC-W", "PSD-W"};
    private static final SDebug db = new SDebug("CxcTdmLinePmThresholdsTableModel");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public CxcTdmLinePmThresholdsTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(iNodeModel);
        this.model = tdmLineModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.myPortRenderer = new EntityCellRenderer();
        this.init();
    }

    private void init() {
        this.numLines = this.model.length;
        this.rowDirty = new boolean[this.numLines];
        this.statsVal = new sLineThresholds600[this.numLines];
    }

    private void refreshPmStats(int n) {
        if (this.statsVal.length > 0 && this.statsVal[n] == null) {
            try {
                this.statsVal[n] = new sLineThresholds600();
                this.model[n].getLineThresholds(this.nearEnd, this.intervalType, this.statsVal[n]);
                if (db.on()) {
                    db.println("Stats val got for line " + n);
                }
                this.printStats(this.statsVal[n]);
            }
            catch (NoSuchInterface noSuchInterface) {
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public Class getColumnClass(int n) {
        if (n == 0) {
            return class$java$lang$String == null ? (class$java$lang$String = CxcTdmLinePmThresholdsTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$java$lang$Integer == null ? (class$java$lang$Integer = CxcTdmLinePmThresholdsTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 1: {
                    if (this.statsVal[n].cv == n3) break;
                    this.statsVal[n].cv = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 2: {
                    if (this.statsVal[n].es == n3) break;
                    this.statsVal[n].es = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 3: {
                    if (this.statsVal[n].ses == n3) break;
                    this.statsVal[n].ses = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 4: {
                    if (this.statsVal[n].fc == n3) break;
                    this.statsVal[n].fc = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 6: {
                    if (this.statsVal[n].psc == n3) break;
                    this.statsVal[n].psc = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 7: {
                    if (this.statsVal[n].psd == n3) break;
                    this.statsVal[n].psd = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 8: {
                    if (this.statsVal[n].pscw == n3) break;
                    this.statsVal[n].pscw = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 9: {
                    if (this.statsVal[n].psdw == n3) break;
                    this.statsVal[n].psdw = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 10: {
                    if (this.statsVal[n].pscs == n3) break;
                    this.statsVal[n].pscs = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 11: {
                    if (this.statsVal[n].psds == n3) break;
                    this.statsVal[n].psds = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 12: {
                    if (this.statsVal[n].pscr == n3) break;
                    this.statsVal[n].pscr = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 13: {
                    if (this.statsVal[n].psdr == n3) break;
                    this.statsVal[n].psdr = n3;
                    this.rowDirty[n] = true;
                    break;
                }
                case 5: {
                    if (this.statsVal[n].uas == n3) break;
                    this.statsVal[n].uas = n3;
                    this.rowDirty[n] = true;
                    break;
                }
            }
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in CxcTdmLinePmThresholdsTableModel::setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in setValueAt " + exception);
            }
            System.err.println("Error in setValueAt " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        if (this.nearEnd) {
            return columnNames.length;
        }
        return 6;
    }

    public sLineThresholds600 getStatsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.statsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.numLines > 0) {
            try {
                if (AbstractPane.isUserAuthorized(this.model[0], SecurityLevel.PROVISIONING) && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0 && !this.model[n].isProtectLine();
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].cv);
                }
                case 2: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].es);
                }
                case 3: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].ses);
                }
                case 4: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].fc);
                }
                case 6: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].psc);
                }
                case 7: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].psd);
                }
                case 8: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pscw);
                }
                case 9: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].psdw);
                }
                case 10: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pscs);
                }
                case 11: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].psds);
                }
                case 12: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].pscr);
                }
                case 13: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].psdr);
                }
                case 5: {
                    this.refreshPmStats(n);
                    return new Integer(this.statsVal[n].uas);
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            System.err.println("Error in getValueAt " + exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void refreshMyLines(TdmLineModel[] tdmLineModelArray) {
        this.model = tdmLineModelArray;
        this.init();
        this.fireTableDataChanged();
    }

    public void refreshLineFromModel(int n) {
        this.statsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.statsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    private void printStats(sLineThresholds600 sLineThresholds6002) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sLineThresholds6002.cv);
            db.println("ES " + sLineThresholds6002.es);
            db.println("SES " + sLineThresholds6002.ses);
            db.println("FC " + sLineThresholds6002.fc);
            db.println("UAS " + sLineThresholds6002.uas);
            db.println("PSC " + sLineThresholds6002.psc);
            db.println("PSD " + sLineThresholds6002.psd);
            db.println("PSC-W " + sLineThresholds6002.pscw);
            db.println("PSD-W " + sLineThresholds6002.psdw);
            db.println("PSC-S " + sLineThresholds6002.pscs);
            db.println("PSD-S " + sLineThresholds6002.psds);
            db.println("PSC-R " + sLineThresholds6002.pscr);
            db.println("PSD-R " + sLineThresholds6002.psdr);
            db.println("===============================================");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

