/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui.sonet;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.SonetMedia.sLineThresholds;
import cerent.cms.model.DwdmLineUpdate;
import cerent.cms.model.FramingType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.OcnLineUpdate;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmModuleModel;
import cerent.cms.ui.CSHelpConst;
import cerent.cms.ui.CSHelpID;
import cerent.cms.ui.NodeProvPane;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.sonet.SdhLinePmThresholdsTableModel;
import cerent.cms.ui.sonet.SonetLinePmThresholdsTableModel;
import cerent.cms.ui.sonet.TdmLinePmThresholdsTableModel;
import cerent.util.AnnotatedException;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import cerent.util.gui.UScrollPane;
import cerent.util.gui.UTable;
import java.awt.Component;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TdmLinePmThresholdsPane
extends NodeProvPane
implements TableModelListener {
    protected TdmLinePmThresholdsTableModel dataModel = null;
    protected TdmLineModel[] lineModels = null;
    protected TdmModuleModel eqpmtModel = null;
    protected eIntervalType intervalType = null;
    protected boolean nearEnd = false;
    private static final SDebug db = new SDebug("TdmLinePmThresholdsPane");

    public TdmLinePmThresholdsPane(String string, TabbedView tabbedView, TdmLineModel[] tdmLineModelArray, eIntervalType eIntervalType2, boolean bl) {
        super(string, tabbedView);
        this.lineModels = tdmLineModelArray;
        this.intervalType = eIntervalType2;
        this.nearEnd = bl;
        this.dataModel = this.getTableModel();
        this.dataModel.addTableModelListener(this);
        this.table = new UTable((TableModel)this.dataModel);
        UScrollPane uScrollPane = new UScrollPane((Component)this.table);
        this.add((Component)uScrollPane);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(225);
        for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth(50);
        }
        this.prepareColumns();
        this.registerWithModel();
    }

    protected TdmLinePmThresholdsTableModel getTableModel() {
        INodeModel iNodeModel = this.uiModel.getNodeModel();
        int n = iNodeModel.getFramingType();
        ModuleModel moduleModel = (ModuleModel)this.getUiModel();
        TdmLinePmThresholdsTableModel tdmLinePmThresholdsTableModel = FramingType.getFramingType((int)n).isSdh() ? new SdhLinePmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, this.nearEnd, moduleModel) : new SonetLinePmThresholdsTableModel(iNodeModel, this.lineModels, this.intervalType, this.nearEnd, moduleModel);
        return tdmLinePmThresholdsTableModel;
    }

    protected void registerWithModel() {
        super.registerWithModel();
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].addObserver((Observer)((Object)this));
        }
    }

    public void unregisterWithModel() {
        for (int i = 0; i < this.lineModels.length; ++i) {
            this.lineModels[i].deleteObserver((Observer)((Object)this));
        }
    }

    public void dispose() {
        this.unregisterWithModel();
        super.dispose();
    }

    protected void changeMessage(Observable observable, Object object) {
        this.requestRefresh(observable, this.getRefreshThread(observable));
    }

    private Runnable getRefreshThread(final Observable observable) {
        return new Runnable(){

            public void run() {
                TdmLinePmThresholdsPane.this.refreshLine(observable);
            }
        };
    }

    protected void refreshMyLines(Object object) {
        if (object instanceof OcnLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = (TdmLineModel[])((OcnLineUpdate)object).getModels();
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        } else if (object instanceof DwdmLineUpdate) {
            this.unregisterWithModel();
            this.lineModels = ((DwdmLineUpdate)object).getTdmLineModels();
            this.registerWithModel();
            this.dataModel.refreshMyLines(this.lineModels);
        }
    }

    protected void refreshLine(Observable observable) {
        int n = Arrays.asList(this.lineModels).indexOf(observable);
        if (n != -1) {
            if (db.on()) {
                db.println("Refreshing Line " + n);
            }
            this.dataModel.refreshLineFromModel(n);
        } else if (db.on()) {
            db.println("In TdmLinePmThresholdsPane changeMessage cannot find Model " + observable);
        }
    }

    public void applyChangesToModel() throws Exception {
        int n = 0;
        try {
            for (n = 0; n < this.lineModels.length; ++n) {
                if (db.on()) {
                    db.println("setting at iteration " + n);
                }
                if (!this.dataModel.isRowDirty(n)) continue;
                this.printThresholds(this.dataModel.getThresholdsVal(n));
                this.lineModels[n].setLinePmThresholds(this.intervalType, this.nearEnd, this.dataModel.getThresholdsVal(n));
            }
            this.dataModel.resetDirtyBits();
        }
        catch (Exception exception) {
            throw new AnnotatedException("Error applying changes to row " + (n + 1), exception);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.lineModels == null) {
            return;
        }
        int n = tableModelEvent.getLastRow() > this.lineModels.length - 1 ? this.lineModels.length - 1 : tableModelEvent.getLastRow();
        for (int i = tableModelEvent.getFirstRow(); i <= n; ++i) {
            if (!this.dataModel.isRowDirty(i)) continue;
            this.setDirty();
            return;
        }
        this.resetDirty();
    }

    public void refreshFromModel() throws Exception {
        if (db.on()) {
            db.println("refreshing ");
        }
        this.dataModel.refreshFromModel();
        this.resetDirty();
    }

    protected void prepareColumns() {
    }

    private void printThresholds(sLineThresholds sLineThresholds2) {
        if (db.on()) {
            db.println("Near End = " + this.nearEnd + " Interval Type = " + EnumStrings.getString((Object)this.intervalType, (int)this.intervalType.value()));
            db.println("===============================================");
            db.println("CV " + sLineThresholds2.cv);
            db.println("ES " + sLineThresholds2.es);
            db.println("SES " + sLineThresholds2.ses);
            db.println("BBE " + sLineThresholds2.bbe);
            db.println("FC " + sLineThresholds2.fc);
            db.println("PSC " + sLineThresholds2.psc);
            db.println("PSD " + sLineThresholds2.psd);
            db.println("UAS " + sLineThresholds2.uas);
            db.println("===============================================");
        }
    }

    public CSHelpID getHelpID() {
        return CSHelpConst.TdmLinePmThresholdsPane;
    }
}

