/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.model.IModel;
import cerent.cms.model.Model;
import cerent.cms.model.NonCachedValue;
import cerent.cms.xml.AbstractSimpleMetaData;
import cerent.cms.xml.CommandResponseCache;
import cerent.cms.xml.IMethodMetaData;
import cerent.cms.xml.MetaDataRepository;
import cerent.cms.xml.MethodState;
import cerent.cms.xml.MethodTypeInfo;
import cerent.cms.xml.OutOfBandUtil;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.TypeInfoRepository;
import cerent.cms.xml.XmlHelperFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.XmlTagFactory;
import cerent.cms.xml.helper.GenericHelper;
import cerent.cms.xml.helper.Helper;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.xml.DOMUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseModelHelper {
    static CommandResponseCache responses = new CommandResponseCache();
    public static final String XML_FAIL_NO_METADATA = "xml.failnometadata";
    private static String FAULT = "fault";
    private static final Class GENERIC_HELPER_CLASS = class$cerent$cms$xml$helper$GenericHelper == null ? (class$cerent$cms$xml$helper$GenericHelper = BaseModelHelper.class$("cerent.cms.xml.helper.GenericHelper")) : class$cerent$cms$xml$helper$GenericHelper;
    static final Node[] NodeArrayTemplate = new Node[0];
    private static final String NO_ATTRIBUTE_FAULT_MSG = "If this was a public method access, check the syntax of the command, verify the typeinfo/*.xml file entry is defined correctly and the xml file has been built into the current ELE_MMNN.jar file.";
    private static TypeInfoRepository tir = BaseModelHelper.getTypeInfoRepository();
    private boolean canonical = true;
    private static final String GENERIC_HELPER = "cerent.cms.xml.helper.Generic";
    public static final String GET_ATTRIBUTE_COMMAND = "get";
    protected static final String GET_ATTRIBUTE_METHOD = "toXml";
    public static final String SET_ATTRIBUTE_COMMAND = "set";
    private static final String SET_ATTRIBUTE_METHOD = "fromXml";
    private static final String EMPTY_TEXT_NODE = "#";
    public static final String GET_COMMAND = "get";
    public static final String SET_COMMAND = "set";
    public static final String RESPONSE_TAG = "Response";
    public static final String NO_ARGUMENTS = "NO_ARGUMENTS";
    protected static final Debug db = new Debug("BaseModelHelper", false);
    static /* synthetic */ Class class$cerent$cms$xml$helper$GenericHelper;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$java$lang$String;

    public static Node get(Model model, Node node) throws CTCUserException {
        String string = model.getClass().getName();
        Element element = XmlNodeFactory.makeElement(node, string, model.getIndex());
        Node[] nodeArray = BaseModelHelper.getNoHeader(model, null, element);
        DOMUtil.appendChildren((Node)element, (Node[])nodeArray);
        return element;
    }

    public static Node get(Model model, Node node, Node node2) throws CTCUserException {
        String string = responses.getTransformedString(model.getClass().getName());
        Element element = XmlNodeFactory.makeElement(node2, string, model.getIndex(), "get");
        Node[] nodeArray = BaseModelHelper.getNoHeader(model, null, element);
        DOMUtil.appendChildren((Node)element, (Node[])nodeArray);
        return element;
    }

    public static Node[] attributeMethod(Model model, Node node, Node node2) throws CTCUserException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            if (db.on()) {
                db.println("Number of Attributes under " + node.getNodeName() + " = " + nodeList.getLength());
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node3 = nodeList.item(i);
                if (node3.getNodeType() != 1) continue;
                String[] stringArray = DOMUtil.getChildNodeTags((Node)node3);
                MethodTypeInfo methodTypeInfo = MetaDataRepository.getInstance().getInfoForPublicMethod(model.getClass().getName(), node3.getNodeName(), stringArray);
                if (methodTypeInfo != null) {
                    arrayList.add(BaseModelHelper.invokePublicMethod(model, node3, methodTypeInfo, stringArray, node2));
                    continue;
                }
                arrayList.add(BaseModelHelper.invokeAttributeMethod(model, node3, node2));
            }
        }
        return arrayList.toArray(NodeArrayTemplate);
    }

    private static Node invokeAttributeMethod(Model model, Node node, Node node2) throws CTCUserException {
        Object object;
        String string = node.getNodeName();
        if (string.startsWith(EMPTY_TEXT_NODE)) {
            return null;
        }
        String string2 = "";
        String string3 = "";
        String string4 = responses.getTransformedString(string);
        Node node3 = node2.appendChild(XmlNodeFactory.makeElement(node2, string4));
        boolean bl = false;
        if (string.startsWith("get")) {
            string3 = "get";
            string2 = GET_ATTRIBUTE_METHOD;
        } else if (string.startsWith("set")) {
            bl = true;
            string3 = "set";
            string2 = SET_ATTRIBUTE_METHOD;
        } else {
            throw new CTCUserException("Unknown Method: " + string + ".");
        }
        String string5 = string.substring(string3.length());
        if (db.on()) {
            db.println("Performing \"" + string3 + "\"" + " on " + string5);
        }
        if ((object = model.getAttributeByName(string5)) == null) {
            throw new CTCUserException("Attribute " + string5 + " NOT FOUND in " + model.getClass().getName() + ".  " + NO_ATTRIBUTE_FAULT_MSG);
        }
        Node node4 = BaseModelHelper.invokeCommandOnValue(object, node, string2, string4, node2);
        if (node4 != null) {
            node3.appendChild(node4);
        } else if (!bl) {
            throw new NullPointerException();
        }
        return node3;
    }

    private static Node invokePublicMethod(Model model, Node node, MethodTypeInfo methodTypeInfo, String[] stringArray, Node node2) throws CTCUserException {
        return BaseModelHelper.invokePublicMethod(model, node, methodTypeInfo, stringArray, null, node2);
    }

    private static Node invokePublicMethod(Model model, Node node, MethodTypeInfo methodTypeInfo, String[] stringArray, String[] stringArray2, Node node2) throws CTCUserException {
        String string = node.getNodeName();
        String string2 = responses.getTransformedString(string);
        Node node3 = node2.appendChild(XmlNodeFactory.makeElement(node2, string2));
        MethodState methodState = BaseModelHelper.createMethodState(model, string, methodTypeInfo);
        if (methodState != null) {
            if (db.on()) {
                db.println("Performing \"" + string + "\"" + " on " + methodState);
            }
            node3.appendChild(GenericHelper.toXml(methodState, node, string2, node3));
        }
        return node3;
    }

    static MethodState createMethodState(Object object, String string, MethodTypeInfo methodTypeInfo) throws CTCUserException {
        Method method;
        Class<?> clazz = object.getClass();
        String string2 = clazz.getName();
        try {
            method = methodTypeInfo.getMatchingMethod(string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CTCUserException(classNotFoundException.getMessage());
        }
        if (method == null) {
            throw new CTCUserException("could not find public instance method matching: " + methodTypeInfo);
        }
        MethodState methodState = null;
        if (!BaseModelHelper.isProductExcluded(object, methodTypeInfo)) {
            methodState = new MethodState(object, method, methodTypeInfo);
        }
        return methodState;
    }

    static MethodState createMethodState(Object object, String string, Method method, String[] stringArray) throws CTCUserException {
        MethodState methodState = null;
        IMethodMetaData iMethodMetaData = MetaDataRepository.getInstance().getMetDataByType(string, stringArray);
        if (!BaseModelHelper.isProductExcluded(object, (AbstractSimpleMetaData)((Object)iMethodMetaData))) {
            methodState = new MethodState(object, method, iMethodMetaData);
        }
        return methodState;
    }

    static MethodState createMethodState(Object object, String string, Method method, Class[] classArray) throws CTCUserException {
        int n = classArray == null ? 0 : classArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = classArray[i].getName();
        }
        return BaseModelHelper.createMethodState(object, string, method, stringArray);
    }

    private static TypeInfoRepository getTypeInfoRepository() {
        try {
            MetaDataRepository metaDataRepository = MetaDataRepository.getInstance();
            tir = metaDataRepository.getTypeInfoRepository();
        }
        catch (CTCUserException cTCUserException) {
            tir = null;
        }
        return tir;
    }

    static boolean isProductExcluded(Object object, AbstractSimpleMetaData abstractSimpleMetaData) {
        boolean bl = true;
        if (tir != null) {
            bl = tir.isProductExcluded(object, abstractSimpleMetaData);
        }
        return bl;
    }

    public static Node get(Object object, Node node, Node node2) throws CTCUserException {
        return BaseModelHelper.getHeader(object, node, node2);
    }

    private static Node getHeader(Object object, Node node, Node node2) throws CTCUserException {
        return (Node)BaseModelHelper._get(object, node, true, node2);
    }

    private static Node[] getNoHeader(Object object, Node node, Node node2) throws CTCUserException {
        return (Node[])BaseModelHelper._get(object, node, false, node2);
    }

    private static Object _get(Object object, Node node, boolean bl, Node node2) throws CTCUserException {
        Object object2;
        String string;
        Node node3 = bl ? null : node2;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Class<?> clazz = object.getClass();
        IModel iModel = null;
        if (object instanceof IModel) {
            iModel = (IModel)object;
        }
        String string2 = clazz.getName();
        if (node != null) {
            string = node.getNodeName();
        } else {
            string = "get" + MethodTypeInfo.getLastSegment(ReflectionUtil.fromJvmClassname((String)string2));
            if (iModel != null) {
                string = string + " index=\"" + iModel.getIndex() + "\"";
            }
        }
        String string3 = "";
        String string4 = "";
        if (!(object instanceof Model)) {
            throw new CTCUserException(string2 + " not an instance of Model");
        }
        if (db.doTiming()) {
            object2 = (Model)object;
            db.logThreadTiming("start state access for model: " + object2.getClass().getName() + " " + ((Model)object2).getIndex());
        }
        object2 = object.getClass().getName();
        if (bl) {
            node3 = node2.appendChild(XmlNodeFactory.makeElement(node2, (String)object2, ((Model)object).getIndex()));
        }
        boolean bl2 = Preferences.instance().getBoolean("ctc", XML_FAIL_NO_METADATA, false);
        try {
            Node node4;
            Object object3;
            Class[] classArray;
            Object object4;
            int n;
            Method[] methodArray = clazz.getMethods();
            int n2 = 0;
            for (n = 0; n < methodArray.length; ++n) {
                Method method = methodArray[n];
                int n3 = method.getModifiers();
                if ((n3 & 1) == 0) continue;
                string4 = method.getName();
                String string5 = method.getDeclaringClass().getName();
                object4 = string5 + "." + string4;
                classArray = method.getParameterTypes();
                if (!MetaDataRepository.getInstance().isPublicMethodByType(string5, string4, classArray) || !ReflectionUtil.isAccessor((Method)method) || !BaseModelHelper.isStateMethod(method, string2)) continue;
                if (db.doTiming()) {
                    db.logThreadTiming("start pub method: " + n + "(" + n2 + ")" + " " + string2 + "." + string4);
                }
                if ((object3 = BaseModelHelper.createMethodState(object, (String)object4, method, classArray)) == null) continue;
                try {
                    NonCachedValue.resetCounter();
                    node4 = BaseModelHelper.invokeCommandOnValue((MethodState)object3, null, GET_ATTRIBUTE_METHOD, "", node3);
                    if (NonCachedValue.getCounter() == 0) {
                        if (bl) {
                            DOMUtil.appendChild((Node)node3, (Node)node4);
                        } else {
                            arrayList.add(node4);
                        }
                    } else {
                        String string6 = "Method: " + (String)object4 + " internally accesses a NonCached" + " value and by design is not included in" + " the Model get xml response.\n" + " This method should be marked as <action>true</action>" + " in the ../CTC/schema/typeinfo/*.xml file.";
                        if (db.on()) {
                            db.println(string6);
                        }
                        CTCUserException cTCUserException = new CTCUserException(string6);
                        BaseModelHelper.handleAttributeException(string, node3, (String)object4, (Exception)((Object)cTCUserException));
                    }
                }
                catch (Exception exception) {
                    BaseModelHelper.handleAttributeException(string, node3, (String)object4, exception);
                }
                ++n2;
            }
            string4 = "";
            Iterator iterator = ((Model)object).getAttributeNames();
            boolean bl3 = true;
            object4 = new LinkedList();
            while (bl3) {
                bl3 = false;
                try {
                    while (iterator.hasNext()) {
                        ((LinkedList)object4).add(iterator.next());
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    ((LinkedList)object4).clear();
                    bl3 = true;
                    Thread.currentThread();
                    Thread.sleep(1L);
                }
            }
            iterator = ((AbstractSequentialList)object4).iterator();
            n = 0;
            while (iterator.hasNext()) {
                block36: {
                    string3 = (String)iterator.next();
                    classArray = ((Model)object).getFQAttributeName(string3);
                    object3 = ((Model)object).getAttributeByName(string3);
                    if (object3 != null) {
                        try {
                            if (!MetaDataRepository.getInstance().isAction(object3)) {
                                if (db.doTiming()) {
                                    db.logThreadTiming("start NCV/CV/UV: " + n + "(" + n2 + ")" + " " + string2 + "$" + string3);
                                }
                                try {
                                    if (bl) {
                                        node4 = BaseModelHelper.invokeCommandOnValue(object3, null, GET_ATTRIBUTE_METHOD, "", node3);
                                        DOMUtil.appendChild((Node)node3, (Node)node4);
                                    } else {
                                        node4 = BaseModelHelper.invokeCommandOnValue(object3, null, GET_ATTRIBUTE_METHOD, "", node3);
                                        arrayList.add(node4);
                                    }
                                    ++n2;
                                }
                                catch (Exception exception) {
                                    BaseModelHelper.handleAttributeException(string, node3, (String)classArray, exception);
                                }
                            }
                        }
                        catch (CTCUserException cTCUserException) {
                            if (bl2) {
                                throw cTCUserException;
                            }
                            if (!db.on()) break block36;
                            db.println("metadata missing for attr of type: " + object3.getClass().getName());
                        }
                    }
                }
                ++n;
            }
            if (iModel instanceof Model) {
                ((Model)iModel).flushHint();
            }
        }
        catch (CTCUserException cTCUserException) {
            Throwable throwable = XmlTagFactory.getOriginatingException(cTCUserException);
            throwable.printStackTrace();
            throw cTCUserException;
        }
        catch (Exception exception) {
            Throwable throwable = XmlTagFactory.getOriginatingException(exception);
            throwable.printStackTrace();
            throw new CTCUserException("BaseModelAdapter " + string2 + " " + string4 + "/" + string3 + exception.toString(), (Throwable)exception);
        }
        if (bl) {
            return node3;
        }
        return arrayList.toArray(NodeArrayTemplate);
    }

    private static boolean isStateMethod(Method method, String string) throws CTCUserException {
        boolean bl = false;
        TypeInfoRepository typeInfoRepository = MetaDataRepository.getInstance().getTypeInfoRepository();
        MethodTypeInfo methodTypeInfo = typeInfoRepository.lookupMethodTypeInfo(string, method.getName(), null, null, true);
        if (methodTypeInfo != null) {
            bl = !methodTypeInfo.getIsAction();
        }
        return bl;
    }

    protected static void handleAttributeException(String string, Node node, String string2, Exception exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        Document document = DOMUtil.getOwnerDocument((Node)node);
        Element element = OutOfBandUtil.addAttributeFault(node, string2, null);
        XmlNodeFactory.makeFaultDocument(document, element, "warning", string, exception);
    }

    protected static Node invokeCommandOnModel(Model model, Node node, String string, Node node2) throws ClassNotFoundException, CTCUserException {
        String string2;
        Object object;
        if (db.on()) {
            db.println("Performing invokeCommandOnModel(...) on " + model.getClass());
        }
        if ((object = model.getAttributeByName(string2 = node.getNodeName())) == null) {
            throw new CTCUserException("[BaseModelHelper] Value by Key " + string2 + " NOT FOUND in " + model.getClass().getName());
        }
        return BaseModelHelper.invokeCommandOnValue(object, node, string, "", node2);
    }

    static Class lookupHelperClass(MethodState methodState) throws CTCUserException {
        return GENERIC_HELPER_CLASS;
    }

    static Class lookupHelperClass(Object object) throws CTCUserException {
        Class clazz = XmlHelperFactory.lookupHelperClass(object.getClass());
        if (clazz == null) {
            try {
                clazz = XmlHelperFactory.getXmlHelperClass(GENERIC_HELPER);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new CTCUserException(classNotFoundException.toString(), (Throwable)classNotFoundException);
            }
            catch (Exception exception) {
                throw new CTCUserException(exception.toString(), (Throwable)exception);
            }
        }
        return clazz;
    }

    private static Node invokeCommandOnValue(MethodState methodState, Node node, String string, String string2, Node node2) throws CTCUserException {
        if (db.on()) {
            db.println("In invokeCommandOnValue " + methodState);
        }
        Class clazz = BaseModelHelper.lookupHelperClass(methodState);
        Node node3 = null;
        if (string2.equals("")) {
            string2 = methodState.toString();
        }
        Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = BaseModelHelper.class$("java.lang.Object")) : class$java$lang$Object, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = BaseModelHelper.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$java$lang$String == null ? (class$java$lang$String = BaseModelHelper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = BaseModelHelper.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node};
        Object[] objectArray = new Object[]{methodState, node, string2, node2};
        try {
            if (db.doTiming()) {
                db.logThreadTiming("start invokeCommandOnValue(" + string + ")");
            }
            Method method = clazz.getMethod(string, classArray);
            method.setAccessible(true);
            Object object = method.invoke(null, objectArray);
            node3 = (Node)object;
            if (db.doTiming()) {
                db.logThreadTiming("end invokeCommandOnValue");
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            if (BaseModelHelper.db.on) {
                db.print(exception.toString());
            }
            throw new CTCUserException("[BaseModelHelper] " + exception.toString(), (Throwable)exception);
        }
        return node3;
    }

    private static Node invokeCommandOnValue(Object object, Node node, String string, String string2, Node node2) throws CTCUserException {
        if (db.on()) {
            db.println("In invokeToXmlOnValue " + object.getClass());
        }
        Class clazz = BaseModelHelper.lookupHelperClass(object);
        Node node3 = null;
        if (string2.equals("")) {
            string2 = object.getClass().getName();
        }
        Class[] classArray = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = BaseModelHelper.class$("java.lang.Object")) : class$java$lang$Object, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = BaseModelHelper.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node, class$java$lang$String == null ? (class$java$lang$String = BaseModelHelper.class$("java.lang.String")) : class$java$lang$String, class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = BaseModelHelper.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node};
        Object[] objectArray = new Object[]{object, node, string2, node2};
        Method method = null;
        try {
            method = clazz.getMethod(string, classArray);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                clazz = GENERIC_HELPER_CLASS;
                method = clazz.getMethod(string, classArray);
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new CTCUserException("Method not found: " + string, (Throwable)noSuchMethodException2);
            }
        }
        try {
            if (method != null) {
                Object object2 = method.invoke(null, objectArray);
                node3 = (Node)object2;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            if (BaseModelHelper.db.on) {
                db.print(exception.toString());
            }
            throw new CTCUserException("[BaseModelHelper] " + exception.toString(), (Throwable)exception);
        }
        return node3;
    }

    protected static Node[] printIDModelArray(IModel[] iModelArray, Node node) throws CTCUserException {
        int n = iModelArray == null ? 0 : iModelArray.length;
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            IModel iModel = iModelArray[i];
            nodeArray[i] = BaseModelHelper.printModelAsID(iModel, node);
        }
        return nodeArray;
    }

    protected static Node printModelAsID(IModel iModel, Node node) {
        Class<?> clazz = iModel.getClass();
        if (db.on()) {
            db.println("in printModelItem() " + clazz);
        }
        return XmlNodeFactory.makeElement(node, clazz.getName(), iModel.getIndex());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Debug
    extends SDebug {
        boolean doTiming;

        public Debug(String string, boolean bl) {
            super(string, bl);
        }

        public final void setLogTiming(boolean bl) {
            this.doTiming = bl;
        }

        public boolean doTiming() {
            return this.doTiming;
        }

        public void logThreadTiming(String string) {
            this.println(Thread.currentThread() + " " + string + " " + System.currentTimeMillis() + " msecs");
        }

        public void logThreadDateAndTiming(String string) {
            Date date = new Date();
            this.println(Thread.currentThread() + " " + string + " " + date + "(" + date.getTime() + ")");
        }
    }
}

