/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.helper;

import cerent.cms.model.CTCUserException;
import cerent.cms.xml.EnumCache;
import cerent.cms.xml.ReflectionUtil;
import cerent.cms.xml.SchemaTagFactory;
import cerent.cms.xml.XmlNodeFactory;
import cerent.cms.xml.helper.BaseObjectHelper;
import cerent.cms.xml.helper.Helper;
import cerent.cms.xml.helper.SchemaHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EnumHelper
extends BaseObjectHelper {
    static EnumCache enumCache = new EnumCache();

    public static Node objectToXml(Object object, String string, Node node) throws CTCUserException {
        return EnumHelper.objectToXml(object, string, "value", node);
    }

    public static Node objectToXml(Object object, String string, String string2, Node node) throws CTCUserException {
        if (db.on()) {
            db.println("[EnumHelper] objectToXml(" + object + ", " + string + ") ");
        }
        Element element = null;
        if (object == null) {
            element = XmlNodeFactory.makeElement(node, string, "");
        } else {
            Class<?> clazz = object.getClass();
            Integer n = new Integer(-1);
            try {
                Method method = clazz.getMethod(string2, null);
                n = (Integer)method.invoke(object, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                Helper.handleInvokeException(invocationTargetException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new CTCUserException("No value() method found in " + clazz.getClass().getName(), (Throwable)noSuchMethodException);
            }
            catch (Exception exception) {
                throw new CTCUserException(exception.toString() + " while objectToXml() ", (Throwable)exception);
            }
            element = XmlNodeFactory.makeElement(node, string, enumCache.getStrings(clazz)[n]);
        }
        return element;
    }

    public static Object nodeToObject(Node node, String string) throws CTCUserException {
        if (db.on()) {
            db.print("[EnumHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
        }
        Object object = null;
        String string2 = "";
        try {
            Field[] fieldArray;
            string2 = node.getFirstChild().getNodeValue().trim();
            Class clazz = ReflectionUtil.forName(string);
            object = EnumHelper.convertIntToEnum(string2, clazz);
            if (object == null) {
                fieldArray = clazz.getDeclaredFields();
                object = EnumHelper.checkFields(fieldArray, string2);
            }
            if (object == null) {
                fieldArray = clazz.getFields();
                object = EnumHelper.checkFields(fieldArray, string2);
            }
            if (object == null) {
                throw new CTCUserException("[EnumHelper] Cannot find Enum field corresponding to " + string2 + " in class " + string);
            }
            if (db.on()) {
                db.println(" with return value " + string + " = " + string2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            db.println("[ERROR] Unable to set " + node.getNodeName());
            db.println("[REASON] " + exception.toString());
            throw new CTCUserException("[EnumHelper]" + exception.toString(), (Throwable)exception);
        }
        return object;
    }

    public static Object nodeToObjectDelete(Node node, String string) throws CTCUserException {
        if (db.on()) {
            db.print("[EnumHelper] nodeToObject(" + node.getNodeName() + ", " + string + ") ");
        }
        Object object = null;
        int n = -1;
        try {
            n = Integer.parseInt(node.getFirstChild().getNodeValue().trim());
            Class clazz = ReflectionUtil.forName(string);
            String string2 = "from_int";
            String string3 = "";
            Class[] classArray = new Class[]{Integer.TYPE};
            Object[] objectArray = new Object[]{new Integer(n)};
            Method method = clazz.getMethod(string2, classArray);
            object = method.invoke(null, objectArray);
            if (db.on()) {
                db.println(" with return value " + enumCache.getStrings(clazz)[n]);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Helper.handleInvokeException(invocationTargetException);
        }
        catch (Exception exception) {
            db.println("[ERROR] Unable to set " + node.getNodeName());
            db.println("[REASON] " + exception.toString());
            throw new CTCUserException("[EnumHelper]" + exception.toString(), (Throwable)exception);
        }
        return object;
    }

    public static Object toSchema(String string, String string2) throws CTCUserException {
        return EnumHelper.getTag(string, string2);
    }

    private static String getTag(String string, String string2) throws CTCUserException {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String[] stringArray = enumCache.getStrings(string2);
            SchemaHelper.createEnumType(string2, stringArray);
            stringBuffer.append(SchemaTagFactory.createClosedElementUserTypeTag(string, string2));
        }
        catch (Exception exception) {
            throw new CTCUserException("Enum not found: " + string2);
        }
        return stringBuffer.toString();
    }

    protected static Object convertIntToEnum(String string, Class clazz) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Object object = null;
        if (Character.isDigit(string.charAt(0))) {
            int n = Integer.parseInt(string);
            n = Integer.parseInt(string);
            String string2 = "from_int";
            String string3 = "";
            Class[] classArray = new Class[]{Integer.TYPE};
            Object[] objectArray = new Object[]{new Integer(n)};
            Method method = clazz.getMethod(string2, classArray);
            object = method.invoke(null, objectArray);
            if (db.on()) {
                db.println(" with return value " + enumCache.getStrings(clazz)[n]);
            }
        }
        return object;
    }

    protected static Object checkFields(Field[] fieldArray, String string) throws IllegalAccessException {
        Object object = null;
        for (int i = 0; i < fieldArray.length; ++i) {
            if (!fieldArray[i].getName().equals(string)) continue;
            object = fieldArray[i].get(null);
            break;
        }
        return object;
    }
}

