/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import cerent.cms.xml.ncvcall.ClassDef;
import cerent.cms.xml.ncvcall.ClassMember;
import cerent.cms.xml.ncvcall.Decl;
import cerent.cms.xml.ncvcall.MCExpressionBuilder;
import cerent.cms.xml.ncvcall.MethodCallsExpression;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class MemberDef
extends ClassMember {
    public static final int UNKNOWN_CALL_NCV = 0;
    public static final int AMBIG_CALL_NCV = 1;
    public static final int DOES_CALL_NCV = 2;
    public static final int DOES_NOT_CALL_NCV = 3;
    private int accessControl;
    private String fqMemType;
    private LinkedList argTypes;
    private LinkedList variables;
    private LinkedList mcExpressions;
    private MCExpressionBuilder builder;
    private LinkedList builderStack;
    private boolean visited;
    private int callNcvState = 0;

    public MemberDef(ClassDef classDef, String string, String string2) {
        super(classDef, 2, string2);
        this.fqMemType = string;
        this.accessControl = 2;
    }

    public MemberDef(int n, ClassDef classDef, String string, String string2, LinkedList linkedList, LinkedList linkedList2) {
        super(classDef, 3, string2);
        this.fqMemType = string;
        this.argTypes = linkedList;
        this.variables = new LinkedList();
        this.mcExpressions = new LinkedList();
        this.addVariableDecls(linkedList, linkedList2);
        this.builder = new MCExpressionBuilder(this);
        this.accessControl = n;
    }

    public String getFqMemType() {
        return this.fqMemType;
    }

    public LinkedList getArgTypes() {
        return this.argTypes;
    }

    public int getNumArgTypes() {
        int n = this.argTypes == null ? 0 : this.argTypes.size();
        return n;
    }

    public boolean isPrivate() {
        return this.accessControl == 0;
    }

    public boolean unknownToCallNcv() {
        return this.callNcvState == 0;
    }

    public boolean doesCallNcv() {
        return this.callNcvState == 2;
    }

    public boolean doesNotCallNcv() {
        return this.callNcvState == 3;
    }

    public int getCallNcvState() {
        return this.callNcvState;
    }

    public void setCallNcvState(int n) {
        this.callNcvState = n;
    }

    public boolean wasVisited() {
        return this.visited;
    }

    public boolean visit() {
        this.visited = true;
        return true;
    }

    public boolean unvisit() {
        this.visited = false;
        return false;
    }

    public String getVariableDecl(String string) {
        String string2 = null;
        ListIterator listIterator = this.variables.listIterator(this.variables.size());
        while (listIterator.hasPrevious()) {
            Decl decl = (Decl)listIterator.previous();
            if (!decl.name.equals(string)) continue;
            string2 = decl.fqType;
            break;
        }
        return string2;
    }

    public void addVariableDecl(String string, String string2) {
        String string3 = this.getParentClass().resolveType(string);
        this.variables.add(new Decl(string3, string2));
    }

    public void addVariableDecls(LinkedList linkedList, LinkedList linkedList2) {
        if (linkedList == null) {
            return;
        }
        Iterator iterator = linkedList.iterator();
        Iterator iterator2 = linkedList2.iterator();
        while (iterator.hasNext()) {
            this.addVariableDecl((String)iterator.next(), (String)iterator2.next());
        }
    }

    public MCExpressionBuilder getBuilder() {
        return this.builder;
    }

    public boolean isCallDepthGreater(int n) {
        int n2 = this.builder.getLastCallDepth();
        if (n2 <= 0) {
            return false;
        }
        return n > n2;
    }

    public boolean isCallDepthLesser(int n) {
        int n2 = this.builder.getLastCallDepth();
        return n < n2;
    }

    public MCExpressionBuilder resetBuilder() {
        this.builder = new MCExpressionBuilder(this);
        return this.builder;
    }

    public MCExpressionBuilder pushBuilder() {
        if (this.builderStack == null) {
            this.builderStack = new LinkedList();
        }
        this.builderStack.add(this.builder);
        this.builder = new MCExpressionBuilder(this);
        return this.builder;
    }

    public MCExpressionBuilder popBuilder() {
        this.finishBuilder();
        if (this.builderStack == null || this.builderStack.size() == 0) {
            return null;
        }
        this.builder = (MCExpressionBuilder)this.builderStack.removeLast();
        return this.builder;
    }

    public void popAllBuilder() {
        if (this.builderStack != null) {
            while (this.builderStack.size() > 0) {
                this.popBuilder();
            }
        }
        this.finishBuilder();
    }

    public void finishBuilder() {
        if (this.builder == null) {
            return;
        }
        MethodCallsExpression methodCallsExpression = this.builder.finish(this);
        if (methodCallsExpression == null) {
            return;
        }
        if (this.builderStack != null && this.builderStack.size() > 0) {
            MCExpressionBuilder mCExpressionBuilder = (MCExpressionBuilder)this.builderStack.getLast();
            mCExpressionBuilder.addSubCall(methodCallsExpression);
        } else {
            this.addMCExpression(methodCallsExpression);
        }
    }

    public boolean unusedBuilder() {
        return this.builder.unused();
    }

    public boolean isTypeCastOnTopOfStack() {
        return this.builder.isTypeCastOnTopOfStack();
    }

    private void addMCExpression(MethodCallsExpression methodCallsExpression) {
        this.mcExpressions.add(methodCallsExpression);
    }

    public boolean isStateCandidate() {
        int n = this.getMemType();
        return n == 3 && !this.fqMemType.equals("void") && (this.argTypes == null || this.argTypes.size() == 0);
    }

    public boolean isNcvCallDone(ClassDef classDef) {
        boolean bl = false;
        try {
            if (this.wasVisited()) {
                return false;
            }
            this.visit();
            if (this.doesCallNcv()) {
                bl = true;
            } else {
                boolean bl2;
                ClassDef classDef2 = this.getParentClass();
                boolean bl3 = bl2 = classDef == null || classDef == classDef2;
                if (!this.doesNotCallNcv() || !bl2) {
                    Iterator iterator = this.mcExpressions.iterator();
                    while (iterator.hasNext() && !bl) {
                        MethodCallsExpression methodCallsExpression = (MethodCallsExpression)iterator.next();
                        bl = methodCallsExpression.isNcvCallDone(classDef);
                    }
                    if (bl2) {
                        this.setCallNcvState(bl ? 2 : 3);
                    }
                }
            }
            this.unvisit();
        }
        catch (RuntimeException runtimeException) {
            System.out.println("### runtime error: " + runtimeException);
            runtimeException.printStackTrace(System.out);
            throw runtimeException;
        }
        return bl;
    }

    public boolean isDirectNcvCall(ClassDef classDef) {
        int n;
        String string;
        String string2;
        boolean bl = false;
        if (classDef.isDirectNcv() && ((string2 = (string = this.getFqName()).substring((n = string.lastIndexOf(".")) + 1)).startsWith("get") || string2.startsWith("set"))) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int n;
        int n2 = this.getMemType() + 17 * this.fqMemType.hashCode() + 17 * this.fqName.hashCode();
        int n3 = n = this.argTypes == null ? 0 : this.argTypes.size();
        if (n > 0) {
            Iterator iterator = this.argTypes.iterator();
            while (iterator.hasNext()) {
                n2 += 17 * iterator.next().hashCode();
            }
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        boolean bl = object instanceof MemberDef;
        if (bl) {
            int n;
            MemberDef memberDef = (MemberDef)object;
            boolean bl2 = bl = this.fqMemType.equals(memberDef.fqMemType) && this.fqName.equals(memberDef.fqName);
            if (!bl) {
                return false;
            }
            int n2 = this.argTypes == null ? 0 : this.argTypes.size();
            int n3 = n = memberDef.argTypes == null ? 0 : memberDef.argTypes.size();
            if (n2 != n) {
                return false;
            }
            if (n2 == 0) {
                return true;
            }
            Iterator iterator = this.argTypes.iterator();
            Iterator iterator2 = memberDef.argTypes.iterator();
            while (bl && iterator.hasNext()) {
                bl &= iterator.next().equals(iterator2.next());
            }
        }
        return bl;
    }
}

