/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.xml.ncvcall;

import antlr.Token;
import antlr.collections.AST;
import cerent.cms.xml.ncvcall.CallItem;
import cerent.cms.xml.ncvcall.ClassDef;
import cerent.cms.xml.ncvcall.ClassDefs;
import cerent.cms.xml.ncvcall.IParsingManager;
import cerent.cms.xml.ncvcall.ImportResolver;
import cerent.cms.xml.ncvcall.MemberDef;
import cerent.cms.xml.ncvcall.ParsingManager;
import cerent.cms.xml.ncvcall.SourcePathResolver;
import cerent.util.antlr.ASTChildIterator;
import cerent.util.antlr.ASTUtil;
import cerent.util.antlr.DefaultParserBinder;
import cerent.util.antlr.IParserBinder;
import cerent.util.antlr.JavaRecognizer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NCVCallParserBinder
extends DefaultParserBinder
implements IParserBinder {
    private static final String PIDENT_CALL = "pident";
    private static final String PRIM_CALL = "prim";
    private static final String SUPER_CALL = "super";
    private static SourcePathResolver srcPathResolver;
    private static IParsingManager parsingManager;
    private String packag;
    private ImportResolver importResolver;
    private ClassDef thisClass;
    private ClassDef currentClass;
    private String currentFQClass = null;
    private MemberDef currentMethod;
    private LinkedList callStack = new LinkedList();

    public static void init(String string, String string2) {
        srcPathResolver = new SourcePathResolver(string, string2);
    }

    public NCVCallParserBinder(JavaRecognizer javaRecognizer) {
        super(javaRecognizer);
    }

    public void logln(String string) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n == 1) {
            return;
        }
        if (JavaRecognizer.verbose) {
            NCVCallParserBinder._logln((String)string);
        }
    }

    public void log(String string) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n == 1) {
            return;
        }
        if (JavaRecognizer.verbose) {
            NCVCallParserBinder._log((String)string);
        }
    }

    private LinkedList getParmTypes(AST aST) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (aST != null) {
            for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                AST aST3;
                AST aST4 = ASTUtil.getChild((AST)aST2, (int)1);
                if (aST4 == null || (aST3 = aST4.getFirstChild()) == null) continue;
                linkedList.add(this.trueType(aST3));
            }
        }
        return linkedList;
    }

    private LinkedList getArgs(AST aST) {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (aST != null) {
            for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
                AST aST3 = ASTUtil.getChild((AST)aST2, (int)2);
                if (aST3 == null) continue;
                linkedList.add(aST3.getText());
            }
        }
        return linkedList;
    }

    private static String toParmTypesStr(List list) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (list != null) {
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append((String)iterator.next());
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public void bindPackageDef(AST aST) {
        super.bindPackageDef(aST);
        this.bindPackageDef(aST.getText());
    }

    private void bindPackageDef(String string) {
        this.packag = string;
        this.importResolver = new ImportResolver(string, srcPathResolver);
        this.logln("package: " + string);
    }

    public void bindImport(AST aST) {
        super.bindImport(aST);
        this.bindImport(aST.getText());
    }

    private void bindImport(String string) {
        this.importResolver.addImport(string);
        this.logln("import: " + string);
    }

    public void bindClassDef(AST aST) {
        super.bindClassDef(aST);
        String string = aST.getText();
        this.currentFQClass = this.currentFQClass == null ? this.packag + "." + string : this.currentFQClass + "." + string;
        ClassDef classDef = ClassDefs.getClassDef(this.currentFQClass);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        if (n == 0) {
            this.thisClass = classDef != null ? classDef : new ClassDef(null, 0, this.importResolver, this.currentFQClass, parsingManager);
            this.currentClass = this.thisClass;
        } else {
            ClassDef classDef2 = classDef != null ? classDef : new ClassDef(this.currentClass, 1, this.importResolver, this.currentFQClass, parsingManager);
            this.currentClass = classDef2;
        }
        for (int i = 0; i < n; ++i) {
            this.log("  ");
        }
        this.log("class: " + this.currentFQClass);
    }

    public void endBindClassDef() {
        ClassDef classDef;
        super.endBindClassDef();
        this.currentClass = classDef = this.currentClass.getParentClass();
        int n = this.currentFQClass.lastIndexOf(".");
        this.currentFQClass = this.currentFQClass.substring(0, n);
        if (this.currentFQClass.equals(this.packag)) {
            this.currentFQClass = null;
        }
    }

    public void bindSuperClass(AST aST) {
        ClassDef classDef;
        super.bindSuperClass(aST);
        String string = "";
        AST aST2 = aST;
        if (aST2 != null) {
            aST2 = aST2.getFirstChild();
        }
        if ((classDef = ClassDefs.getClassDef(string = aST2 != null ? aST2.getText() : "")) == null) {
            String string2 = this.currentClass.resolveType(string);
            classDef = ClassDefs.getClassDef(string2);
        }
        this.currentClass.addSuperClassDef(classDef);
        if (string.endsWith("NonCachedValue")) {
            this.logln("...ncv");
        } else {
            this.logln("");
        }
    }

    private String trueType(AST aST) {
        if (aST.getType() == 14) {
            aST = aST.getFirstChild();
        }
        int n = aST.getType();
        String string = aST.getText();
        int n2 = ASTUtil.countChild((AST)aST, (int)18);
        for (int i = 0; i < n2; ++i) {
            string = string + "[]";
        }
        return string;
    }

    public void bindMethodDef(AST aST, AST aST2, AST aST3, AST aST4) {
        super.bindMethodDef(aST, aST2, aST3, aST4);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        String string = aST3.getText();
        for (int i = 0; i < n; ++i) {
            this.log("  ");
        }
        String string2 = this.trueType(aST2);
        String string3 = NCVCallParserBinder.getAccessControl(aST);
        String string4 = this.currentFQClass + "." + string;
        LinkedList linkedList = this.getParmTypes(aST4);
        LinkedList linkedList2 = this.getArgs(aST4);
        this.currentMethod = this.currentClass.addMethodDef(string3, string2, string4, linkedList, linkedList2);
        String string5 = NCVCallParserBinder.toParmTypesStr(linkedList);
        this.logln(string2 + " method " + string + ": " + string5);
    }

    private static String getAccessControl(AST aST) {
        String string = null;
        ASTChildIterator aSTChildIterator = new ASTChildIterator(aST);
        while (aSTChildIterator.hasNext() && string == null) {
            AST aST2 = aSTChildIterator.nextAST();
            String string2 = aST2.getText();
            if (!string2.equals("private") && !string2.equals("protected") && !string2.equals("private")) continue;
            string = string2;
        }
        return string;
    }

    public void endBindMethodDef() {
        super.endBindMethodDef();
        if (this.currentMethod == null) {
            return;
        }
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        if (n != 1) {
            this.currentMethod.popAllBuilder();
        }
        this.currentMethod = null;
    }

    public void bindFieldDef(AST aST, AST aST2) {
        super.bindFieldDef(aST, aST2);
        AST aST3 = aST2;
        if (aST3 != null) {
            aST3 = aST3.getFirstChild().getNextSibling();
        }
        if (aST3 != null) {
            aST3 = aST3.getNextSibling();
        }
        String string = aST.getText();
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getClassNesting();
        for (int i = 0; i < n + 1; ++i) {
            this.log("  ");
        }
        String string2 = this.trueType(aST);
        String string3 = aST3.getText();
        String string4 = this.currentFQClass + "." + string3;
        this.currentClass.addFieldDef(string2, string4);
        this.logln(string2 + " field " + string3);
    }

    private StringBuffer prepMemberAccessBuffer() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        JavaRecognizer javaRecognizer = this.getParser();
        int n2 = javaRecognizer.getClassNesting();
        for (n = 0; n < n2 + 1; ++n) {
            stringBuffer.append("  ");
        }
        n = javaRecognizer.getCallDepth();
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append("..");
        return stringBuffer;
    }

    public void bindVariableDecl(AST aST, Token token) {
        super.bindVariableDecl(aST, token);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        if (n == 1 || !bl) {
            return;
        }
        if (bl) {
            String string = this.trueType(aST);
            String string2 = token.getText();
            this.currentMethod.addVariableDecl(string, string2);
            StringBuffer stringBuffer = this.prepMemberAccessBuffer();
            this.log(stringBuffer.toString());
            this.logln(string + " variable " + string2);
        }
    }

    public void bindTypeCast(AST aST) {
        super.bindTypeCast(aST);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        if (n == 1 || !bl) {
            return;
        }
        int n2 = javaRecognizer.getCallDepth();
        String string = this.trueType(aST.getFirstChild());
        if (this.currentMethod.isCallDepthGreater(n2)) {
            this.currentMethod.pushBuilder();
        } else if (this.currentMethod.isCallDepthLesser(n2)) {
            this.currentMethod.popBuilder();
        } else if (!this.currentMethod.unusedBuilder()) {
            this.currentMethod.finishBuilder();
            this.currentMethod.resetBuilder();
        }
        this.currentMethod.getBuilder().addTypecast(string, n2);
        StringBuffer stringBuffer = this.prepMemberAccessBuffer();
        stringBuffer.append(string + " typecast(" + n2 + "}");
        this.bindMemberAccess(stringBuffer);
    }

    public void bindPIdentMethodCall(Token token, AST aST) {
        super.bindPIdentMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(PIDENT_CALL, token, aST);
    }

    public void bindPrimMethodCall(Token token, AST aST) {
        super.bindPrimMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(PRIM_CALL, token, aST);
    }

    public void bindSuperMethodCall(Token token, AST aST) {
        super.bindSuperMethodCall(token, aST);
        if (this.currentMethod == null) {
            return;
        }
        this.bindMethodCall(SUPER_CALL, token, aST);
    }

    private void bindMethodCall(String string, Token token, AST aST) {
        String string2 = token.getText();
        this.bindMethodCall(string, string2, aST);
    }

    private void bindMethodCall(String string, String string2, AST aST) {
        int n = aST == null ? 0 : aST.getNumberOfChildren();
        this.bindMethodCall(string, string2, n);
    }

    private void bindMemberAccess(StringBuffer stringBuffer) {
        CallItem callItem = this.callStack.size() == 0 ? null : (CallItem)this.callStack.getLast();
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getCallDepth();
        if (callItem != null) {
            int n2;
            int n3 = n + 1;
            LinkedList<CallItem> linkedList = new LinkedList<CallItem>();
            while ((n2 = this.callStack.size()) > 0) {
                callItem = (CallItem)this.callStack.getLast();
                if (callItem.callDepth != n3) break;
                this.callStack.removeLast();
                linkedList.add(callItem);
            }
            while ((n2 = linkedList.size()) > 0) {
                callItem = (CallItem)linkedList.removeLast();
                stringBuffer.append('\n');
                stringBuffer.append(callItem.text);
            }
        }
        CallItem callItem2 = new CallItem(n, stringBuffer.toString());
        this.callStack.add(callItem2);
    }

    private void bindMethodCall(String string, String string2, int n) {
        JavaRecognizer javaRecognizer = this.getParser();
        int n2 = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        if (n2 == 1 || !bl) {
            return;
        }
        StringBuffer stringBuffer = this.prepMemberAccessBuffer();
        int n3 = javaRecognizer.getCallDepth();
        if (string == PIDENT_CALL) {
            if (this.currentMethod.isCallDepthGreater(n3)) {
                this.currentMethod.pushBuilder();
            } else if (this.currentMethod.isCallDepthLesser(n3)) {
                this.currentMethod.popBuilder();
            } else if (!this.currentMethod.isTypeCastOnTopOfStack() && !this.currentMethod.unusedBuilder()) {
                this.currentMethod.finishBuilder();
                this.currentMethod.resetBuilder();
            }
            this.currentMethod.getBuilder().addPIdentCall(string2, n, n3);
        } else if (string == PRIM_CALL) {
            this.currentMethod.getBuilder().addPrimCall(string2, n, n3);
        }
        stringBuffer.append(string + " call{" + n3 + "}: " + string2 + "(" + n + ")");
        this.bindMemberAccess(stringBuffer);
    }

    public void bindFieldVarAccess(String string) {
        super.bindFieldVarAccess(string);
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        if (n == 1 || !bl) {
            return;
        }
        if (string != null) {
            this.currentMethod.getBuilder().addFieldVarAccess(string);
            StringBuffer stringBuffer = this.prepMemberAccessBuffer();
            int n2 = javaRecognizer.getCallDepth();
            stringBuffer.append("fieldvar-access{" + n2 + "}: " + string);
            this.bindMemberAccess(stringBuffer);
        }
    }

    public void endBindMethodCall() {
        super.endBindMethodCall();
        JavaRecognizer javaRecognizer = this.getParser();
        int n = javaRecognizer.getPass();
        boolean bl = javaRecognizer.isInMethodDef();
        if (n == 1 || !bl) {
            return;
        }
        int n2 = javaRecognizer.getCallDepth();
        if (n2 == 0 && this.callStack.size() > 0) {
            LinkedList<String> linkedList = new LinkedList<String>();
            CallItem callItem = (CallItem)this.callStack.getLast();
            while (callItem.callDepth == 1) {
                this.callStack.removeLast();
                linkedList.add(callItem.text);
                if (this.callStack.size() == 0) break;
                callItem = (CallItem)this.callStack.getLast();
            }
            while (linkedList.size() > 0) {
                this.logln((String)linkedList.removeLast());
            }
        }
    }

    public void reportNcvCalls(String string) {
        NCVCallParserBinder._logln((String)("*** starting NCV call checking report for: " + string));
        ClassDef classDef = ClassDefs.getClassDef(string);
        if (classDef == null) {
            NCVCallParserBinder._logln((String)(string + " not found..."));
            Iterator iterator = ClassDefs.getFqNameIterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                ClassDef classDef2 = ClassDefs.getClassDef(string2);
                NCVCallParserBinder._logln((String)("--- " + string2));
            }
        } else {
            int n = classDef.reportNcvCalls(true, false);
            int n2 = classDef.getMethodCount();
            NCVCallParserBinder._logln((String)("*** (" + n2 + ") considered " + n + " candidates"));
        }
        NCVCallParserBinder._logln((String)"");
    }

    static {
        parsingManager = ParsingManager.inst();
    }
}

