/*
 * Decompiled with CFR 0.152.
 */
package cerent.util.ior;

import cerent.util.ior.CdrReader;
import cerent.util.ior.CdrWriter;
import cerent.util.ior.TaggedProfile;
import java.io.IOException;
import java.io.PrintStream;

public class Ior {
    private String _typeId;
    private TaggedProfile[] _profiles;

    public Ior(CdrReader cdrReader) throws IOException {
        this._typeId = cdrReader.getString();
        int n = cdrReader.getInt();
        if (n <= 0) {
            this._profiles = null;
        } else {
            this._profiles = new TaggedProfile[n];
            for (int i = 0; i < n; ++i) {
                this._profiles[i] = new TaggedProfile(cdrReader);
            }
        }
    }

    public CdrWriter write(CdrWriter cdrWriter) throws IOException {
        cdrWriter.putString(this._typeId);
        if (this._profiles == null) {
            cdrWriter.putInt(0);
        } else {
            cdrWriter.putInt(this._profiles.length);
            for (int i = 0; i < this._profiles.length; ++i) {
                this._profiles[i].write(cdrWriter);
            }
        }
        return cdrWriter;
    }

    public void print(PrintStream printStream) {
        printStream.println("IOR:");
        String string = "  ";
        printStream.println(string + "typeId: " + this._typeId);
        if (this._profiles == null) {
            printStream.println(string + "no profiles");
        } else {
            printStream.println(string + "#profiles: " + this._profiles.length);
            for (int i = 0; i < this._profiles.length; ++i) {
                this._profiles[i].print(printStream, string + string + i + ".");
            }
        }
    }

    public String typeId() {
        return this._typeId;
    }

    public void typeId(String string) {
        this._typeId = string;
    }

    public int profiles() {
        return this._profiles == null ? 0 : this._profiles.length;
    }

    public void profiles(int n) {
        this._profiles = n <= 0 ? null : new TaggedProfile[n];
    }

    public TaggedProfile profile(int n) {
        return this._profiles[n];
    }

    public void profile(int n, TaggedProfile taggedProfile) {
        this._profiles[n] = taggedProfile;
    }
}

