/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc327.ui.xtc;

import cerent.cms.model.EntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.ui.shelf.AbstractShelfLayout;
import cerent.cms.ui.shelf.CardView;
import cerent.cms.ui.shelf.EnvPortGraphic;
import cerent.cms.ui.shelf.GenericPortGraphic;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;

public class XtcCardView
extends CardView {
    private static final int MAX_PER_ROW = 7;

    public XtcCardView(ModuleModel moduleModel) {
        super(moduleModel);
    }

    private JLabel formatLabel(String string) {
        return AbstractShelfLayout.formatLabel(new JLabel(string));
    }

    private int[] getEnvInputTypes() {
        return new int[]{38};
    }

    private int[] getEnvOutputTypes() {
        return new int[]{39};
    }

    private int[] getBbeTypes() {
        return new int[]{32, 33, 31};
    }

    private int[] getWbeTypes() {
        return new int[]{34};
    }

    private boolean isa(EntityModel entityModel, int[] nArray) {
        int n = entityModel.getEqType();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return true;
        }
        return false;
    }

    private boolean hasPorts(int[] nArray) {
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            return true;
        }
        return false;
    }

    private void addAlarmPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new EnvPortGraphic(this, entityModel, entityModel.getPort());
            this.add((Component)this.ports[i], gridBagConstraints);
            if (++gridBagConstraints.gridx <= 7) continue;
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void addPorts(int[] nArray, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = 1;
        for (int i = 0; i < this.numPorts; ++i) {
            EntityModel entityModel;
            Object e = this.portModels.get(i);
            if (!(e instanceof EntityModel) || !this.isa(entityModel = (EntityModel)e, nArray)) continue;
            this.ports[i] = new GenericPortGraphic(this, entityModel, entityModel.getPort());
            this.add((Component)this.ports[i], gridBagConstraints);
            if (++gridBagConstraints.gridx <= 7) continue;
            gridBagConstraints.gridx = 1;
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
    }

    private void addLabel(String string, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.anchor;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.formatLabel(string), gridBagConstraints);
        gridBagConstraints.anchor = n;
    }

    protected void addPorts(boolean bl) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.addLabel("EXTERNAL ALARM INPUTS", gridBagConstraints);
        this.addAlarmPorts(this.getEnvInputTypes(), gridBagConstraints);
        this.addLabel("EXTERNAL CONTROL OUTPUT", gridBagConstraints);
        this.addAlarmPorts(this.getEnvOutputTypes(), gridBagConstraints);
        if (this.hasPorts(this.getBbeTypes())) {
            this.addLabel("DS3", gridBagConstraints);
            this.addPorts(this.getBbeTypes(), gridBagConstraints);
        }
        this.addLabel("DS1", gridBagConstraints);
        this.addPorts(this.getWbeTypes(), gridBagConstraints);
        this.invalidate();
    }
}

