/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.ds3xm12;

import cerent.cms.idl.Common.sPmStat;
import cerent.cms.idl.Ds123Media.sNetworkPmPathStats;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.PmRendererStat;
import cerent.cms.ui.PmTableModel;
import cerent.cms.ui.pm.PmLayer;
import cerent.util.SDebug;

public class PmLayerDs3xm12Ds1NetworkPath
extends PmLayer {
    protected Ds123LineModel model;
    protected int numRegisters;
    protected final SDebug childDb;
    protected int numParms;
    protected sNetworkPmPathStats[] statsVal;
    public static String[] parmNames = new String[]{"DS1 ESNE-NP", "DS1 SESNE-NP", "DS1 UASNE-NP", "DS1 ESFE-NP", "DS1 SESFE-NP", "DS1 UASFE-NP"};
    public static final int ESNE_NP_INDEX = 0;
    public static final int SESNE_NP_INDEX = 1;
    public static final int UASNE_NP_INDEX = 2;
    public static final int ESFE_NP_INDEX = 3;
    public static final int SESFE_NP_INDEX = 4;
    public static final int UASFE_NP_INDEX = 5;
    private static final sNetworkPmPathStats _defaultStats = new sNetworkPmPathStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
    private static final SDebug db = new SDebug("PmLayerDs3xm12Ds1NetworkPath");

    public PmLayerDs3xm12Ds1NetworkPath(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n, boolean bl, SDebug sDebug) {
        super(pmTableModel, ds123LineModel, bl);
        this.model = ds123LineModel;
        this.numRegisters = n;
        this.childDb = sDebug;
        this.statsVal = new sNetworkPmPathStats[n];
        this.numParms = parmNames.length;
        for (int i = 0; i < n; ++i) {
            if (this.statsVal[i] == null) continue;
            this.statsVal[i] = null;
        }
    }

    public PmLayerDs3xm12Ds1NetworkPath(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n, boolean bl) {
        this(pmTableModel, ds123LineModel, n, bl, db);
    }

    public PmLayerDs3xm12Ds1NetworkPath(PmTableModel pmTableModel, Ds123LineModel ds123LineModel, int n) {
        this(pmTableModel, ds123LineModel, n, true);
    }

    public void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        this.model.clearNetworkPmPathStats(this.intervalType);
    }

    public Object getPmValue(int n, int n2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        sPmStat sPmStat2 = PM_STATS_VALID;
        if (PmLayerDs3xm12Ds1NetworkPath.db.on) {
            db.println("entering getPmValue - row= " + n + ", interval= " + n2);
        }
        switch (n) {
            case 0: {
                sPmStat2 = this.statsVal[n2].esne;
                break;
            }
            case 1: {
                sPmStat2 = this.statsVal[n2].sesne;
                break;
            }
            case 2: {
                sPmStat2 = this.statsVal[n2].uasne;
                break;
            }
            case 3: {
                sPmStat2 = this.statsVal[n2].esfe;
                break;
            }
            case 4: {
                sPmStat2 = this.statsVal[n2].sesfe;
                break;
            }
            case 5: {
                sPmStat2 = this.statsVal[n2].uasfe;
                break;
            }
        }
        return new PmRendererStat(sPmStat2);
    }

    public String layerLabel() {
        return "DS1";
    }

    public void refreshPmStats(int n) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        if (this.statsVal[n] == null || this.statsVal[n] == _defaultStats) {
            boolean bl = this.fromPeerCard;
            this.statsVal[n] = _defaultStats;
            try {
                if (!this.nearEnd) {
                    this.statsVal[n] = this.model.getNetworkPmPathStats(this.intervalType, (short)n);
                }
            }
            catch (InternalCommError internalCommError) {
                this.statsVal[n] = new sNetworkPmPathStats(false, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID, PM_STATS_INVALID);
                throw internalCommError;
            }
            this.fromPeerCard = this.statsVal[n].fromPeerCard;
            if (this.childDb.on() && bl != this.fromPeerCard) {
                this.childDb.println("Ds1NetworkPath fromPeerCard changed from " + bl + " to " + this.fromPeerCard);
            }
        }
    }

    public String parmName(int n) {
        return parmNames[n];
    }

    public int parmCount() {
        return parmNames.length;
    }

    public void setModel(InterfaceModel interfaceModel) {
        this.model = (Ds123LineModel)interfaceModel;
    }

    public void tossData() {
        for (int i = 0; i < this.numRegisters; ++i) {
            this.statsVal[i] = null;
        }
        this.fromPeerCard = false;
    }
}

