/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc454.ui.shelf;

import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.model.OpticsChannelModel;
import cerent.cms.model.OpticsModuleModel;
import cerent.cms.model.OpticsMultiplexSectionModel;
import cerent.cms.ui.shelf.CardGraphic;
import cerent.cms.ui.shelf.ICardPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CardPainter
implements ICardPainter {
    private static final float CARD_H_TO_CARD_W_RATIO = 9.166667f;
    private static final float PORT_W_TO_CARD_W_RATIO = 0.41666666f;
    private static final float OPTICON_Y_OFFSET_TO_CARD_H_RATIO = 0.3181818f;
    private static final float OPTICON_Y_SPACING_TO_CARD_H_RATIO = 0.11363637f;
    public static final int CARD_WIDTH = 30;
    public static final int CARD_HEIGHT = Math.round(275.0f);
    private static final int PORT_WIDTH = Math.round(12.5f);
    private static final int PORT_HEIGHT = PORT_WIDTH * 2;
    private static final int SMALL_PORT_HEIGHT = PORT_WIDTH;
    private static final int PORT_LOOPBACK_DIST = 3;
    private static final int PORT_CONN1_X;
    private static final int PORT_CONN2_X;
    private static final int PORT_CONN1_Y;
    private static final int PORT_CONN2_Y;
    private static final int SMALL_PORT_CONN1_Y;
    private static final int SMALL_PORT_CONN2_Y;
    static final int OPTICON_X_OFFSET;
    private static final int MULTIPORT_OPTICON_X_OFFSET;
    private static final int OPTICON_Y_OFFSET;
    private static final int HEIGHT;
    private static final float RECT_H_TO_CARD_H_RATIO = 0.013636364f;
    private static final float RECT_OFFSET_TO_CARD_H_RATIO = 0.23636363f;
    private static final float BOTTOM_RECT_OFFSET_TO_CARD_H_RATIO = 0.81363636f;
    private static final float EXTRACTOR_H_TO_CARD_H_RATIO = 0.11818182f;
    private static final float EXTRACTOR_W_TO_EXTRACTOR_H_RATIO = 0.46153846f;
    private static final float NAME_X_OFFSET_TO_CARD_W_RATIO = 0.083333336f;
    private static final float NAME_Y_OFFSET_TO_CARD_H_RATIO = 0.19545455f;
    private static final float ACTIVE_Y_LIGHT_OFFSET_TO_CARD_H_RATIO = 0.27272728f;
    private static final float ACTIVE_LIGHT_W_TO_CARD_W_RATIO = 0.25f;
    private static final float ACTIVE_LIGHT_H_TO_CARD_H_RATIO = 0.018181818f;
    private static final int RECT_HEIGHT;
    private static final int RECT_OFFSET;
    private static final int TOP_RECT_OFFSET;
    private static final int TOP_RECT_HEIGHT;
    private static final int BOTTOM_RECT_OFFSET;
    private static final int BOTTOM_RECT_HEIGHT;
    private static final int EXTRACTOR_HEIGHT;
    private static final int EXTRACTOR_WIDTH;
    private static final int TAB_MARGIN = 2;
    private static final int TAB_RADIUS;
    private static final int TAB_DIAMETER;
    private static final int TAB_ARC_WIDTH;
    private static final int TAB_ARC_HEIGHT;
    private static final int BOTTOM_EXTRACTOR_OFFSET;
    private static final int BOTTOM_EXTRACTOR_HEIGHT;
    private static final int TOP_EXTRACTOR_OFFSET = 0;
    private static final int TOP_EXTRACTOR_HEIGHT;
    private static final int NAME_X_OFFSET;
    private static final int NAME_Y_OFFSET;
    private static final int ACTIVE_LIGHT_Y_OFFSET;
    private static final int ACTIVE_LIGHT_WIDTH;
    private static final int ACTIVE_LIGHT_HEIGHT;
    private static final int OPTICON_X_SPACING = 0;
    private static final int OPTICON_Y_SPACING;
    private static final int SMALL_OPTICON_Y_SPACING;
    private static final int MINI_PORT_WIDTH;
    private static final int MINI_PORT_HEIGHT;
    private static final int MINI_MULTIPORT_OPTICON_X_OFFSET;
    private static final int MINI_OPTICON_Y_OFFSET;
    private static final int MINI_OPTICON_X_SPACING = 0;
    private static final int MINI_OPTICON_Y_SPACING;
    private static final float[] dash1;
    private static final Rectangle topExtractorRectangle;
    private static final Rectangle bottomExtractorRectangle;
    private static final Arc2D.Double topExtractorMain;
    private static final Arc2D.Double topExtractorSmall;
    private static final Line2D.Double topExtractorLine;
    private static final Arc2D.Double bottomExtractorMain;
    private static final Arc2D.Double bottomExtractorSmall;
    private static final Line2D.Double bottomExtractorLine;
    private final int WIDTH;
    private final Rectangle topRectangle;
    private final Rectangle bottomRectangle;
    private final Rectangle mainRectangle;
    protected CardGraphic cg;
    protected OpticsMultiplexSectionModel[] bandmodels;
    protected OpticsChannelModel[] models;
    public static final String[] ChnWavelengthStrings;
    public static final String[] BandWavelengthStrings;

    public CardPainter(CardGraphic cardGraphic) {
        OpticsModuleModel opticsModuleModel;
        this.cg = cardGraphic;
        this.WIDTH = cardGraphic.getSlotsOccupied() * 30;
        this.topRectangle = new Rectangle(0, TOP_RECT_OFFSET, this.WIDTH, TOP_RECT_HEIGHT);
        this.bottomRectangle = new Rectangle(0, BOTTOM_RECT_OFFSET, this.WIDTH, BOTTOM_RECT_HEIGHT);
        this.mainRectangle = new Rectangle(0, 0, this.WIDTH, HEIGHT);
        if (this.cg.getModel() instanceof OpticsModuleModel && (opticsModuleModel = (OpticsModuleModel)this.cg.getModel()).getState() != eEqState.DELETED) {
            this.models = opticsModuleModel.getOpticsChannelModels();
            this.bandmodels = opticsModuleModel.getOpticsOMSModels();
        }
    }

    public void updateWidth() {
    }

    public int getOpticonXOffset() {
        return OPTICON_X_OFFSET;
    }

    public int getOpticonYOffset() {
        return OPTICON_Y_OFFSET;
    }

    public int getMultiPortOpticonXOffset() {
        return MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getOpticonXSpacing() {
        return 0;
    }

    public int getOpticonYSpacing() {
        return OPTICON_Y_SPACING;
    }

    public int getMiniMultiPortOticonXOffset() {
        return MINI_MULTIPORT_OPTICON_X_OFFSET;
    }

    public int getCardWidth() {
        return 30;
    }

    public int getCardHeight() {
        return CARD_HEIGHT;
    }

    public Rectangle getMainRectangle() {
        return this.mainRectangle;
    }

    public int getPortWidth() {
        return PORT_WIDTH;
    }

    public int getPortHeight() {
        return PORT_HEIGHT;
    }

    public int getMiniPortWidth() {
        return MINI_PORT_WIDTH;
    }

    public int getMiniPortHeight() {
        return MINI_PORT_HEIGHT;
    }

    public int getMiniOpticonXSpacing() {
        return 0;
    }

    public int getMiniOpticonYSpacing() {
        return MINI_OPTICON_Y_SPACING;
    }

    public int getMiniOpticonYOffset() {
        return MINI_OPTICON_Y_OFFSET;
    }

    public int getPortX(int n, int n2) {
        return MULTIPORT_OPTICON_X_OFFSET + 0 * n2;
    }

    public int getPortY(int n, int n2) {
        if (n == 0) {
            return OPTICON_Y_OFFSET + OPTICON_Y_SPACING * n2;
        }
        return OPTICON_Y_OFFSET + SMALL_OPTICON_Y_SPACING * n2;
    }

    public int getSmallPortWidth() {
        return 0;
    }

    public int getSmallPortHeight() {
        return SMALL_PORT_HEIGHT;
    }

    public int getPortConn1X() {
        return PORT_CONN1_X;
    }

    public int getPortConn2X() {
        return PORT_CONN2_X;
    }

    public int getPortConn1Y() {
        return PORT_CONN1_Y;
    }

    public int getPortConn2Y() {
        return PORT_CONN2_Y;
    }

    public int getSmallPortConn1Y() {
        return SMALL_PORT_CONN1_Y;
    }

    public int getSmallPortConn2Y() {
        return SMALL_PORT_CONN2_Y;
    }

    public int getSmallPortConn1X() {
        return 0;
    }

    public int getSmallPortConn2X() {
        return 0;
    }

    public int getPortLoopbackDist() {
        return 3;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setColor(this.cg.getCurrentColor());
        graphics2D.fill(this.mainRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.draw(this.mainRectangle);
        graphics2D.setStroke(new BasicStroke(1.0f));
        graphics2D.setColor(Color.gray);
        graphics2D.draw(topExtractorRectangle);
        graphics2D.draw(bottomExtractorRectangle);
        graphics2D.setColor(Color.black);
        graphics2D.draw(topExtractorMain);
        graphics2D.draw(topExtractorSmall);
        graphics2D.draw(topExtractorLine);
        graphics2D.draw(bottomExtractorMain);
        graphics2D.draw(bottomExtractorSmall);
        graphics2D.draw(bottomExtractorLine);
        int n3 = this.cg.getState();
        String string = "";
        Color color = graphics2D.getColor();
        Color color2 = this.cg.getCurrentColor();
        switch (n3) {
            case 5: {
                string = "Act";
                color2 = Color.green;
                break;
            }
            case 4: {
                string = "Sby";
                color2 = Color.yellow;
                break;
            }
            case 2: {
                string = "Ldg";
                color2 = Color.white;
                break;
            }
            case 3: {
                string = "Fail";
                break;
            }
            case 1: {
                string = "Mis";
                break;
            }
            case 0: {
                string = "NP";
                break;
            }
            case 6: {
                string = "Del";
                break;
            }
        }
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, 2, ACTIVE_LIGHT_Y_OFFSET + ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color2);
        graphics2D.fillRect(30 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(30 - ACTIVE_LIGHT_WIDTH - 2, ACTIVE_LIGHT_Y_OFFSET, ACTIVE_LIGHT_WIDTH, ACTIVE_LIGHT_HEIGHT);
        graphics2D.setColor(color);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 3.0f, dash1, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.topRectangle);
        graphics2D.draw(this.bottomRectangle);
        graphics2D.setColor(Color.black);
        String string2 = "";
        int n4 = 0;
        String string3 = this.cg.getEqLabel();
        if (string3.length() > 4) {
            StringTokenizer stringTokenizer;
            Font font = graphics.getFont();
            FontMetrics fontMetrics = component.getFontMetrics(font);
            int n5 = fontMetrics.getAscent();
            String string4 = string3;
            String string5 = "";
            String string6 = "";
            int n6 = n2 + NAME_Y_OFFSET;
            if (string3.startsWith("OC")) {
                if (string3.equals("OC48AS")) {
                    string4 = string3.substring(0, 4);
                    string5 = string3.substring(4, string3.length());
                } else {
                    stringTokenizer = new StringTokenizer(string3, "_");
                    try {
                        string4 = stringTokenizer.nextToken();
                        string5 = stringTokenizer.nextToken();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
            } else if (string3.startsWith("DS3_E")) {
                stringTokenizer = new StringTokenizer(string3, "_");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("DS")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(3, string3.length());
            } else if (string3.startsWith("ETH")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(3, string3.length());
            } else if (string3.startsWith("XC")) {
                string4 = string3.substring(0, 2);
                string5 = string3.substring(2, string3.length());
                if (string5.length() > 3) {
                    string5 = string5.substring(0, string5.indexOf(32));
                }
            } else if (string3.startsWith("G1000")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 5);
                if (string3.endsWith("(TXP)")) {
                    string5 = string3.substring(6);
                }
            } else if (string3.startsWith("ML100")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 2);
                string5 = string3.substring(2, string3.length());
            } else if (string3.startsWith("ML2")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 3);
                string5 = string3.substring(4, 8);
            } else if (string3.startsWith("CE")) {
                graphics.setFont(new Font(font.getFontName(), font.getStyle(), font.getSize() - 1));
                string4 = string3.substring(0, 2);
                string5 = string3.substring(3, 7);
            } else if (string3.startsWith("TXP") || string3.startsWith("MXP")) {
                stringTokenizer = new StringTokenizer(string3, "_");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("FC-MR")) {
                stringTokenizer = new StringTokenizer(string3, "-");
                try {
                    string4 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {}
            } else if (string3.startsWith("OADM 1 b")) {
                string4 = "AD1B";
                n4 = this.getBandWave();
                string5 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("OADM 4 b")) {
                string4 = "AD4B";
                n4 = this.getBandWave();
                string5 = n4 != 0 ? BandWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("OADM 1 c")) {
                string4 = "AD1C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("OADM 2 c")) {
                string4 = "AD2C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("OADM 4 c")) {
                string4 = "AD4C";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.equals("Optical booster")) {
                string4 = "OPT";
                string5 = "BST";
            } else if (string3.equals("Optical booster ENH")) {
                string4 = "OPT";
                string5 = "BST";
                string6 = "ENH";
            } else if (string3.startsWith("Optical pre")) {
                string4 = "OPT";
                string5 = "PRE";
            } else if (string3.startsWith("OSC M")) {
                string4 = "OSCM";
                string5 = "";
            } else if (string3.startsWith("OSC ")) {
                string4 = "OSC";
                string5 = "CSM";
            } else if (string3.startsWith("32 WSS")) {
                string4 = "     32 WSS";
                string5 = "";
            } else if (string3.equals("32 DMX")) {
                string4 = "32";
                string5 = "DMX";
            } else if (string3.startsWith("4MD")) {
                string4 = "4MD";
                n4 = this.getWave();
                string5 = n4 != 0 ? ChnWavelengthStrings[n4].substring(2, 6) : "XX.X";
            } else if (string3.startsWith("32 MUXO")) {
                string4 = "       32 MUXO";
                string5 = "";
            } else if (string3.equals("32 DMXO")) {
                string4 = "       32 DMXO";
                string5 = "";
            } else if (string3.startsWith("MRC")) {
                string4 = string3.substring(0, 3);
                string5 = string3.substring(4, string3.length());
            } else if (string3.startsWith("PPM")) {
                string4 = "";
                string5 = "";
            } else if (string3.startsWith("TCC2P")) {
                string4 = string3.substring(0, 4);
                string5 = string3.substring(4, string3.length());
            }
            if (string5.length() != 0 && string6.length() != 0) {
                n6 -= n5;
            }
            int n7 = fontMetrics.stringWidth(string4);
            graphics2D.drawString(string4, (n + 30 - n7) / 2, n6);
            if (string5.length() > 0) {
                n7 = fontMetrics.stringWidth(string5);
                graphics2D.drawString(string5, (n + 30 - n7) / 2, n6 += n5);
            }
            if (string6.length() > 0) {
                n7 = fontMetrics.stringWidth(string6);
                graphics2D.drawString(string6, (n + 30 - n7) / 2, n6 += n5);
            }
        } else if (string3 != null) {
            int n8 = 0;
            if (string3.startsWith("UNK")) {
                n8 = -1;
            }
            graphics2D.drawString(string3, n + NAME_X_OFFSET + n8, n2 + NAME_Y_OFFSET);
        }
        graphics2D.setStroke(stroke);
    }

    private int getWave() {
        int n = 0;
        try {
            n = this.models[0].getExpectedWaveLenght().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    private int getBandWave() {
        int n = 0;
        try {
            n = this.bandmodels[0].getExpectedBand().value();
        }
        catch (Exception exception) {
            return 0;
        }
        return n;
    }

    static {
        PORT_CONN2_X = PORT_CONN1_X = PORT_WIDTH / 2;
        PORT_CONN1_Y = PORT_HEIGHT / 3;
        PORT_CONN2_Y = PORT_CONN1_Y * 2;
        SMALL_PORT_CONN1_Y = SMALL_PORT_HEIGHT / 3;
        SMALL_PORT_CONN2_Y = SMALL_PORT_CONN1_Y * 2;
        OPTICON_X_OFFSET = (30 - PORT_WIDTH) / 2;
        MULTIPORT_OPTICON_X_OFFSET = (30 - PORT_WIDTH) / 2;
        OPTICON_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.3181818f);
        HEIGHT = CARD_HEIGHT;
        RECT_HEIGHT = Math.round((float)CARD_HEIGHT * 0.013636364f);
        TOP_RECT_OFFSET = RECT_OFFSET = Math.round((float)CARD_HEIGHT * 0.23636363f);
        TOP_RECT_HEIGHT = RECT_HEIGHT;
        BOTTOM_RECT_OFFSET = Math.round((float)CARD_HEIGHT * 0.81363636f);
        BOTTOM_RECT_HEIGHT = RECT_HEIGHT;
        EXTRACTOR_HEIGHT = Math.round((float)CARD_HEIGHT * 0.11818182f);
        EXTRACTOR_WIDTH = Math.round((float)EXTRACTOR_HEIGHT * 0.46153846f);
        TAB_RADIUS = (30 - EXTRACTOR_WIDTH) / 2;
        TAB_DIAMETER = TAB_RADIUS * 2;
        TAB_ARC_WIDTH = 30 - EXTRACTOR_WIDTH - TAB_RADIUS;
        TAB_ARC_HEIGHT = EXTRACTOR_HEIGHT - TAB_DIAMETER;
        BOTTOM_EXTRACTOR_OFFSET = CARD_HEIGHT - EXTRACTOR_HEIGHT - 1;
        BOTTOM_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        TOP_EXTRACTOR_HEIGHT = EXTRACTOR_HEIGHT;
        NAME_X_OFFSET = Math.round(2.5f) - 1;
        NAME_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.19545455f);
        ACTIVE_LIGHT_Y_OFFSET = Math.round((float)CARD_HEIGHT * 0.27272728f);
        ACTIVE_LIGHT_WIDTH = Math.round(7.5f) - 1;
        ACTIVE_LIGHT_HEIGHT = Math.round((float)CARD_HEIGHT * 0.018181818f);
        OPTICON_Y_SPACING = Math.round((float)CARD_HEIGHT * 0.11363637f);
        SMALL_OPTICON_Y_SPACING = Math.round((float)((double)((float)CARD_HEIGHT * 0.11363637f) * 0.75));
        MINI_PORT_WIDTH = PORT_WIDTH;
        MINI_PORT_HEIGHT = Math.round(14.375f);
        MINI_MULTIPORT_OPTICON_X_OFFSET = (30 - MINI_PORT_WIDTH) / 2;
        MINI_OPTICON_Y_OFFSET = OPTICON_Y_OFFSET - 4;
        MINI_OPTICON_Y_SPACING = MINI_PORT_HEIGHT + 3;
        dash1 = new float[]{1.5f};
        topExtractorRectangle = new Rectangle(2, 2, EXTRACTOR_WIDTH - 4, TOP_EXTRACTOR_HEIGHT - 4);
        bottomExtractorRectangle = new Rectangle(2, BOTTOM_EXTRACTOR_OFFSET + 2, EXTRACTOR_WIDTH - 4, BOTTOM_EXTRACTOR_HEIGHT - 4);
        topExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, 0 - TAB_ARC_HEIGHT, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, 90.0, 0);
        topExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, 0 + TAB_ARC_HEIGHT, TAB_DIAMETER, TAB_DIAMETER, 90.0, -180.0, 0);
        topExtractorLine = new Line2D.Double(0.0, EXTRACTOR_HEIGHT, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, EXTRACTOR_HEIGHT);
        bottomExtractorMain = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET + TAB_DIAMETER, 2 * TAB_ARC_WIDTH, 2 * TAB_ARC_HEIGHT, 180.0, -90.0, 0);
        bottomExtractorSmall = new Arc2D.Double(EXTRACTOR_WIDTH, BOTTOM_EXTRACTOR_OFFSET, TAB_DIAMETER, TAB_DIAMETER, -90.0, 180.0, 0);
        bottomExtractorLine = new Line2D.Double(0.0, BOTTOM_EXTRACTOR_OFFSET, EXTRACTOR_WIDTH + TAB_ARC_WIDTH, BOTTOM_EXTRACTOR_OFFSET);
        ChnWavelengthStrings = new String[]{"UNKNOWN", "1530.3", "1531.1", "1531.9", "1532.6", "1534.2", "1535.0", "1535.8", "1536.6", "1538.1", "1538.9", "1539.7", "1540.5", "1542.1", "1542.9", "1543.7", "1544.5", "1546.1", "1546.9", "1547.7", "1548.5", "1550.1", "1550.9", "1551.7", "1552.5", "1554.1", "1554.9", "1555.7", "1556.5", "1558.1", "1558.9", "1559.7", "1560.6"};
        BandWavelengthStrings = new String[]{"UNKNOWN", "1530.3", "1534.2", "1538.1", "1542.1", "1546.1", "1550.1", "1554.1", "1558.1"};
    }
}

