/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.SonetMedia.sPathThresholds;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmHoModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.MuxIndex;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.awt.Frame;
import javax.swing.table.AbstractTableModel;

public class STM1E12PathPmThresholdsTableModel
extends AbstractTableModel {
    protected INodeModel node;
    protected TdmHoModel[] model = null;
    protected boolean[] rowDirty = null;
    protected sPathThresholds[] thresholdsVal;
    protected sInterface[] info = null;
    protected eIntervalType intervalType;
    protected int numLines;
    protected boolean nearEnd = false;
    protected EntityCellRenderer myPortRenderer;
    public static final int LINENUMBER_INDEX = 0;
    public static final int CV_INDEX = 1;
    public static final int BBE_INDEX = 2;
    public static final int ES_INDEX = 3;
    public static final int SES_INDEX = 4;
    public static final int UAS_INDEX = 5;
    public static final int PJPIN_INDEX = 6;
    public static final int PJNIN_INDEX = 7;
    public static final int PJPOUT_INDEX = 8;
    public static final int PJNOUT_INDEX = 9;
    public static final int PJDIFF_INDEX = 10;
    public static final int PJINSEC_INDEX = 11;
    public static final int PJOUTSEC_INDEX = 12;
    public int LAST_INDEX = 12;
    protected static String[] columnNames;
    private static final SDebug db;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;

    public STM1E12PathPmThresholdsTableModel(INodeModel iNodeModel, TdmHoModel[] tdmHoModelArray, eIntervalType eIntervalType2, boolean bl) {
        this.node = iNodeModel;
        this.model = tdmHoModelArray;
        this.nearEnd = bl;
        this.intervalType = eIntervalType2;
        this.initColumnNames();
        if (this.model == null) {
            if (db.on()) {
                db.println("Model null");
            }
            this.numLines = 0;
            return;
        }
        this.numLines = this.model.length;
        this.init();
    }

    protected String getLineNumber(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getInfo(n);
        if (this.info.length > n && this.info[n] != null && this.model.length > n) {
            MuxIndex muxIndex = new MuxIndex(this.model[n], this.info[n].muxIndex + 1);
            short s = this.info[n].portNumber;
            String string = "VC4";
            try {
                TDMTerminology tDMTerminology = Model.getTDMTerminology((IModel)this.node);
                string = tDMTerminology.getGeneralTerms(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.append("Line ");
            stringBuffer.append(s == 0 ? "all" : Integer.toString(s));
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(muxIndex);
        }
        return stringBuffer.toString();
    }

    protected sInterface getInfo(int n) {
        if (this.info[n] == null) {
            try {
                this.info[n] = this.model[n].getInfo();
            }
            catch (NoSuchInterface noSuchInterface) {
                // empty catch block
            }
        }
        return this.info[n];
    }

    private void init() {
        this.myPortRenderer = new EntityCellRenderer();
        this.rowDirty = new boolean[this.numLines];
        this.thresholdsVal = new sPathThresholds[this.numLines];
        this.info = new sInterface[this.numLines];
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
            this.thresholdsVal[i] = null;
        }
    }

    private void refreshPmStats(int n) {
        if (this.thresholdsVal[n] == null) {
            try {
                this.thresholdsVal[n] = this.model[n].getPmThresholds(this.nearEnd, this.intervalType);
            }
            catch (Exception exception) {
                db.println("Error in getting stats");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private Frame getFrame() {
        return this.node.getUiToolkit().getApplicationFrame();
    }

    private void initColumnNames() {
        columnNames = new String[this.LAST_INDEX + 1];
        try {
            TDMTerminology tDMTerminology = this.node.getTDMTerminology();
            STM1E12PathPmThresholdsTableModel.columnNames[0] = "Port ";
            STM1E12PathPmThresholdsTableModel.columnNames[3] = tDMTerminology.getPmStat(2);
            STM1E12PathPmThresholdsTableModel.columnNames[4] = tDMTerminology.getPmStat(3);
            STM1E12PathPmThresholdsTableModel.columnNames[1] = tDMTerminology.getPmStat(1);
            STM1E12PathPmThresholdsTableModel.columnNames[5] = tDMTerminology.getPmStat(9);
            STM1E12PathPmThresholdsTableModel.columnNames[2] = tDMTerminology.getPmStat(5);
            STM1E12PathPmThresholdsTableModel.columnNames[6] = tDMTerminology.getPmStat(10);
            STM1E12PathPmThresholdsTableModel.columnNames[7] = tDMTerminology.getPmStat(11);
            STM1E12PathPmThresholdsTableModel.columnNames[8] = tDMTerminology.getPmStat(12);
            STM1E12PathPmThresholdsTableModel.columnNames[9] = tDMTerminology.getPmStat(13);
            STM1E12PathPmThresholdsTableModel.columnNames[10] = tDMTerminology.getPmStat(28);
            STM1E12PathPmThresholdsTableModel.columnNames[11] = tDMTerminology.getPmStat(29);
            STM1E12PathPmThresholdsTableModel.columnNames[12] = tDMTerminology.getPmStat(30);
        }
        catch (Exception exception) {
            db.finer("Exception in initColumnNames() " + exception);
        }
    }

    private int getEs(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].es;
    }

    private int getCv(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].cv;
    }

    private int getSes(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].ses;
    }

    private int getFc(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].fc;
    }

    private int getUas(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].uas;
    }

    private int getBbe(int n) {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].bbe;
    }

    protected int getPjpIn(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjpIn;
    }

    protected int getPjnIn(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjnIn;
    }

    protected int getPjpOut(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjpOut;
    }

    protected int getPjnOut(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjnOut;
    }

    protected int getPjDiff(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjDiff;
    }

    protected int getPjInSec(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjInSec;
    }

    protected int getPjOutSec(int n) throws NoSuchInterface, WrongInterfaceType {
        this.refreshPmStats(n);
        return this.thresholdsVal[n].pjOutSec;
    }

    public Class getColumnClass(int n) {
        if (n != 0) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = STM1E12PathPmThresholdsTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        return class$java$lang$String == null ? (class$java$lang$String = STM1E12PathPmThresholdsTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (db.on()) {
                db.println("Change in value " + n + " " + n2);
            }
            int n3 = -1;
            if (object instanceof Integer) {
                n3 = (Integer)object;
            } else if (object instanceof String) {
                n3 = Integer.parseInt((String)object);
            }
            if (n3 < 0) {
                throw new Exception();
            }
            switch (n2) {
                case 1: {
                    this.thresholdsVal[n].cv = n3;
                    break;
                }
                case 3: {
                    this.thresholdsVal[n].es = n3;
                    break;
                }
                case 4: {
                    this.thresholdsVal[n].ses = n3;
                    break;
                }
                case 5: {
                    this.thresholdsVal[n].uas = n3;
                    break;
                }
                case 2: {
                    this.thresholdsVal[n].bbe = n3;
                    break;
                }
                case 6: {
                    this.thresholdsVal[n].pjpIn = n3;
                    break;
                }
                case 7: {
                    this.thresholdsVal[n].pjnIn = n3;
                    break;
                }
                case 8: {
                    this.thresholdsVal[n].pjpOut = n3;
                    break;
                }
                case 9: {
                    this.thresholdsVal[n].pjnOut = n3;
                    break;
                }
                case 10: {
                    this.thresholdsVal[n].pjDiff = n3;
                    break;
                }
                case 11: {
                    this.thresholdsVal[n].pjInSec = n3;
                    break;
                }
                case 12: {
                    this.thresholdsVal[n].pjOutSec = n3;
                    break;
                }
            }
            this.rowDirty[n] = true;
            this.fireTableCellUpdated(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (db.on()) {
                db.println("NumberFormatException caught in StsTermPmThresholdsTableModel::setValueAt(): " + numberFormatException);
                SDebug.printStackTrace((Throwable)numberFormatException);
            }
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in setting value " + exception);
            }
            System.err.println("Error in setting value " + exception);
            exception.printStackTrace(System.err);
        }
    }

    public int getRowCount() {
        return this.numLines;
    }

    public int getColumnCount() {
        if (this.node.getFramingTypeObj().isSdh()) {
            return columnNames.length;
        }
        return columnNames.length - 1;
    }

    public sPathThresholds getThresholdsVal(int n) {
        if (n >= this.numLines) {
            return null;
        }
        return this.thresholdsVal[n];
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.model != null && this.model.length > 0) {
            boolean bl = AbstractPane.isUserAuthorized((IModel)this.node, SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.model[0].getModuleModel().isProtectModule()) {
                    return n2 > 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    protected String getPortDescriptionFor(int n) throws AbstractCmsNoSuchEntityException {
        IPortModel iPortModel = this.model[n].getPortModel();
        return this.myPortRenderer.getPortString((IEntityModel)iPortModel, false);
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return this.getPortDescriptionFor(n);
                }
                case 1: {
                    return new Integer(this.getCv(n));
                }
                case 3: {
                    return new Integer(this.getEs(n));
                }
                case 4: {
                    return new Integer(this.getSes(n));
                }
                case 5: {
                    return new Integer(this.getUas(n));
                }
                case 2: {
                    return new Integer(this.getBbe(n));
                }
                case 6: {
                    return new Integer(this.getPjpIn(n));
                }
                case 7: {
                    return new Integer(this.getPjnIn(n));
                }
                case 8: {
                    return new Integer(this.getPjpOut(n));
                }
                case 9: {
                    return new Integer(this.getPjnOut(n));
                }
                case 10: {
                    return new Integer(this.getPjDiff(n));
                }
                case 11: {
                    return new Integer(this.getPjInSec(n));
                }
                case 12: {
                    return new Integer(this.getPjOutSec(n));
                }
            }
            return null;
        }
        catch (Exception exception) {
            if (db.on()) {
                db.println("Error in getValueAt " + exception);
            }
            System.err.println("Error in getValueAt " + exception);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public void refreshLineFromModel(int n) {
        this.thresholdsVal[n] = null;
        this.rowDirty[n] = false;
        this.fireTableRowsUpdated(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStsModel(TdmHoModel[] tdmHoModelArray) {
        STM1E12PathPmThresholdsTableModel sTM1E12PathPmThresholdsTableModel = this;
        synchronized (sTM1E12PathPmThresholdsTableModel) {
            this.model = tdmHoModelArray;
            this.numLines = this.model.length;
            this.thresholdsVal = new sPathThresholds[this.numLines];
            this.rowDirty = new boolean[this.numLines];
            this.info = new sInterface[this.numLines];
            for (int i = 0; i < this.numLines; ++i) {
                this.thresholdsVal[i] = null;
                this.rowDirty[i] = false;
            }
        }
        this.fireTableDataChanged();
    }

    public void refreshFromModel() {
        int n;
        if (db.on()) {
            db.println("refreshing in model");
        }
        for (n = 0; n < this.numLines; ++n) {
            this.thresholdsVal[n] = null;
        }
        for (n = 0; n < this.numLines; ++n) {
            this.rowDirty[n] = false;
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    public boolean isRowDirty(int n) {
        return this.rowDirty[n];
    }

    public void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            this.rowDirty[i] = false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        db = new SDebug("STM1E12PathPmThresholdsTableModel");
    }
}

