/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc455.ui.stm1e;

import cerent.cms.idl.SonetMedia.eStm1eMode;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Attribute;
import cerent.cms.model.ElementDefaults;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.SecurityLevel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.AbstractPane;
import cerent.util.SDebug;
import javax.swing.table.AbstractTableModel;

public class STM1E12PortTableModel
extends AbstractTableModel {
    protected TdmLineModel[] lineModels = null;
    protected INodeModel node = null;
    private int numLines = 0;
    private boolean dirty = false;
    final String[] columnNames = new String[]{"Port", "Interface"};
    public static final int LINENUMBER_INDEX = 0;
    public static final int INTERFACE_INDEX = 1;
    private Attribute[] lInterface;
    private boolean[][] isDirty;
    private static final SDebug db = new SDebug("STM1E12PortTableModel");
    static /* synthetic */ Class class$cerent$cms$idl$SonetMedia$eStm1eMode;
    static /* synthetic */ Class class$java$lang$Object;

    public STM1E12PortTableModel(INodeModel iNodeModel, TdmLineModel[] tdmLineModelArray) {
        this.lineModels = tdmLineModelArray;
        this.node = iNodeModel;
        this.numLines = this.lineModels.length;
        this.lInterface = new Attribute[this.numLines];
        this.isDirty = new boolean[this.numLines][this.getColumnCount()];
        this.resetDirtyBits();
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return class$cerent$cms$idl$SonetMedia$eStm1eMode == null ? (class$cerent$cms$idl$SonetMedia$eStm1eMode = STM1E12PortTableModel.class$("cerent.cms.idl.SonetMedia.eStm1eMode")) : class$cerent$cms$idl$SonetMedia$eStm1eMode;
            }
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = STM1E12PortTableModel.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (n2) {
                case 0: {
                    return new Integer(n + 1);
                }
                case 1: {
                    return this.getInterfaceIndex(n);
                }
            }
            return null;
        }
        catch (Exception exception) {
            System.err.println("STM1E12PortTableModel: error in getValueAt " + exception);
            return null;
        }
    }

    public void applyChanges() throws Exception {
        try {
            for (int i = 0; i < this.numLines; ++i) {
                if (!this.isDirty(i, 1)) continue;
                this.lineModels[i].setStm1eMode(this.getInterface(i));
            }
            this.dirty = false;
            this.resetDirtyBits();
        }
        catch (Exception exception) {
            db.println("Error in applyChanges " + exception);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private eStm1eMode getInterface(int n) throws AbstractCmsIOException {
        return eStm1eMode.from_int(this.lInterface[n].getIntValue());
    }

    public int getRowCount() {
        return this.numLines;
    }

    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 1: {
                this.lInterface[n] = (Attribute)object;
                break;
            }
        }
        this.dirty = true;
        this.isDirty[n][n2] = true;
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.lineModels != null && this.numLines > 0) {
            boolean bl = AbstractPane.isUserAuthorized(this.lineModels[0], SecurityLevel.PROVISIONING);
            try {
                if (bl && !this.lineModels[0].getModuleModel().isProtectModule()) {
                    if (n2 < 1 || n < 8) {
                        return false;
                    }
                    return this.lineModels[n].getHigherLayerModels().length == 0;
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                db.println("Caught exception in isCellEditable");
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                return false;
            }
        }
        return false;
    }

    protected Attribute getAttributeFor(Object object, int n) {
        return ElementDefaults.getAttributeMap((IModel)this.node).getAttributeForVal("STM1E_12_LINE_CARD." + object.getClass().getName(), n);
    }

    private Attribute getInterfaceIndex(int n) throws AbstractCmsIOException {
        try {
            if (this.lInterface[n] == null) {
                eStm1eMode eStm1eMode2 = this.lineModels[n].getStm1eMode();
                this.lInterface[n] = this.getAttributeFor(eStm1eMode2, eStm1eMode2.value());
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Error in getInterfaceIndex " + (Object)((Object)noSuchInterface));
        }
        catch (WrongInterfaceType wrongInterfaceType) {
            db.println("Error in getInterfaceIndex " + (Object)((Object)wrongInterfaceType));
        }
        return this.lInterface[n];
    }

    public void refreshLineFromModel(int n) {
        if (n > this.numLines || n < 0) {
            if (db.on()) {
                db.println("Invalid lineNo for refresh " + n);
            }
            return;
        }
        this.resetLineCache(n);
        this.fireTableRowsUpdated(n, n);
    }

    protected void resetLineCache(int n) {
        this.lInterface[n] = null;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            this.isDirty[n][i] = false;
        }
    }

    public boolean isDirty(int n, int n2) {
        return this.isDirty[n][n2];
    }

    private void resetDirtyBits() {
        for (int i = 0; i < this.numLines; ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                this.isDirty[i][j] = false;
            }
        }
    }

    public void refreshFromModel() {
        for (int i = 0; i < this.numLines; ++i) {
            this.resetLineCache(i);
        }
        this.fireTableRowsUpdated(0, this.numLines - 1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

