/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.model;

import cerent.cms.idl.Node.eDbType;
import cerent.cms.model.DataTransferJob;
import cerent.cms.model.SwUpgradeModel;
import cerent.util.SDebug;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobStatus;
import com.cisco.ctc600.model.DatabaseManagementModel;
import com.cisco.ctc600.model.PlatformNodeModel;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class DataTransferJob600
extends DataTransferJob {
    private ArrayList selList;
    static final SDebug db = new SDebug("DataTransferJob600");
    protected int[] restoreInfoType = null;
    protected int[] restoreInfoSize = null;
    private File tmpFile;
    private DatabaseManagementModel dbModel = null;

    public DataTransferJob600(PlatformNodeModel platformNodeModel, String string, int n, IJobProgressControl iJobProgressControl) {
        super(platformNodeModel, string, n, iJobProgressControl);
        this.dbModel = platformNodeModel.getDatabaseManagementModel();
    }

    public JobStatus executeJob() {
        JobStatus jobStatus;
        if (this.operation != 3) {
            if (this.dbModel.getDbTypesFromFile() == null) {
                try {
                    this.dbModel.validateDbBackupFile(this.fileName);
                }
                catch (Exception exception) {
                    db.fine("Either CTM or CTS caused something wrong. CTC would never come here");
                }
            }
            this.buildRestoreInfo();
            db.finest("Using " + this.fileName + " for " + this.operationName);
            jobStatus = super.executeJob();
        } else {
            SwUpgradeModel swUpgradeModel = SwUpgradeModel.getInstance(this.nodeModel);
            swUpgradeModel.init();
            jobStatus = swUpgradeModel.isOperationAllowed(3) ? super.executeJob() : new JobStatus(2, (Object)new Exception("Download not allowed"));
        }
        this.cleanup();
        return jobStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildRestoreInfo() {
        this.selList = new ArrayList<E>();
        var1_1 = this.dbModel.getUserSelection();
        for (var2_2 = 0; var2_2 < var1_1.length; ++var2_2) {
            this.selList.add(eDbType.from_int(var1_1[var2_2]));
        }
        var2_3 = new StringBuffer();
        this.restoreInfoType = this.dbModel.getDbTypesFromFile();
        this.restoreInfoSize = this.dbModel.getDbSizesFromFile();
        var2_3.append(this.dbModel.getConfigIpAddr() + "|" + this.dbModel.getDbSwVersion() + "|" + this.dbModel.getDbVersion() + "|" + this.selList.size() + ":");
        for (var3_4 = 0; var3_4 < this.restoreInfoType.length; ++var3_4) {
            if (!this.selList.contains(eDbType.from_int(this.restoreInfoType[var3_4]))) continue;
            var2_3.append(this.restoreInfoType[var3_4] + ",");
            var2_3.append(this.restoreInfoSize[var3_4] + ":");
        }
        var2_3.append("|;");
        DataTransferJob600.db.fine("StringBuffer = " + var2_3.toString());
        var3_5 = null;
        var4_6 = null;
        try {
            block25: {
                this.tmpFile = File.createTempFile("dbRestore", ".db");
                DataTransferJob600.db.fine("Temporary filename generated = " + this.tmpFile.getCanonicalPath());
                var3_5 = new DataOutputStream(new FileOutputStream(this.tmpFile));
                var3_5.writeBytes(var2_3.toString());
                if (!this.dbModel.isFileFromOlderDB()) break block25;
                this.buildOldDbRestoreInfo((DataOutputStream)var3_5);
                var12_7 = null;
                if (var3_5 == null) ** GOTO lbl106
                ** GOTO lbl100
            }
            var4_6 = new DataInputStream(new FileInputStream(this.fileName));
            var5_15 = new byte[1024];
            var4_6.read(var5_15, 0, this.dbModel.getFirstDbStarts());
            for (var10_17 = 0; var10_17 < this.restoreInfoType.length; ++var10_17) {
                var6_18 = 0;
                var7_19 = this.restoreInfoSize[var10_17];
                var9_21 = this.selList.contains(eDbType.from_int(this.restoreInfoType[var10_17]));
                DataTransferJob600.db.fine("Starting to copy db = " + this.restoreInfoType[var10_17] + ", filesize = " + var7_19 + ", needsToWrite = " + var9_21);
                while (var6_18 < this.restoreInfoSize[var10_17]) {
                    var8_20 = var4_6.read(var5_15, 0, Math.min(1024, var7_19));
                    if (var8_20 <= 0) continue;
                    var6_18 += var8_20;
                    var7_19 -= var8_20;
                    if (!var9_21) continue;
                    var3_5.write(var5_15, 0, var8_20);
                    DataTransferJob600.db.fine("bytesRead = " + var6_18 + ", bytesLeft = " + var7_19 + ", actualRead = " + var8_20);
                }
            }
            this.fileName = this.tmpFile.getCanonicalPath();
            DataTransferJob600.db.fine("filename to be send = " + this.fileName);
            ** GOTO lbl115
        }
        catch (Exception var5_16) {
            DataTransferJob600.db.info("Caught exception");
            SDebug.printStackTrace((Throwable)var5_16);
            var12_9 = null;
            if (var3_5 != null) {
                try {
                    var3_5.close();
                }
                catch (IOException var13_13) {
                    SDebug.printStackTrace((Throwable)var13_13);
                }
            }
            if (var4_6 == null) return;
            try {
                var4_6.close();
                return;
            }
            catch (IOException var13_13) {
                SDebug.printStackTrace((Throwable)var13_13);
                return;
            }
        }
        {
            block24: {
                block26: {
                    catch (Throwable var11_22) {
                        block23: {
                            var12_10 = null;
                            if (var3_5 != null) {
                                ** try [egrp 2[TRYBLOCK] [6 : 714->721)] { 
lbl86:
                                // 1 sources

                                var3_5.close();
                                break block23;
lbl88:
                                // 1 sources

                                catch (IOException var13_14) {
                                    SDebug.printStackTrace((Throwable)var13_14);
                                }
                            }
                        }
                        if (var4_6 == null) throw var11_22;
                        ** try [egrp 3[TRYBLOCK] [7 : 737->745)] { 
lbl94:
                        // 1 sources

                        var4_6.close();
                        throw var11_22;
lbl96:
                        // 1 sources

                        catch (IOException var13_14) {
                            SDebug.printStackTrace((Throwable)var13_14);
                        }
                        throw var11_22;
                    }
lbl100:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [6 : 714->721)] { 
lbl101:
                    // 1 sources

                    var3_5.close();
                    break block26;
lbl103:
                    // 1 sources

                    catch (IOException var13_11) {
                        SDebug.printStackTrace((Throwable)var13_11);
                    }
                }
                if (var4_6 == null) return;
                ** try [egrp 3[TRYBLOCK] [7 : 737->745)] { 
lbl109:
                // 1 sources

                var4_6.close();
                return;
lbl111:
                // 1 sources

                catch (IOException var13_11) {
                    SDebug.printStackTrace((Throwable)var13_11);
                }
                return;
lbl115:
                // 1 sources

                var12_8 = null;
                if (var3_5 != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 714->721)] { 
lbl118:
                    // 1 sources

                    var3_5.close();
                    break block24;
lbl120:
                    // 1 sources

                    catch (IOException var13_12) {
                        SDebug.printStackTrace((Throwable)var13_12);
                    }
                }
            }
            if (var4_6 == null) return;
            try {}
            catch (IOException var13_12) {}
            SDebug.printStackTrace((Throwable)var13_12);
            return;
            var4_6.close();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void buildOldDbRestoreInfo(DataOutputStream dataOutputStream) {
        byte[] byArray = new byte[1024];
        ZipInputStream zipInputStream = null;
        zipInputStream = new ZipInputStream(new FileInputStream(this.fileName));
        for (int i = 0; i < this.restoreInfoType.length; ++i) {
            ZipEntry zipEntry;
            if (!this.selList.contains(eDbType.from_int(this.restoreInfoType[i]))) continue;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (this.restoreInfoType[i] != Integer.parseInt(zipEntry.getName())) continue;
                int n = this.restoreInfoSize[i];
                int n2 = 0;
                db.fine("Starting to copy db = " + this.restoreInfoType[i] + ", filesize = " + n);
                while (n2 < this.restoreInfoSize[i]) {
                    int n3 = zipInputStream.read(byArray, 0, Math.min(1024, n));
                    if (n3 <= 0) continue;
                    n2 += n3;
                    n -= n3;
                    dataOutputStream.write(byArray, 0, n3);
                }
                break block9;
            }
            if (zipEntry != null) continue;
            zipInputStream.close();
            zipInputStream = new ZipInputStream(new FileInputStream(this.fileName));
        }
        dataOutputStream.close();
        this.fileName = this.tmpFile.getCanonicalPath();
        db.fine("filename to be send = " + this.fileName);
        Object var10_10 = null;
        if (zipInputStream == null) return;
        try {
            zipInputStream.close();
            return;
        }
        catch (IOException iOException) {
            SDebug.printStackTrace((Throwable)iOException);
        }
        return;
        {
            catch (Exception exception) {
                db.info("Caught exception");
                SDebug.printStackTrace((Throwable)exception);
                Object var10_11 = null;
                if (zipInputStream == null) return;
                try {
                    zipInputStream.close();
                    return;
                }
                catch (IOException iOException) {
                    SDebug.printStackTrace((Throwable)iOException);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                SDebug.printStackTrace((Throwable)iOException);
            }
            throw throwable;
        }
    }

    private void cleanup() {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }
}

