/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.EtherMedia.sAsapEtherLineInfo;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sIdStats;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ether.AbstractPmStatTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.HashSet;

public class AsapEtherPortPmStatTableModel
extends AbstractPmStatTableModel {
    private static final String[] PARM_NAMES = new String[]{"Time Last Cleared", "Link Status", "Rx Bytes", "Rx Unicast Packets", "Rx Multicast Packets", "Rx Broadcast Packets", "Rx Giants", "Rx FCS Errors", "Rx Runts", "Rx Jabbers", "Rx Align Errors", "Tx Bytes", "Tx Unicast Packets", "Tx Multicast Packets", "Tx Broadcast Packets", "Port Drop Counts", "Rx Discards", "etherStatsOctets", "etherStatsPkts", "etherStatsBroadcastPkts", "etherStatsMulticastPkts", "etherStatsFragments", "etherStatsPkts64Octets", "etherStatsPkts65to127Octets", "etherStatsPkts128to255Octets", "etherStatsPkts256to511Octets", "etherStatsPkts512to1023Octets", "etherStatsPkts1024to1518Octets", "Tx Discards", "Rx Errors", "Tx Errors", "dot3StatsInternalMacTxErrors", "dot3StatsFrameTooLong", "dot3StatsInternalMacRxErrors", "dot3StatsSymbolErrors", "Rx Pause Frames", "Tx Pause Frames"};
    private eStatsId[] supportedStatsIds = new eStatsId[]{eStatsId.STATS_IfInOctets, eStatsId.STATS_IfInUcastPkts, eStatsId.STATS_IfInMulticastPkts, eStatsId.STATS_IfInBroadcastPkts, eStatsId.STATS_EtherStatsOversizePkts, eStatsId.STATS_Dot3StatsFCSErrors, eStatsId.STATS_EtherStatsUndersizePkts, eStatsId.STATS_EtherStatsJabbers, eStatsId.STATS_Dot3StatsAlignmentErrors, eStatsId.STATS_IfOutOctets, eStatsId.STATS_IfOutUcastPkts, eStatsId.STATS_IfOutMulticastPkts, eStatsId.STATS_IfOutBroadcastPkts, eStatsId.STATS_EtherStatsDropEvents, eStatsId.STATS_IfInDiscards, eStatsId.STATS_EtherStatsOctets, eStatsId.STATS_EtherStatsPkts, eStatsId.STATS_EtherStatsBroadcastPkts, eStatsId.STATS_EtherStatsMulticastPkts, eStatsId.STATS_EtherStatsFragments, eStatsId.STATS_EtherStatsPkts64Octets, eStatsId.STATS_EtherStatsPkts65to127Octets, eStatsId.STATS_EtherStatsPkts128to255Octets, eStatsId.STATS_EtherStatsPkts256to511Octets, eStatsId.STATS_EtherStatsPkts512to1023Octets, eStatsId.STATS_EtherStatsPkts1024to1518Octets, eStatsId.STATS_IfOutDiscards, eStatsId.STATS_IfInErrors, eStatsId.STATS_IfOutErrors, eStatsId.STATS_Dot3StatsInternalMacTxErrors, eStatsId.STATS_Dot3StatsFrameTooLong, eStatsId.STATS_Dot3StatsInternalMacRxErrors, eStatsId.STATS_Dot3StatsSymbolErrors, eStatsId.STATS_ReceivePauseFrames, eStatsId.STATS_TransmitPauseFrames};
    private AsapEtherLineModel[] etherLineModels;
    private EventUtilities timeConverter;
    private static final SDebug db = new SDebug("AsapEtherPortPmStatTableModel");
    static /* synthetic */ Class class$cerent$cms$idl$Rmon$eStatsId;

    public AsapEtherPortPmStatTableModel(AsapEtherLineModel[] asapEtherLineModelArray, NodeModelDelegate nodeModelDelegate) {
        super(PARM_NAMES, asapEtherLineModelArray.length, 2);
        this.etherLineModels = asapEtherLineModelArray;
        this.timeConverter = EventUtilities.getInstance(nodeModelDelegate);
        if (db.isFinestEnabled()) {
            if (PARM_NAMES.length - this.supportedStatsIds.length != 2) {
                db.println("Row Label count (" + PARM_NAMES.length + ") and data source count (" + this.supportedStatsIds.length + ") is different!!");
            }
            HashSet<eStatsId> hashSet = new HashSet<eStatsId>();
            for (int i = 0; i < this.supportedStatsIds.length; ++i) {
                boolean bl = hashSet.add(this.supportedStatsIds[i]);
                if (bl) continue;
                db.println("Duplicate entry in supportedStatsIds " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Rmon$eStatsId == null ? AsapEtherPortPmStatTableModel.class$("cerent.cms.idl.Rmon.eStatsId") : class$cerent$cms$idl$Rmon$eStatsId))[this.supportedStatsIds[i].value()] + ", value = " + this.supportedStatsIds[i].value());
            }
            if (hashSet.size() != this.supportedStatsIds.length) {
                db.println("Number of Duplicate entries in supportedStatsIds is " + (this.supportedStatsIds.length - hashSet.size()));
            }
            hashSet.clear();
        }
    }

    protected void retrievePm(int n) {
        sIdStats[] sIdStatsArray = null;
        try {
            sIdStatsArray = this.etherLineModels[n].getPortStats();
            this.retrievePm(n, sIdStatsArray);
        }
        catch (Exception exception) {
            db.println("Exception caught accessing stats for port " + n + " : " + exception);
            if (AsapEtherPortPmStatTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return;
        }
    }

    private int mapIdStatsToTableRow(eStatsId eStatsId2) {
        for (int i = 0; i < this.supportedStatsIds.length; ++i) {
            if (this.supportedStatsIds[i].value() != eStatsId2.value()) continue;
            return i;
        }
        return -1;
    }

    protected void retrievePm(int n, sIdStats[] sIdStatsArray) {
        this.portPms[n].setText(0, this.getLastClearTime(this.etherLineModels[n]));
        this.portPms[n].setText(1, this.getLinkStatus(this.etherLineModels[n]));
        for (int i = 0; i < sIdStatsArray.length; ++i) {
            sIdStats sIdStats2 = sIdStatsArray[i];
            try {
                int n2 = this.mapIdStatsToTableRow(sIdStats2.statId);
                if (n2 != -1) {
                    this.portPms[n].setCounter(n2, sIdStats2.count);
                    continue;
                }
                db.println("Unknown eStatsId value: " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Rmon$eStatsId == null ? AsapEtherPortPmStatTableModel.class$("cerent.cms.idl.Rmon.eStatsId") : class$cerent$cms$idl$Rmon$eStatsId))[sIdStats2.statId.value()]);
                continue;
            }
            catch (Exception exception) {
                db.println("Exception caught in retrievePm() : " + exception);
                if (!db.on()) continue;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private String getLastClearTime(AsapEtherLineModel asapEtherLineModel) {
        String string;
        block3: {
            string = "Never Cleared";
            try {
                int n = asapEtherLineModel.getLineLastClearedStats();
                if (n > 0) {
                    string = this.timeConverter.convertSecondsToFormattedTimeZoneString(n);
                }
            }
            catch (Exception exception) {
                db.println("Exception caught in retrievePm() : " + exception);
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public boolean isPmClearingSupported() {
        return true;
    }

    private String getLinkStatus(AsapEtherLineModel asapEtherLineModel) {
        String string;
        block2: {
            string = "Down";
            try {
                sAsapEtherLineInfo sAsapEtherLineInfo2 = asapEtherLineModel.getAsapEtherLineInfo();
                string = sAsapEtherLineInfo2.linkUp ? "Up" : "Down";
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    public void clearStats(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (nArray[i] - 1 >= this.etherLineModels.length) continue;
                this.etherLineModels[nArray[i] - 1].clearLineStats();
                continue;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshMyLines(AsapEtherLineModel[] asapEtherLineModelArray) {
        this.etherLineModels = asapEtherLineModelArray;
        this.numLines = asapEtherLineModelArray.length;
        db.fine("refreshMyLines(): refreshing lines, ether lines= " + asapEtherLineModelArray.length);
        this.updatePortPMColumns();
        this.fireTableStructureChanged();
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        String string = "Port " + n;
        try {
            PortModel portModel = (PortModel)this.etherLineModels[n - 1].getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            string = "Port " + entityCellRenderer.getPortString(portModel, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

