/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.Rmon.eStatsId;
import cerent.cms.idl.Rmon.sTimedStats;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.EtherPmStatsSeries;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NoSuchStatsId;
import cerent.cms.model.NoSuchStatsSeries;
import cerent.cms.ui.ether.AbstractPmHistPane;
import cerent.cms.ui.ether.AbstractPmHistTableModel;
import cerent.util.SDebug;

public class AsapPosPortPmHistTableModel
extends AbstractPmHistTableModel {
    protected static final int ASAP_RX_OCTETS = 0;
    protected static final int ASAP_RX_PACKETS = 1;
    protected static final int ASAP_RX_CRC_ERRORS = 2;
    protected static final int ASAP_TX_OCTETS = 3;
    protected static final int ASAP_TX_PACKETS = 4;
    protected static final int ASAP_RX_SBIT_ERRORS = 5;
    protected static final int ASAP_RX_MBIT_ERRORS = 6;
    protected static final int ASAP_RX_TYPE_INVALID = 7;
    protected static final int ASAP_RX_IN_ABORT_PACKETS = 8;
    protected static final int ASAP_RX_SHORTS = 9;
    protected static final int ASAP_RX_LONGS = 10;
    protected static final int ASAP_RX_IN_DROP_PACKETS = 11;
    protected static final int ASAP_RX_RUNTS = 12;
    private static final String[] PARM_NAMES = new String[]{"Rx Octets", "Rx Packets", "Rx CRC Errors", "Tx Octets", "Tx Packets", "Rx Single Bit Errors", "Rx Multi Bit Errors", "Rx Type Invalid", "Rx Input Abort Packets", "Rx Shorts", "Rx Longs", "Rx Input Drop Packets", "Rx Runts"};
    private static final SDebug db = new SDebug("AsapPosPortPmHistTableModel");

    public AsapPosPortPmHistTableModel(AbstractPmHistPane abstractPmHistPane, ModuleModel moduleModel) {
        super(abstractPmHistPane, moduleModel);
        this.parmNames = PARM_NAMES;
        this.numLines = this.parmNames.length;
    }

    public void refresh(EtherLineModel etherLineModel, EtherPmStatsSeries etherPmStatsSeries) throws NoSuchStatsSeries, NoSuchStatsId, NoSuchInterface {
        this.etherLineModel = etherLineModel;
        boolean bl = true;
        try {
            bl = ((AsapPosLineModel)etherLineModel).getAsapPosPortAdminInfo().posFraming == ePosFramingType.GFP_F;
        }
        catch (CTCUserException cTCUserException) {
            SDebug.printStackTrace((Throwable)cTCUserException);
        }
        this.refresh = false;
        this.nCols = this.getStatsColCount(etherPmStatsSeries);
        this.timedStats = new sTimedStats[this.numLines][];
        this.lastIntervalTimeStamp = "";
        block17: for (int i = 0; i < this.numLines; ++i) {
            this.timedStats[i] = this.createColsDefaultData(this.nCols);
            switch (i) {
                case 0: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxOctets);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_hdlcInOctets);
                    continue block17;
                }
                case 1: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxFrame);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_rxTotalPkts);
                    continue block17;
                }
                case 2: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxCRCErrors);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_MediaIndStatsRxFramesBadCRC);
                    continue block17;
                }
                case 3: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsTxOctets);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_hdlcOutOctets);
                    continue block17;
                }
                case 4: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsTxFrame);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_txTotalPkts);
                    continue block17;
                }
                case 5: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxSBitErrors);
                        continue block17;
                    }
                    this.zeroRow(i);
                    continue block17;
                }
                case 6: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxMBitErrors);
                        continue block17;
                    }
                    this.zeroRow(i);
                    continue block17;
                }
                case 7: {
                    if (bl) {
                        this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_GfpStatsRxTypeInvalid);
                        continue block17;
                    }
                    this.zeroRow(i);
                    continue block17;
                }
                case 8: {
                    if (bl) {
                        this.zeroRow(i);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_hdlcRxAborts);
                    continue block17;
                }
                case 9: {
                    if (bl) {
                        this.zeroRow(i);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_MediaIndStatsRxShortPkts);
                    continue block17;
                }
                case 10: {
                    if (bl) {
                        this.zeroRow(i);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_MediaIndStatsRxFramesTooLong);
                    continue block17;
                }
                case 11: {
                    if (bl) {
                        this.zeroRow(i);
                        continue block17;
                    }
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_ReceivePktsDroppedInternalCongestion);
                    continue block17;
                }
                case 12: {
                    this.getStatsSeries(etherPmStatsSeries, i, eStatsId.STATS_MediaIndStatsRxFramesTruncated);
                }
            }
        }
        this.refresh = true;
        this.refreshCols(etherPmStatsSeries);
    }

    private void zeroRow(int n) {
        for (int i = 0; i < this.nCols; ++i) {
            try {
                this.timedStats[n][i].count = 0L;
                continue;
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("rowNo=" + n + " hits exception");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }
}

