/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.asap;

import cerent.cms.idl.EtherMedia.ePosFramingType;
import cerent.cms.idl.EtherMedia.sAsapEtherLineInfo;
import cerent.cms.idl.EtherMedia.sAsapPosPortAdminInfo;
import cerent.cms.idl.Rmon.sIdStats;
import cerent.cms.model.AsapEtherLineModel;
import cerent.cms.model.AsapPosLineModel;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PortModel;
import cerent.cms.model.enum.EtherEnumStrings;
import cerent.cms.ui.EntityCellRenderer;
import cerent.cms.ui.ether.AbstractPmStatTableModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;

public class AsapPosPortPmStatTableModel
extends AbstractPmStatTableModel {
    private static final String[] PARM_NAMES = new String[]{"Time Last Cleared", "Link Status", "Framing Type", "Rx Octets", "Rx Packets", "Rx CRC Errors", "Tx Octets", "Tx Packets", "Rx Single Bit Errors", "Rx Mult Bit Errors", "Rx Type Invalid", "Rx Input Abort Packets", "Rx Shorts", "Rx Longs", "Rx Input Drop Packets", "Rx Runts"};
    private AsapPosLineModel[] posLineModels;
    private AsapEtherLineModel[] etherLineModels;
    private EventUtilities timeConverter;
    private String lastClearTime = "";
    private String linkStatus = "";
    private String framingTypeStr = "";
    protected static final SDebug db = new SDebug("AsapPosPortPmStatTableModel");
    static /* synthetic */ Class class$cerent$cms$idl$EtherMedia$ePosFramingType;
    static /* synthetic */ Class class$cerent$cms$idl$Rmon$eStatsId;

    public AsapPosPortPmStatTableModel(AsapPosLineModel[] asapPosLineModelArray, AsapEtherLineModel[] asapEtherLineModelArray, NodeModelDelegate nodeModelDelegate) {
        super(PARM_NAMES, asapPosLineModelArray.length, 3);
        this.posLineModels = asapPosLineModelArray;
        this.etherLineModels = asapEtherLineModelArray;
        this.timeConverter = EventUtilities.getInstance(nodeModelDelegate);
    }

    protected void retrievePm(int n) {
        sAsapPosPortAdminInfo sAsapPosPortAdminInfo2 = null;
        ePosFramingType ePosFramingType2 = null;
        sIdStats[] sIdStatsArray = null;
        try {
            sIdStatsArray = this.posLineModels[n].getPortStats();
            sAsapPosPortAdminInfo2 = this.posLineModels[n].getAsapPosPortAdminInfo();
            ePosFramingType2 = sAsapPosPortAdminInfo2.posFraming;
            this.lastClearTime = this.getLastClearTime(this.posLineModels[n]);
            this.linkStatus = this.getLinkStatus(this.etherLineModels[n]);
            this.framingTypeStr = EtherEnumStrings.get(class$cerent$cms$idl$EtherMedia$ePosFramingType == null ? (class$cerent$cms$idl$EtherMedia$ePosFramingType = AsapPosPortPmStatTableModel.class$("cerent.cms.idl.EtherMedia.ePosFramingType")) : class$cerent$cms$idl$EtherMedia$ePosFramingType, ePosFramingType2.value()).toString();
            if (AsapPosPortPmStatTableModel.db.on) {
                db.println("framing type for port " + n + "=" + ePosFramingType2);
            }
            if (ePosFramingType2 != null) {
                if (ePosFramingType2 == ePosFramingType.GFP_F) {
                    this.retrieveGfpPm(n, sIdStatsArray);
                } else {
                    this.retrieveHdlcPm(n, sIdStatsArray);
                }
            }
        }
        catch (Exception exception) {
            db.println("Exception caught accessing stats for port " + n + " : " + exception);
            if (AsapPosPortPmStatTableModel.db.on) {
                SDebug.printStackTrace((Throwable)exception);
            }
            return;
        }
    }

    private String getLinkStatus(AsapEtherLineModel asapEtherLineModel) {
        String string;
        block2: {
            string = "Down";
            try {
                sAsapEtherLineInfo sAsapEtherLineInfo2 = asapEtherLineModel.getAsapEtherLineInfo();
                string = sAsapEtherLineInfo2.linkUp ? "Up" : "Down";
            }
            catch (Exception exception) {
                if (!db.on()) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private String getLastClearTime(AsapPosLineModel asapPosLineModel) {
        String string;
        block3: {
            string = "Never Cleared";
            try {
                int n = asapPosLineModel.getLineLastClearedStats();
                if (n > 0) {
                    string = this.timeConverter.convertSecondsToFormattedTimeZoneString(n);
                }
            }
            catch (Exception exception) {
                if (!db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        return string;
    }

    private void retrieveHdlcPm(int n, sIdStats[] sIdStatsArray) {
        this.portPms[n].setText(0, this.lastClearTime);
        this.portPms[n].setText(1, this.linkStatus);
        this.portPms[n].setText(2, this.framingTypeStr);
        block12: for (int i = 0; i < sIdStatsArray.length; ++i) {
            sIdStats sIdStats2 = sIdStatsArray[i];
            int n2 = sIdStats2.statId.value();
            switch (n2) {
                case 80: {
                    this.portPms[n].setCounter(0, sIdStats2.count);
                    continue block12;
                }
                case 44: {
                    this.portPms[n].setCounter(1, sIdStats2.count);
                    continue block12;
                }
                case 66: {
                    this.portPms[n].setCounter(2, sIdStats2.count);
                    continue block12;
                }
                case 82: {
                    this.portPms[n].setCounter(3, sIdStats2.count);
                    continue block12;
                }
                case 43: {
                    this.portPms[n].setCounter(4, sIdStats2.count);
                    continue block12;
                }
                case 81: {
                    this.portPms[n].setCounter(8, sIdStats2.count);
                    continue block12;
                }
                case 83: {
                    this.portPms[n].setCounter(9, sIdStats2.count);
                    continue block12;
                }
                case 65: {
                    this.portPms[n].setCounter(10, sIdStats2.count);
                    continue block12;
                }
                case 41: {
                    this.portPms[n].setCounter(11, sIdStats2.count);
                    continue block12;
                }
                case 64: {
                    this.portPms[n].setCounter(12, sIdStats2.count);
                    continue block12;
                }
                default: {
                    db.finest("In retrieveHdlcPm, Unknown eStatsId value: " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Rmon$eStatsId == null ? AsapPosPortPmStatTableModel.class$("cerent.cms.idl.Rmon.eStatsId") : class$cerent$cms$idl$Rmon$eStatsId))[n2]);
                }
            }
        }
    }

    private void retrieveGfpPm(int n, sIdStats[] sIdStatsArray) {
        this.portPms[n].setText(0, this.lastClearTime);
        this.portPms[n].setText(1, this.linkStatus);
        this.portPms[n].setText(2, this.framingTypeStr);
        block11: for (int i = 0; i < sIdStatsArray.length; ++i) {
            sIdStats sIdStats2 = sIdStatsArray[i];
            int n2 = sIdStats2.statId.value();
            switch (n2) {
                case 61: {
                    this.portPms[n].setCounter(0, sIdStats2.count);
                    continue block11;
                }
                case 59: {
                    this.portPms[n].setCounter(1, sIdStats2.count);
                    continue block11;
                }
                case 55: {
                    this.portPms[n].setCounter(2, sIdStats2.count);
                    continue block11;
                }
                case 62: {
                    this.portPms[n].setCounter(3, sIdStats2.count);
                    continue block11;
                }
                case 60: {
                    this.portPms[n].setCounter(4, sIdStats2.count);
                    continue block11;
                }
                case 52: {
                    this.portPms[n].setCounter(5, sIdStats2.count);
                    continue block11;
                }
                case 53: {
                    this.portPms[n].setCounter(6, sIdStats2.count);
                    continue block11;
                }
                case 54: {
                    this.portPms[n].setCounter(7, sIdStats2.count);
                    continue block11;
                }
                case 64: {
                    this.portPms[n].setCounter(12, sIdStats2.count);
                    continue block11;
                }
                default: {
                    db.println("In retrieveGfpPm, Unknown eStatsId value: " + EnumStrings.getStrings((Class)(class$cerent$cms$idl$Rmon$eStatsId == null ? AsapPosPortPmStatTableModel.class$("cerent.cms.idl.Rmon.eStatsId") : class$cerent$cms$idl$Rmon$eStatsId))[n2]);
                }
            }
        }
    }

    public boolean isPmClearingSupported() {
        return true;
    }

    public void clearStats(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (nArray[i] - 1 >= this.posLineModels.length) continue;
                this.posLineModels[nArray[i] - 1].clearLineStats();
                continue;
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void refreshMyLines(AsapEtherLineModel[] asapEtherLineModelArray, AsapPosLineModel[] asapPosLineModelArray) {
        this.posLineModels = asapPosLineModelArray;
        this.etherLineModels = asapEtherLineModelArray;
        this.numLines = asapEtherLineModelArray.length;
        db.fine("refreshMyLines(): refreshing lines, pos lines= " + asapPosLineModelArray.length + " ether lines= " + asapEtherLineModelArray.length);
        this.updatePortPMColumns();
        this.fireTableStructureChanged();
    }

    public String getColumnName(int n) {
        if (n < 1) {
            return "Param";
        }
        String string = "Port " + n;
        try {
            PortModel portModel = (PortModel)this.posLineModels[n - 1].getPortModel();
            EntityCellRenderer entityCellRenderer = new EntityCellRenderer();
            string = "Port " + entityCellRenderer.getPortString(portModel, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

