/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.ctc600.ui.shelf;

import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.eModuleOp;
import cerent.cms.model.EntityModel;
import cerent.cms.model.FramingType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ui.shelf.CardBehavior;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JOptionPane;

public class CardBehavior600
extends CardBehavior {
    protected static final String RESET_TITLE = "Reset Warning";
    protected static final String HARD_RESET = "hard-reset?";
    protected static final String SOFT_RESET = "soft-reset?";
    protected static final String FORCED_HARD_RESET = "FORCED hard-reset?";
    protected static final String FORCED_SOFT_RESET = "FORCED soft-reset?";
    protected static final String NORMAL_WARNING = "Are you sure you want to perform a ";
    protected static final String SW_UPGRADE_WARNING = "A software upgrade is in progress.";
    protected static final String SIMPLEX_WARNING = "No protect TSC card found.";
    protected static final String FORCED_WARNING = "The protect TSC card is not in STANDBY mode.";
    protected static final String FORCED_RETRY_WARNING = "The reset operation failed.\nThe shelf or the protect TSC card is not ready.\n\nDo you want to perform a FORCED ";
    protected static final String RESET_WARNING = "\n\nResets may result in a traffic disruption. Are you sure you want to perform a ";
    protected static final String FORCED_RESET_WARNING = "\n\nResets may result in a traffic disruption. Do you want to perform a ";
    protected static final String CXC_FORCED_RETRY_WARNING = "The reset operation failed.\nThere are one or more cross connects provisioned.\nPerforming a FORCED hard-reset will result in a traffic disruption.\n\nDo you want to perform a ";
    protected static final int NORMAL_RESET = 1;
    protected static final int SW_UPGRADE_RESET = 2;
    protected static final int SIMPLEX_RESET = 3;
    protected static final int FORCED_RESET = 4;
    protected static final int DUAL_TSC_RESET = 5;
    protected static final int TSC_A_INDEX = 5;
    protected static final int TSC_B_INDEX = 10;

    public CardBehavior600(SDebug sDebug, NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getPlatform(), sDebug);
    }

    public void addCard(Component component, EntityModel entityModel, String string) {
        if (entityModel.getEqType() == 147) {
            this.addPim(component, entityModel, string);
        } else {
            super.addCard(component, entityModel, string);
        }
    }

    public boolean deleteCard(Component component, EntityModel entityModel) {
        if (entityModel.getEqType() == 148) {
            return this.deletePim(component, entityModel);
        }
        return super.deleteCard(component, entityModel);
    }

    public void hardResetCard(Component component, ModuleModel moduleModel) {
        if (moduleModel.getEqType() == 89) {
            eModuleOp eModuleOp2 = eModuleOp.HARD_RESET;
            String string = null;
            int n = this.getTscResetType(moduleModel);
            switch (n) {
                case 1: 
                case 5: {
                    string = "Are you sure you want to perform a hard-reset?";
                    break;
                }
                case 2: {
                    string = "A software upgrade is in progress.\n\nResets may result in a traffic disruption. Are you sure you want to perform a hard-reset?";
                    break;
                }
                case 3: {
                    string = "No protect TSC card found.\n\nResets may result in a traffic disruption. Are you sure you want to perform a hard-reset?";
                    break;
                }
                case 4: {
                    string = "The protect TSC card is not in STANDBY mode.\n\nResets may result in a traffic disruption. Do you want to perform a FORCED hard-reset?";
                    eModuleOp2 = eModuleOp.FORCE_HARD_RESET;
                    break;
                }
                default: {
                    string = "Are you sure you want to perform a hard-reset?";
                }
            }
            this.db.fine("hardResetCard(): hard-reset TSC");
            this.doTscResetOp(component, moduleModel, n, eModuleOp2, string);
        } else if (moduleModel.getEqType() == 91) {
            this.db.fine("hardResetCard(): hard-reset CXC");
            this.doCxcResetOp(component, moduleModel, eModuleOp.HARD_RESET, "Are you sure you want to perform a hard-reset?");
        } else {
            this.db.fine("hardResetCard(): hard-reset line card");
            super.hardResetCard(component, moduleModel);
        }
    }

    public void hardResetPim(Component component, PimModel pimModel) {
        this.resetPim(component, pimModel, eModuleOp.HARD_RESET);
    }

    public void softResetCard(Component component, ModuleModel moduleModel) {
        if (moduleModel.getEqType() == 89) {
            eModuleOp eModuleOp2 = eModuleOp.SOFT_RESET;
            String string = null;
            int n = this.getTscResetType(moduleModel);
            switch (n) {
                case 1: 
                case 5: {
                    string = "Are you sure you want to perform a soft-reset?";
                    break;
                }
                case 2: {
                    string = "A software upgrade is in progress.\n\nResets may result in a traffic disruption. Are you sure you want to perform a soft-reset?";
                    break;
                }
                case 3: {
                    string = "No protect TSC card found.\n\nResets may result in a traffic disruption. Are you sure you want to perform a soft-reset?";
                    break;
                }
                case 4: {
                    string = "The protect TSC card is not in STANDBY mode.\n\nResets may result in a traffic disruption. Do you want to perform a FORCED soft-reset?";
                    eModuleOp2 = eModuleOp.FORCE_SOFT_RESET;
                    break;
                }
                default: {
                    string = "Are you sure you want to perform a soft-reset?";
                }
            }
            this.db.fine("softResetCard(): soft-reset TSC");
            this.doTscResetOp(component, moduleModel, n, eModuleOp2, string);
        } else {
            this.db.fine("softResetCard(): soft-reset CXC or line card");
            super.softResetCard(component, moduleModel);
        }
    }

    public int getTscResetType(ModuleModel moduleModel) {
        int n = 1;
        if (null == moduleModel || moduleModel.getEqType() != 89) {
            throw new IllegalArgumentException("Card type passed in is not a TSC");
        }
        if (moduleModel.getNodeModelDelegate().isRestAllowed()) {
            if (this.isActiveTsc(moduleModel)) {
                ModuleModel moduleModel2 = this.getTscMateFor(moduleModel);
                n = null != moduleModel2 ? (moduleModel2.getState().value() != 4 ? 4 : 5) : 3;
            }
        } else {
            n = 2;
            this.db.config("getTscResetType(): Hard reset requested while node is in software upgrade.");
        }
        return n;
    }

    protected void doTscResetOp(Component component, ModuleModel moduleModel, int n, eModuleOp eModuleOp2, String string) {
        this.db.config("doTscResetOp(): Reset of TSC requested.  Warning message presented: " + string);
        boolean bl = CerentDialog.yesNoDialog((Component)component, (String)string, (String)RESET_TITLE);
        if (bl) {
            try {
                moduleModel.doCommand(eModuleOp2);
                this.db.config("doTscResetOp(): Resetting TSC card: " + moduleModel.toString() + "  Issued warning: " + string);
            }
            catch (ProvisionError provisionError) {
                if (n == 5 && eModuleOp2 == eModuleOp.HARD_RESET) {
                    this.db.warning("doTscResetOp(): Normal TSC hard reset failed on a dual TSC system; ask user if a FORCED hard reset should be attempted on TSC card.");
                    String string2 = "\n\nResets may result in a traffic disruption. Do you want to perform a hard-reset?";
                    this.doTscResetOp(component, moduleModel, 4, eModuleOp.FORCE_HARD_RESET, string2);
                } else if (n == 5 && eModuleOp2 == eModuleOp.SOFT_RESET) {
                    this.db.warning("doTscResetOp(): Normal TSC soft reset failed on a dual TSC system; ask user if a FORCED soft reset should be attempted on TSC card.");
                    String string3 = "\n\nResets may result in a traffic disruption. Do you want to perform a soft-reset?";
                    this.doTscResetOp(component, moduleModel, 4, eModuleOp.FORCE_SOFT_RESET, string3);
                } else {
                    if (eModuleOp2 == eModuleOp.HARD_RESET || eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
                        ErrorMsg.displayDetailed(component, EMC.EID_HARD_RESET_CARD, provisionError.toString());
                    } else {
                        ErrorMsg.displayDetailed(component, EMC.EID_SOFT_RESET_CARD, provisionError.toString());
                    }
                    SDebug.printStackTrace((Throwable)provisionError);
                    this.db.warning("doTscResetOp(): TSC reset operation threw xProvisionError?");
                }
            }
            catch (Exception exception) {
                if (eModuleOp2 == eModuleOp.HARD_RESET || eModuleOp2 == eModuleOp.FORCE_HARD_RESET) {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_HARD_RESET_CARD);
                } else {
                    ErrorMsg.displayError((Component)component, (EID)EMC.EID_SOFT_RESET_CARD);
                }
                SDebug.printStackTrace((Throwable)exception);
                this.db.warning("doTscResetOp(): TSC reset operation failed?");
            }
        }
    }

    protected boolean isActiveTsc(ModuleModel moduleModel) {
        if (moduleModel.getState().value() == 5) {
            return true;
        }
        ModuleModel moduleModel2 = this.getTscMateFor(moduleModel);
        if (null == moduleModel2) {
            this.db.warning("isActiveTsc(): Simplex TSC detected, but it's not in an ACTIVE state.  CTC shouldn't be able to talk with the node.");
            return true;
        }
        if (moduleModel2.getState().value() != 5) {
            this.db.warning("isActiveTsc(): Neither TSC is currently reporting to be ACTIVE.  CTC shouldn't be able to talk with the node.");
        }
        return false;
    }

    protected boolean isTscAcquiringClock(ModuleModel moduleModel) {
        if (null == moduleModel || moduleModel.getEqType() != 89) {
            throw new IllegalArgumentException("Card type passed in is not a TSC");
        }
        return false;
    }

    protected ModuleModel getTscMateFor(ModuleModel moduleModel) {
        IEntityModel iEntityModel;
        if (null == moduleModel || moduleModel.getEqType() != 89) {
            throw new IllegalArgumentException("Card type passed in is not a TSC");
        }
        ModuleModel moduleModel2 = null;
        NodeModelDelegate nodeModelDelegate = moduleModel.getNodeModelDelegate();
        int n = 10;
        if (moduleModel.getSlot() == 10) {
            n = 5;
        }
        if ((iEntityModel = nodeModelDelegate.getEntityTableModel().getEntityModelBySlot(n)).getChildren().size() > 0) {
            moduleModel2 = (ModuleModel)iEntityModel.getChildren().get(0);
        }
        if (this.db.isConfigEnabled()) {
            this.db.config("getTscMateFor(): Finding TSC mate for TSC card in slot " + moduleModel.getSlot());
            if (null == moduleModel2) {
                this.db.config("getTscMateFor(): No mate found.");
            } else {
                this.db.config("getTscMateFor(): Mate identified in slot " + moduleModel2.getSlot());
            }
        }
        return moduleModel2;
    }

    protected void doCxcResetOp(Component component, ModuleModel moduleModel, eModuleOp eModuleOp2, String string) {
        this.db.config("doCxcResetOp(): Reset of CXC requested.  Warning message presented: " + string);
        boolean bl = CerentDialog.yesNoDialog((Component)component, (String)string, (String)RESET_TITLE);
        if (bl) {
            try {
                moduleModel.doCommand(eModuleOp2);
                this.db.config("doCxcResetOp(): Resetting CXC card: " + moduleModel.toString() + "  Issued warning: " + string);
            }
            catch (ProvisionError provisionError) {
                if (eModuleOp2 == eModuleOp.HARD_RESET) {
                    this.db.warning("doCxcResetOp(): Normal CXC hard reset failed; ask user if a FORCED hard reset should be attempted on CXC card.");
                    String string2 = "The reset operation failed.\nThere are one or more cross connects provisioned.\nPerforming a FORCED hard-reset will result in a traffic disruption.\n\nDo you want to perform a FORCED hard-reset?";
                    this.doCxcResetOp(component, moduleModel, eModuleOp.FORCE_HARD_RESET, string2);
                } else {
                    CerentDialog.errorDialog((Component)component, (Exception)((Object)provisionError), (String)"Error resetting card");
                    this.db.warning("doCxcResetOp(): CXC FORCED hard reset threw xProvisionError?");
                    SDebug.printStackTrace((Throwable)provisionError);
                }
            }
            catch (Exception exception) {
                CerentDialog.errorDialog((Component)component, (Exception)exception, (String)"Error resetting card");
                this.db.warning("doCxcResetOp(): CXC hard reset threw unexpected exception.");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void addPim(final Component component, final EntityModel entityModel, final String string) {
        new Thread("PIM Provisioner"){

            public void run() {
                Frame frame = JOptionPane.getFrameForComponent(component);
                PluggableSlotModel pluggableSlotModel = (PluggableSlotModel)entityModel;
                try {
                    eEqType eEqType2 = EntityModel.name2EqType((NodeModelDelegate)pluggableSlotModel.getNodeModel(), string);
                    if (eEqType2 != null) {
                        pluggableSlotModel.provisionPluggable(eEqType2);
                    }
                }
                catch (ResourceInUse resourceInUse) {
                    ErrorMsg.displayError((Component)frame, (EID)EMC.EID_CARD_SLOT_IN_USE);
                }
                catch (ProvisionError provisionError) {
                    if (CardBehavior600.this.db.on()) {
                        CardBehavior600.this.db;
                        SDebug.printStackTrace((Throwable)provisionError);
                    }
                    ErrorMsg.displayError((Component)frame, (EID)EMC.EID_CARD_PROV_ERROR_PARAM_1, (Object)provisionError.getMessage());
                }
            }
        }.start();
    }

    private boolean deletePim(Component component, EntityModel entityModel) {
        PimModel pimModel = (PimModel)entityModel;
        Frame frame = JOptionPane.getFrameForComponent(component);
        boolean bl = CerentDialog.yesNoDialog((Component)frame, (String)"Are you sure you want to delete this PIM?", (String)"Deleting PIM");
        boolean bl2 = false;
        if (bl) {
            try {
                pimModel.unprovision();
                bl2 = true;
            }
            catch (ResourceInUse resourceInUse) {
                StringBuffer stringBuffer = new StringBuffer();
                if (pimModel.isSupportingBLSR()) {
                    int n = pimModel.getNodeModel().getFramingType();
                    boolean bl3 = FramingType.getFramingType((int)n).isSonet();
                    if (bl3) {
                        stringBuffer.append("it is supporting the BLSR.");
                    } else {
                        stringBuffer.append("it is supporting the MS-SPRing.");
                    }
                } else if (pimModel.isInProtectionGroup()) {
                    stringBuffer.append("it is part of a protection group.");
                } else if (pimModel.isSupportingGCC()) {
                    stringBuffer.append("the GCC is in use.");
                } else if (pimModel.isSupportingSDCC()) {
                    stringBuffer.append("the SDCC is in use.");
                } else if (pimModel.isSupportingLDCC()) {
                    stringBuffer.append("the LDCC is in use.");
                } else if (pimModel.isTimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (pimModel.isEXT_1TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (pimModel.isEXT_2TimingSource()) {
                    stringBuffer.append("it is a timing source.");
                } else if (pimModel.hasCircuits()) {
                    stringBuffer.append("one or more circuits transit it.");
                } else if (pimModel.hasOhCircuits()) {
                    stringBuffer.append("one or more overhead circuits transit it.");
                } else {
                    stringBuffer.append("it is in use.");
                }
                ErrorMsg.displayError((Component)frame, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)stringBuffer.toString());
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayError((Component)frame, (EID)EMC.EID_FAIL_CARD_DELETE_PARAM_1, (Object)"Provision Error");
            }
        }
        return bl2;
    }

    private void resetPim(Component component, PimModel pimModel, eModuleOp eModuleOp2) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        String string = "Are you sure you want to hard-reset this PIM?";
        String string2 = "Hard-resetting PIM";
        EID eID = EMC.EID_HARD_RESET_CARD;
        if (CerentDialog.yesNoDialog((Component)frame, (String)string.toString(), (String)string2)) {
            try {
                pimModel.reset(eModuleOp2);
                if (this.db.on()) {
                    this.db.println("resetPim(): " + string2);
                }
            }
            catch (ProvisionError provisionError) {
                ErrorMsg.displayDetailed((Component)frame, eID, provisionError.toString());
            }
            catch (Exception exception) {
                ErrorMsg.displayDetailed((Component)frame, eID, exception.toString());
            }
        }
    }
}

