/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvChart;
import ilog.views.chart.data.IlvAbstractTableDataSource;
import ilog.views.chart.data.IlvDataSet;
import ilog.views.chart.data.IlvDataSource;
import ilog.views.chart.data.IlvDefaultDataSource;
import ilog.views.chart.data.IlvJDBCDataSource;
import ilog.views.chart.data.IlvSwingTableDataSource;
import ilog.views.chart.data.xml.IlvXMLDataReader;
import ilog.views.chart.data.xml.IlvXMLDataSource;
import ilog.views.chart.data.xml.IlvXMLDataWriter;
import ilog.views.chart.util.IlvChartUtil;
import ilog.views.util.collections.IlvCollections;
import ilog.views.util.css.Util;
import ilog.views.util.internal.IlvURLUtil;
import ilog.views.util.styling.IlvStylingException;
import ilog.views.util.xml.XMLUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class IlvChartConfiguration {
    private static Map a = new HashMap();
    private static String[] b = new String[0];
    private List c;
    private List d;

    public final synchronized Iterator getDataSourceIterator() {
        if (this.c == null) {
            return IlvCollections.emptyIterator();
        }
        return IlvCollections.unmodifiableIterator(new ArrayList(this.c).iterator());
    }

    public final synchronized int getDataSourceCount() {
        return this.c == null ? 0 : this.c.size();
    }

    public final synchronized IlvDataSource getDataSource(int n2) {
        if (this.c != null && n2 < this.c.size()) {
            return (IlvDataSource)this.c.get(n2);
        }
        return null;
    }

    public final synchronized void setStyleSheets(String[] stringArray) {
        this.a(null, stringArray);
    }

    public final synchronized String[] getStyleSheets() {
        return this.d == null ? b : this.d.toArray(new String[this.d.size()]);
    }

    public final synchronized void setDataSources(IlvDataSource[] ilvDataSourceArray) {
        this.a(ilvDataSourceArray, null);
    }

    private void a(IlvDataSource[] ilvDataSourceArray, String[] stringArray) {
        if (ilvDataSourceArray != null) {
            if (this.c == null) {
                this.c = new LinkedList();
            } else {
                this.c.clear();
            }
            this.c.addAll(Arrays.asList(ilvDataSourceArray));
        }
        if (stringArray != null) {
            if (this.d != null) {
                this.d.clear();
            } else {
                this.d = new LinkedList();
            }
            this.d.addAll(Arrays.asList(stringArray));
        }
    }

    public final synchronized void addDataSource(IlvDataSource ilvDataSource) {
        if (this.c == null) {
            this.c = new LinkedList();
        }
        this.c.add(ilvDataSource);
    }

    public final synchronized void addStyleSheet(String string) {
        if (this.d == null) {
            this.d = new LinkedList();
        }
        this.d.add(string);
    }

    public final void addStyleSheets(String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addStyleSheet(stringArray[i2]);
        }
    }

    public void apply(IlvChart ilvChart) throws IlvStylingException {
        this.applyDataSource(ilvChart);
        this.applyStyling(ilvChart);
    }

    public void applyDataSource(IlvChart ilvChart) {
        IlvDataSource ilvDataSource = this.getDataSource(0);
        if (ilvDataSource != null) {
            ilvChart.setDataSource(ilvDataSource);
        }
    }

    public void applyStyling(IlvChart ilvChart) throws IlvStylingException {
        String[] stringArray = this.getStyleSheets();
        if (stringArray.length > 0) {
            ilvChart.setStyleSheets(stringArray);
        }
    }

    public void read(URL uRL) throws IOException {
        try {
            ConfigSerializer configSerializer = new ConfigSerializer();
            configSerializer.read(uRL, this);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void write(URL uRL) throws IOException {
        try {
            ConfigSerializer configSerializer = new ConfigSerializer();
            configSerializer.write(uRL, this);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException(exception.getMessage());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public static void setDataSourceSerializer(Class clazz, IlvDataSourceXMLSerializer ilvDataSourceXMLSerializer) {
        if (!IlvDataSource.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Not an IlvDataSource implementation.");
        }
        a.put(clazz, ilvDataSourceXMLSerializer);
    }

    public static IlvDataSourceXMLSerializer getDataSourceSerializer(Class clazz) {
        IlvDataSourceXMLSerializer ilvDataSourceXMLSerializer;
        while ((ilvDataSourceXMLSerializer = (IlvDataSourceXMLSerializer)a.get(clazz)) == null) {
            if (clazz == Object.class) break;
            clazz = clazz.getSuperclass();
        }
        return ilvDataSourceXMLSerializer;
    }

    static {
        a.put(IlvXMLDataSource.class, new XMLDataSourceSerializer());
        a.put(IlvJDBCDataSource.class, new JDBCDataSourceSerializer());
        IlvDefaultDataSourceSerializer ilvDefaultDataSourceSerializer = new IlvDefaultDataSourceSerializer();
        a.put(IlvDefaultDataSource.class, ilvDefaultDataSourceSerializer);
        a.put(IlvSwingTableDataSource.class, ilvDefaultDataSourceSerializer);
    }

    private static class ConfigSerializer {
        private static final String a = "chartConfiguration";
        private static final String b = "dataSource";
        private static final String c = "style";
        private static final String d = "xlink:href";
        private static final String e = "type";
        private boolean f = false;
        private Document g;
        private URL h;
        private static Set i = new HashSet();

        public void read(URL uRL, IlvChartConfiguration ilvChartConfiguration) throws Exception {
            this.h = uRL;
            InputSource inputSource = new InputSource(uRL.toExternalForm());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(this.f);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            if (document == null) {
                throw new IllegalArgumentException("document cannot be null");
            }
            this.g = document;
            Element element = ConfigSerializer.a(this.g, a);
            if (element == null) {
                throw new IOException("<chartConfiguration/> element not found");
            }
            this.a(element, ilvChartConfiguration, uRL);
        }

        private void a(Element element, IlvChartConfiguration ilvChartConfiguration, URL uRL) throws Exception {
            this.a(ilvChartConfiguration, element, uRL);
            this.a(ilvChartConfiguration, element);
        }

        private void a(IlvChartConfiguration ilvChartConfiguration, Element element, URL uRL) throws Exception {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                if (node.getNodeType() != 1 || !c.equals(node.getNodeName()) || (string = ((Element)node).getAttribute(d)) == null) continue;
                arrayList.add(new URL(uRL, string).toExternalForm());
            }
            if (arrayList.size() != 0) {
                ilvChartConfiguration.setStyleSheets(arrayList.toArray(new String[arrayList.size()]));
            }
        }

        private void a(IlvChartConfiguration ilvChartConfiguration, Element element) throws Exception {
            Element element2 = ConfigSerializer.a(element, b);
            IlvDataSource[] ilvDataSourceArray = null;
            if (element2 != null) {
                ilvDataSourceArray = new IlvDataSource[1];
                String string = element2.getAttribute(e);
                Class<?> clazz = Class.forName(string);
                IlvDataSourceXMLSerializer ilvDataSourceXMLSerializer = IlvChartConfiguration.getDataSourceSerializer(clazz);
                if (ilvDataSourceXMLSerializer != null) {
                    ilvDataSourceArray[0] = ilvDataSourceXMLSerializer.createDataSource();
                    ilvChartConfiguration.setDataSources(ilvDataSourceArray);
                    ilvDataSourceXMLSerializer.read(element2, ilvDataSourceArray[0], this.h);
                }
            }
        }

        public void write(URL uRL, IlvChartConfiguration ilvChartConfiguration) throws IOException {
            this.h = uRL;
            try {
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                String string = ConfigSerializer.a(uRL.toExternalForm());
                URL uRL2 = new URL(string + ".css");
                this.a(document, IlvChartUtil.relativeURL(uRL, uRL2), ilvChartConfiguration);
                boolean bl = uRL.getProtocol().equals("file");
                OutputStream outputStream = bl ? new FileOutputStream(IlvURLUtil.convertFileURLToFilename(uRL)) : uRL.openConnection().getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                XMLUtil.WriteDocument(document, bufferedOutputStream, null, null, i);
                bufferedOutputStream.close();
                outputStream = bl ? new FileOutputStream(IlvURLUtil.convertFileURLToFilename(uRL2)) : uRL2.openConnection().getOutputStream();
                PrintWriter printWriter = Util.makeUTF8Writer(outputStream);
                this.a(printWriter, ilvChartConfiguration);
                printWriter.close();
                outputStream.close();
            }
            catch (Exception exception) {
                IOException iOException = new IOException(exception.getMessage());
                iOException.initCause(exception);
                throw iOException;
            }
        }

        private void a(Document document, String string, IlvChartConfiguration ilvChartConfiguration) throws Exception {
            if (document == null) {
                throw new IllegalArgumentException("Document cannot be null.");
            }
            this.g = document;
            Element element = document.createElement(a);
            element.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            document.appendChild(element);
            this.a(element, string, ilvChartConfiguration);
            this.a(element, ilvChartConfiguration);
        }

        private void a(Element element, IlvChartConfiguration ilvChartConfiguration) throws Exception {
            Iterator iterator = ilvChartConfiguration.getDataSourceIterator();
            while (iterator.hasNext()) {
                IlvDataSource ilvDataSource = (IlvDataSource)iterator.next();
                IlvDataSourceXMLSerializer ilvDataSourceXMLSerializer = IlvChartConfiguration.getDataSourceSerializer(ilvDataSource.getClass());
                if (ilvDataSourceXMLSerializer == null) continue;
                Element element2 = this.g.createElement(b);
                element2.setAttribute(e, ilvDataSource.getClass().getName());
                element.appendChild(element2);
                ilvDataSourceXMLSerializer.write(element2, ilvDataSource, this.h);
            }
        }

        private void a(Element element, String string, IlvChartConfiguration ilvChartConfiguration) throws Exception {
            Element element2 = this.g.createElement(c);
            element2.setAttribute(d, string);
            element.appendChild(element2);
        }

        private void a(PrintWriter printWriter, IlvChartConfiguration ilvChartConfiguration) throws IOException {
            String[] stringArray = ilvChartConfiguration.getStyleSheets();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                printWriter.println(stringArray[i2]);
            }
        }

        static Element a(Node node, String string) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                return (Element)node2;
            }
            return null;
        }

        private static String a(String string) {
            int n2 = string.lastIndexOf(46);
            if (n2 >= 0) {
                return string.substring(0, n2);
            }
            return string;
        }

        public static String relativeURL(URL uRL, URL uRL2) {
            String string;
            String string2 = ConfigSerializer.b(uRL);
            int n2 = string2.lastIndexOf(47);
            if (n2 > 0) {
                string2 = string2.substring(0, n2 + 1);
            }
            if ((string = ConfigSerializer.b(uRL2)).startsWith(string2)) {
                String string3 = string.substring(string2.length());
                if (string3.length() > 0 && string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
                return string3;
            }
            return string;
        }

        private static String b(URL uRL) {
            if (uRL.getProtocol().equals("file")) {
                File file = IlvURLUtil.convertFileURLToFile(uRL).getAbsoluteFile();
                try {
                    return file.toURL().toExternalForm();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return uRL.toExternalForm();
        }

        static {
            i.add("labels");
            i.add("label");
        }
    }

    public static interface IlvDataSourceXMLSerializer {
        public IlvDataSource createDataSource();

        public void write(Element var1, IlvDataSource var2, URL var3) throws Exception;

        public IlvDataSource read(Element var1, IlvDataSource var2, URL var3) throws Exception;
    }

    private static class IlvDefaultDataSourceSerializer
    implements IlvDataSourceXMLSerializer {
        private IlvDefaultDataSourceSerializer() {
        }

        public void write(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            IlvDataSet[] ilvDataSetArray = ilvDataSource.getDataSets();
            IlvXMLDataWriter ilvXMLDataWriter = new IlvXMLDataWriter(Locale.getDefault());
            Element element2 = element.getOwnerDocument().createElement("model");
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            ilvXMLDataWriter.write(document, ilvDataSetArray);
            for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !node.getNodeName().equals("chartData")) continue;
                element2.appendChild(element2.getOwnerDocument().importNode(node, true));
                break;
            }
            element.appendChild(element2);
        }

        public IlvDataSource read(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            IlvXMLDataReader ilvXMLDataReader = new IlvXMLDataReader();
            boolean bl = false;
            block0: for (Node node = element.getFirstChild(); node != null && !bl; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || !"model".equals(node.getNodeName())) continue;
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeType() != 1 || !"chartData".equals(node2.getNodeName())) continue;
                    DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    Document document = documentBuilder.newDocument();
                    node2 = document.importNode(node2, true);
                    document.appendChild(node2);
                    IlvDataSet[] ilvDataSetArray = ilvXMLDataReader.read(document);
                    ((IlvDefaultDataSource)ilvDataSource).setDataSets(ilvDataSetArray);
                    bl = true;
                    continue block0;
                }
            }
            return ilvDataSource;
        }

        public IlvDataSource createDataSource() {
            return new IlvDefaultDataSource();
        }
    }

    private static class JDBCDataSourceSerializer
    implements IlvDataSourceXMLSerializer {
        private static final String a = "connection";
        private static final String b = "param";
        private static final String c = "mapping";
        private static final String d = "xSeries";
        private static final String e = "labels";
        private static final String f = "ySeries";

        private JDBCDataSourceSerializer() {
        }

        public void write(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            if (!(ilvDataSource instanceof IlvJDBCDataSource)) {
                throw new IllegalArgumentException("Must be an instance of IlvJDBCDataSource.");
            }
            String string = ((IlvJDBCDataSource)ilvDataSource).getConnectionParams();
            Element element2 = element.getOwnerDocument().createElement(a);
            element2.setAttribute(b, string);
            element.appendChild(element2);
            IlvAbstractTableDataSource.Mapping[] mappingArray = ((IlvJDBCDataSource)ilvDataSource).getMapping();
            if (mappingArray != null) {
                for (int i2 = 0; i2 < mappingArray.length; ++i2) {
                    String string2;
                    Element element3 = element.getOwnerDocument().createElement(c);
                    String string3 = mappingArray[i2].getXColumn();
                    if (string3 != null) {
                        element3.setAttribute(d, string3);
                    }
                    if ((string2 = mappingArray[i2].getLabelsColumn()) != null) {
                        element3.setAttribute(e, string2);
                    }
                    String[] stringArray = mappingArray[i2].getYColumns();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i3 = 0; i3 < stringArray.length; ++i3) {
                        stringBuffer.append(stringArray[i3]);
                        if (i3 >= stringArray.length - 1) continue;
                        stringBuffer.append(',');
                    }
                    element3.setAttribute(f, stringBuffer.toString());
                    element.appendChild(element3);
                }
            }
        }

        public IlvDataSource read(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            ArrayList<IlvAbstractTableDataSource.Mapping> arrayList = null;
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                String string2;
                CharSequence charSequence;
                if (node.getNodeType() != 1) continue;
                if (a.equals(node.getNodeName())) {
                    charSequence = new StringBuffer(((Element)node).getAttribute(b));
                    ((IlvJDBCDataSource)ilvDataSource).setConnectionParams(((StringBuffer)charSequence).toString());
                    continue;
                }
                if (!c.equals(node.getNodeName())) continue;
                charSequence = ((Element)node).getAttribute(d);
                if (((String)charSequence).length() == 0) {
                    charSequence = null;
                }
                if ((string2 = ((Element)node).getAttribute(e)).length() == 0) {
                    string2 = null;
                }
                if ((string = ((Element)node).getAttribute(f)).length() == 0) {
                    throw new IOException("Invalid configuration: a mapping must have one or more y-series.");
                }
                if (string.indexOf(44) == -1) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<IlvAbstractTableDataSource.Mapping>();
                    }
                    arrayList.add(new IlvAbstractTableDataSource.Mapping((String)charSequence, string2, new String[]{string}));
                    continue;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2++] = stringTokenizer.nextToken();
                }
                arrayList.add(new IlvAbstractTableDataSource.Mapping((String)charSequence, string2, stringArray));
            }
            if (arrayList != null && ilvDataSource != null) {
                ((IlvJDBCDataSource)ilvDataSource).setMapping(arrayList.toArray(new IlvAbstractTableDataSource.Mapping[arrayList.size()]));
            }
            return ilvDataSource;
        }

        public IlvDataSource createDataSource() {
            return new IlvJDBCDataSource();
        }
    }

    private static class XMLDataSourceSerializer
    implements IlvDataSourceXMLSerializer {
        private static final String a = "file";
        private static final String b = "location";
        private IlvXMLDataReader c;

        private XMLDataSourceSerializer() {
        }

        public void write(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            if (!(ilvDataSource instanceof IlvXMLDataSource)) {
                throw new IllegalArgumentException("Must be an instance of IlvXMLDataSource.");
            }
            String string = ((IlvXMLDataSource)ilvDataSource).getFilename();
            string = ConfigSerializer.relativeURL(uRL, new URL(string));
            Element element2 = element.getOwnerDocument().createElement(a);
            element2.setAttribute(b, string);
            element.appendChild(element2);
        }

        public IlvXMLDataReader getDataReader() {
            if (this.c == null) {
                this.c = new IlvXMLDataReader();
            }
            return this.c;
        }

        public IlvDataSource read(Element element, IlvDataSource ilvDataSource, URL uRL) throws Exception {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || "chartData".equals(node.getNodeName()) || !a.equals(node.getNodeName())) continue;
                String string = ((Element)node).getAttribute(b);
                if (string != null) {
                    URL uRL2 = new URL(uRL, string);
                    string = ConfigSerializer.b(uRL2);
                }
                ((IlvXMLDataSource)ilvDataSource).setFilename(string);
                ((IlvXMLDataSource)ilvDataSource).load(new InputSource(string), this.getDataReader());
                break;
            }
            return ilvDataSource;
        }

        public IlvDataSource createDataSource() {
            return new IlvXMLDataSource();
        }
    }
}

