/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChart3DSupport;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDoublePoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.event.ChartInteractionEvent;
import ilog.views.chart.event.ChartInteractionListener;
import ilog.views.chart.event.IlvListenerList;
import ilog.views.chart.internal.IlvChartInteractorManager;
import ilog.views.util.swing.IlvEventUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class IlvChartInteractor
implements IlvChart3DSupport,
Serializable {
    private static HashMap a = new HashMap();
    public static final int INTERNAL_HIGH = 1000;
    public static final int NORMAL = 0;
    public static final int INTERNAL_LOW = -1000;
    private IlvListenerList b;
    private IlvChart c = null;
    private int d = 0;
    private long e;
    private transient boolean f = false;
    private transient boolean g = false;
    private int h;
    private int i;
    private int j;
    private boolean k = true;
    private Color l = Color.white;
    private Color m = Color.black;
    private boolean n = false;
    private boolean o = false;

    protected static synchronized void register(String string, Class clazz) {
        a.put(string, clazz);
    }

    public static synchronized Class getInteractorClassByName(String string) {
        return (Class)a.get(string);
    }

    public static synchronized String getShortName(Class clazz) {
        String string = null;
        Set set = a.entrySet();
        for (Map.Entry entry : set) {
            if (clazz != (Class)entry.getValue()) continue;
            string = (String)entry.getKey();
            break;
        }
        return string;
    }

    public static IlvChartInteractor create(String string) {
        IlvChartInteractor ilvChartInteractor = null;
        try {
            ilvChartInteractor = IlvChartInteractor.create(string, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ilvChartInteractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IlvChartInteractor create(String string, boolean bl) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object object = IlvChartInteractor.class;
        synchronized (IlvChartInteractor.class) {
            Class<?> clazz = (Class<?>)a.get(string);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (clazz == null) {
                try {
                    clazz = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        throw classNotFoundException;
                    }
                    classNotFoundException.printStackTrace();
                }
            }
            object = null;
            if (clazz != null) {
                try {
                    object = (IlvChartInteractor)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                    if (bl) {
                        throw instantiationException;
                    }
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (bl) {
                        throw illegalAccessException;
                    }
                    illegalAccessException.printStackTrace();
                }
            }
            return object;
        }
    }

    public static synchronized String[] getRegisteredInteractorsByName() {
        String[] stringArray = new String[a.size()];
        a.keySet().toArray(stringArray);
        return stringArray;
    }

    public static String getLocalizedName(Class clazz, Locale locale) {
        Object object;
        Method method;
        try {
            method = clazz.getMethod("getLocalizedName", Locale.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            method = null;
        }
        catch (SecurityException securityException) {
            method = null;
        }
        if (method != null && Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers()) && method.getDeclaringClass() == clazz) {
            object = null;
            try {
                object = method.invoke(null, locale);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            if (object instanceof String) {
                return object;
            }
        }
        if ((object = IlvChartInteractor.getShortName(clazz)) != null) {
            return object;
        }
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        return string;
    }

    public IlvChartInteractor() {
        this(0, 0);
    }

    public IlvChartInteractor(int n2, int n3) {
        this.h = n2;
        this.i = n3;
        this.j = IlvEventUtil.convertModifiersMask(this.i);
    }

    public final int getPriority() {
        return this.d;
    }

    public void setPriority(int n2) {
        this.d = n2;
    }

    public final IlvAxis getXAxis() {
        return this.c.getXAxis();
    }

    public final IlvAxis getYAxis() {
        return this.c.getYAxis(this.h);
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        return this.c.getCoordinateSystem(this.h);
    }

    public final IlvChart getChart() {
        return this.c;
    }

    public final void setChart(IlvChart ilvChart) {
        IlvChart ilvChart2 = this.c;
        if (ilvChart != ilvChart2) {
            this.c = ilvChart;
            this.chartConnected(ilvChart2, ilvChart);
        }
    }

    protected void chartConnected(IlvChart ilvChart, IlvChart ilvChart2) {
    }

    public final long getAWTEventMask() {
        return this.e;
    }

    protected final void enableEvents(long l2) {
        this.e |= l2;
    }

    protected final void disableEvents(long l2) {
        this.e &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final boolean isAborted() {
        return this.f;
    }

    protected void setAborted(boolean bl) {
        this.f = bl;
    }

    public final boolean isInOperation() {
        return this.g;
    }

    protected void setInOperation(boolean bl) {
        this.g = bl;
    }

    public final int getYAxisIndex() {
        return this.h;
    }

    public void setYAxisIndex(int n2) {
        this.h = n2;
    }

    public final int getEventMask() {
        return this.i;
    }

    public final int getEventMaskEx() {
        return this.j;
    }

    public void setEventMask(int n2) {
        this.i = n2;
        this.j = IlvEventUtil.convertModifiersMask(this.i);
    }

    public boolean isConsumeEvents() {
        return this.k;
    }

    public void setConsumeEvents(boolean bl) {
        this.k = bl;
    }

    public Color getGhostColor() {
        return this.m;
    }

    public void setGhostColor(Color color) {
        this.m = color;
    }

    public final Color getXORColor() {
        return this.l;
    }

    public void setXORColor(Color color) {
        this.l = color;
    }

    protected final boolean isAllowDrawGhost() {
        return this.n;
    }

    protected void setAllowDrawGhost(boolean bl) {
        this.n = bl;
    }

    public final boolean isXORGhost() {
        return this.o;
    }

    public void setXORGhost(boolean bl) {
        this.o = bl;
    }

    protected Rectangle getGhostBounds() {
        return null;
    }

    public boolean isHandling(int n2, int n3) {
        if (this.getChart().is3D()) {
            return this.getChart().getChartArea().getDrawRect().contains(n2, n3);
        }
        return this.getChart().getProjector().getShape(this.getCoordinateSystem().getVisibleWindow(), this.getChart().getProjectorRect(), this.getCoordinateSystem()).contains(n2, n3);
    }

    public final IlvDoublePoint getData(MouseEvent mouseEvent) {
        return this.getData(mouseEvent.getX(), mouseEvent.getY());
    }

    public final IlvDoublePoint getData(int n2, int n3) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n2, n3);
        this.getChart().toData(ilvDoublePoints, this.getYAxisIndex());
        IlvDoublePoint ilvDoublePoint = new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
        ilvDoublePoints.dispose();
        return ilvDoublePoint;
    }

    public final IlvDoublePoint toDisplay(IlvDoublePoint ilvDoublePoint) {
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(ilvDoublePoint.x, ilvDoublePoint.y);
        this.getChart().toDisplay(ilvDoublePoints, this.getYAxisIndex());
        IlvDoublePoint ilvDoublePoint2 = new IlvDoublePoint(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0));
        ilvDoublePoints.dispose();
        return ilvDoublePoint2;
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public void handleExpose(Graphics graphics) {
        if (this.getChart() == null) {
            return;
        }
        if (this.n) {
            Graphics graphics2 = graphics.create();
            this.initGhostGraphics(graphics2);
            Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
            graphics2.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.drawGhost(graphics2);
            graphics2.dispose();
        }
    }

    protected final void drawGhost() {
        if (this.getChart() == null || !this.n) {
            return;
        }
        Rectangle rectangle = this.getGhostBounds();
        if (rectangle != null) {
            rectangle.grow(1, 1);
            if (!this.isXORGhost()) {
                this.getChart().getChartArea().repaint(rectangle);
            } else {
                Graphics graphics = this.getChart().getChartArea().getGraphics();
                if (graphics != null) {
                    this.initGhostGraphics(graphics);
                    graphics.setClip(rectangle);
                    this.drawGhost(graphics);
                    graphics.dispose();
                }
            }
        }
    }

    protected void drawGhost(Graphics graphics) {
    }

    protected void initGhostGraphics(Graphics graphics) {
        if (this.isXORGhost()) {
            graphics.setXORMode(this.getXORColor());
            graphics.setColor(this.getGhostColor());
        }
    }

    public void interactionStarted(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
    }

    protected void startOperation(MouseEvent mouseEvent) {
        this.setAborted(false);
        this.g = true;
        this.getChart().n().interactionStarted(this, mouseEvent);
    }

    protected void endOperation(MouseEvent mouseEvent) {
        this.setAborted(false);
        this.g = false;
    }

    protected void abort() {
        this.setAborted(true);
        this.g = false;
    }

    protected Cursor setCursor(Cursor cursor) {
        Cursor cursor2 = cursor != null ? IlvChartInteractorManager.pushCursor(this.c, cursor) : IlvChartInteractorManager.popCursor(this.c);
        return cursor2;
    }

    public final void addChartInteractionListener(ChartInteractionListener chartInteractionListener) {
        if (this.b == null) {
            this.b = new IlvListenerList();
        }
        this.b.add(chartInteractionListener);
    }

    public final void removeChartInteractionListener(ChartInteractionListener chartInteractionListener) {
        if (this.b == null) {
            return;
        }
        this.b.remove(chartInteractionListener);
        if (this.b.getListenerList().length == 0) {
            this.b = null;
        }
    }

    protected final void fireChartInteractionEvent(ChartInteractionEvent chartInteractionEvent) {
        if (this.b == null) {
            return;
        }
        Object[] objectArray = this.b.getListenerList();
        int n2 = objectArray.length;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ((ChartInteractionListener)objectArray[i2]).interactionPerformed(chartInteractionEvent);
        }
    }

    public boolean has3DSupport() {
        return true;
    }
}

