/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart;

import ilog.views.chart.IlvAxis;
import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartDrawable;
import ilog.views.chart.IlvChartProjector;
import ilog.views.chart.IlvCoordinateSystem;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.IlvScale;
import ilog.views.chart.IlvStyle;
import ilog.views.chart.util.IlvDoubleArray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class IlvGrid
implements IlvChartDrawable,
Serializable {
    private static final Shape[] a = new Shape[0];
    private static Color b = Color.lightGray;
    private IlvChart.AxisElement c;
    private boolean d = true;
    private boolean e = true;
    private IlvStyle f;
    private IlvStyle g;
    private int h = -1;
    private static final boolean i = true;

    public IlvGrid() {
        this(b);
    }

    public IlvGrid(Paint paint) {
        this(paint, paint);
        this.setMinorLineVisible(false);
    }

    public IlvGrid(Paint paint, Paint paint2) {
        this.setMajorPaint(paint);
        this.setMinorPaint(paint2);
    }

    public final int getDrawOrder() {
        return this.h;
    }

    public void setDrawOrder(int n2) {
        if (this.h == n2) {
            return;
        }
        int n3 = this.h;
        this.h = n2;
        if (this.getChart() != null) {
            this.getChart().a(this, n3, n2);
            this.getChart().getChartArea().repaint2D(this.getBounds(null));
        }
    }

    public boolean isVisible() {
        return this.e || this.d;
    }

    public final void setVisible(boolean bl) {
        this.d = this.e = bl;
    }

    public final boolean isMajorLineVisible() {
        return this.d;
    }

    public void setMajorLineVisible(boolean bl) {
        this.d = bl;
    }

    public final boolean isMinorLineVisible() {
        return this.e;
    }

    public void setMinorLineVisible(boolean bl) {
        this.e = bl;
    }

    public final IlvStyle getMajorStyle() {
        if (this.f == null) {
            this.f = IlvStyle.createStroked(Color.black);
        }
        return this.f;
    }

    public final Stroke getMajorStroke() {
        return this.getMajorStyle().getStroke();
    }

    public void setMajorStroke(Stroke stroke) {
        this.f = this.getMajorStyle().setStroke(stroke);
    }

    public final Paint getMajorPaint() {
        return this.getMajorStyle().getStrokePaint();
    }

    public void setMajorPaint(Paint paint) {
        this.f = this.getMajorStyle().setStrokePaint(paint);
    }

    public final IlvStyle getMinorStyle() {
        if (this.g == null) {
            this.g = IlvStyle.createStroked(Color.black);
        }
        return this.g;
    }

    public final Stroke getMinorStroke() {
        return this.getMinorStyle().getStroke();
    }

    public void setMinorStroke(Stroke stroke) {
        this.g = this.getMinorStyle().setStroke(stroke);
    }

    public final Paint getMinorPaint() {
        return this.getMinorStyle().getStrokePaint();
    }

    public void setMinorPaint(Paint paint) {
        this.g = this.getMinorStyle().setStrokePaint(paint);
    }

    public final IlvChart getChart() {
        return this.c == null ? null : this.c.f();
    }

    public final IlvAxis getAxis() {
        return this.c == null ? null : this.c.c();
    }

    public final IlvCoordinateSystem getCoordinateSystem() {
        return this.c == null ? null : this.c.g();
    }

    void a(IlvChart.AxisElement axisElement) {
        this.c = axisElement;
    }

    public boolean has3DSupport() {
        return this.getChart() != null && this.getChart().getType() == 1;
    }

    public void draw(Graphics graphics) {
        IlvDoubleArray ilvDoubleArray;
        if (this.getChart() == null) {
            return;
        }
        IlvScale ilvScale = this.c.d();
        if (ilvScale == null) {
            return;
        }
        if (this.isMajorLineVisible() && (ilvDoubleArray = ilvScale.getStepValues()).size() > 0) {
            this.draw(graphics, ilvDoubleArray, true);
        }
        if (this.isMinorLineVisible() && (ilvDoubleArray = ilvScale.getSubStepValues()).size() > 0) {
            this.draw(graphics, ilvDoubleArray, false);
        }
    }

    protected void draw(Graphics graphics, IlvDoubleArray ilvDoubleArray, boolean bl) {
        if (this.getChart().is3D()) {
            this.a(graphics, ilvDoubleArray, bl);
        } else {
            switch (this.getChart().getType()) {
                case 1: {
                    this.b(graphics, ilvDoubleArray, bl);
                    break;
                }
                case 4: {
                    if (this.b()) {
                        this.b(graphics, ilvDoubleArray, bl);
                        break;
                    }
                    this.c(graphics, ilvDoubleArray, bl);
                    break;
                }
                default: {
                    this.d(graphics, ilvDoubleArray, bl);
                }
            }
        }
    }

    public Rectangle2D getBounds(Rectangle2D rectangle2D) {
        if (this.getChart() == null) {
            if (rectangle2D == null) {
                rectangle2D = new Rectangle();
            } else {
                rectangle2D.setRect(0.0, 0.0, 0.0, 0.0);
            }
        } else if (rectangle2D == null) {
            rectangle2D = (Rectangle)this.getChart().getChartArea().getPlotRect().clone();
        } else {
            rectangle2D.setRect(this.getChart().getChartArea().getPlotRect());
        }
        return rectangle2D;
    }

    private void a(Graphics graphics, IlvDoubleArray ilvDoubleArray, boolean bl) {
        IlvStyle ilvStyle = bl ? this.getMajorStyle() : this.getMinorStyle();
        this.getChart().get3DView().d().drawGridlines(graphics, this.getAxis(), ilvDoubleArray, ilvStyle);
    }

    private IlvDoublePoints a(IlvDoubleArray ilvDoubleArray) {
        Serializable serializable;
        int n2;
        IlvChart ilvChart = this.getChart();
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        int n3 = 0;
        int n4 = ilvDoubleArray.size();
        if (ilvChart.getType() == 1 && ilvChart.getChartArea().getPlotStyle() != null && ilvChart.getChartArea().getPlotStyle().isStrokeOn()) {
            n2 = 0;
            Serializable serializable2 = serializable = this.b() ? ilvCoordinateSystem.getXAxis() : ilvCoordinateSystem.getYAxis();
            if (ilvDoubleArray.get(0) == ((IlvAxis)serializable).getVisibleMin()) {
                ++n3;
                ++n2;
            }
            if (ilvDoubleArray.get(n4 - 1) == ((IlvAxis)serializable).getVisibleMax()) {
                ++n2;
            }
            n4 -= n2;
        }
        n2 = n4 << 1;
        serializable = new IlvDoublePoints(n2);
        if (this.b()) {
            int n5;
            System.arraycopy(ilvDoubleArray.data(), n3, ((IlvDoublePoints)serializable).getXValues(), 0, n4);
            System.arraycopy(ilvDoubleArray.data(), n3, ((IlvDoublePoints)serializable).getXValues(), n4, n4);
            double[] dArray = ((IlvDoublePoints)serializable).getYValues();
            double d2 = ilvCoordinateSystem.getYAxis().getVisibleMin();
            for (n5 = 0; n5 < n4; ++n5) {
                dArray[n5] = d2;
            }
            d2 = ilvCoordinateSystem.getYAxis().getVisibleMax();
            while (n5 < n2) {
                dArray[n5] = d2;
                ++n5;
            }
        } else {
            int n6;
            System.arraycopy(ilvDoubleArray.data(), n3, ((IlvDoublePoints)serializable).getYValues(), 0, n4);
            System.arraycopy(ilvDoubleArray.data(), n3, ((IlvDoublePoints)serializable).getYValues(), n4, n4);
            double[] dArray = ((IlvDoublePoints)serializable).getXValues();
            double d3 = ilvCoordinateSystem.getXAxis().getVisibleMin();
            for (n6 = 0; n6 < n4; ++n6) {
                dArray[n6] = d3;
            }
            d3 = ilvCoordinateSystem.getXAxis().getVisibleMax();
            while (n6 < n2) {
                dArray[n6] = d3;
                ++n6;
            }
        }
        ((IlvDoublePoints)serializable).setSize(n2);
        this.getChart().toDisplay((IlvDoublePoints)serializable, this.a());
        return serializable;
    }

    public final Shape[] getGridShapes(IlvDoubleArray ilvDoubleArray) {
        switch (this.getChart().getType()) {
            case 1: {
                return this.b(ilvDoubleArray);
            }
            case 4: {
                if (this.b()) {
                    return this.b(ilvDoubleArray);
                }
                return this.c(ilvDoubleArray);
            }
        }
        return this.d(ilvDoubleArray);
    }

    private Shape[] b(IlvDoubleArray ilvDoubleArray) {
        IlvDoublePoints ilvDoublePoints = this.a(ilvDoubleArray);
        double[] dArray = ilvDoublePoints.getXValues();
        double[] dArray2 = ilvDoublePoints.getYValues();
        int n2 = ilvDoublePoints.size() >> 1;
        Shape[] shapeArray = new Shape[n2];
        int n3 = 0;
        int n4 = n2;
        while (n3 < shapeArray.length) {
            shapeArray[n3] = new Line2D.Double(dArray[n3], dArray2[n3], dArray[n4], dArray2[n4]);
            ++n3;
            ++n4;
        }
        ilvDoublePoints.dispose();
        return shapeArray;
    }

    private Shape[] c(IlvDoubleArray ilvDoubleArray) {
        IlvScale ilvScale = this.getChart().getXScale();
        if (ilvScale == null) {
            return a;
        }
        int n2 = ilvDoubleArray.size();
        double[] dArray = ilvDoubleArray.data();
        int n3 = ilvScale.getStepValues().size();
        double[] dArray2 = ilvScale.getStepValues().data();
        Shape[] shapeArray = new Shape[n2];
        IlvDoublePoints ilvDoublePoints = new IlvDoublePoints(n3 + 1);
        ilvDoublePoints.setSize(n3 + 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            System.arraycopy(dArray2, 0, ilvDoublePoints.getXValues(), 0, n3);
            ilvDoublePoints.setX(n3, dArray2[0]);
            for (int i3 = 0; i3 <= n3; ++i3) {
                ilvDoublePoints.setY(i3, dArray[i2]);
            }
            this.getChart().toDisplay(ilvDoublePoints, this.a());
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)ilvDoublePoints.getX(0), (float)ilvDoublePoints.getY(0));
            for (int i4 = 1; i4 < ilvDoublePoints.size(); ++i4) {
                generalPath.lineTo((float)ilvDoublePoints.getX(i4), (float)ilvDoublePoints.getY(i4));
            }
            generalPath.closePath();
            shapeArray[i2] = generalPath;
        }
        ilvDoublePoints.dispose();
        return shapeArray;
    }

    private Shape[] d(IlvDoubleArray ilvDoubleArray) {
        IlvChartProjector ilvChartProjector = this.getChart().getProjector();
        IlvCoordinateSystem ilvCoordinateSystem = this.getCoordinateSystem();
        Rectangle rectangle = this.getChart().getChartArea().getPlotRect();
        int n2 = ilvDoubleArray.size();
        Shape[] shapeArray = new Shape[n2];
        int n3 = this.getAxis().getType();
        for (int i2 = 0; i2 < n2; ++i2) {
            shapeArray[i2] = ilvChartProjector.getShape(ilvDoubleArray.get(i2), n3, rectangle, ilvCoordinateSystem);
        }
        return shapeArray;
    }

    private void b(Graphics graphics, IlvDoubleArray ilvDoubleArray, boolean bl) {
        Shape[] shapeArray = this.b(ilvDoubleArray);
        for (int i2 = 0; i2 < shapeArray.length; ++i2) {
            this.drawGridLine(graphics, shapeArray[i2], bl);
        }
    }

    private void c(Graphics graphics, IlvDoubleArray ilvDoubleArray, boolean bl) {
        Shape[] shapeArray = this.c(ilvDoubleArray);
        int n2 = shapeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.drawGridLine(graphics, shapeArray[i2], bl);
        }
    }

    private void d(Graphics graphics, IlvDoubleArray ilvDoubleArray, boolean bl) {
        Shape[] shapeArray = this.getGridShapes(ilvDoubleArray);
        int n2 = shapeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.drawGridLine(graphics, shapeArray[i2], bl);
        }
    }

    protected void drawGridLine(Graphics graphics, Shape shape, boolean bl) {
        IlvStyle ilvStyle = bl ? this.getMajorStyle() : this.getMinorStyle();
        switch (this.getChart().getType()) {
            case 1: {
                Line2D.Double double_ = (Line2D.Double)shape;
                ilvStyle.drawLine(graphics, double_.x1, double_.y1, double_.x2, double_.y2);
                break;
            }
            default: {
                ilvStyle.draw(graphics, shape);
            }
        }
    }

    private final int a() {
        return this.b() ? 0 : this.c.b();
    }

    private final boolean b() {
        return this.getAxis().isXAxis();
    }

    public static void setDefaultGridColor(Color color) {
        b = color;
    }

    public static Color getDefaultGridColor() {
        return b;
    }

    public static int getAxisIndex(IlvGrid ilvGrid) {
        if (ilvGrid.c == null) {
            throw new IllegalArgumentException("grid not connected to a chart.");
        }
        return ilvGrid.c.b();
    }
}

