/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.internal;

import ilog.views.chart.IlvChart;
import ilog.views.chart.IlvChartInteractor;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public final class IlvChartInteractorManager
implements Serializable {
    private static final String a = "__Ilv_Cursors_Repository";
    private static final IlvChartInteractor[] b = new IlvChartInteractor[0];
    private ArrayList c = new ArrayList(5);
    private ArrayList d = new ArrayList(1);
    private final IlvChart e;
    private transient IlvChartInteractor f = null;
    private int g;
    private int h;
    private int i;
    private transient InputEventDispatcher j;
    private transient InputEventDispatcher k;
    private transient InputEventDispatcher l;
    private static Comparator m = new InteractorComparator();

    public IlvChartInteractorManager(IlvChart ilvChart) {
        this.e = ilvChart;
        this.a();
    }

    private void a() {
        this.j = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                if (ilvChartInteractor.isHandling(mouseEvent.getX(), mouseEvent.getY()) || ilvChartInteractor.isInOperation()) {
                    ilvChartInteractor.processMouseEvent(mouseEvent);
                }
            }
        };
        this.k = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                MouseEvent mouseEvent = (MouseEvent)inputEvent;
                if (ilvChartInteractor.isHandling(mouseEvent.getX(), mouseEvent.getY()) || ilvChartInteractor.isInOperation()) {
                    ilvChartInteractor.processMouseMotionEvent(mouseEvent);
                }
            }
        };
        this.l = new InputEventDispatcher(){

            public void dispatch(InputEvent inputEvent, IlvChartInteractor ilvChartInteractor) {
                ilvChartInteractor.processKeyEvent((KeyEvent)inputEvent);
            }
        };
    }

    public final IlvChart getChart() {
        return this.e;
    }

    public final synchronized int getCardinal() {
        return this.c.size();
    }

    private boolean a(IlvChartInteractor ilvChartInteractor) {
        int n2 = ilvChartInteractor.getPriority();
        return n2 == 1000 || n2 == -1000;
    }

    public synchronized void addInteractor(IlvChartInteractor ilvChartInteractor) throws IllegalArgumentException {
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException();
        }
        if (ilvChartInteractor.getChart() != this.e) {
            if (ilvChartInteractor.getChart() != null) {
                throw new IllegalArgumentException("Interactor already connected to another chart");
            }
            ArrayList arrayList = this.a(ilvChartInteractor) ? this.d : this.c;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Object e2 = arrayList.get(i2);
                if (e2 != ilvChartInteractor) continue;
                throw new IllegalArgumentException(ilvChartInteractor + " has already been added");
            }
            arrayList.add(ilvChartInteractor);
            ilvChartInteractor.setChart(this.e);
            this.a(ilvChartInteractor.getAWTEventMask(), 1);
        }
    }

    public void addInteractor(String string) throws IllegalArgumentException {
        IlvChartInteractor ilvChartInteractor = IlvChartInteractor.create(string);
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException(string + " cannot be found");
        }
        this.addInteractor(ilvChartInteractor);
    }

    public synchronized boolean removeInteractor(IlvChartInteractor ilvChartInteractor) throws IllegalArgumentException {
        ArrayList arrayList;
        if (ilvChartInteractor == null) {
            throw new IllegalArgumentException();
        }
        ArrayList arrayList2 = arrayList = this.a(ilvChartInteractor) ? this.d : this.c;
        if (arrayList.size() == 0) {
            return false;
        }
        ilvChartInteractor.setChart(null);
        this.a(ilvChartInteractor.getAWTEventMask(), -1);
        return arrayList.remove(ilvChartInteractor);
    }

    public synchronized void removeAllInteractors() {
        while (this.c.size() > 0) {
            IlvChartInteractor ilvChartInteractor = (IlvChartInteractor)this.c.get(this.c.size() - 1);
            ilvChartInteractor.setChart(null);
            this.a(ilvChartInteractor.getAWTEventMask(), -1);
            this.c.remove(this.c.size() - 1);
        }
    }

    public synchronized IlvChartInteractor[] getInteractors() {
        IlvChartInteractor[] ilvChartInteractorArray = new IlvChartInteractor[this.c.size()];
        this.c.toArray(ilvChartInteractorArray);
        return ilvChartInteractorArray;
    }

    public synchronized boolean setInteractors(IlvChartInteractor[] ilvChartInteractorArray) {
        int n2;
        int n3 = ilvChartInteractorArray.length;
        boolean bl = n3 == this.c.size();
        for (n2 = 0; bl && n2 < n3; ++n2) {
            bl = this.c.get(n2) == ilvChartInteractorArray[n2];
        }
        if (!bl) {
            this.removeAllInteractors();
            for (n2 = 0; n2 < n3; ++n2) {
                this.addInteractor(ilvChartInteractorArray[n2]);
            }
            return true;
        }
        return false;
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.i != 0) {
            this.a(mouseEvent, this.k);
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.h != 0) {
            this.a(mouseEvent, this.j);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.g != 0) {
            this.a(keyEvent, this.l);
        }
    }

    public void handleExpose(Graphics graphics) {
        if (this.f != null) {
            this.f.handleExpose(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interactionStarted(IlvChartInteractor ilvChartInteractor, MouseEvent mouseEvent) {
        IlvChartInteractor[] ilvChartInteractorArray;
        IlvChartInteractorManager ilvChartInteractorManager = this;
        synchronized (ilvChartInteractorManager) {
            ilvChartInteractorArray = this.c.toArray(b);
        }
        for (int i2 = 0; i2 < ilvChartInteractorArray.length; ++i2) {
            IlvChartInteractor ilvChartInteractor2 = ilvChartInteractorArray[i2];
            if (ilvChartInteractor2 == ilvChartInteractor) continue;
            ilvChartInteractor2.interactionStarted(ilvChartInteractor, mouseEvent);
        }
    }

    private void a(InputEvent inputEvent, InputEventDispatcher inputEventDispatcher) {
        int n2;
        IlvChartInteractor ilvChartInteractor = this.f;
        if (ilvChartInteractor != null) {
            inputEventDispatcher.dispatch(inputEvent, ilvChartInteractor);
            if (!ilvChartInteractor.isInOperation()) {
                this.f = null;
            }
            return;
        }
        boolean bl = this.getChart().is3D();
        int n3 = this.c.size();
        if (n3 + (n2 = this.d.size()) > 0) {
            IlvChartInteractor ilvChartInteractor2;
            int n4;
            IlvChartInteractor[] ilvChartInteractorArray = new IlvChartInteractor[n3 + n2];
            int n5 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                ilvChartInteractor2 = (IlvChartInteractor)this.c.get(n4);
                if (bl && !ilvChartInteractor2.has3DSupport()) continue;
                ilvChartInteractorArray[n5++] = ilvChartInteractor2;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                ilvChartInteractor2 = (IlvChartInteractor)this.d.get(n4);
                if (bl && !ilvChartInteractor2.has3DSupport()) continue;
                ilvChartInteractorArray[n5++] = ilvChartInteractor2;
            }
            Arrays.sort(ilvChartInteractorArray, 0, n5, m);
            for (n4 = 0; n4 < n5; ++n4) {
                ilvChartInteractor2 = ilvChartInteractorArray[n4];
                inputEventDispatcher.dispatch(inputEvent, ilvChartInteractor2);
                if (!inputEvent.isConsumed()) continue;
                if (inputEvent.getID() != 501) break;
                this.f = ilvChartInteractor2;
                break;
            }
        }
    }

    private void a(long l2, int n2) {
        if ((l2 & 0x10L) != 0L) {
            this.h += n2;
        }
        if ((l2 & 0x20L) != 0L) {
            this.i += n2;
        }
        if ((l2 & 8L) != 0L) {
            this.g += n2;
        }
    }

    public static Cursor pushCursor(IlvChart ilvChart, Cursor cursor) {
        Cursor cursor2;
        Cursor cursor3 = cursor2 = ilvChart.isCursorSet() ? ilvChart.getCursor() : null;
        if (cursor == null) {
            return cursor2;
        }
        Vector<Cursor> vector = (Vector<Cursor>)ilvChart.getClientProperty(a);
        if (vector == null) {
            vector = new Vector<Cursor>(5, 5);
            ilvChart.putClientProperty(a, vector);
        }
        vector.addElement(cursor2);
        ilvChart.setCursor(cursor);
        return cursor2;
    }

    public static Cursor popCursor(IlvChart ilvChart) {
        Vector vector = (Vector)ilvChart.getClientProperty(a);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        Cursor cursor = ilvChart.isCursorSet() ? ilvChart.getCursor() : null;
        Cursor cursor2 = (Cursor)vector.lastElement();
        vector.removeElementAt(vector.size() - 1);
        ilvChart.setCursor(cursor2);
        return cursor;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.a();
    }

    private static interface InputEventDispatcher {
        public void dispatch(InputEvent var1, IlvChartInteractor var2);
    }

    private static class InteractorComparator
    implements Comparator {
        private InteractorComparator() {
        }

        public int compare(Object object, Object object2) {
            int n2;
            int n3 = ((IlvChartInteractor)object).getPriority();
            if (n3 > (n2 = ((IlvChartInteractor)object2).getPriority())) {
                return -1;
            }
            if (n3 < n2) {
                return 1;
            }
            return 0;
        }
    }
}

