/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.util.internal.IlvArrayPool;
import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DPoints;
import ilog.views.chart.view3d.Ilv3DTransform;
import ilog.views.chart.view3d.Ilv3DVector;
import java.awt.Color;
import java.awt.Graphics;

public final class Ilv3DUtil {
    private Ilv3DUtil() {
    }

    public static Ilv3DVector computeCenter(Ilv3DVector[] ilv3DVectorArray, Ilv3DVector ilv3DVector) {
        if (ilv3DVector == null) {
            ilv3DVector = new Ilv3DVector();
        } else {
            ilv3DVector.set(0.0, 0.0, 0.0);
        }
        int n2 = ilv3DVectorArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ilv3DVector.add(ilv3DVectorArray[i2]);
        }
        ilv3DVector.scale(1.0 / (double)n2);
        return ilv3DVector;
    }

    public static Ilv3DVector computeCenter(Ilv3DVector[] ilv3DVectorArray, int[] nArray, Ilv3DVector ilv3DVector) {
        if (ilv3DVector == null) {
            ilv3DVector = new Ilv3DVector();
        } else {
            ilv3DVector.set(0.0, 0.0, 0.0);
        }
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ilv3DVector.add(ilv3DVectorArray[nArray[i2]]);
        }
        ilv3DVector.scale(1.0 / (double)n2);
        return ilv3DVector;
    }

    public static Ilv3DVector computeNormal(Ilv3DVector[] ilv3DVectorArray, int[] nArray, Ilv3DVector ilv3DVector) {
        int n2;
        int n3 = nArray.length;
        if (n3 < 3) {
            return new Ilv3DVector();
        }
        Ilv3DVector ilv3DVector2 = ilv3DVectorArray[nArray[0]];
        if (ilv3DVector == null) {
            ilv3DVector = ilv3DVector2.copy();
        } else {
            ilv3DVector.set(ilv3DVector2);
        }
        Ilv3DVector ilv3DVector3 = null;
        Ilv3DVector ilv3DVector4 = null;
        for (n2 = 1; n2 < n3; ++n2) {
            Ilv3DVector ilv3DVector5 = ilv3DVectorArray[nArray[n2]];
            if (ilv3DVector5.equals(ilv3DVector2)) continue;
            if (ilv3DVector3 != null) {
                ilv3DVector4 = ilv3DVector2.copy();
                ilv3DVector4.sub(ilv3DVector5);
                if (ilv3DVector4.isCollinear(ilv3DVector)) continue;
                break;
            }
            ilv3DVector3 = ilv3DVector5;
            ilv3DVector.sub(ilv3DVector3);
        }
        if (n2 == n3) {
            ilv3DVector.set(0.0, 0.0, 0.0);
            return ilv3DVector;
        }
        ilv3DVector.cross(ilv3DVector4);
        return ilv3DVector.normalize();
    }

    public static Ilv3DVector[] createCubeVertices(double d2, double d3, double d4, double d5, double d6, double d7, Ilv3DVector[] ilv3DVectorArray) {
        if (ilv3DVectorArray == null) {
            ilv3DVectorArray = new Ilv3DVector[]{new Ilv3DVector(d2, d3, d6), new Ilv3DVector(d2, d5, d6), new Ilv3DVector(d4, d5, d6), new Ilv3DVector(d4, d3, d6), new Ilv3DVector(d2, d3, d7), new Ilv3DVector(d2, d5, d7), new Ilv3DVector(d4, d5, d7), new Ilv3DVector(d4, d3, d7)};
        } else {
            ilv3DVectorArray[0].set(d2, d3, d6);
            ilv3DVectorArray[1].set(d2, d5, d6);
            ilv3DVectorArray[2].set(d4, d5, d6);
            ilv3DVectorArray[3].set(d4, d3, d6);
            ilv3DVectorArray[4].set(d2, d3, d7);
            ilv3DVectorArray[5].set(d2, d5, d7);
            ilv3DVectorArray[6].set(d4, d5, d7);
            ilv3DVectorArray[7].set(d4, d3, d7);
        }
        return ilv3DVectorArray;
    }

    public static IlvDoublePoints toScreen(Ilv3DTransform ilv3DTransform, IlvDoublePoints ilvDoublePoints, double d2) {
        int n2 = ilvDoublePoints.size();
        if (ilv3DTransform.isUsingPerspective()) {
            Ilv3DVector ilv3DVector = new Ilv3DVector();
            for (int i2 = 0; i2 < n2; ++i2) {
                ilv3DVector.set(ilvDoublePoints.getX(i2), ilvDoublePoints.getY(i2), d2);
                ilv3DTransform.transform(1, ilv3DVector);
                ilvDoublePoints.set(i2, ilv3DVector.x, ilv3DVector.y);
            }
        } else {
            Ilv3DMatrix ilv3DMatrix = ilv3DTransform.getMatrix();
            double d3 = ilv3DMatrix.m00;
            double d4 = ilv3DMatrix.m01;
            double d5 = ilv3DMatrix.m02;
            double d6 = ilv3DMatrix.m03;
            double d7 = ilv3DMatrix.m10;
            double d8 = ilv3DMatrix.m11;
            double d9 = ilv3DMatrix.m12;
            double d10 = ilv3DMatrix.m13;
            for (int i3 = 0; i3 < n2; ++i3) {
                double d11 = ilvDoublePoints.getX(i3);
                double d12 = ilvDoublePoints.getY(i3);
                ilvDoublePoints.set(i3, d11 * d3 + d12 * d4 + d2 * d5 + d6, d11 * d7 + d12 * d8 + d2 * d9 + d10);
            }
        }
        return ilvDoublePoints;
    }

    public static Ilv3DPoints toScreen(Ilv3DTransform ilv3DTransform, Ilv3DPoints ilv3DPoints) {
        int n2 = ilv3DPoints.size();
        if (ilv3DTransform.isUsingPerspective()) {
            Ilv3DVector ilv3DVector = new Ilv3DVector();
            for (int i2 = 0; i2 < n2; ++i2) {
                ilv3DVector.set(ilv3DPoints.getX(i2), ilv3DPoints.getY(i2), ilv3DPoints.getZ(i2));
                ilv3DTransform.transform(1, ilv3DVector);
                ilv3DPoints.set(i2, ilv3DVector.x, ilv3DVector.y);
            }
        } else {
            Ilv3DMatrix ilv3DMatrix = ilv3DTransform.getMatrix();
            double d2 = ilv3DMatrix.m00;
            double d3 = ilv3DMatrix.m01;
            double d4 = ilv3DMatrix.m02;
            double d5 = ilv3DMatrix.m03;
            double d6 = ilv3DMatrix.m10;
            double d7 = ilv3DMatrix.m11;
            double d8 = ilv3DMatrix.m12;
            double d9 = ilv3DMatrix.m13;
            for (int i3 = 0; i3 < n2; ++i3) {
                double d10 = ilv3DPoints.getX(i3);
                double d11 = ilv3DPoints.getY(i3);
                double d12 = ilv3DPoints.getZ(i3);
                ilv3DPoints.set(i3, d10 * d2 + d11 * d3 + d12 * d4 + d5, d10 * d6 + d11 * d7 + d12 * d8 + d9);
            }
        }
        return ilv3DPoints;
    }

    public static Color computeFaceColor(Ilv3DVector ilv3DVector, Ilv3DVector ilv3DVector2, Color color, float f2, boolean bl) {
        double d2 = bl ? Math.abs(ilv3DVector.dot(ilv3DVector2)) : Math.max(0.0, ilv3DVector.dot(ilv3DVector2));
        d2 *= (double)(1.0f - f2);
        int n2 = Ilv3DUtil.a((double)(f2 *= 255.0f) + d2 * (double)color.getRed());
        int n3 = Ilv3DUtil.a((double)f2 + d2 * (double)color.getGreen());
        int n4 = Ilv3DUtil.a((double)f2 + d2 * (double)color.getBlue());
        return new Color(n2, n3, n4, color.getAlpha());
    }

    private static int a(double d2) {
        if (d2 >= 255.0) {
            return 255;
        }
        if (d2 <= 0.0) {
            return 0;
        }
        return (int)d2;
    }

    static void a(Graphics graphics, Ilv3DVector ilv3DVector) {
        Ilv3DUtil.a(graphics, ilv3DVector, Color.black);
    }

    static void a(Graphics graphics, Ilv3DVector ilv3DVector, Color color) {
        graphics.setColor(color);
        int n2 = (int)ilv3DVector.x - 2;
        int n3 = (int)ilv3DVector.y - 2;
        graphics.fillRect(n2, n3, 5, 5);
    }

    static void a(Graphics graphics, Ilv3DVector ilv3DVector, String string) {
        int n2 = (int)ilv3DVector.x;
        int n3 = (int)ilv3DVector.y;
        int n4 = graphics.getFontMetrics().stringWidth(string);
        graphics.drawString(string, n2 - n4 / 2, n3);
    }

    static void b(Graphics graphics, Ilv3DVector ilv3DVector) {
        Ilv3DUtil.a(graphics, ilv3DVector, String.valueOf(ilv3DVector.z));
    }

    static double[][] a(Ilv3DVector[] ilv3DVectorArray, int n2, int n3, boolean bl, boolean bl2) {
        Object object;
        int n4;
        int n5 = n3 - n2 + 1;
        int n6 = n4 = bl ? n5 + 1 : n5;
        if (bl2) {
            object = IlvArrayPool.allocDoubleCoords(n4);
        } else {
            double[][] dArrayArray = new double[2][];
            dArrayArray[0] = new double[n4];
            object = dArrayArray;
            dArrayArray[1] = new double[n4];
        }
        double[][] dArray = object;
        double[] dArray2 = dArray[0];
        double[] dArray3 = dArray[1];
        int n7 = 0;
        int n8 = n2;
        while (n8 <= n3) {
            Ilv3DVector ilv3DVector = ilv3DVectorArray[n8];
            dArray2[n7] = ilv3DVector.x;
            dArray3[n7] = ilv3DVector.y;
            ++n8;
            ++n7;
        }
        if (bl) {
            dArray2[n7] = dArray2[0];
            dArray3[n7] = dArray3[0];
        }
        return dArray;
    }
}

