/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.IlvDisplayPoint;
import ilog.views.chart.IlvDoublePoints;
import ilog.views.chart.renderer.IlvSingleChartRenderer;
import ilog.views.chart.util.IlvGraphicUtil;
import ilog.views.chart.view3d.Ilv3DUtil;
import ilog.views.chart.view3d.Ilv3DVector;
import ilog.views.chart.view3d.IlvChart3DObject;
import ilog.views.chart.view3d.IlvChart3DScene;
import ilog.views.chart.view3d.IlvPolyhedron;
import java.awt.Dimension;
import java.awt.Point;

public class IlvChart3DBar
extends IlvChart3DObject {
    private static final int a = 0;
    private static final int b = 5;

    public IlvChart3DBar(IlvChart3DScene ilvChart3DScene, IlvDoublePoints ilvDoublePoints, double[] dArray, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        this(ilvChart3DScene, ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1), dArray[0], dArray[1], ilvSingleChartRenderer, n2);
    }

    public IlvChart3DBar(IlvChart3DScene ilvChart3DScene, double d2, double d3, double d4, double d5, double d6, double d7, IlvSingleChartRenderer ilvSingleChartRenderer, int n2) {
        super(ilvChart3DScene, ilvSingleChartRenderer, n2);
        Ilv3DVector[] ilv3DVectorArray = Ilv3DUtil.createCubeVertices(d2, d3, d4, d5, d6, d7, null);
        this.setVertices(ilv3DVectorArray, new Ilv3DVector((d2 + d4) / 2.0, (d3 + d5) / 2.0, (d6 + d7) / 2.0));
        IlvPolyhedron.Face[] faceArray = new IlvPolyhedron.Face[]{new IlvPolyhedron.Face(this, new int[]{0, 3, 2, 1}), new IlvPolyhedron.Face(this, new int[]{3, 7, 6, 2}), new IlvPolyhedron.Face(this, new int[]{7, 4, 5, 6}), new IlvPolyhedron.Face(this, new int[]{4, 0, 1, 5}), new IlvPolyhedron.Face(this, new int[]{0, 4, 7, 3}), new IlvPolyhedron.Face(this, new int[]{1, 2, 6, 5})};
        this.setFaces(faceArray);
    }

    public final IlvChart3DBar setGeometry(IlvDoublePoints ilvDoublePoints, double[] dArray, int n2) {
        this.dataIdx = n2;
        Ilv3DUtil.createCubeVertices(ilvDoublePoints.getX(0), ilvDoublePoints.getY(0), ilvDoublePoints.getX(1), ilvDoublePoints.getY(1), dArray[0], dArray[1], this.getVertices());
        this.updateGeometry();
        this.applyTransform(this.getScene().getTransform(), 1);
        return this;
    }

    public Point computeDataLabelLocation(IlvDisplayPoint ilvDisplayPoint, Dimension dimension) {
        Ilv3DVector ilv3DVector = this.getFace(0).getCenter(true);
        return new Point(IlvGraphicUtil.toInt(ilv3DVector.x), IlvGraphicUtil.toInt(ilv3DVector.y));
    }
}

