/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.chart.view3d;

import ilog.views.chart.view3d.Ilv3DMatrix;
import ilog.views.chart.view3d.Ilv3DVector;

public final class IlvQuaternion {
    public double x;
    public double y;
    public double z;
    public double w;

    public IlvQuaternion() {
    }

    public IlvQuaternion(double d2, double d3, double d4, double d5) {
        this.set(d2, d3, d4, d5);
    }

    public IlvQuaternion(IlvQuaternion ilvQuaternion) {
        this.set(ilvQuaternion.x, ilvQuaternion.y, ilvQuaternion.z, ilvQuaternion.w);
    }

    public IlvQuaternion copy() {
        return new IlvQuaternion(this);
    }

    public IlvQuaternion(Ilv3DVector ilv3DVector, double d2, boolean bl) {
        this.set(ilv3DVector, d2, bl);
    }

    public void set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public void set(Ilv3DVector ilv3DVector, double d2, boolean bl) {
        if (!bl) {
            d2 = Math.toRadians(d2);
        }
        double d3 = Math.sin(d2 *= 0.5);
        double d4 = Math.cos(d2);
        this.x = ilv3DVector.x * d3;
        this.y = ilv3DVector.y * d3;
        this.z = ilv3DVector.z * d3;
        this.w = d4;
    }

    public IlvQuaternion mult(IlvQuaternion ilvQuaternion) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        this.x = ilvQuaternion.w * d2 + ilvQuaternion.x * d5 - ilvQuaternion.y * d4 + ilvQuaternion.z * d3;
        this.y = ilvQuaternion.w * d3 + ilvQuaternion.y * d5 - ilvQuaternion.z * d2 + ilvQuaternion.x * d4;
        this.z = ilvQuaternion.w * d4 + ilvQuaternion.z * d5 - ilvQuaternion.x * d3 + ilvQuaternion.y * d2;
        this.w = ilvQuaternion.w * d5 - ilvQuaternion.x * d2 - ilvQuaternion.y * d3 - ilvQuaternion.z * d4;
        return this;
    }

    public static IlvQuaternion mult(IlvQuaternion ilvQuaternion, IlvQuaternion ilvQuaternion2) {
        return ilvQuaternion.copy().mult(ilvQuaternion2);
    }

    public Ilv3DMatrix toRotationMatrix(Ilv3DMatrix ilv3DMatrix) {
        if (ilv3DMatrix == null) {
            ilv3DMatrix = new Ilv3DMatrix();
        }
        ilv3DMatrix.set(this);
        return ilv3DMatrix;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + "," + this.w + ")";
    }
}

