/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvArcUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;

public class IlvArc
extends IlvGraphic
implements IlvDefinitionRectInterface {
    protected final IlvRect bbox = new IlvRect();
    private float a;
    private float b;
    private Color c;
    private Color d;
    private int e = 2;
    private static int f = 2;
    private static int g = 4;
    private static int h = 8;
    private float i = 0.0f;
    private IlvTransformer j;

    public IlvArc() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f), 0.0f, 90.0f);
    }

    public IlvArc(IlvRect ilvRect, float f2, float f3) {
        this.bbox.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        if (f3 < 0.0f) {
            f2 += f3;
            f3 = -f3;
        }
        f2 = IlvArc.a(f2);
        while (f3 > 360.0f) {
            f3 -= 360.0f;
        }
        this.a = f2;
        this.b = f3;
    }

    public IlvArc(IlvRect ilvRect, float f2, float f3, boolean bl, boolean bl2) {
        this(ilvRect, f2, f3);
        this.setStrokeOn(bl);
        this.setFillOn(bl2);
    }

    private static final float a(double d2) {
        while (d2 < 0.0) {
            d2 += 360.0;
        }
        while (d2 >= 360.0) {
            d2 -= 360.0;
        }
        return (float)d2;
    }

    public IlvArc(IlvArc ilvArc) {
        super(ilvArc);
        this.a = ilvArc.a;
        this.b = ilvArc.b;
        this.bbox.reshape(ilvArc.bbox.x, ilvArc.bbox.y, ilvArc.bbox.width, ilvArc.bbox.height);
        this.setForeground(ilvArc.getForeground());
        this.setBackground(ilvArc.getBackground());
        this.e = ilvArc.e;
        this.i = ilvArc.i;
        this.j = ilvArc.j == null ? null : new IlvTransformer(ilvArc.j);
    }

    public IlvArc(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        IlvRect ilvRect = ilvInputStream.readRect("rectangle");
        this.bbox.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        this.setStartAngle(ilvInputStream.readFloat("startAngle"));
        this.setDeltaAngle(ilvInputStream.readFloat("deltaAngle"));
        try {
            this.setBackground(ilvInputStream.readColor("background"));
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.e = ilvInputStream.readInt("flags");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.i = ilvInputStream.readFloat("annulusThickness");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.j = ilvInputStream.readTransformer("transformer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvArc(this);
    }

    public final IlvRect getDefinitionRect() {
        return new IlvRect(this.bbox);
    }

    public void setDefinitionRect(IlvRect ilvRect) {
        this.bbox.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
    }

    public IlvTransformer getDefinitionTransformer() {
        return this.getTransformer();
    }

    public final float getStartAngle() {
        return this.a;
    }

    public final void setStartAngle(float f2) {
        this.a = IlvArc.a(f2);
    }

    public final float getDeltaAngle() {
        return this.b;
    }

    public final void setDeltaAngle(float f2) {
        this.b = f2;
        if (this.b > 0.0f) {
            while ((double)this.b > 360.0) {
                this.b -= 360.0f;
            }
        } else {
            while ((double)this.b < 360.0) {
                this.b += 360.0f;
            }
        }
    }

    public float getAnnulusThickness() {
        return this.i;
    }

    public void setAnnulusThickness(float f2) {
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Incorrect annulus thickness: " + f2);
        }
        this.i = f2;
    }

    private IlvRect a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint(this.i, this.i);
        if (ilvTransformer != null) {
            ilvTransformer.deltaApply(ilvPoint);
            ilvPoint.x = Math.abs(ilvPoint.x);
            ilvPoint.y = Math.abs(ilvPoint.y);
        }
        ilvPoint.x = Math.min(ilvPoint.x, (float)ilvRect.getWidth() / 2.0f);
        ilvPoint.y = Math.min(ilvPoint.y, (float)ilvRect.getHeight() / 2.0f);
        float f2 = (float)(ilvRect.getX() + (double)ilvPoint.x);
        float f3 = (float)(ilvRect.getY() + (double)ilvPoint.y);
        float f4 = (float)(ilvRect.getWidth() - (double)(2.0f * ilvPoint.x));
        float f5 = (float)(ilvRect.getHeight() - (double)(2.0f * ilvPoint.y));
        return new IlvRect(f2, f3, f4, f5);
    }

    public final boolean isTransformerMode() {
        return (this.e & h) == h;
    }

    public final void setTransformerMode(boolean bl) {
        this.e = bl ? (this.e |= h) : (this.e &= ~h);
    }

    public final void setTransformer(IlvTransformer ilvTransformer) {
        this.j = ilvTransformer == null ? null : new IlvTransformer(ilvTransformer);
    }

    public final IlvTransformer getTransformer() {
        if (this.j == null || !this.isTransformerMode()) {
            return null;
        }
        return new IlvTransformer(this.j);
    }

    private Shape a() {
        float f2 = this.getStartAngle();
        float f3 = this.getDeltaAngle();
        IlvRect ilvRect = new IlvRect(this.bbox);
        IlvRect ilvRect2 = null;
        if (this.i > 0.0f) {
            ilvRect2 = this.a(ilvRect, null);
        }
        if (f3 == 360.0f) {
            Ellipse2D.Float float_ = new Ellipse2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
            if (this.i == 0.0f) {
                return float_;
            }
            Ellipse2D.Float float_2 = new Ellipse2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height);
            Area area = new Area(float_);
            area.subtract(new Area(float_2));
            return area;
        }
        if (this.i == 0.0f) {
            if (this.isFillOn()) {
                return new Arc2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, f2, f3, 2);
            }
            return new Arc2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, f2, f3, 0);
        }
        Arc2D.Float float_ = new Arc2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, f2, f3, 0);
        Arc2D.Float float_3 = new Arc2D.Float(ilvRect2.x, ilvRect2.y, ilvRect2.width, ilvRect2.height, f2 + f3, -f3, 0);
        GeneralPath generalPath = new GeneralPath(float_);
        generalPath.append(float_3, true);
        generalPath.closePath();
        return generalPath;
    }

    private boolean b() {
        return this.i == 0.0f && this.b != 360.0f;
    }

    private AffineTransform a(IlvTransformer ilvTransformer) {
        IlvTransformer ilvTransformer2 = null;
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer2 = new IlvTransformer(ilvTransformer);
        }
        if (this.isTransformerMode() && this.j != null && !this.j.isIdentity()) {
            if (ilvTransformer2 == null) {
                ilvTransformer2 = new IlvTransformer(this.j);
            } else {
                ilvTransformer2.postCompose(this.j);
            }
        }
        if (ilvTransformer2 != null) {
            return ilvTransformer2.getAffineTransform(null);
        }
        return null;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        Cloneable cloneable;
        Shape shape = null;
        Shape shape2 = null;
        float f2 = this.getStartAngle();
        float f3 = this.getDeltaAngle();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.b()) {
            cloneable = new IlvRect(this.bbox);
            if (!this.isTransformerMode()) {
                f2 = IlvArc.a((IlvRect)cloneable, ilvTransformer, f2, f3);
            }
            if (this.isFillOn()) {
                shape = new Arc2D.Float(((Rectangle2D.Float)cloneable).x, ((Rectangle2D.Float)cloneable).y, ((Rectangle2D.Float)cloneable).width, ((Rectangle2D.Float)cloneable).height, f2, f3, 2);
            }
            if (this.isStrokeOn()) {
                shape2 = new Arc2D.Float(((Rectangle2D.Float)cloneable).x, ((Rectangle2D.Float)cloneable).y, ((Rectangle2D.Float)cloneable).width, ((Rectangle2D.Float)cloneable).height, f2, f3, 0);
            }
            if (!this.isTransformerMode()) {
                this.a(graphics2D, shape, shape2);
                return;
            }
        } else {
            shape = this.a();
        }
        if ((cloneable = this.a(ilvTransformer)) != null) {
            if (shape2 != null) {
                shape2 = ((AffineTransform)cloneable).createTransformedShape(shape2);
            }
            if (shape != null) {
                shape = ((AffineTransform)cloneable).createTransformedShape(shape);
            }
        }
        this.a(graphics2D, shape, shape2);
    }

    private void a(Graphics2D graphics2D, Shape shape, Shape shape2) {
        if (this.isFillOn() && shape != null) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(shape);
        }
        if (this.isStrokeOn()) {
            graphics2D.setColor(this.getForeground());
            if (shape2 != null) {
                graphics2D.draw(shape2);
            } else if (shape != null) {
                graphics2D.draw(shape);
            }
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.b() && !this.isTransformerMode()) {
            float f2 = this.getStartAngle();
            float f3 = this.getDeltaAngle();
            IlvRect ilvRect = new IlvRect(this.bbox);
            f2 = IlvArc.a(ilvRect, ilvTransformer, f2, f3);
            if (this.isFillOn()) {
                return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, f2, f3);
            }
            if (this.isStrokeOn()) {
                return IlvArcUtil.PointInArc(ilvPoint2, ilvRect, f2, f3);
            }
            return false;
        }
        Shape shape = this.a();
        AffineTransform affineTransform = this.a(ilvTransformer);
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return shape.contains(ilvPoint2.x, ilvPoint2.y);
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        if (this.b() && !this.isTransformerMode()) {
            double d2;
            boolean bl = this.isFillOn();
            double d3 = this.getStartAngle();
            for (d2 = (double)this.getDeltaAngle(); d2 > 360.0; d2 -= 360.0) {
            }
            while (d2 < 0.0) {
                d2 += 360.0;
            }
            IlvRect ilvRect = this.getDefinitionRect();
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect);
            }
            IlvPoint[] ilvPointArray = new IlvPoint[4];
            int n2 = IlvClippingUtil.LineIntersectsArc(ilvPoint, ilvPoint2, ilvRect, d3, d2, ilvPointArray);
            if (bl) {
                IlvPoint ilvPoint3;
                IlvPoint ilvPoint4;
                IlvPoint ilvPoint5 = new IlvPoint(ilvRect.x + 0.5f * ilvRect.width, ilvRect.y + 0.5f * ilvRect.height);
                IlvPoint ilvPoint6 = IlvClippingUtil.ArcStartPoint(ilvRect, d3);
                IlvPoint ilvPoint7 = IlvClippingUtil.ArcEndPoint(ilvRect, d3, d2);
                IlvPoint ilvPoint8 = new IlvPoint();
                boolean bl2 = false;
                if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint6, ilvPoint8)) {
                    ilvPointArray[n2++] = ilvPoint8;
                    ilvPoint8 = new IlvPoint();
                    bl2 = true;
                }
                if (IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint5, ilvPoint7, ilvPoint8)) {
                    ilvPointArray[n2++] = ilvPoint8;
                    bl2 = true;
                }
                if (!bl2 && IlvClippingUtil.LineIntersectsSegment(ilvPoint, ilvPoint2, ilvPoint4 = new IlvPoint(0.5f * (ilvPoint6.x + ilvPoint5.x), 0.5f * (ilvPoint6.y + ilvPoint5.y)), ilvPoint3 = new IlvPoint(0.5f * (ilvPoint7.x + ilvPoint5.x), 0.5f * (ilvPoint7.y + ilvPoint5.y)), ilvPoint8)) {
                    ilvPointArray[n2++] = ilvPoint5;
                }
            }
            return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n2);
        }
        Shape shape = this.a();
        AffineTransform affineTransform = this.a(ilvTransformer);
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        return IlvClippingUtil.getClippedPoint(shape.getPathIterator(null), null, 0.0f, ilvPoint, ilvPoint2);
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.b() && !this.isTransformerMode()) {
            IlvRect ilvRect = new IlvRect(this.bbox);
            IlvRect ilvRect2 = new IlvRect();
            float f2 = this.a;
            float f3 = this.b;
            f2 = IlvArc.a(ilvRect, ilvTransformer, f2, f3);
            IlvArcUtil.ComputeArcBBox(ilvRect, f2, f3, ilvRect2);
            if (this.isFillOn()) {
                IlvPoint ilvPoint = new IlvPoint(this.bbox.x + this.bbox.width / 2.0f, this.bbox.y + this.bbox.height / 2.0f);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint);
                }
                ilvRect2.add(ilvPoint.x, ilvPoint.y);
            }
            return ilvRect2;
        }
        Shape shape = this.a();
        AffineTransform affineTransform = this.a(ilvTransformer);
        if (affineTransform != null) {
            shape = affineTransform.createTransformedShape(shape);
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        return new IlvRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public IlvPoint getCenter(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint(this.bbox.x + this.bbox.width / 2.0f, this.bbox.y + this.bbox.height / 2.0f);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint);
        }
        if (this.isTransformerMode() && this.j != null) {
            this.j.apply(ilvPoint);
        }
        return ilvPoint;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.isTransformerMode()) {
            if (this.j != null) {
                this.j.compose(ilvTransformer);
            } else {
                this.j = new IlvTransformer(ilvTransformer);
            }
        } else {
            this.a = IlvArc.a(this.bbox, ilvTransformer, this.a, this.b);
        }
    }

    public void rotate(IlvPoint ilvPoint, double d2) {
        IlvTransformer ilvTransformer = new IlvTransformer(ilvPoint, d2);
        if (this.isTransformerMode()) {
            this.applyTransform(ilvTransformer);
        } else {
            IlvPoint ilvPoint2 = new IlvPoint(this.bbox.x + this.bbox.width / 2.0f, this.bbox.y + this.bbox.height / 2.0f);
            ilvTransformer.apply(ilvPoint2);
            this.bbox.translate(ilvPoint2.x - (this.bbox.x + this.bbox.width / 2.0f), ilvPoint2.y - (this.bbox.y + this.bbox.height / 2.0f));
            this.a = IlvArc.a((double)this.a - d2);
        }
    }

    public void symmetry(int n2) {
        switch (n2) {
            case 32: 
            case 96: {
                this.a = 360.0f - this.a - this.b;
                break;
            }
            case 16: {
                this.a += 180.0f;
                break;
            }
            case 64: 
            case 128: {
                this.a = 180.0f - this.a - this.b;
                break;
            }
        }
        this.a = IlvArc.a(this.a);
    }

    public void setForeground(Color color) {
        this.c = color;
    }

    public Color getForeground() {
        if (this.c == null) {
            return Color.black;
        }
        return this.c;
    }

    public void setBackground(Color color) {
        this.d = color;
    }

    public Color getBackground() {
        if (this.d == null) {
            return Color.black;
        }
        return this.d;
    }

    public boolean isFillOn() {
        return (this.e & g) != 0;
    }

    public void setFillOn(boolean bl) {
        this.e = bl ? (this.e |= g) : (this.e &= ~g);
    }

    public boolean isStrokeOn() {
        return (this.e & f) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.e = bl ? (this.e |= f) : (this.e &= ~f);
    }

    static float a(IlvRect ilvRect, IlvTransformer ilvTransformer, float f2, float f3) {
        if (ilvTransformer == null) {
            return f2;
        }
        IlvPoint ilvPoint = new IlvPoint();
        IlvPoint ilvPoint2 = new IlvPoint();
        ilvPoint.move((float)((double)(ilvRect.x + ilvRect.width / 2.0f) + (double)ilvRect.width * Math.cos((double)f2 * Math.PI / 180.0) / 2.0), (float)((double)(ilvRect.y + ilvRect.height / 2.0f) - (double)ilvRect.height * Math.sin((double)f2 * Math.PI / 180.0) / 2.0));
        ilvPoint2.move((float)((double)(ilvRect.x + ilvRect.width / 2.0f) + (double)ilvRect.width * Math.cos((double)(f3 + f2) * Math.PI / 180.0) / 2.0), (float)((double)(ilvRect.y + ilvRect.height / 2.0f) - (double)ilvRect.height * Math.sin((double)(f3 + f2) * Math.PI / 180.0) / 2.0));
        boolean bl = (ilvPoint.x - (ilvRect.x + ilvRect.width / 2.0f)) * (ilvPoint2.y - (ilvRect.y + ilvRect.height / 2.0f)) - (ilvPoint.y - (ilvRect.y + ilvRect.height / 2.0f)) * (ilvPoint2.x - (ilvRect.x + ilvRect.width / 2.0f)) > 0.0f;
        ilvTransformer.apply(ilvPoint);
        ilvTransformer.apply(ilvPoint2);
        ilvTransformer.apply(ilvRect);
        double d2 = ilvTransformer.getx11();
        double d3 = ilvTransformer.getx12();
        double d4 = ilvTransformer.getx21();
        double d5 = ilvTransformer.getx22();
        if (!ilvTransformer.isTranslation() && !ilvTransformer.isIdentity()) {
            if (d3 == 0.0 && d4 == 0.0) {
                if (d2 < 0.0) {
                    if ((double)(f2 = 180.0f - f2 - f3) < 0.0) {
                        f2 += 360.0f;
                    }
                    if ((double)f2 > 360.0) {
                        f2 -= 360.0f;
                    }
                }
                if (d5 < 0.0) {
                    if ((double)(f2 = 360.0f - f2 - f3) < 0.0) {
                        f2 += 360.0f;
                    }
                    if ((double)f2 > 360.0) {
                        f2 -= 360.0f;
                    }
                }
            } else {
                boolean bl2;
                f2 = (float)(Math.atan2(ilvRect.y + ilvRect.height / 2.0f - ilvPoint.y, ilvPoint.x - (ilvRect.x + ilvRect.width / 2.0f)) * 180.0 / Math.PI);
                if (f2 < 0.0f) {
                    f2 += 360.0f;
                }
                if (f2 > 360.0f) {
                    f2 -= 360.0f;
                }
                boolean bl3 = bl2 = (ilvPoint.x - (ilvRect.x + ilvRect.width / 2.0f)) * (ilvPoint2.y - (ilvRect.y + ilvRect.height / 2.0f)) - (ilvPoint.y - (ilvRect.y + ilvRect.height / 2.0f)) * (ilvPoint2.x - (ilvRect.x + ilvRect.width / 2.0f)) > 0.0f;
                if (bl2 != bl) {
                    f2 -= f3;
                }
            }
        }
        return f2;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("rectangle", this.bbox);
        ilvOutputStream.write("startAngle", this.a);
        ilvOutputStream.write("deltaAngle", this.b);
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.e);
        if ((double)this.i > 0.0) {
            ilvOutputStream.write("annulusThickness", this.i);
        }
        if (this.j != null) {
            ilvOutputStream.write("transformer", this.j);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

