/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvArcUtil;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;

public class IlvEllipse
extends IlvGraphic {
    protected final IlvRect drawrect = new IlvRect();
    private Color a;
    private Color b;
    private int c = 2;
    private static int d = 2;
    private static int e = 4;

    public IlvEllipse() {
        this(new IlvRect(0.0f, 0.0f, 100.0f, 100.0f));
    }

    public IlvEllipse(IlvRect ilvRect) {
        this.drawrect.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
    }

    public IlvEllipse(IlvPoint ilvPoint, int n2) {
        this(ilvPoint, (float)n2);
    }

    public IlvEllipse(IlvPoint ilvPoint, float f2) {
        this.drawrect.reshape(ilvPoint.x - f2, ilvPoint.y - f2, 2.0f * f2, 2.0f * f2);
    }

    public IlvEllipse(IlvRect ilvRect, boolean bl, boolean bl2) {
        this(ilvRect);
        this.setStrokeOn(bl);
        this.setFillOn(bl2);
    }

    public IlvEllipse(IlvEllipse ilvEllipse) {
        super(ilvEllipse);
        this.drawrect.reshape(ilvEllipse.drawrect.x, ilvEllipse.drawrect.y, ilvEllipse.drawrect.width, ilvEllipse.drawrect.height);
        this.setForeground(ilvEllipse.getForeground());
        this.setBackground(ilvEllipse.getBackground());
        this.c = ilvEllipse.c;
    }

    public IlvEllipse(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setForeground(ilvInputStream.readColor("foreground"));
        IlvRect ilvRect = ilvInputStream.readRect("rectangle");
        this.drawrect.reshape(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height);
        try {
            this.setBackground(ilvInputStream.readColor("background"));
            this.c = ilvInputStream.readInt("flags");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvEllipse(this);
    }

    public final IlvRect getDefinitionRect() {
        return new IlvRect(this.drawrect);
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.isFillOn()) {
            graphics.setColor(this.getBackground());
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvRect = new IlvRect();
                ilvRect.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                ilvTransformer.applyFloor(ilvRect);
                graphics.fillArc((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width + 1, (int)ilvRect.height + 1, 0, 360);
            } else {
                graphics.fillArc(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor() + 1, this.drawrect.heightFloor() + 1, 0, 360);
            }
        }
        if (this.isStrokeOn()) {
            graphics.setColor(this.getForeground());
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvRect = new IlvRect();
                ilvRect.reshape(this.drawrect.x, this.drawrect.y, this.drawrect.width, this.drawrect.height);
                ilvTransformer.applyFloor(ilvRect);
                graphics.drawArc((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height, 0, 360);
            } else {
                graphics.drawArc(this.drawrect.xFloor(), this.drawrect.yFloor(), this.drawrect.widthFloor(), this.drawrect.heightFloor(), 0, 360);
            }
        }
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.isFillOn()) {
            IlvRect ilvRect = new IlvRect(this.drawrect);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvRect);
            }
            return IlvArcUtil.PointInFilledArc(ilvPoint2, ilvRect, 0.0f, 360.0f);
        }
        if (this.isStrokeOn()) {
            IlvRect ilvRect = new IlvRect(this.drawrect);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
            }
            return IlvArcUtil.PointInArc(ilvPoint2, ilvRect, 0.0f, 360.0f);
        }
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(this.drawrect);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvRect);
        }
        return ilvRect;
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        ilvTransformer.apply(this.drawrect);
        if (this.drawrect.width < 1.0E-20f) {
            this.drawrect.width = 1.0E-20f;
        }
        if (this.drawrect.height < 1.0E-20f) {
            this.drawrect.height = 1.0E-20f;
        }
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (ilvPoint == null || ilvPoint2 == null) {
            return null;
        }
        if (ilvPoint.equals(ilvPoint2)) {
            return new IlvPoint(ilvPoint);
        }
        IlvPoint[] ilvPointArray = new IlvPoint[2];
        int n2 = IlvClippingUtil.LineIntersectsEllipse(ilvPoint, ilvPoint2, this.boundingBox(ilvTransformer), ilvPointArray);
        return IlvClippingUtil.BestClipPointOnRay(ilvPoint, ilvPoint2, ilvPointArray, n2);
    }

    public void setForeground(Color color) {
        this.a = color;
    }

    public Color getForeground() {
        if (this.a == null) {
            return Color.black;
        }
        return this.a;
    }

    public void setBackground(Color color) {
        this.b = color;
    }

    public Color getBackground() {
        if (this.b == null) {
            return Color.black;
        }
        return this.b;
    }

    public boolean isFillOn() {
        return (this.c & e) != 0;
    }

    public void setFillOn(boolean bl) {
        this.c = bl ? (this.c |= e) : (this.c &= ~e);
    }

    public boolean isStrokeOn() {
        return (this.c & d) != 0;
    }

    public void setStrokeOn(boolean bl) {
        this.c = bl ? (this.c |= d) : (this.c &= ~d);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("foreground", this.getForeground());
        ilvOutputStream.write("rectangle", this.drawrect);
        ilvOutputStream.write("background", this.getBackground());
        ilvOutputStream.write("flags", this.c);
    }
}

