/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.decoration;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.composite.decoration.IlvBalloon;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;

public class IlvRoundRectBalloon
extends IlvBalloon {
    private int a;
    private int b;
    private BalloonPointer c;

    public IlvRoundRectBalloon() {
    }

    public IlvRoundRectBalloon(IlvRoundRectBalloon ilvRoundRectBalloon) {
        super(ilvRoundRectBalloon);
        this.a = ilvRoundRectBalloon.a;
        this.b = ilvRoundRectBalloon.b;
    }

    public IlvRoundRectBalloon(int n2, int n3, int n4, Color color, Color color2, Color color3, int n5, int n6) {
        super(n2, n3, n4, color, color2, color3);
        this.setRadius(n5);
        this.setPointerDistance(n6);
    }

    public IlvRoundRectBalloon(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setRadius(ilvInputStream.readInt("radius"));
        this.setPointerDistance(ilvInputStream.readInt("pointerDistance"));
    }

    public IlvGraphic copy() {
        return new IlvRoundRectBalloon(this);
    }

    void a() {
        super.a();
        this.c = this.a(this.getOrientation());
    }

    public IlvPoint getHotSpot() {
        if (!this.b()) {
            this.a();
        }
        IlvRect ilvRect = this.boundingBox(null);
        ilvRect.width -= (float)this.getShadowThickness();
        ilvRect.height -= (float)this.getShadowThickness();
        switch (this.getOrientation()) {
            case 3: 
            case 7: {
                ilvRect.width -= (float)this.getPointerDepth();
                break;
            }
            default: {
                ilvRect.height -= (float)this.getPointerDepth();
            }
        }
        return this.a(ilvRect);
    }

    private IlvPoint a(IlvRect ilvRect) {
        if (!this.b()) {
            this.a();
        }
        return this.c.getHotSpot(ilvRect);
    }

    public void setPointerDistance(int n2) {
        this.b = n2;
        this.d();
    }

    public int getPointerDistance() {
        return this.b;
    }

    public void setRadius(int n2) {
        this.a = n2;
        this.d();
    }

    public int getRadius() {
        return this.a;
    }

    private BalloonPointer a(int n2) {
        if (!this.b()) {
            this.a();
        }
        BalloonPointer balloonPointer = null;
        switch (n2) {
            case 4: 
            case 5: 
            case 6: {
                balloonPointer = new SouthPointer();
                break;
            }
            case 3: {
                balloonPointer = new EastPointer();
                break;
            }
            case 7: {
                balloonPointer = new WestPointer();
                break;
            }
            default: {
                balloonPointer = new NorthPointer();
            }
        }
        return balloonPointer;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (!this.b()) {
            this.a();
        }
        this.c.draw(graphics, ilvTransformer);
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return this.c.contains(ilvPoint, ilvPoint2, ilvTransformer);
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("radius", this.getRadius());
        ilvOutputStream.write("pointerDistance", this.getPointerDistance());
    }

    private abstract class BalloonPointer {
        private Area a;
        private Area b;
        private IlvRect c;

        private BalloonPointer() {
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer, IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Shape shape = this.a(ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
            graphics.setColor(IlvRoundRectBalloon.this.getShadowColor());
            graphics2D.fill(this.b);
            graphics2D.draw(this.b);
            graphics.setColor(IlvRoundRectBalloon.this.getBalloonColor());
            graphics2D.fill(shape);
            graphics.setColor(IlvRoundRectBalloon.this.getBorderColor());
            graphics2D.draw(shape);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        private Shape a(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            if (this.c != null && this.c.height == ilvRect.height && this.c.width == ilvRect.width) {
                if (this.c.x == ilvRect.x && this.c.y == ilvRect.y) {
                    return this.a;
                }
                this.a.transform(AffineTransform.getTranslateInstance(ilvRect.x - this.c.x, ilvRect.y - this.c.y));
                this.b.transform(AffineTransform.getTranslateInstance(ilvRect.x - this.c.x, ilvRect.y - this.c.y));
                this.c = ilvRect;
                return this.a;
            }
            RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(ilvRect.x, ilvRect.y, ilvRect.width, ilvRect.height, IlvRoundRectBalloon.this.getRadius(), IlvRoundRectBalloon.this.getRadius());
            GeneralPath generalPath = new GeneralPath(float_);
            generalPath.moveTo(ilvPoint.x, ilvPoint.y);
            generalPath.lineTo(ilvPoint2.x, ilvPoint2.y);
            generalPath.lineTo(ilvPoint3.x, ilvPoint3.y);
            this.a = new Area(generalPath);
            this.b = new Area(generalPath);
            this.b.transform(AffineTransform.getTranslateInstance(IlvRoundRectBalloon.this.getShadowThickness(), IlvRoundRectBalloon.this.getShadowThickness()));
            this.c = ilvRect;
            return this.a;
        }

        public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
            IlvRect ilvRect = IlvRoundRectBalloon.this.e();
            IlvPoint ilvPoint = new IlvPoint();
            IlvPoint ilvPoint2 = new IlvPoint();
            IlvPoint ilvPoint3 = new IlvPoint();
            this.getPointer(ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
                ilvTransformer.apply(ilvPoint);
                ilvTransformer.apply(ilvPoint2);
                ilvTransformer.apply(ilvPoint3);
            }
            this.draw(graphics, ilvTransformer, ilvRect, ilvPoint, ilvPoint2, ilvPoint3);
        }

        public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
            Shape shape;
            IlvRect ilvRect = IlvRoundRectBalloon.this.e();
            IlvPoint ilvPoint3 = new IlvPoint();
            IlvPoint ilvPoint4 = new IlvPoint();
            IlvPoint ilvPoint5 = new IlvPoint();
            this.getPointer(ilvRect, ilvPoint3, ilvPoint4, ilvPoint5);
            if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
                ilvTransformer.apply(ilvRect);
                ilvTransformer.apply(ilvPoint3);
                ilvTransformer.apply(ilvPoint4);
                ilvTransformer.apply(ilvPoint5);
            }
            if ((shape = this.a(ilvRect, ilvPoint3, ilvPoint4, ilvPoint5)).contains(ilvPoint2)) {
                return true;
            }
            return this.b.contains(ilvPoint2);
        }

        public abstract IlvPoint getHotSpot(IlvRect var1);

        protected abstract void getPointer(IlvRect var1, IlvPoint var2, IlvPoint var3, IlvPoint var4);
    }

    private class EastPointer
    extends BalloonPointer {
        private EastPointer() {
        }

        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f2;
            float f3 = ilvRect.x;
            float f4 = ilvRect.y;
            float f5 = ilvRect.y + ilvRect.height;
            float f6 = IlvRoundRectBalloon.this.getPointerDepth();
            float f7 = f2 = (f4 + f5 - f6) / 2.0f;
            float f8 = f2 + f6;
            float f9 = f3;
            float f10 = f9 - f6;
            float f11 = f3;
            ilvPoint.x = f9;
            ilvPoint.y = f2;
            ilvPoint2.x = f10;
            ilvPoint2.y = f7;
            ilvPoint3.x = f11;
            ilvPoint3.y = f8;
        }

        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n2 = IlvRoundRectBalloon.this.getPointerDepth();
            f3 = (ilvRect.height - (float)n2) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            f2 = 1.0f;
            IlvPoint ilvPoint = new IlvPoint(f2, f3);
            return ilvPoint;
        }
    }

    private class NorthPointer
    extends BalloonPointer {
        private NorthPointer() {
        }

        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f2;
            float f3;
            float f4 = ilvRect.x;
            float f5 = ilvRect.x + ilvRect.width;
            float f6 = ilvRect.y + ilvRect.height;
            float f7 = IlvRoundRectBalloon.this.getPointerDistance();
            float f8 = IlvRoundRectBalloon.this.getPointerDepth();
            float f9 = (f4 + f5 - f8) / 2.0f;
            f9 += (float)IlvRoundRectBalloon.this.getShadowThickness();
            if (f7 > 0.0f && f7 < f9 - f4) {
                f9 = f4 + f7;
            }
            if (IlvRoundRectBalloon.this.getOrientation() == 2) {
                f3 = f9;
                f2 = f9 + f8;
            } else {
                f3 = f2 = f9 + f8;
            }
            float f10 = f6;
            float f11 = f6 + f8;
            float f12 = f6;
            ilvPoint.x = f9;
            ilvPoint.y = f10;
            ilvPoint2.x = f3;
            ilvPoint2.y = f11;
            ilvPoint3.x = f2;
            ilvPoint3.y = f12;
        }

        public IlvPoint getHotSpot(IlvRect ilvRect) {
            int n2 = IlvRoundRectBalloon.this.getPointerDepth();
            float f2 = ilvRect.height + (float)n2;
            float f3 = IlvRoundRectBalloon.this.getOrientation() == 2 ? (ilvRect.width - (float)n2) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f : (ilvRect.width + (float)n2) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            return new IlvPoint(f3, f2);
        }
    }

    private class SouthPointer
    extends BalloonPointer {
        private SouthPointer() {
        }

        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f2;
            float f3;
            float f4 = ilvRect.x;
            float f5 = ilvRect.y;
            float f6 = ilvRect.x + ilvRect.width;
            int n2 = IlvRoundRectBalloon.this.getPointerDepth();
            float f7 = (f4 + f6 - (float)n2) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness();
            int n3 = IlvRoundRectBalloon.this.getPointerDistance();
            if (n3 > 0 && (float)n3 < f7 - f4) {
                f7 = f4 + (float)n3;
            }
            if (IlvRoundRectBalloon.this.getOrientation() == 4) {
                f3 = f7;
                f2 = f7 + (float)n2;
            } else {
                f3 = f2 = f7 + (float)n2;
            }
            float f8 = f5;
            float f9 = f8 - (float)n2;
            float f10 = f8;
            ilvPoint.x = f7;
            ilvPoint.y = f8;
            ilvPoint2.x = f3;
            ilvPoint2.y = f9;
            ilvPoint3.x = f2;
            ilvPoint3.y = f10;
        }

        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f2 = 1.0f;
            float f3 = 0.0f;
            f3 = IlvRoundRectBalloon.this.getOrientation() == 4 ? (ilvRect.width - (float)IlvRoundRectBalloon.this.getPointerDepth()) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f : (ilvRect.width + (float)IlvRoundRectBalloon.this.getPointerDepth()) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            return new IlvPoint(f3, f2);
        }
    }

    private class WestPointer
    extends BalloonPointer {
        private WestPointer() {
        }

        protected void getPointer(IlvRect ilvRect, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3) {
            float f2;
            float f3 = ilvRect.y;
            float f4 = ilvRect.x + ilvRect.width;
            float f5 = ilvRect.y + ilvRect.height;
            float f6 = IlvRoundRectBalloon.this.getPointerDepth();
            float f7 = f2 = (f3 + f5 - f6) / 2.0f;
            float f8 = f2 + f6;
            float f9 = f4;
            float f10 = f9 + f6;
            float f11 = f4;
            ilvPoint.x = f9;
            ilvPoint.y = f2;
            ilvPoint2.x = f10;
            ilvPoint2.y = f7;
            ilvPoint3.x = f11;
            ilvPoint3.y = f8;
        }

        public IlvPoint getHotSpot(IlvRect ilvRect) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n2 = IlvRoundRectBalloon.this.getPointerDepth();
            f3 = (ilvRect.height - (float)n2) / 2.0f + (float)IlvRoundRectBalloon.this.getShadowThickness() + 1.0f;
            f2 = ilvRect.width + (float)n2;
            IlvPoint ilvPoint = new IlvPoint(f2, f3);
            return ilvPoint;
        }
    }
}

