/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic.composite.internal;

import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IlvLineSegment
extends Line2D
implements Cloneable,
Serializable {
    protected IlvPoint _from;
    protected IlvPoint _to;
    private int a;
    static final long serialVersionUID = 2275642729241063494L;

    protected void transientInit() {
        this.a = (this._from.x == this._to.x ? 128 : 0) | (this._from.y == this._to.y ? 96 : 0);
    }

    public IlvLineSegment(IlvPoint ilvPoint, IlvPoint ilvPoint2) {
        this._from = ilvPoint;
        this._to = ilvPoint2;
        this.transientInit();
    }

    public IlvPoint getFrom() {
        return this._from;
    }

    public IlvPoint getTo() {
        return this._to;
    }

    public int getOrientation() {
        return this.a;
    }

    public int getDirection() {
        int n2 = this.getOrientation();
        if (n2 == 96) {
            n2 = this._from.x < this._to.x ? 2 : 1;
        } else if (n2 == 128) {
            n2 = this._from.y < this._to.y ? 8 : 4;
        }
        return n2;
    }

    public float length() {
        if (this.a == 0) {
            float f2 = this._to.x - this._from.x;
            float f3 = this._to.y - this._from.y;
            return (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        if (this.a == 96) {
            return Math.abs(this._to.x - this._from.x);
        }
        if (this.a == 128) {
            return Math.abs(this._to.y - this._from.y);
        }
        return 0.0f;
    }

    public IlvPoint nearestTo(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = this._from;
        IlvPoint ilvPoint3 = this._to;
        float f2 = ilvPoint2.x - ilvPoint3.x;
        float f3 = ilvPoint2.y - ilvPoint3.y;
        float f4 = ilvPoint2.x - ilvPoint.x;
        float f5 = ilvPoint2.y - ilvPoint.y;
        float f6 = ilvPoint3.x - ilvPoint.x;
        float f7 = ilvPoint3.y - ilvPoint.y;
        if (this.a == 0) {
            if (f2 * f4 + f3 * f5 <= 0.0f) {
                return ilvPoint2;
            }
            if (f2 * f6 + f3 * f7 >= 0.0f) {
                return ilvPoint3;
            }
            float f8 = (f2 * f4 + f3 * f5) / (f2 * f2 + f3 * f3);
            return new IlvPoint(ilvPoint2.x - f8 * f2, ilvPoint2.y - f8 * f3);
        }
        if (this.a == 96) {
            if (f2 * f4 <= 0.0f) {
                return ilvPoint2;
            }
            if (f2 * f6 >= 0.0f) {
                return ilvPoint3;
            }
            return new IlvPoint(ilvPoint.x, ilvPoint2.y);
        }
        if (this.a == 128) {
            if (f3 * f5 <= 0.0f) {
                return ilvPoint2;
            }
            if (f3 * f7 >= 0.0f) {
                return ilvPoint3;
            }
            return new IlvPoint(ilvPoint2.x, ilvPoint.y);
        }
        return ilvPoint2;
    }

    public float sqdist(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = this._from;
        IlvPoint ilvPoint3 = this._to;
        float f2 = ilvPoint2.x - ilvPoint3.x;
        float f3 = ilvPoint2.y - ilvPoint3.y;
        float f4 = ilvPoint2.x - ilvPoint.x;
        float f5 = ilvPoint2.y - ilvPoint.y;
        float f6 = ilvPoint3.x - ilvPoint.x;
        float f7 = ilvPoint3.y - ilvPoint.y;
        if (this.a == 0) {
            float f8;
            if (f2 * f4 + f3 * f5 <= 0.0f) {
                return f4 * f4 + f5 * f5;
            }
            if (f2 * f6 + f3 * f7 >= 0.0f) {
                return f6 * f6 + f7 * f7;
            }
            float f9 = f6 * f6 + f7 * f7;
            float f10 = f4 * f4 + f5 * f5;
            if (f9 < f10) {
                float f11 = f2 * f6 + f3 * f7;
                f8 = f9 - f11 * f11 / (f2 * f2 + f3 * f3);
            } else {
                float f12 = f2 * f4 + f3 * f5;
                f8 = f10 - f12 * f12 / (f2 * f2 + f3 * f3);
            }
            if (f8 < 0.0f) {
                f8 = 0.0f;
            }
            return f8;
        }
        if (this.a == 96) {
            if (f2 * f4 <= 0.0f) {
                return f4 * f4 + f5 * f5;
            }
            if (f2 * f6 >= 0.0f) {
                return f6 * f6 + f7 * f7;
            }
            return f7 * f7;
        }
        if (this.a == 128) {
            if (f3 * f5 <= 0.0f) {
                return f4 * f4 + f5 * f5;
            }
            if (f3 * f7 >= 0.0f) {
                return f6 * f6 + f7 * f7;
            }
            return f6 * f6;
        }
        return f4 * f4 + f5 * f5;
    }

    public boolean intersects(float f2, float f3, float f4, float f5) {
        float f6;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        if (this.a == 96) {
            if (ilvPoint.y < f3 || ilvPoint.y > f5) {
                return false;
            }
            return !(ilvPoint.x < f2 && ilvPoint2.x < f2) && (!(ilvPoint.x > f4) || !(ilvPoint2.x > f4));
        }
        if (this.a == 128) {
            if (ilvPoint.x < f2 || ilvPoint.x > f4) {
                return false;
            }
            return !(ilvPoint.y < f3 && ilvPoint2.y < f3) && (!(ilvPoint.y > f5) || !(ilvPoint2.y > f5));
        }
        if (this.a == 224) {
            return ilvPoint.x >= f2 && ilvPoint.x <= f4 && ilvPoint.y >= f3 && ilvPoint.y <= f5;
        }
        if (ilvPoint.x < f2 && ilvPoint2.x < f2 || ilvPoint.x > f4 && ilvPoint2.x > f4) {
            return false;
        }
        if (ilvPoint.y < f3 && ilvPoint2.y < f3 || ilvPoint.y > f5 && ilvPoint2.y > f5) {
            return false;
        }
        if (ilvPoint.x >= f2 && ilvPoint.x <= f4 && ilvPoint.y >= f3 && ilvPoint.y <= f5) {
            return true;
        }
        if (ilvPoint2.x >= f2 && ilvPoint2.x <= f4 && ilvPoint2.y >= f3 && ilvPoint2.y <= f5) {
            return true;
        }
        if (ilvPoint.x >= f2 && ilvPoint2.x <= f2 || ilvPoint.x <= f2 && ilvPoint2.x >= f2) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            f6 = ilvPoint.y + (f2 - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) / (ilvPoint2.x - ilvPoint.x);
            if (f6 >= f3 && f6 <= f5) {
                return true;
            }
        }
        if (ilvPoint.x >= f4 && ilvPoint2.x <= f4 || ilvPoint.x <= f4 && ilvPoint2.x >= f4) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            f6 = ilvPoint.y + (f4 - ilvPoint.x) * (ilvPoint2.y - ilvPoint.y) / (ilvPoint2.x - ilvPoint.x);
            if (f6 >= f3 && f6 <= f5) {
                return true;
            }
        }
        if (ilvPoint.y >= f3 && ilvPoint2.y <= f3 || ilvPoint.y <= f3 && ilvPoint2.y >= f3) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            f6 = ilvPoint.x + (f3 - ilvPoint.y) * (ilvPoint2.x - ilvPoint.x) / (ilvPoint2.y - ilvPoint.y);
            if (f6 >= f2 && f6 <= f4) {
                return true;
            }
        }
        if (ilvPoint.y >= f5 && ilvPoint2.y <= f5 || ilvPoint.y <= f5 && ilvPoint2.y >= f5) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            f6 = ilvPoint.x + (f5 - ilvPoint.y) * (ilvPoint2.x - ilvPoint.x) / (ilvPoint2.y - ilvPoint.y);
            if (f6 >= f2 && f6 <= f4) {
                return true;
            }
        }
        return false;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        double d6;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        if (this.a == 96) {
            if ((double)ilvPoint.y < d3 || (double)ilvPoint.y > d5) {
                return false;
            }
            return !((double)ilvPoint.x < d2 && (double)ilvPoint2.x < d2) && (!((double)ilvPoint.x > d4) || !((double)ilvPoint2.x > d4));
        }
        if (this.a == 128) {
            if ((double)ilvPoint.x < d2 || (double)ilvPoint.x > d4) {
                return false;
            }
            return !((double)ilvPoint.y < d3 && (double)ilvPoint2.y < d3) && (!((double)ilvPoint.y > d5) || !((double)ilvPoint2.y > d5));
        }
        if (this.a == 224) {
            return (double)ilvPoint.x >= d2 && (double)ilvPoint.x <= d4 && (double)ilvPoint.y >= d3 && (double)ilvPoint.y <= d5;
        }
        if ((double)ilvPoint.x < d2 && (double)ilvPoint2.x < d2 || (double)ilvPoint.x > d4 && (double)ilvPoint2.x > d4) {
            return false;
        }
        if ((double)ilvPoint.y < d3 && (double)ilvPoint2.y < d3 || (double)ilvPoint.y > d5 && (double)ilvPoint2.y > d5) {
            return false;
        }
        if ((double)ilvPoint.x >= d2 && (double)ilvPoint.x <= d4 && (double)ilvPoint.y >= d3 && (double)ilvPoint.y <= d5) {
            return true;
        }
        if ((double)ilvPoint2.x >= d2 && (double)ilvPoint2.x <= d4 && (double)ilvPoint2.y >= d3 && (double)ilvPoint2.y <= d5) {
            return true;
        }
        if ((double)ilvPoint.x >= d2 && (double)ilvPoint2.x <= d2 || (double)ilvPoint.x <= d2 && (double)ilvPoint2.x >= d2) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            d6 = (double)ilvPoint.y + (d2 - (double)ilvPoint.x) * (double)(ilvPoint2.y - ilvPoint.y) / (double)(ilvPoint2.x - ilvPoint.x);
            if (d6 >= d3 && d6 <= d5) {
                return true;
            }
        }
        if ((double)ilvPoint.x >= d4 && (double)ilvPoint2.x <= d4 || (double)ilvPoint.x <= d4 && (double)ilvPoint2.x >= d4) {
            if (ilvPoint.x == ilvPoint2.x) {
                return true;
            }
            d6 = (double)ilvPoint.y + (d4 - (double)ilvPoint.x) * (double)(ilvPoint2.y - ilvPoint.y) / (double)(ilvPoint2.x - ilvPoint.x);
            if (d6 >= d3 && d6 <= d5) {
                return true;
            }
        }
        if ((double)ilvPoint.y >= d3 && (double)ilvPoint2.y <= d3 || (double)ilvPoint.y <= d3 && (double)ilvPoint2.y >= d3) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            d6 = (double)ilvPoint.x + (d3 - (double)ilvPoint.y) * (double)(ilvPoint2.x - ilvPoint.x) / (double)(ilvPoint2.y - ilvPoint.y);
            if (d6 >= d2 && d6 <= d4) {
                return true;
            }
        }
        if ((double)ilvPoint.y >= d5 && (double)ilvPoint2.y <= d5 || (double)ilvPoint.y <= d5 && (double)ilvPoint2.y >= d5) {
            if (ilvPoint.y == ilvPoint2.y) {
                return true;
            }
            d6 = (double)ilvPoint.x + (d5 - (double)ilvPoint.y) * (double)(ilvPoint2.x - ilvPoint.x) / (double)(ilvPoint2.y - ilvPoint.y);
            if (d6 >= d2 && d6 <= d4) {
                return true;
            }
        }
        return false;
    }

    public boolean isParallelTo(IlvLineSegment ilvLineSegment) {
        return this.a == ilvLineSegment.a && (this._to.x - this._from.x) * (ilvLineSegment._to.y - ilvLineSegment._from.y) == (ilvLineSegment._to.x - ilvLineSegment._from.x) * (this._to.y - this._from.y);
    }

    public boolean isParallelVectorTo(IlvLineSegment ilvLineSegment) {
        return this.isParallelTo(ilvLineSegment) && this._from.x < this._to.x == ilvLineSegment._from.x < ilvLineSegment._to.x && this._from.y < this._to.y == ilvLineSegment._from.y < ilvLineSegment._to.y;
    }

    public Object clone() {
        IlvLineSegment ilvLineSegment = (IlvLineSegment)super.clone();
        ilvLineSegment._from = this._from;
        ilvLineSegment._to = this._to;
        ilvLineSegment.transientInit();
        return ilvLineSegment;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        objectOutputStream.writeObject(this._from);
        objectOutputStream.writeObject(this._to);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        if (by != 1) {
            throw new InvalidClassException("Unsupported version " + by + " in readObject of class " + this.getClass());
        }
        this._from = (IlvPoint)objectInputStream.readObject();
        this._to = (IlvPoint)objectInputStream.readObject();
        this.transientInit();
    }

    public double getX1() {
        return this._from.x;
    }

    public double getY1() {
        return this._from.y;
    }

    public double getX2() {
        return this._to.x;
    }

    public double getY2() {
        return this._to.y;
    }

    public Point2D getP1() {
        return this._from;
    }

    public Point2D getP2() {
        return this._to;
    }

    public void setLine(double d2, double d3, double d4, double d5) {
        this._from = new IlvPoint((float)d2, (float)d3);
        this._to = new IlvPoint((float)d4, (float)d5);
    }

    public Rectangle2D getBounds2D() {
        float f2;
        float f3;
        float f4;
        float f5;
        IlvPoint ilvPoint = this._from;
        IlvPoint ilvPoint2 = this._to;
        float f6 = ilvPoint.x;
        float f7 = ilvPoint.y;
        float f8 = ilvPoint2.x;
        float f9 = ilvPoint2.y;
        if (f6 <= f8) {
            f5 = f6;
            f4 = f8 - f6;
        } else {
            f5 = f8;
            f4 = f6 - f8;
        }
        if (f7 <= f9) {
            f3 = f7;
            f2 = f9 - f7;
        } else {
            f3 = f9;
            f2 = f7 - f9;
        }
        return new IlvRect(f5, f3, f4, f2);
    }

    public String toString() {
        return this.getClass().getName() + "[(" + this._from.x + "," + this._from.y + ")-(" + this._to.x + "," + this._to.y + ")]";
    }
}

