/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvGrid;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.IlvListenerList;
import ilog.views.interactor.RectangleDraggedEvent;
import ilog.views.interactor.RectangleDraggedListener;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class IlvDragRectangleInteractor
extends IlvManagerViewInteractor {
    private final transient IlvPoint a = new IlvPoint();
    private final transient IlvPoint b = new IlvPoint();
    IlvRect c = new IlvRect();
    private transient boolean d = false;
    private transient boolean e = false;
    private float f = 0.0f;
    private float[] g;
    private boolean h;
    private transient IlvPoint[] i;
    private IlvListenerList j = new IlvListenerList();
    private transient RectangleDraggedEvent k;
    private Cursor l;
    private Cursor m;
    private int n = 16;
    private boolean o = false;

    public IlvDragRectangleInteractor() {
        this.enableEvents(48L);
        this.setOpaqueMode(false);
    }

    public final boolean isGridMode() {
        return this.e;
    }

    public final void setGridMode(boolean bl) {
        this.e = bl;
    }

    public void setOpaqueMode(boolean bl) {
        this.h = bl;
    }

    public boolean isOpaqueMode() {
        return this.h;
    }

    public boolean isXORGhost() {
        return this.isOpaqueMode() ? super.isXORGhost() : true;
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        if (!this.getCursor().equals(ilvManagerView.getCursor())) {
            this.m = ilvManagerView.isCursorSet() ? ilvManagerView.getCursor() : null;
            ilvManagerView.setCursor(this.getCursor());
        }
    }

    protected void detach() {
        this.f();
        this.getManagerView().setCursor(this.m);
        this.m = null;
        this.d = false;
        this.c.width = 0.0f;
        this.c.height = 0.0f;
        super.detach();
    }

    public Cursor getCursor() {
        if (this.l == null) {
            if (this.getManagerView() != null) {
                return this.getManagerView().getCursor();
            }
            return Cursor.getDefaultCursor();
        }
        return this.l;
    }

    public void setCursor(Cursor cursor) {
        this.l = cursor;
    }

    public float getRectangleAspectRatio() {
        return this.f;
    }

    public void setRectangleAspectRatio(float f2) {
        this.f = f2;
    }

    float a() {
        IlvGrid ilvGrid;
        if (this.e && (ilvGrid = this.getManagerView().getGrid()) != null && ilvGrid.isActive()) {
            return ilvGrid.getHorizontalSpacing();
        }
        return 0.0f;
    }

    float b() {
        IlvGrid ilvGrid;
        if (this.e && (ilvGrid = this.getManagerView().getGrid()) != null && ilvGrid.isActive()) {
            return ilvGrid.getVerticalSpacing();
        }
        return 0.0f;
    }

    private float d() {
        float f2 = this.a();
        return this.a(f2);
    }

    private float e() {
        float f2 = this.b();
        return this.a(f2);
    }

    float a(float f2) {
        IlvTransformer ilvTransformer = this.getTransformer();
        if (f2 == 0.0f || ilvTransformer == null || ilvTransformer.isIdentity()) {
            return f2;
        }
        IlvPoint ilvPoint = new IlvPoint(0.0f, 0.0f);
        IlvPoint ilvPoint2 = new IlvPoint(0.0f, f2);
        ilvTransformer.apply(ilvPoint);
        ilvTransformer.apply(ilvPoint2);
        double d2 = ilvPoint2.x - ilvPoint.x;
        double d3 = ilvPoint2.y - ilvPoint.y;
        return (float)Math.sqrt(d2 * d2 + d3 * d3);
    }

    protected IlvPoint getStartPoint() {
        return new IlvPoint(this.a);
    }

    public void setLineStyle(float[] fArray) {
        this.g = fArray;
    }

    public float[] getLineStyle() {
        return this.g;
    }

    public final void setStartDragModifier(int n2) {
        this.n = n2;
    }

    public final int getStartDragModifier() {
        return this.n;
    }

    protected boolean isStartDragModifierDown(MouseEvent mouseEvent) {
        return (mouseEvent.getModifiers() & this.getStartDragModifier()) != 0;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.handleButtonDown(mouseEvent);
                break;
            }
            case 502: {
                this.handleButtonUp(mouseEvent);
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506) {
            this.handleButtonDragged(mouseEvent);
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    protected boolean handleButtonDown(MouseEvent mouseEvent) {
        if (this.d) {
            return false;
        }
        if (this.isStartDragModifierDown(mouseEvent)) {
            this.d = true;
            IlvTransformer ilvTransformer = this.getTransformer();
            this.b.move(mouseEvent.getX(), mouseEvent.getY());
            if (this.e) {
                this.getManagerView().snapToGrid(this.b);
            }
            this.a.setLocation(this.b);
            if (this.isRotationAllowed()) {
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(this.a);
                }
                this.c.reshape(this.a.x, this.a.y, 0.0f, 0.0f);
            } else {
                this.c.reshape(this.b.x, this.b.y, 0.0f, 0.0f);
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(this.a);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean handleButtonDragged(MouseEvent mouseEvent) {
        if (!this.d) {
            return false;
        }
        this.c();
        this.a(mouseEvent.getX(), mouseEvent.getY(), this.getTransformer());
        this.c();
        return true;
    }

    void a(float f2, float f3, IlvTransformer ilvTransformer) {
        float f4;
        float f5;
        IlvPoint ilvPoint = new IlvPoint(f2, f3);
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        if (this.e) {
            this.getManagerView().snapToGrid(ilvPoint);
        }
        float f6 = this.getRectangleAspectRatio();
        boolean bl = this.isRotationAllowed();
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (bl) {
            f7 = this.a.x;
            f8 = this.a.y;
            this.c.reshape(f7, f8, 0.0f, 0.0f);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(ilvPoint);
                ilvTransformer.inverse(ilvPoint2);
            }
            this.c.add(ilvPoint.x, ilvPoint.y);
            if (f6 > 0.0f) {
                if (this.c.width > f6 * this.c.height) {
                    this.c.height = this.c.width / f6;
                } else {
                    this.c.width = f6 * this.c.height;
                }
                if (this.c.x == ilvPoint.x) {
                    this.c.x = f7 - this.c.width;
                }
                if (this.c.y == ilvPoint.y) {
                    this.c.y = f8 - this.c.height;
                }
            }
        } else {
            float f9;
            f7 = this.b.x;
            f8 = this.b.y;
            f5 = ilvPoint.x - f7;
            f4 = ilvPoint.y - f8;
            float f10 = ilvPoint.x < f7 ? ilvPoint.x : f7;
            float f11 = ilvPoint.y < f8 ? ilvPoint.y : f8;
            float f12 = f5 > 0.0f ? f5 : -f5;
            float f13 = f9 = f4 > 0.0f ? f4 : -f4;
            if (f6 > 0.0f) {
                float f14;
                if (f12 > f6 * f9) {
                    f14 = f12 / f6;
                    if (f4 < 0.0f) {
                        f11 += f9 - f14;
                    }
                    f9 = f14;
                } else {
                    f14 = f6 * f9;
                    if (f5 < 0.0f) {
                        f10 += f12 - f14;
                    }
                    f12 = f14;
                }
            }
            this.c.reshape(f10, f11, f12, f9);
        }
        f5 = bl ? this.a() : this.d();
        float f15 = f4 = bl ? this.b() : this.e();
        if (this.c.width < f5) {
            if (ilvPoint2.x < f7) {
                this.c.x = f7 - f5;
                this.c.width = f5;
                ilvPoint.x = this.c.x;
            } else {
                this.c.width = f5;
                ilvPoint.x = this.c.x + this.c.width;
            }
        }
        if (this.c.height < f4) {
            if (ilvPoint2.y < f8) {
                this.c.y = f8 - f4;
                this.c.height = f4;
                ilvPoint.y = this.c.y;
            } else {
                this.c.height = f4;
                ilvPoint.y = this.c.y + this.c.height;
            }
        }
        if (bl) {
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            this.a(ilvPoint);
        } else {
            double d2 = 0.0;
            double d3 = 0.0;
            IlvTransformer ilvTransformer2 = this.getTransformer();
            if (ilvTransformer2 != null) {
                d2 = ilvTransformer2.getx0();
                d3 = ilvTransformer2.gety0();
            }
            this.a(ilvPoint);
            ilvTransformer2 = this.getTransformer();
            if (ilvTransformer2 != null) {
                d2 = ilvTransformer2.getx0() - d2;
                d3 = ilvTransformer2.gety0() - d3;
            }
            if (d2 != 0.0 || d3 != 0.0) {
                this.b.x = (float)((double)this.b.x + d2);
                this.b.y = (float)((double)this.b.y + d3);
                this.c.reshape(this.c.x + (float)d2, this.c.y + (float)d3, this.c.width - (float)d2, this.c.height - (float)d3);
            }
        }
    }

    private void a(IlvPoint ilvPoint) {
        boolean bl = this.getManagerView().isOptimizedTranslation();
        if (!bl) {
            this.f();
        }
        this.ensureVisible(ilvPoint);
        if (!bl) {
            this.drawGhost();
        }
    }

    protected boolean handleButtonUp(MouseEvent mouseEvent) {
        IlvTransformer ilvTransformer;
        if (!this.d) {
            return false;
        }
        this.d = false;
        IlvRect ilvRect = new IlvRect(this.c);
        this.f();
        this.c.width = 0.0f;
        this.c.height = 0.0f;
        if (!this.isRotationAllowed() && (ilvTransformer = this.getTransformer()) != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.boundingBox(ilvRect, true);
        }
        this.fireRectangleDraggedEvent(ilvRect, mouseEvent);
        return true;
    }

    protected void drawGhost(Graphics graphics) {
        IlvRect ilvRect = this.getDraggedRectangle();
        if (ilvRect.width <= 0.0f || ilvRect.height <= 0.0f) {
            return;
        }
        float[] fArray = this.getLineStyle();
        if (this.isRotationAllowed()) {
            IlvPoint[] ilvPointArray = this.a(ilvRect, this.getTransformer());
            if (!this.isOpaqueMode() && fArray == null) {
                fArray = new float[]{100000.0f};
            }
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 5, 1.0f, 1, 0, fArray, null);
        } else if (fArray == null) {
            graphics.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
        } else {
            IlvPoint[] ilvPointArray = this.a(ilvRect, null);
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, 5, 1.0f, 0, 0, fArray, null);
        }
    }

    private IlvPoint[] a(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        if (this.i == null) {
            this.i = new IlvPoint[5];
            for (int i2 = 0; i2 < 5; ++i2) {
                this.i[i2] = new IlvPoint();
            }
        }
        this.i[0].move(ilvRect.x, ilvRect.y);
        this.i[1].move(ilvRect.x + ilvRect.width, ilvRect.y);
        this.i[2].move(ilvRect.x + ilvRect.width, ilvRect.y + ilvRect.height);
        this.i[3].move(ilvRect.x, ilvRect.y + ilvRect.height);
        this.i[4].move(ilvRect.x, ilvRect.y);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(this.i[0]);
            ilvTransformer.apply(this.i[1]);
            ilvTransformer.apply(this.i[2]);
            ilvTransformer.apply(this.i[3]);
            ilvTransformer.apply(this.i[4]);
        }
        return this.i;
    }

    private void f() {
        this.c();
    }

    void c() {
        if (this.isOpaqueMode()) {
            IlvManagerView ilvManagerView = this.getManagerView();
            if (ilvManagerView == null) {
                return;
            }
            if (this.c != null && this.c.width > 0.0f && this.c.height > 0.0f) {
                IlvTransformer ilvTransformer;
                IlvRect ilvRect = new IlvRect(this.c);
                if (this.isRotationAllowed() && (ilvTransformer = this.getTransformer()) != null) {
                    ilvTransformer.boundingBox(ilvRect, false);
                }
                ilvManagerView.invalidateRect(ilvRect);
                ilvManagerView.reDrawViews();
            }
        } else {
            this.drawGhost();
        }
    }

    public void addRectangleDraggedListener(RectangleDraggedListener rectangleDraggedListener) {
        this.j.add(rectangleDraggedListener);
    }

    public void removeRectangleDraggedListener(RectangleDraggedListener rectangleDraggedListener) {
        this.j.remove(rectangleDraggedListener);
    }

    protected void fireRectangleDraggedEvent(IlvRect ilvRect, MouseEvent mouseEvent) {
        Object[] objectArray = this.j.getListenerList();
        int n2 = objectArray.length;
        if (n2 != 0) {
            if (this.k == null) {
                this.k = new RectangleDraggedEvent(this, ilvRect, mouseEvent);
            } else {
                this.k.a(this);
                this.k.a(ilvRect);
                this.k.a(mouseEvent);
            }
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                ((RectangleDraggedListener)objectArray[i2]).rectangleDragged(this.k);
            }
        }
    }

    public IlvRect getDraggedRectangle() {
        return this.c;
    }

    public void setRotationAllowed(boolean bl) {
        this.o = bl;
    }

    public boolean isRotationAllowed() {
        return this.o;
    }
}

