/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.interactor;

import ilog.views.IlvApplyObject;
import ilog.views.IlvFontInterface;
import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLabelInterface;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvManagerViewInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvToolkit;
import ilog.views.IlvTransformer;
import ilog.views.event.TransformerChangedEvent;
import ilog.views.event.TransformerListener;
import ilog.views.graphic.IlvLabel;
import ilog.views.interactor.IlvLabeledObjectFactory;
import ilog.views.interactor.IlvLabelledObjectFactory;
import ilog.views.interactor.IlvPermanentInteractorInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class IlvEditLabelInteractor
extends IlvManagerViewInteractor
implements IlvPermanentInteractorInterface {
    private Color a = Color.black;
    private Font b = IlvToolkit.defaultFont;
    private IlvGraphic c;
    private IlvManager d;
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;
    private boolean h = true;
    private boolean i = true;
    private IlvLabeledObjectFactory j;
    private IlvPoint k;
    private boolean l = true;
    private TransformerListener m = new ViewTransformerListener();
    private ValidationListener n = new ValidationListener();
    private Component o;
    private JScrollPane p;

    public IlvEditLabelInteractor() {
        this.enableEvents(16L);
    }

    protected void attach(IlvManagerView ilvManagerView) {
        super.attach(ilvManagerView);
        ilvManagerView.addTransformerListener(this.m);
        this.g = false;
    }

    protected void detach() {
        this.getManagerView().removeTransformerListener(this.m);
        this.a();
        super.detach();
    }

    public final boolean isEditionAllowed() {
        return this.i;
    }

    public final void setEditionAllowed(boolean bl) {
        this.i = bl;
        if (!bl) {
            this.h = true;
        }
    }

    public final boolean isCreationAllowed() {
        return this.h;
    }

    public final void setCreationAllowed(boolean bl) {
        this.h = bl;
        if (!bl) {
            this.i = true;
        }
    }

    public void setCreationInSubManagersAllowed(boolean bl) {
        this.l = bl;
    }

    public boolean isCreationInSubManagersAllowed() {
        return this.l;
    }

    private final void a() {
        if (this.o != null && this.getManagerView() != null) {
            Rectangle rectangle = this.getManagerView().isInSwingParent() ? this.d() : null;
            Component component = this.o instanceof JTextArea ? this.p : this.o;
            this.o = null;
            this.p = null;
            this.getManagerView().remove(component);
            if (rectangle != null) {
                this.getManagerView().invalidateRect(new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                this.getManagerView().reDrawViews();
            }
        }
        this.c = null;
        this.d = null;
        this.g = false;
    }

    public final boolean isPermanent() {
        return this.e;
    }

    public final void setPermanent(boolean bl) {
        this.e = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addObject(IlvGraphic ilvGraphic) {
        IlvManager ilvManager;
        IlvManager ilvManager2 = ilvManager = this.getManager();
        IlvTransformer ilvTransformer = this.getTransformer();
        if (this.isCreationInSubManagersAllowed()) {
            IlvGraphic ilvGraphic2;
            IlvPoint ilvPoint = new IlvPoint(this.k);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint);
            }
            if ((ilvGraphic2 = ilvManager2.getObject(ilvPoint, this.getManagerView(), true)) != null) {
                if (ilvGraphic2 instanceof IlvManager && ilvGraphic2 != ilvManager2) {
                    ilvManager2 = (IlvManager)ilvGraphic2;
                } else if (ilvGraphic2.getGraphicBag() != ilvManager2 && ilvGraphic2.getGraphicBag() instanceof IlvManager) {
                    ilvManager2 = (IlvManager)ilvGraphic2.getGraphicBag();
                }
            }
            this.d = ilvManager2;
            if (ilvManager2 != ilvManager) {
                IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
                IlvTransformer ilvTransformer2 = ilvManager2.getDrawingTransformer(this.getManagerView());
                if (ilvTransformer2 != null) {
                    ilvTransformer2.inverse(ilvRect);
                }
                ilvGraphic.moveResize(ilvRect);
            }
        }
        if (ilvManager2 != ilvManager) {
            ilvManager2.setContentsAdjusting(true, true);
        }
        try {
            if (this.isGrapherMode() && ilvManager2 instanceof IlvGrapher) {
                ((IlvGrapher)ilvManager2).addNode(ilvGraphic, true);
            } else {
                ilvManager2.addObject(ilvGraphic, true);
            }
        }
        finally {
            if (ilvManager2 != ilvManager) {
                ilvManager2.setContentsAdjusting(false, true);
            }
        }
    }

    protected IlvGraphic makeObject(IlvPoint ilvPoint, String string) {
        IlvGraphic ilvGraphic = null;
        if (string != null && !string.equals("")) {
            if (this.j != null) {
                ilvGraphic = this.j.createObject(ilvPoint, string, this.getFont(), this.getForeground());
            } else {
                IlvLabel ilvLabel = new IlvLabel(ilvPoint, string);
                ilvLabel.setFont(this.getFont());
                ilvLabel.setForeground(this.getForeground());
                ilvGraphic = ilvLabel;
            }
        }
        return ilvGraphic;
    }

    public final void setObjectFactory(IlvLabeledObjectFactory ilvLabeledObjectFactory) {
        this.j = ilvLabeledObjectFactory;
    }

    public final void setObjectFactory(IlvLabelledObjectFactory ilvLabelledObjectFactory) {
        final IlvLabelledObjectFactory ilvLabelledObjectFactory2 = ilvLabelledObjectFactory;
        this.setObjectFactory(new IlvLabeledObjectFactory(){

            public IlvGraphic createObject(IlvPoint ilvPoint, String string, Font font, Color color) {
                return ilvLabelledObjectFactory2.createObject(ilvPoint, string, font, color);
            }
        });
    }

    public IlvLabeledObjectFactory getObjectFactory() {
        return this.j;
    }

    protected String getObjectLabel(IlvGraphic ilvGraphic) {
        if (!(ilvGraphic instanceof IlvLabelInterface)) {
            throw new IllegalArgumentException("object must implement IlvLabelInterface");
        }
        return ((IlvLabelInterface)((Object)ilvGraphic)).getLabel();
    }

    protected void setObjectLabel(IlvGraphic ilvGraphic, String string) {
        if (!(ilvGraphic instanceof IlvLabelInterface)) {
            throw new IllegalArgumentException("object must implement IlvLabelInterface");
        }
        ((IlvLabelInterface)((Object)ilvGraphic)).setLabel(string);
    }

    protected boolean supportMultiline(IlvGraphic ilvGraphic) {
        if (ilvGraphic != null) {
            if (!(ilvGraphic instanceof IlvLabelInterface)) {
                throw new IllegalArgumentException("object must implement IlvLabelInterface");
            }
            return ((IlvLabelInterface)((Object)ilvGraphic)).supportMultiline();
        }
        return false;
    }

    protected IlvRect getLabelBBox(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
        if (!(ilvGraphic instanceof IlvLabelInterface)) {
            return ilvGraphic.boundingBox(ilvTransformer);
        }
        IlvRect ilvRect = ((IlvLabelInterface)((Object)ilvGraphic)).getLabelBBox(ilvTransformer);
        if (ilvRect == null) {
            ilvRect = ilvGraphic.boundingBox(ilvTransformer);
        } else {
            ilvRect.intersection(ilvGraphic.boundingBox(ilvTransformer));
        }
        return ilvRect;
    }

    protected Font getEditionFont(IlvGraphic ilvGraphic) {
        if (ilvGraphic instanceof IlvFontInterface) {
            return ((IlvFontInterface)((Object)ilvGraphic)).getFont();
        }
        return IlvToolkit.defaultFont;
    }

    protected Component createEditComponent(boolean bl, boolean bl2, ActionListener actionListener, FocusListener focusListener) {
        Component component;
        if (!bl) {
            if (bl2) {
                component = new TextArea("", 5, 2, 3);
            } else {
                component = new TextField(5);
                ((TextField)component).addActionListener(actionListener);
            }
        } else if (bl2) {
            component = new JTextArea("", 5, 2);
            ((JTextArea)component).setMargin(new Insets(2, 2, 2, 2));
            ((JTextArea)component).setLineWrap(true);
        } else {
            component = new JTextField(5);
            ((JTextField)component).addActionListener(actionListener);
        }
        component.addFocusListener(focusListener);
        return component;
    }

    protected void editObject(IlvGraphic ilvGraphic, IlvPoint ilvPoint) {
        this.c = ilvGraphic;
        this.g = true;
        IlvTransformer ilvTransformer = this.getTransformer();
        if (ilvGraphic != null) {
            IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
            IlvManager ilvManager = this.d = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
            if (this.d != null && this.d != this.getManager()) {
                ilvTransformer = this.d.getDrawingTransformer(this.getManagerView());
            }
            this.k = null;
        } else {
            this.d = null;
            this.k = new IlvPoint(ilvPoint.x, ilvPoint.y);
            if (ilvTransformer != null) {
                ilvTransformer.inverse(this.k);
            }
        }
        boolean bl = this.supportMultiline(ilvGraphic);
        boolean bl2 = this.getManagerView().isInSwingParent();
        this.o = this.createEditComponent(bl2, bl, this.n, this.n);
        if (bl2 && bl) {
            this.p = new JScrollPane(this.o, 21, 31);
        }
        String string = null;
        Font font = null;
        if (ilvGraphic != null) {
            string = this.getObjectLabel(ilvGraphic);
            font = this.getEditionFont(ilvGraphic);
        }
        if (string == null) {
            string = "";
        }
        if (font == null) {
            font = this.getFont();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object object = new FontRenderContext(null, false, false);
        LineMetrics lineMetrics = font.getLineMetrics(string, (FontRenderContext)object);
        int n5 = (int)lineMetrics.getHeight();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ++n3;
            int n6 = (int)font.getStringBounds(string2, (FontRenderContext)object).getWidth();
            if (n2 >= n6) continue;
            n2 = n6;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (this.o instanceof TextArea) {
            n4 = 6;
        } else if (this.o instanceof TextField) {
            n4 = 8;
        }
        this.o.setVisible(false);
        if (!(this.o instanceof JTextArea)) {
            this.getManagerView().add(this.o);
        } else {
            this.getManagerView().add(this.p);
        }
        this.a(string);
        this.o.setFont(font);
        object = this.getEditingAreaBBox(ilvGraphic, ilvPoint, n3, n2, n5, n4, ilvTransformer);
        this.a((int)((Rectangle2D.Float)object).x, (int)((Rectangle2D.Float)object).y, (int)((Rectangle2D.Float)object).width, (int)((Rectangle2D.Float)object).height);
        this.o.setVisible(true);
        this.o.requestFocus();
    }

    protected IlvRect getEditingAreaBBox(IlvGraphic ilvGraphic, IlvPoint ilvPoint, int n2, int n3, int n4, int n5, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(ilvPoint.x, ilvPoint.y, 1.0f, 1.0f);
        ilvRect.width = this.o.getPreferredSize().width;
        ilvRect.height = this.o.getPreferredSize().height;
        if (ilvGraphic != null) {
            IlvRect ilvRect2 = this.getLabelBBox(ilvGraphic, ilvTransformer);
            boolean bl = this.supportMultiline(ilvGraphic);
            ilvRect.width = Math.max(ilvRect.width, ilvRect2.width);
            ilvRect.height = Math.max(ilvRect.height, ilvRect2.height);
            ilvRect.width = Math.max(ilvRect.width, (float)n3) + (float)(2 * n5);
            ilvRect.height = Math.max(ilvRect.height, (float)((n2 + (bl ? 4 : 0)) * n4));
            ilvRect.x = ilvRect2.x + (float)((int)ilvRect2.width / 2) - (float)((int)ilvRect.width / 2);
            ilvRect.y = ilvRect2.y;
        }
        return ilvRect;
    }

    private final void b() {
        if ((this.c == null || this.d != null && this.d.isManaged(this.c)) && this.g) {
            this.g = false;
            if (this.c != null && this.d != null) {
                this.d.applyToObject(this.c, new ApplyChange(), this.c(), true);
            } else {
                IlvGraphic ilvGraphic;
                IlvTransformer ilvTransformer = this.getTransformer();
                Rectangle rectangle = this.d();
                IlvRect ilvRect = new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (ilvTransformer != null) {
                    ilvTransformer.inverse(ilvRect);
                }
                IlvPoint ilvPoint = new IlvPoint(ilvRect.x + ilvRect.width / 2.0f, ilvRect.y + ilvRect.height / 2.0f);
                if (this.getManagerView().getGrid() != null) {
                    if (ilvTransformer != null) {
                        ilvTransformer.apply(ilvPoint);
                    }
                    this.getManagerView().snapToGrid(ilvPoint);
                    if (ilvTransformer != null) {
                        ilvTransformer.inverse(ilvPoint);
                    }
                }
                if ((ilvGraphic = this.makeObject(ilvPoint, this.c())) != null) {
                    this.addObject(ilvGraphic);
                }
            }
        }
        if (!this.e) {
            if (this.getManagerView() != null) {
                this.getManagerView().popInteractor();
            }
        } else {
            this.a();
        }
    }

    protected boolean accept(IlvGraphic ilvGraphic) {
        return ilvGraphic instanceof IlvLabelInterface;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                IlvGraphic ilvGraphic = null;
                if (this.g && this.e) {
                    this.b();
                }
                if (this.g) break;
                IlvPoint ilvPoint = new IlvPoint(mouseEvent.getX(), mouseEvent.getY());
                if (this.i) {
                    IlvManager ilvManager = this.getManager();
                    ilvGraphic = ilvManager.getSelection(ilvPoint, this.getManagerView(), true);
                    ilvGraphic = ilvGraphic != null ? ilvGraphic.getObject() : ilvManager.getObject(ilvPoint, this.getManagerView(), true);
                    if (ilvGraphic != null) {
                        if (this.accept(ilvGraphic)) {
                            this.editObject(ilvGraphic, ilvPoint);
                            break;
                        }
                        if (this.h) {
                            this.editObject(null, ilvPoint);
                            break;
                        }
                        if (this.e) break;
                        this.getManagerView().popInteractor();
                        break;
                    }
                    if (this.h) {
                        this.editObject(null, ilvPoint);
                        break;
                    }
                    if (this.e) break;
                    this.getManagerView().popInteractor();
                    break;
                }
                this.editObject(null, ilvPoint);
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public Color getForeground() {
        return this.a;
    }

    public void setForeground(Color color) {
        this.a = color;
    }

    public Font getFont() {
        return this.b;
    }

    public void setFont(Font font) {
        this.b = font;
    }

    public boolean isGrapherMode() {
        return this.f;
    }

    public void setGrapherMode(boolean bl) {
        this.f = bl;
    }

    private void a(String string) {
        if (this.getManagerView().isInSwingParent()) {
            ((JTextComponent)this.o).setText(string);
        } else {
            ((TextComponent)this.o).setText(string);
        }
    }

    private String c() {
        if (this.getManagerView().isInSwingParent()) {
            return ((JTextComponent)this.o).getText();
        }
        return ((TextComponent)this.o).getText();
    }

    protected boolean ensureEditAreaInView() {
        return true;
    }

    private void a(int n2, int n3, int n4, int n5) {
        if (this.ensureEditAreaInView()) {
            Container container = this.o instanceof JTextArea ? this.p.getParent() : this.o.getParent();
            Rectangle rectangle = container.getBounds();
            if (n4 > rectangle.width) {
                n4 = rectangle.width;
            }
            if (n5 > rectangle.height) {
                n5 = rectangle.height;
            }
            if (n2 + n4 > rectangle.width) {
                n2 = rectangle.width - n4;
            }
            if (n3 + n5 > rectangle.height) {
                n3 = rectangle.height - n5;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 < 0) {
                n3 = 0;
            }
        }
        if (this.o instanceof JTextArea) {
            this.p.setBounds(n2, n3, n4, n5);
        } else {
            this.o.setBounds(n2, n3, n4, n5);
        }
    }

    private Rectangle d() {
        if (this.o instanceof JTextArea) {
            return this.p.getBounds();
        }
        return this.o.getBounds();
    }

    private final class ApplyChange
    implements IlvApplyObject {
        private ApplyChange() {
        }

        public void apply(IlvGraphic ilvGraphic, Object object) {
            String string = (String)object;
            IlvEditLabelInteractor.this.setObjectLabel(ilvGraphic, string);
        }
    }

    private final class ValidationListener
    extends FocusAdapter
    implements ActionListener {
        private ValidationListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getComponent() == IlvEditLabelInteractor.this.o || focusEvent.getComponent() == IlvEditLabelInteractor.this.p) {
                IlvEditLabelInteractor.this.b();
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            IlvEditLabelInteractor.this.b();
        }
    }

    private final class ViewTransformerListener
    implements TransformerListener {
        private ViewTransformerListener() {
        }

        public void transformerChanged(TransformerChangedEvent transformerChangedEvent) {
            if (IlvEditLabelInteractor.this.o != null) {
                Rectangle rectangle = IlvEditLabelInteractor.this.d();
                IlvRect ilvRect = new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (transformerChangedEvent.getOldValue() != null) {
                    transformerChangedEvent.getOldValue().inverse(ilvRect);
                }
                if (transformerChangedEvent.getNewValue() != null) {
                    transformerChangedEvent.getNewValue().applyFloor(ilvRect);
                }
                if (rectangle.x != (int)ilvRect.x || rectangle.y != (int)ilvRect.y || rectangle.width != (int)ilvRect.width || rectangle.height != (int)ilvRect.height) {
                    IlvEditLabelInteractor.this.getManagerView().invalidateRect(new IlvRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                    IlvEditLabelInteractor.this.getManagerView().reDrawViews();
                    IlvEditLabelInteractor.this.a((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                }
            }
        }
    }
}

