/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.java2d;

import ilog.views.IlvTransformer;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.io.IOException;

public abstract class IlvMultipleGradientPaint
implements Paint,
IlvPersistentObject {
    private int a = 1;
    float[] b;
    Color[] c;
    AffineTransform d;
    short e;
    short f;
    boolean g;
    public static final short SPREAD_PAD = 1;
    public static final short SPREAD_REFLECT = 2;
    public static final short SPREAD_REPEAT = 3;
    public static final short SRGB = 0;
    public static final short LINEAR_RGB = 1;

    IlvMultipleGradientPaint(float[] fArray, Color[] colorArray, short s2, short s3, AffineTransform affineTransform, boolean bl) {
        if (colorArray.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        if (s3 != 1 && s3 != 0) {
            throw new IllegalArgumentException("Invalid colorspace for interpolation");
        }
        if (s2 != 1 && s2 != 2 && s2 != 3) {
            throw new IllegalArgumentException("Invalid spread method");
        }
        int n2 = fArray.length;
        this.b = new float[n2];
        System.arraycopy(fArray, 0, this.b, 0, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.b[i2] < 0.0f) {
                this.b[i2] = 0.0f;
            } else if (this.b[i2] > 1.0f) {
                this.b[i2] = 1.0f;
            }
            if (i2 <= 0 || !(this.b[i2] < this.b[i2 - 1])) continue;
            this.b[i2] = this.b[i2 - 1];
        }
        this.c = new Color[colorArray.length];
        System.arraycopy(colorArray, 0, this.c, 0, colorArray.length);
        this.f = s3;
        this.e = s2;
        this.d = affineTransform == null ? null : (AffineTransform)affineTransform.clone();
        this.g = bl;
        this.a();
    }

    public IlvMultipleGradientPaint(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        this.a(ilvInputStream);
        this.a();
    }

    void a(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
        try {
            this.e = ilvInputStream.readShort("spread");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.e = 1;
        }
        this.g = ilvInputStream.readBoolean("adapt");
        this.b = ilvInputStream.readFloatArray("stops");
        this.c = ilvInputStream.readColorArray("colors");
        try {
            this.f = ilvInputStream.readShort("inter");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            this.f = 0;
            return;
        }
        try {
            IlvTransformer ilvTransformer = ilvInputStream.readTransformer("t");
            this.d = new AffineTransform(ilvTransformer.getx11(), ilvTransformer.getx21(), ilvTransformer.getx12(), ilvTransformer.getx22(), ilvTransformer.getx0(), ilvTransformer.gety0());
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    void a() {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            if (this.c[i2].getAlpha() == 255) continue;
            this.a = 3;
            break;
        }
    }

    public final Color[] getColors() {
        Color[] colorArray = new Color[this.c.length];
        System.arraycopy(this.c, 0, colorArray, 0, this.c.length);
        return colorArray;
    }

    public final float[] getStops() {
        float[] fArray = new float[this.b.length];
        System.arraycopy(this.b, 0, fArray, 0, this.b.length);
        return fArray;
    }

    public final int getTransparency() {
        return this.a;
    }

    public final boolean isAdapting() {
        return this.g;
    }

    public final short getSpreadMethod() {
        return this.e;
    }

    public final short getColorSpace() {
        return this.f;
    }

    public final AffineTransform getTransform() {
        if (this.d != null) {
            return new AffineTransform(this.d);
        }
        return null;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("spread", this.e);
        ilvOutputStream.write("adapt", this.g);
        ilvOutputStream.write("stops", this.b);
        ilvOutputStream.write("colors", this.c);
        ilvOutputStream.write("inter", this.f);
        if (this.d != null && !this.d.isIdentity()) {
            IlvTransformer ilvTransformer = new IlvTransformer(this.d.getScaleX(), this.d.getShearX(), this.d.getShearY(), this.d.getScaleY(), this.d.getTranslateX(), this.d.getTranslateY());
            ilvOutputStream.write("t", ilvTransformer);
        }
    }
}

