/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.linkconnector;

import ilog.views.IlvGraphic;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvGrapherPin;
import ilog.views.linkconnector.IlvPinLinkConnector;
import java.io.IOException;

public class IlvDefaultGrapherPin
extends IlvGrapherPin {
    private IlvPoint a = new IlvPoint();

    public IlvDefaultGrapherPin(IlvPinLinkConnector ilvPinLinkConnector, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        super(ilvPinLinkConnector);
        this.setPosition(ilvPoint, ilvTransformer);
    }

    public IlvDefaultGrapherPin(IlvPinLinkConnector ilvPinLinkConnector, IlvPoint ilvPoint) {
        super(ilvPinLinkConnector);
        this.setProportionalPosition(ilvPoint);
    }

    public IlvDefaultGrapherPin(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readPoint("location");
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("location", this.a);
    }

    public boolean isPersistent() {
        return true;
    }

    protected IlvRect getNodeBoundingBox(IlvTransformer ilvTransformer) {
        IlvGraphic ilvGraphic = this.getNode();
        return ilvGraphic != null ? ilvGraphic.boundingBox(ilvTransformer) : new IlvRect();
    }

    public void setPosition(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (ilvPoint == null) {
            throw new IllegalArgumentException("point cannot be null");
        }
        IlvGraphic ilvGraphic = this.getNode();
        if (ilvGraphic == null) {
            throw new RuntimeException("the link connector is not attached to a node");
        }
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        if (ilvRect.width < 1.0E-10f) {
            ilvRect.width = 1.0E-10f;
        }
        if (ilvRect.height < 1.0E-10f) {
            ilvRect.height = 1.0E-10f;
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && !ilvTransformer.isTranslation()) {
            ilvTransformer.inverse(ilvRect);
            ilvTransformer.inverse(ilvPoint2);
        }
        this.a = new IlvPoint((ilvPoint2.x - ilvRect.x) / ilvRect.width, (ilvPoint2.y - ilvRect.y) / ilvRect.height);
    }

    public IlvPoint getPosition(IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getNodeBoundingBox(ilvTransformer);
        IlvPoint ilvPoint = new IlvPoint(this.a);
        if (ilvRect.width < 1.0E-10f) {
            ilvRect.width = 1.0E-10f;
        }
        if (ilvRect.height < 1.0E-10f) {
            ilvRect.height = 1.0E-10f;
        }
        if (ilvTransformer != null && !ilvTransformer.isIdentity() && !ilvTransformer.isTranslation()) {
            ilvTransformer.inverse(ilvRect);
            ilvPoint.x = ilvRect.x + ilvPoint.x * ilvRect.width;
            ilvPoint.y = ilvRect.y + ilvPoint.y * ilvRect.height;
            ilvTransformer.apply(ilvPoint);
        } else {
            ilvPoint.x = ilvRect.x + ilvPoint.x * ilvRect.width;
            ilvPoint.y = ilvRect.y + ilvPoint.y * ilvRect.height;
        }
        return ilvPoint;
    }

    public void setProportionalPosition(IlvPoint ilvPoint) {
        this.a = new IlvPoint(ilvPoint);
    }

    public IlvPoint getProportionalPosition() {
        return new IlvPoint(this.a);
    }

    public boolean allowsMove() {
        return true;
    }
}

