/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans.editor;

import ilog.views.util.beans.editor.IlvFormattedPropertyEditor;
import ilog.views.util.beans.editor.Messages;
import ilog.views.util.swing.calendar.IlvJCalendar;
import ilog.views.util.swing.calendar.event.CalendarModelEvent;
import ilog.views.util.swing.calendar.event.CalendarModelListener;
import ilog.views.util.text.IlvDateFormat;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class IlvFormattedDatePropertyEditor
extends IlvFormattedPropertyEditor {
    private Date a;
    private IlvJCalendar b;

    public String getJavaInitializationString() {
        Date date = (Date)this.getValue();
        return "new java.util.Date(" + date.getTime() + ")";
    }

    protected String getFormatAsText() {
        String string = "";
        Format format = this.getFormat();
        if (format != null) {
            if (format instanceof SimpleDateFormat) {
                string = ((SimpleDateFormat)format).toPattern();
            } else if (format instanceof IlvDateFormat) {
                string = ((IlvDateFormat)format).toPattern();
            }
        }
        return string;
    }

    protected void setFormatFromText(String string) throws IllegalArgumentException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        if (simpleDateFormat != null) {
            this.setFormat(simpleDateFormat);
        }
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string != null) {
            Date date = null;
            char c2 = string.charAt(0);
            if (!Character.isDigit(c2)) {
                try {
                    super.setAsText(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalArgumentException("Could not create a Date from " + string);
                }
            }
            try {
                date = new Date(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (date == null) {
                throw new IllegalArgumentException("Could not create a Date from " + string);
            }
            this.setValue(date);
        }
    }

    public String getAsText() {
        Date date = (Date)this.getValue();
        if (date == null) {
            return "";
        }
        if (this.getFormat() != null) {
            return super.getAsText();
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        if (simpleDateFormat != null) {
            this.setFormat(simpleDateFormat);
            return super.getAsText();
        }
        return String.valueOf(date.getTime());
    }

    public void setValue(Object object) {
        this.a = (Date)object;
        super.setValue(object);
        if (this.b != null && object != null && !object.equals(this.b.getCalendar().getTime())) {
            this.b.getCalendar().setTime(this.a);
        }
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string;
        if (this.a == null) {
            return;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        Format format = this.getFormat();
        if (format == null && (format = new SimpleDateFormat()) != null) {
            this.setFormat(format);
        }
        if ((string = this.getFormattedValue()) == null) {
            string = String.valueOf(this.a.getTime());
        }
        graphics.drawString(string, 0, rectangle.height - n2);
    }

    public Object getValue() {
        return this.a;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        if (this.b == null) {
            this.b = new IlvJCalendar();
            this.b.putClientProperty("__PSheetDialogTitleKey", Messages.BUNDLE.getString("FormattedDatePropertyEditor.Title"));
            this.b.setTimeChooser(this.b.createDefaultTimeChooser());
            this.b.getModel().addCalendarModelListener(new CalendarModelListener(){

                public void calendarChanged(CalendarModelEvent calendarModelEvent) {
                    IlvFormattedDatePropertyEditor.this.setValue(IlvFormattedDatePropertyEditor.this.b.getCalendar().getTime());
                }
            });
        } else if (this.a != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.a);
            this.b.setCalendar(calendar);
        }
        return this.b;
    }
}

