/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataReboot;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobStatus;

public class DataRebootJob
implements IJobControl {
    protected NodeModelDelegate nodeModel;
    protected IJobProgressControl observer;
    protected int operation;
    private DataReboot dataReboot;
    protected String operationName;
    protected String errorMessage;

    public DataRebootJob(NodeModelDelegate nodeModelDelegate, int n, IJobProgressControl iJobProgressControl) {
        this.nodeModel = nodeModelDelegate;
        this.observer = iJobProgressControl;
        this.operation = n;
        this.dataReboot = null;
        this.errorMessage = null;
        this.operationName = n == 4 ? "Activate" : "Revert";
    }

    public String getName() {
        return this.nodeModel.getHostName() + " - data reboot";
    }

    public JobStatus executeJob() {
        if (!this.nodeModel.isOperationAllowed(this.operation)) {
            return new JobStatus(2, (Object)new Exception("The " + this.operationName + " operation is not allowed."));
        }
        this.dataReboot = new DataReboot(this.nodeModel, this.operation, this.observer);
        this.dataReboot.start();
        if (this.dataReboot.aborted()) {
            return new JobStatus(3, (Object)new Exception("Cancelled by user"));
        }
        if (this.dataReboot.failed()) {
            this.errorMessage = this.dataReboot.getErrorMessage();
            return new JobStatus(2, (Object)new Exception(this.errorMessage));
        }
        return new JobStatus(4);
    }

    public void abortJob() {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

