/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.IPlatform;
import cerent.cms.idl.Ds123Media.General;
import cerent.cms.idl.Equipment.eCardTransportMode;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.ePortToVtMappingMode;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xUnsupportedTransportMode;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.ProtectionGroupModel;
import cerent.util.HoLoFactory;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class Ds123ModuleModel
extends ModuleModel {
    protected static final int DS1SPERDS3 = 28;
    protected static final int E1SPERVC4 = 63;
    protected ChangeBbePortType changeBbePortType;
    protected CardTransportMode cardTransportMode;
    protected PortToVtMappingMode portToVtMappingMode;
    protected CardRetimingEnabled cardRetimingEnabled;

    public Ds123ModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
        this.changeBbePortType = new ChangeBbePortType(nodeModelDelegate, "Ds123ModuleModel.changeBbePortType");
        this.cardTransportMode = new CardTransportMode("Ds123ModuleModel.cardTransportMode");
        this.cardRetimingEnabled = new CardRetimingEnabled("Ds123ModuleModel.cardRetimingEnabled");
        this.portToVtMappingMode = new PortToVtMappingMode("Ds123ModuleModel.portToVtMappingMode");
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        InterfaceModel[] interfaceModelArray = new Ds123LineModel[portModelArray.length];
        for (int i = 0; i < portModelArray.length; ++i) {
            interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
        }
        return interfaceModelArray;
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = eEqType2 != null ? (PortModel[])this.getChildrenOfType(eEqType2).toArray(new Ds123PortModel[0]) : (PortModel[])this.getDescendantsOfClassType(7).toArray(new Ds123PortModel[0]);
        return portModelArray == null ? new Ds123PortModel[]{} : portModelArray;
    }

    public List getConnectionsList() {
        List list = null;
        ProtectionGroupModel protectionGroupModel = this.getProtectionGroupModel();
        if (protectionGroupModel != null && this.isProtectModule()) {
            ModuleModel moduleModel = protectionGroupModel.getProtectedModuleModel();
            if (moduleModel != null) {
                list = moduleModel.getConnectionsList();
            }
        } else {
            PortModel[] portModelArray = this.getPortModels();
            list = new LinkedList();
            for (int i = 0; i < portModelArray.length; ++i) {
                list.addAll(portModelArray[i].getConnectionsList());
            }
        }
        return list == null ? new LinkedList() : list;
    }

    public String toString() {
        return "Ds123" + super.toString();
    }

    protected boolean isElectricalCard() {
        boolean bl = false;
        int n = this.getEqType();
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 83: 
            case 108: 
            case 109: 
            case 145: 
            case 185: 
            case 197: 
            case 218: 
            case 233: 
            case 234: {
                bl = true;
            }
        }
        return bl;
    }

    protected int getNumPorts() {
        return this.getDescendantsOfClassType(7).size();
    }

    protected void checkPortNumber(int n) {
        if (n <= 0 || n > this.getNumPorts()) {
            throw new IllegalArgumentException("The port number " + n + " is invalid.");
        }
    }

    ILoNum getLoNumForPort(int n, int n2, IHoLoNum iHoLoNum) {
        IHoLoNum iHoLoNum2;
        this.checkPortNumber(n);
        ILoNum iLoNum = null;
        int n3 = this.calcFramingTypeForLo();
        int n4 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n5 = n - 1;
        IHoNum iHoNum = HoLoFactory.createFirstHoNum(n3);
        ILoNum iLoNum2 = HoLoFactory.createFirstLoNum(n3, n4);
        if (iHoLoNum == null) {
            iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum, iLoNum2);
        } else {
            iHoLoNum2 = iHoLoNum;
            iHoLoNum2.setHoNum(iHoNum);
            iHoLoNum2.setLoNum(iLoNum2);
        }
        if (this.isElectricalCard()) {
            HoLoFactory.increaseGroupOffset(iHoLoNum2, n5);
            iLoNum = iHoLoNum2.getLoNum();
        } else {
            iLoNum = super.getLoNumForPort(n, n2);
        }
        return iLoNum;
    }

    public ILoNum getLoNumForPort(int n, int n2) {
        return this.getLoNumForPort(n, n2, null);
    }

    IHoNum getHoNumForPort(int n, int n2, IHoLoNum iHoLoNum) {
        this.checkPortNumber(n);
        IHoNum iHoNum = null;
        int n3 = CircuitSize.width2sizeOfLoCircuit((int)n2).getEnum();
        int n4 = n - 1;
        if (this.isElectricalCard()) {
            IHoLoNum iHoLoNum2;
            int n5 = this.calcFramingTypeForLo();
            IHoNum iHoNum2 = HoLoFactory.createFirstHoNum(n5);
            ILoNum iLoNum = HoLoFactory.createFirstLoNum(n5, n3);
            if (iHoLoNum == null) {
                iHoLoNum2 = HoLoFactory.createHoLoNum(iHoNum2, iLoNum);
            } else {
                iHoLoNum2 = iHoLoNum;
                iHoLoNum2.setHoNum(iHoNum2);
                iHoLoNum2.setLoNum(iLoNum);
            }
            HoLoFactory.increaseGroupOffset(iHoLoNum2, n4);
            iHoNum = iHoLoNum2.getHoNum();
        } else {
            iHoNum = super.getHoNumForPort(n, n2);
        }
        return iHoNum;
    }

    public IHoNum getHoNumForPort(int n, int n2) {
        return this.getHoNumForPort(n, n2, null);
    }

    public boolean supportsLoopbackAis() {
        return true;
    }

    public boolean supportsFacilitiesLoopbackAis(IPortModel iPortModel) {
        boolean bl = true;
        IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
        int n = this.getEqType();
        if ((iPlatform.is454() || iPlatform.is455()) && n == 65) {
            bl = false;
        }
        return bl;
    }

    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        boolean bl = true;
        IPlatform iPlatform = ((NodeModelDelegate)this.getNodeModel()).getPlatform();
        int n = this.getEqType();
        if ((iPlatform.is454() || iPlatform.is455()) && (n == 12 || n == 65 || n == 6 || n == 57 || n == 66)) {
            bl = false;
        }
        return bl;
    }

    public void changeBbePortType(PortModel portModel, eEqType eEqType2) throws EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{new Integer(portModel.getEntityIndex()), eEqType2};
            this.changeBbePortType.set(objectArray);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, "port", portModel.getNodeModelDelegate().getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("changeBbePortType", userException);
        }
    }

    public ePortToVtMappingMode getPortToVtMappingMode() {
        try {
            return (ePortToVtMappingMode)this.portToVtMappingMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getPortToVtMappingMode() ", userException);
        }
    }

    public eCardTransportMode getCardTransportMode() {
        try {
            return (eCardTransportMode)this.cardTransportMode.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getCardTransportMode ", userException);
        }
    }

    protected IPortModel getPortModelForHoPath(IEntityModel iEntityModel, IHoNum iHoNum) {
        IPortModel iPortModel = null;
        if ((this.getEqTypeEnum() == eEqType.DS3_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3N_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3NE_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3_EC1_48_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3E_LINE_CARD) && this.getCardTransportMode() == eCardTransportMode.TRANSPORT_MODE_SONET) {
            int n = (iHoNum.getIdlHoNum() - 1) * 28 + 1;
            iPortModel = this.getPortByNumberAndType(eEqType.DS3, new int[]{n});
        } else {
            iPortModel = this.getPortByNumberAndType(null, new int[]{iHoNum.getIdlHoNum()});
        }
        return iPortModel;
    }

    protected IPortModel getPortModelForLoPath(IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum) {
        IPortModel iPortModel = null;
        if ((this.getEqTypeEnum() == eEqType.DS3_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3N_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3NE_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3_EC1_48_LINE_CARD || this.getEqTypeEnum() == eEqType.DS3E_LINE_CARD) && this.getPortToVtMappingMode() == ePortToVtMappingMode.PORT_VT_MAPPING_INDUSTRY) {
            int n = (iLoNum.getIdlGroupNum() - 1) * 4 + iLoNum.getIdlNumInGroup() + (iHoNum.getHoNum() - 1) * 28;
            iPortModel = this.getPortByNumberAndType(eEqType.DS3, new int[]{n});
        } else {
            PortModel[] portModelArray = this.getPortModels();
            int n = iLoNum.getLoPathWidth();
            IHoLoNum iHoLoNum = HoLoFactory.createHoLoNum(null, null);
            for (int i = 0; i < portModelArray.length; ++i) {
                IHoNum iHoNum2;
                ILoNum iLoNum2;
                PortModel portModel = portModelArray[i];
                int[] nArray = portModel.getPortNum();
                if (nArray == null || nArray.length != 1 || (iLoNum2 = this.getLoNumForPort(nArray[0], n, iHoLoNum)) == null || !iLoNum2.equals(iLoNum) || (iHoNum2 = this.getHoNumForPort(nArray[0], n, iHoLoNum)) == null || !iHoNum2.equals(iHoNum)) continue;
                iPortModel = portModel;
                break;
            }
        }
        return iPortModel;
    }

    General getDs123Ref() {
        return this.getNodeModelDelegate().getIorRepository().getDs123Ref();
    }

    protected class CardRetimingEnabled
    extends CachedValue {
        public CardRetimingEnabled(String string) {
            super(Ds123ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            Ds123ModuleModel.this.getCardModuleRef().setCardRetimingEnabled(Ds123ModuleModel.this.entityIndex, (Boolean)object);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment {
            return new Boolean(Ds123ModuleModel.this.getCardModuleRef().getCardRetimingEnabled(Ds123ModuleModel.this.entityIndex));
        }

        public Object outer() {
            return this;
        }
    }

    protected class CardTransportMode
    extends CachedValue {
        public CardTransportMode(String string) {
            super(Ds123ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment, xNotSupportedOnEquipment, xUnsupportedTransportMode {
            Ds123ModuleModel.this.getCardModuleRef().setCardTransportMode(Ds123ModuleModel.this.entityIndex, (eCardTransportMode)object);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return Ds123ModuleModel.this.getCardModuleRef().getCardTransportMode(Ds123ModuleModel.this.entityIndex);
        }

        public Object outer() {
            return this;
        }
    }

    class ChangeBbePortType
    extends NonCachedValue {
        public ChangeBbePortType(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            int n = (Integer)objectArray[0];
            eEqType eEqType2 = (eEqType)objectArray[1];
            Ds123ModuleModel.this.getDs123Ref().changeElectricalPortType(n, eEqType2);
        }
    }

    protected class PortToVtMappingMode
    extends CachedValue {
        public PortToVtMappingMode(String string) {
            super(Ds123ModuleModel.this.node, string);
        }

        protected void setValue(Object object) throws xWrongEquipmentType, xProvisionError, xNoSuchEquipment, xNotSupportedOnEquipment {
            Ds123ModuleModel.this.getCardModuleRef().setPortToVtMappingMode(Ds123ModuleModel.this.entityIndex, (ePortToVtMappingMode)object);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return Ds123ModuleModel.this.getCardModuleRef().getPortToVtMappingMode(Ds123ModuleModel.this.entityIndex);
        }

        public Object outer() {
            return this;
        }
    }
}

