/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Optics.xFeatureUnsupported;
import cerent.cms.idl.OpticsTopology.eApcAdminStatus;
import cerent.cms.idl.OpticsTopology.sAPCLastModification;
import cerent.cms.idl.OpticsTopology.sAPCLastRun;
import cerent.cms.idl.OpticsTopology.sApcDomainItem;
import cerent.cms.idl.OpticsTopology.xBusy;
import cerent.cms.idl.OpticsTopology.xCannotPerform;
import cerent.cms.idl.OpticsTopology.xWrongNodeSide;
import cerent.cms.model.APCLastModification;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.IAPCLastModification;
import cerent.cms.model.IDwdmApcModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.Model;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.WrongNodeSide;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.cms.ui.DwdmSide;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class DwdmApcModel
extends Model
implements IDwdmApcModel {
    private ApcState apcState;
    private ApcAdminState apcAdminStateRef;
    private ApcProgressStatus apcProgressStatusRef;
    private RunApc runApcRef;
    private GetSideAPCLastModif getSideAPCLastModif;
    private GetApcDomain getApcDomain;
    private NodeModelDelegate nmd;
    private HashMap<ObjectType, NonCachedValue> apcObjType = new HashMap();
    private EventDispatcher dispatcher;
    private int nodeSide;

    public DwdmApcModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate.getChildDebug(DwdmApcModel.class));
        this.nmd = nodeModelDelegate;
        this.nodeSide = n;
        this.index = n;
        this.dispatcher = null;
        this.apcState = new ApcState(this.nmd, "dwdmApcModel::ApcState");
        this.apcAdminStateRef = new ApcAdminState(this.nmd, "dwdmApcModel::ApcAdminState");
        this.apcProgressStatusRef = new ApcProgressStatus(this.nmd, "dwdmApcModel::ApcProgressStatus");
        this.runApcRef = new RunApc(this.nmd, "dwdmApcModel::RunApc");
        this.getSideAPCLastModif = new GetSideAPCLastModif(this.nmd, "dwdmApcModel::GetSideAPCLastModif");
        this.getApcDomain = new GetApcDomain(this.nmd, "dwdmApcModel::GetApcDomain");
        this.apcObjType.put(ObjectType.ObjectApcAdmin, this.apcAdminStateRef);
        this.apcObjType.put(ObjectType.ObjectApcStatus, this.apcState);
        this.apcObjType.put(ObjectType.ObjectApcProgress, this.apcProgressStatusRef);
        this.apcObjType.put(ObjectType.ObjectApcModifiedList, this.getSideAPCLastModif);
        this.apcObjType.put(ObjectType.ObjectApcDomain, this.getApcDomain);
    }

    public int getApcNodeSide() {
        return this.nodeSide;
    }

    public void init() {
        super.init0();
        if (this.db.on()) {
            this.db.println("DwdmApcModel::init()");
        }
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            Iterator<ObjectType> iterator = this.apcObjType.keySet().iterator();
            while (iterator.hasNext()) {
                this.dispatcher.addObserver(iterator.next(), this.nodeSide, (Observer)this);
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose DwdmApcModel");
        }
        if (this.dispatcher != null) {
            Iterator<ObjectType> iterator = this.apcObjType.keySet().iterator();
            while (iterator.hasNext()) {
                this.dispatcher.deleteObserver(iterator.next(), this.nodeSide, (Observer)this);
            }
            this.dispatcher = null;
        }
        this.apcObjType.clear();
        this.apcState.dispose();
        this.apcAdminStateRef.dispose();
        this.apcProgressStatusRef.dispose();
        this.getSideAPCLastModif.dispose();
        this.getApcDomain.dispose();
        super.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public void update(Observable observable, Object object) {
        if (this.db.on) {
            this.db.println(this.getClass() + "::update");
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        int n2 = ((IObjectMessageInfo)object).getObjectType();
        if (n == 1) {
            this.apcObjType.get(ObjectType.from_int(n2)).update();
            if (this.db.on) {
                this.db.println(this.getClass() + "::update APC Event for side Index: 0x" + Integer.toHexString(this.nodeSide) + " for " + this.nmd.getName());
            }
            this.updateLocal();
            this.setChanged();
            this.notifyObservers(n);
        } else if (n == 0) {
            this.nmd.getDwdmApcModels().deleteApcModel(this.nodeSide);
            this.setChanged();
            this.notifyObservers(n);
            if (this.db.on) {
                this.db.println(this.getClass() + "::delete APC Event for side Index: 0x" + Integer.toHexString(this.nodeSide) + " for " + this.nmd.getName());
            }
        }
    }

    protected void updateLocal() {
        this.apcProgressStatusRef.update();
        this.apcState.update();
        this.apcAdminStateRef.update();
        this.getSideAPCLastModif.update();
        super.updateLocal();
    }

    public String getSide() {
        return DwdmSide.getSideFromOffset(this.nodeSide);
    }

    public int getApcState() throws WrongNodeSide {
        try {
            return (Integer)this.apcState.get();
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcProgressState", userException);
        }
    }

    public int getApcAdminState() throws WrongNodeSide {
        try {
            return ((eApcAdminStatus)this.apcAdminStateRef.get()).value();
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcProgressState", userException);
        }
    }

    public int getApcProgressState() throws WrongNodeSide {
        try {
            return ((sAPCLastRun)this.apcProgressStatusRef.get()).lastRunStatus.value();
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcProgressState", userException);
        }
    }

    public int getApcFailingNodeId() throws WrongNodeSide {
        try {
            int n = ((sAPCLastRun)this.apcProgressStatusRef.get()).abortedNode;
            if (this.db.on) {
                this.db.println("Failing node id " + n);
            }
            return n;
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcFailingNodeId", userException);
        }
    }

    public void setApcAdminState(eApcAdminStatus eApcAdminStatus2) throws WrongNodeSide {
        try {
            this.apcAdminStateRef.set(new Object[]{new Integer(this.nodeSide), eApcAdminStatus2});
        }
        catch (xWrongNodeSide xWrongNodeSide2) {
            throw new WrongNodeSide((UserException)xWrongNodeSide2);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            abstractCmsIOException.printStackTrace();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
    }

    public void setApcAdminState(int n) throws WrongNodeSide {
        if (n == 0) {
            this.setApcAdminState(eApcAdminStatus.APC_FORCE_DISABLE);
        } else {
            this.setApcAdminState(eApcAdminStatus.APC_FREE_TO_RUN);
        }
    }

    public void runApc() throws Busy, CannotPerform {
        try {
            this.runApcRef.set();
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xCannotPerform xCannotPerform2) {
            throw new CannotPerform((UserException)xCannotPerform2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "runApc", userException);
        }
    }

    public IAPCLastModification[] getSideAPCLastModif() {
        APCLastModification[] aPCLastModificationArray = null;
        try {
            sAPCLastModification[] sAPCLastModificationArray = (sAPCLastModification[])this.getSideAPCLastModif.get();
            aPCLastModificationArray = new APCLastModification[sAPCLastModificationArray.length];
            for (int i = 0; i < sAPCLastModificationArray.length; ++i) {
                aPCLastModificationArray[i] = new APCLastModification(sAPCLastModificationArray[i]);
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            abstractCmsIOException.printStackTrace();
        }
        catch (UserException userException) {
            userException.printStackTrace();
        }
        return aPCLastModificationArray;
    }

    public sApcDomainItem[] getApcDomain() {
        try {
            return (sApcDomainItem[])this.getApcDomain.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getApcDomain", userException);
        }
    }

    public String toString() {
        return "Dwdm Side Model: Side 0x" + Integer.toHexString(this.nodeSide) + " Node " + this.nmd.getName();
    }

    private class ApcAdminState
    extends CachedValue {
        public ApcAdminState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongNodeSide {
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getApcAdminState(DwdmApcModel.this.nodeSide);
        }

        public void setValue(Object object) throws xWrongNodeSide {
            if (DwdmApcModel.this.db.on) {
                DwdmApcModel.this.db.println(this.getClass() + "::setValue");
            }
            Object[] objectArray = (Object[])object;
            eApcAdminStatus eApcAdminStatus2 = (eApcAdminStatus)objectArray[1];
            this.node.getIorRepository().getDwdmOpticalSetupRef().setApcAdminState(DwdmApcModel.this.nodeSide, eApcAdminStatus2);
        }
    }

    private class ApcProgressStatus
    extends CachedValue {
        public ApcProgressStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xWrongNodeSide {
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getApcProgressState(DwdmApcModel.this.nodeSide);
        }
    }

    private class ApcState
    extends CachedValue {
        public ApcState(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return new Integer(this.node.getIorRepository().getDwdmOpticalSetupRef().getApcState(DwdmApcModel.this.nodeSide).value());
        }
    }

    private class GetApcDomain
    extends NonCachedValue {
        public GetApcDomain(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xCannotPerform, xWrongNodeSide, xFeatureUnsupported, xBusy {
            if (DwdmApcModel.this.db.on) {
                DwdmApcModel.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getApcDomain(DwdmApcModel.this.nodeSide);
        }
    }

    private class GetSideAPCLastModif
    extends CachedValue {
        public GetSideAPCLastModif(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() {
            if (DwdmApcModel.this.db.on) {
                DwdmApcModel.this.db.println(this.getClass() + "::getValue");
            }
            return this.node.getIorRepository().getDwdmOpticalSetupRef().getSideAPCLastModif(DwdmApcModel.this.nodeSide);
        }
    }

    private class RunApc
    extends NonCachedValue {
        public RunApc(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue() throws xBusy, xCannotPerform, xWrongNodeSide {
            if (DwdmApcModel.this.db.on) {
                DwdmApcModel.this.db.println(this.getClass() + "::setValue");
            }
            this.node.getIorRepository().getDwdmOpticalSetupRef().runAPC(DwdmApcModel.this.nodeSide);
        }
    }
}

