/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Epos.MSTBridge;
import cerent.cms.idl.Epos.sBridgePortAdminInfo;
import cerent.cms.idl.Epos.sBridgePortAdminInfo_2_2;
import cerent.cms.idl.Epos.sBridgePortInfo;
import cerent.cms.idl.Epos.sCIR;
import cerent.cms.idl.Epos.xNoMoreSpanningTree;
import cerent.cms.idl.Epos.xNoSuchVlan;
import cerent.cms.idl.Epos.xVlanHardwareViolation;
import cerent.cms.idl.Epos.xVlanSpanningTreeViolation;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AdminState;
import cerent.cms.model.CachedValue;
import cerent.cms.model.EtherBridgeModel;
import cerent.cms.model.EtherLineModel;
import cerent.cms.model.Feature;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.PortModel;
import cerent.cms.model.UnsupportedOperation;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class EtherPortModel
extends PortModel {
    PortInfo portInfo;
    PortAdminInfo portAdminInfo;
    VlanIds vlanIds;
    VlanTagging vlanTagging;
    BridgePortVlans bridgePortVlans;
    PortVlansNoProv portVlansNoProv;
    private int type;

    public EtherPortModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(EtherPortModel.class));
        this.portInfo = new PortInfo(nodeModelDelegate, "EtherPortModel::portInfo");
        this.portAdminInfo = new PortAdminInfo(nodeModelDelegate, "EtherPortModel::portAdminInfo");
        this.vlanIds = new VlanIds(nodeModelDelegate, "EtherPortModel::vlanIds");
        this.vlanTagging = new VlanTagging(nodeModelDelegate, "EtherPortModel::vlanTagging");
        this.bridgePortVlans = new BridgePortVlans(nodeModelDelegate, "EtherPortModel::bridgePortVlans");
        this.portVlansNoProv = new PortVlansNoProv(nodeModelDelegate, "EtherPortModel::portVlansNoProv");
    }

    public void init() {
        if (this.db.on()) {
            this.db.println("EtherPortModel::init() entry");
        }
        super.init();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
        this.portAdminInfo.init();
        this.vlanIds.init();
        this.vlanTagging.init();
        try {
            this.type = this.getEqType();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        if (this.db.on()) {
            this.db.println("EtherPortModel::init() exit");
        }
    }

    public void dispose() {
        this.portAdminInfo.dispose();
        this.vlanIds.dispose();
        this.vlanTagging.dispose();
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectInterface, this.getEntityIndex(), (Observer)this);
        }
        super.dispose();
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("EtherPortModel::updateLocal");
        }
        this.portAdminInfo.update();
        this.vlanIds.update();
        this.vlanTagging.update();
        try {
            this.type = this.getEqType();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        this.setChanged();
        super.updateLocal();
    }

    public void destroy() {
        InterfaceModel interfaceModel;
        super.destroy();
        if ((this.type == 35 || this.type == 36) && (interfaceModel = this.findEtherBackPlaneInterfaceModelInCache()) != null) {
            interfaceModel.deleteAll();
        }
    }

    private InterfaceModel findEtherBackPlaneInterfaceModelInCache() {
        return this.getNodeModelDelegate().getIfModels().findInterfaceModelInCache(this.getEntityIndex() + 12);
    }

    public EtherLineModel getEtherLineModel() {
        return (EtherLineModel)this.getInterfaceModel();
    }

    public sBridgePortInfo getBridgePortInfo() throws IllegalArgumentException, AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("EtherPortModel::getBridgePortInfo");
        }
        try {
            return (sBridgePortInfo)this.portInfo.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.getBridgePortInfo(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public sBridgePortAdminInfo_2_2 getBridgePortAdminInfo() throws IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("EtherPortModel::getBridgePortAdminInfo");
        }
        try {
            return (sBridgePortAdminInfo_2_2)this.portAdminInfo.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.getBridgePortAdminInfo(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setBridgePortAdminInfoNoProv(sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22) throws xVlanSpanningTreeViolation, xNoMoreSpanningTree, xVlanHardwareViolation, IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("EtherPortModel::setBridgePortAdminInfo");
        }
        try {
            this.portAdminInfo.set(sBridgePortAdminInfo_2_22);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw xVlanSpanningTreeViolation2;
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw xNoMoreSpanningTree2;
        }
        catch (xVlanHardwareViolation xVlanHardwareViolation2) {
            throw xVlanHardwareViolation2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.setBridgePortAdminInfo(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IVlanModel[] getBridgePortVlans() throws IllegalArgumentException, AbstractCmsIOException {
        if (this.db.on()) {
            this.db.println("EtherPortModel::getBridgePortVlans");
        }
        try {
            short[] sArray = (short[])this.vlanIds.get();
            IVlanModel[] iVlanModelArray = this.getChassis().getEtherBridgeModel().getVlanList();
            IVlanModel[] iVlanModelArray2 = new IVlanModel[sArray.length];
            block3: for (int i = 0; i < sArray.length; ++i) {
                for (int j = 0; j < iVlanModelArray.length; ++j) {
                    if (sArray[i] != iVlanModelArray[j].getId()) continue;
                    iVlanModelArray2[i] = iVlanModelArray[j];
                    continue block3;
                }
            }
            return iVlanModelArray2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.getBridgePortVlans(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public short[] getPortVlanIDs() throws IllegalArgumentException, AbstractCmsIOException {
        try {
            short[] sArray = (short[])this.vlanIds.get();
            return sArray;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.getBridgePortVlans(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public void setPortVlansNoProv(IVlanModel[] iVlanModelArray) throws IllegalArgumentException, xVlanSpanningTreeViolation, xNoMoreSpanningTree, xVlanHardwareViolation, xNoSuchVlan {
        if (this.db.on()) {
            this.db.println("EtherPortModel::setPortVlans");
        }
        try {
            if (iVlanModelArray == null) {
                return;
            }
            short[] sArray = new short[iVlanModelArray.length];
            for (int i = 0; i < iVlanModelArray.length; ++i) {
                sArray[i] = iVlanModelArray[i].getId();
            }
            this.vlanIds.set(sArray);
        }
        catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
            throw xVlanSpanningTreeViolation2;
        }
        catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
            throw xNoMoreSpanningTree2;
        }
        catch (xVlanHardwareViolation xVlanHardwareViolation2) {
            throw xVlanHardwareViolation2;
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw xNoSuchVlan2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.getPortVlans(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public IVlanModel getPortVlanTagging() throws AbstractCmsIOException, IllegalArgumentException {
        if (this.db.on()) {
            this.db.println("EtherPortModel::getPortVlanTagging");
        }
        try {
            return (IVlanModel)this.vlanTagging.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.setPortVlanTagging(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    public int getServiceStateType() {
        return this.getBridgePortAdminInfo().portEnabled ? 102 : 103;
    }

    public void setPortVlanTaggingNoProv(IVlanModel iVlanModel) throws AbstractCmsIOException, IllegalArgumentException, xNoSuchVlan, xVlanHardwareViolation {
        if (this.db.on()) {
            this.db.println("EtherPortModel::setPortVlanTagging");
        }
        try {
            this.vlanTagging.set(iVlanModel);
        }
        catch (xVlanHardwareViolation xVlanHardwareViolation2) {
            throw xVlanHardwareViolation2;
        }
        catch (xNoSuchVlan xNoSuchVlan2) {
            throw xNoSuchVlan2;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new IllegalArgumentException("An attempt was made to access a non-existent interface [ EtherPortModel.setPortVlanTagging(" + this.entityIndex + ", ...) ].");
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public String toString() {
        return "Ether" + super.toString();
    }

    public boolean maybeSetAdminState(int n, int n2, int n3) throws NoSuchInterface, LoopbackActive, UnsupportedOperation {
        boolean bl = false;
        InterfaceModel interfaceModel = (InterfaceModel)this.getInterfaceModel();
        if (interfaceModel != null) {
            this.db.info("EtherPortModel" + this + ".maybeSetAdminState(): targetState:" + n + ", policy:" + n2 + ", circuitSize:" + n3);
            if (n != -1) {
                boolean bl2 = false;
                TDMTerminology tDMTerminology = this.getNodeModel().getTDMTerminology();
                switch (n) {
                    case 0: {
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperation("Ethernet ports only support " + AdminState.getAdminTermIS(tDMTerminology) + " and " + AdminState.getAdminTermDSBLD(tDMTerminology) + " states.");
                    }
                }
                try {
                    sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22 = this.getBridgePortAdminInfo();
                    if (sBridgePortAdminInfo_2_22.portEnabled != bl2) {
                        sBridgePortAdminInfo_2_22.portEnabled = bl2;
                        this.setBridgePortAdminInfoNoProv(sBridgePortAdminInfo_2_22);
                        this.getChassis().getEtherBridgeModel().finalizePortProvisioning();
                    }
                }
                catch (xVlanSpanningTreeViolation xVlanSpanningTreeViolation2) {
                    this.db.severe(xVlanSpanningTreeViolation2.toString());
                    throw new UnsupportedOperation(xVlanSpanningTreeViolation2.toString());
                }
                catch (xNoMoreSpanningTree xNoMoreSpanningTree2) {
                    this.db.severe(xNoMoreSpanningTree2.toString());
                    throw new UnsupportedOperation(xNoMoreSpanningTree2.toString());
                }
                catch (xVlanHardwareViolation xVlanHardwareViolation2) {
                    this.db.severe(xVlanHardwareViolation2.toString());
                    throw new UnsupportedOperation(xVlanHardwareViolation2.toString());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.db.severe(illegalArgumentException.toString());
                    throw new UnsupportedOperation(illegalArgumentException.toString());
                }
                bl = true;
            }
        }
        return bl;
    }

    private MSTBridge getEtherBridgeRef() {
        return this.node.getIorRepository().getEtherBridgeRef();
    }

    public class BridgePortVlans
    extends NonCachedValue {
        public BridgePortVlans(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return EtherPortModel.this.getBridgePortVlans();
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }

    class PortAdminInfo
    extends CachedValue {
        public PortAdminInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            if (EtherPortModel.this.node.provides(Feature.IDL_220)) {
                EtherPortModel.this.getEtherBridgeRef().setPortAdminInfoNoProv_2_2(EtherPortModel.this.entityIndex, (sBridgePortAdminInfo_2_2)object);
            } else {
                sBridgePortAdminInfo sBridgePortAdminInfo2 = ((EtherBridgeModel)EtherPortModel.this.node.getEtherBridgeModel()).convertBridgePortAdminInfo((sBridgePortAdminInfo_2_2)object);
                EtherPortModel.this.getEtherBridgeRef().setPortAdminInfoNoProv(EtherPortModel.this.entityIndex, sBridgePortAdminInfo2);
            }
        }

        protected Object getValue() throws UserException {
            sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22 = null;
            if (EtherPortModel.this.node.provides(Feature.IDL_220)) {
                sBridgePortAdminInfo_2_22 = EtherPortModel.this.getEtherBridgeRef().getPortAdminInfo_2_2(EtherPortModel.this.entityIndex);
            } else {
                sBridgePortAdminInfo sBridgePortAdminInfo2 = EtherPortModel.this.getEtherBridgeRef().getPortAdminInfo(EtherPortModel.this.entityIndex);
                sBridgePortAdminInfo_2_22 = ((EtherBridgeModel)EtherPortModel.this.node.getEtherBridgeModel()).convertBridgePortAdminInfo_2_2(sBridgePortAdminInfo2);
            }
            return sBridgePortAdminInfo_2_22;
        }

        protected Object cloneValue() {
            sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_22 = (sBridgePortAdminInfo_2_2)this.value;
            sCIR sCIR2 = new sCIR(sBridgePortAdminInfo_2_22.cir.cirRate, sBridgePortAdminInfo_2_22.cir.cirBurst, sBridgePortAdminInfo_2_22.cir.eirRate, sBridgePortAdminInfo_2_22.cir.eirBurst);
            sBridgePortAdminInfo_2_2 sBridgePortAdminInfo_2_23 = new sBridgePortAdminInfo_2_2(sBridgePortAdminInfo_2_22.portEnabled, sBridgePortAdminInfo_2_22.stpPriority, sBridgePortAdminInfo_2_22.stpPathCost, sBridgePortAdminInfo_2_22.queuingPriority, sBridgePortAdminInfo_2_22.broadcastLimit, sCIR2, sBridgePortAdminInfo_2_22.stpEnabled, sBridgePortAdminInfo_2_22.encapType);
            return sBridgePortAdminInfo_2_23;
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }

    class PortInfo
    extends NonCachedValue {
        public PortInfo(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
        }

        protected Object getValue() throws UserException {
            return EtherPortModel.this.getEtherBridgeRef().getPortInfo(EtherPortModel.this.entityIndex);
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }

    public class PortVlansNoProv
    extends NonCachedValue {
        public PortVlansNoProv(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            Object[] objectArray = (Object[])object;
            IVlanModel[] iVlanModelArray = new IVlanModel[objectArray.length];
            for (int i = 0; i < iVlanModelArray.length; ++i) {
                iVlanModelArray[i] = (IVlanModel)objectArray[i];
            }
            EtherPortModel.this.setPortVlansNoProv(iVlanModelArray);
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }

    class VlanIds
    extends CachedValue {
        public VlanIds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException, xNoSuchVlan {
            EtherPortModel.this.getEtherBridgeRef().setPortVlansNoProv(EtherPortModel.this.entityIndex, (short[])object);
        }

        protected Object getValue() throws UserException {
            return EtherPortModel.this.getEtherBridgeRef().getPortVlans(EtherPortModel.this.entityIndex);
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }

    class VlanTagging
    extends CachedValue {
        public VlanTagging(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws UserException {
            EtherPortModel.this.getEtherBridgeRef().setPortVlanTaggingNoProv(EtherPortModel.this.entityIndex, ((IVlanModel)object).getId());
        }

        protected Object getValue() throws UserException {
            short s = EtherPortModel.this.getEtherBridgeRef().getPortVlanTagging(EtherPortModel.this.entityIndex);
            IChassisModel iChassisModel = EtherPortModel.this.getChassis();
            IVlanModel[] iVlanModelArray = iChassisModel.getEtherBridgeModel().getVlanList();
            for (int i = 0; i < iVlanModelArray.length; ++i) {
                if (s != iVlanModelArray[i].getId()) continue;
                return iVlanModelArray[i];
            }
            return null;
        }

        public Object outer() {
            return EtherPortModel.this;
        }
    }
}

