/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Lmp.General;
import cerent.cms.idl.Lmp.sControlChannelAttrsEx;
import cerent.cms.idl.Lmp.xLmpException;
import cerent.cms.model.AbstractTermConnectionModel;
import cerent.cms.model.CachedValue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.ILmpCtrlChannelModel;
import cerent.cms.model.ILmpCtrlChannelModels;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.LmpCtrlChannelModel;
import cerent.cms.model.LmpException;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.ObjectMessageInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class LmpCtrlChannelModels
extends Model
implements ILmpCtrlChannelModels {
    private static NodeSingletonFactory<LmpCtrlChannelModels> sfactory = new NodeSingletonFactory<LmpCtrlChannelModels>(LmpCtrlChannelModels.class);
    private static final ObjectType _eventType = ObjectType.ObjectControlChannelList;
    private NodeModelDelegate _nmd;
    private EventDispatcher _dispatcher;
    private HashMap _models;
    private Create _create;
    private Get _get;
    private Delete _delete;
    private UserException _getException;

    private LmpCtrlChannelModels(NodeModelDelegate nodeModelDelegate) {
        super(nodeModelDelegate.getChildDebug(LmpCtrlChannelModels.class));
        this._nmd = nodeModelDelegate;
        this._dispatcher = null;
        this._models = new HashMap();
        this._create = new Create(this._nmd, "Lmp::ControlChannelManager::Create");
        this._get = new Get(this._nmd, "Lmp::ControlChannelManager::Get");
        this._delete = new Delete(this._nmd, "Lmp::ControlChannelManager::Delete");
        this._getException = null;
        this.index = 0;
    }

    General getLmpMgrRef() {
        return this._nmd.getIorRepository().getLmpMgrRef();
    }

    public INodeModel getNodeModel() {
        return this._nmd;
    }

    public void init() {
        if (this._dispatcher == null) {
            this._dispatcher = this._nmd.getDispatcher();
        }
        if (this._dispatcher != null) {
            this._dispatcher.addObserver(_eventType, 0, (Observer)this);
        }
        this.updateLocal();
        if (this.db.on()) {
            this.db.println("init(" + this + ")");
        }
        super.init0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache() {
        ArrayList arrayList = new ArrayList();
        ArrayList<LmpCtrlChannelModel> arrayList2 = new ArrayList<LmpCtrlChannelModel>();
        boolean bl = false;
        Iterator iterator = this._models;
        synchronized (iterator) {
            try {
                this._get.update();
                int[] nArray = (int[])this._get.get();
                this._getException = null;
                HashSet hashSet = new HashSet(this._models.keySet());
                HashSet hashSet2 = new HashSet();
                for (int i = 0; i < nArray.length; ++i) {
                    Integer n = new Integer(nArray[i]);
                    if (hashSet.contains(n)) {
                        hashSet.remove(n);
                        continue;
                    }
                    hashSet2.add(n);
                }
                StringBuffer stringBuffer = null;
                if (this.db.on()) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append('-');
                }
                for (Integer n : hashSet) {
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList.add(this._models.remove(n));
                }
                if (this.db.on()) {
                    if (stringBuffer.length() > 1) {
                        this.db.println(stringBuffer.toString());
                    }
                    stringBuffer.setLength(0);
                    stringBuffer.append('+');
                }
                for (Integer n : hashSet2) {
                    LmpCtrlChannelModel lmpCtrlChannelModel = new LmpCtrlChannelModel(this._nmd, this, n);
                    if (this.db.on()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(n);
                    }
                    arrayList2.add(lmpCtrlChannelModel);
                    this._models.put(n, lmpCtrlChannelModel);
                }
                if (this.db.on() && stringBuffer.length() > 1) {
                    this.db.println(stringBuffer.toString());
                }
            }
            catch (xLmpException xLmpException2) {
                this.db.println("Failed to get LMP control channels: " + (Object)((Object)xLmpException2));
                this._getException = xLmpException2;
            }
            catch (UserException userException) {
                this.db.println("Failed to get LMP control channels: " + (Object)((Object)userException));
                this._getException = userException;
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ((LmpCtrlChannelModel)iterator.next()).destroy();
            bl = true;
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            ((LmpCtrlChannelModel)iterator.next()).init();
        }
        if (!arrayList2.isEmpty()) {
            this.setChanged();
            super.updateLocal();
        }
        if (bl) {
            this.setChanged();
            this.notifyObservers(ModelUpdateType.DELETED);
        }
    }

    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(" + this + ")");
        }
        this.updateCache();
    }

    public void update(Observable observable, Object object) {
        if (this.db.on()) {
            this.db.println("update(" + this + ", arg=" + object + ", from=" + observable + ")");
        }
        if (observable instanceof CmsObservable && object instanceof ObjectMessageInfo) {
            ObjectMessageInfo objectMessageInfo = (ObjectMessageInfo)object;
            switch (objectMessageInfo.getUpdateType()) {
                case 2: {
                    this.updateLocal();
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this._dispatcher != null) {
            this._dispatcher.deleteObserver(_eventType, 0, (Observer)this);
            this._dispatcher = null;
        }
        this._get.dispose();
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            this._models.clear();
        }
        if (this.db.on()) {
            this.db.println("dispose(" + this + ")");
        }
        super.dispose();
    }

    public void destroy() {
        if (this.db.on()) {
            this.db.println("destroy(" + this + ")");
        }
        super.destroy();
    }

    public int createCtrlChannel(sControlChannelAttrsEx sControlChannelAttrsEx2) throws LmpException {
        try {
            return (Integer)this._create.get(sControlChannelAttrsEx2);
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "createCtrlChannel", userException);
        }
    }

    public ILmpCtrlChannelModel[] getICtrlChannels() throws LmpException {
        return this.getCtrlChannels();
    }

    public LmpCtrlChannelModel[] getCtrlChannels() throws LmpException {
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            if (this._getException != null) {
                this.updateCache();
            }
            if (this._getException == null) {
                LmpCtrlChannelModel[] lmpCtrlChannelModelArray = this._models.values().toArray(new LmpCtrlChannelModel[this._models.size()]);
                if (this.db.on()) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('=');
                    for (int i = 0; i < lmpCtrlChannelModelArray.length; ++i) {
                        stringBuffer.append(' ');
                        stringBuffer.append(lmpCtrlChannelModelArray[i].getIndex());
                    }
                    this.db.println(stringBuffer.toString());
                }
                return lmpCtrlChannelModelArray;
            }
            if (this._getException instanceof xLmpException) {
                throw new LmpException((xLmpException)this._getException);
            }
            throw NodeModelDelegate.doUnknown(this.db, "getCtrlChannels", this._getException);
        }
    }

    public void deleteCtrlChannel(int n) throws LmpException {
        try {
            this._delete.set(new Integer(n));
        }
        catch (xLmpException xLmpException2) {
            throw new LmpException(xLmpException2);
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "deleteCtrlChannel", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isControlChannel(int n) throws LmpException {
        HashMap hashMap = this._models;
        synchronized (hashMap) {
            for (LmpCtrlChannelModel lmpCtrlChannelModel : this._models.values()) {
                if (lmpCtrlChannelModel.getLocalPortId() != n) continue;
                return true;
            }
        }
        return false;
    }

    private void addCandidates(ArrayList arrayList, AbstractTermConnectionModel abstractTermConnectionModel) throws LmpException {
        Iterator iterator = abstractTermConnectionModel.getTerms().iterator();
        while (iterator.hasNext()) {
            int n = ((IOhTermModel)iterator.next()).getOpticalPortIndex();
            if (this.isControlChannel(n)) continue;
            arrayList.add(new Integer(n));
        }
    }

    public int[] getCandidates() throws LmpException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        this.addCandidates(arrayList, (AbstractTermConnectionModel)this.getNodeModel().getDccTermConnectionModel());
        this.addCandidates(arrayList, (AbstractTermConnectionModel)this.getNodeModel().getLdccTermConnectionModel());
        this.addCandidates(arrayList, (AbstractTermConnectionModel)this.getNodeModel().getGccTermConnectionModel());
        this.addCandidates(arrayList, (AbstractTermConnectionModel)this.getNodeModel().getOscTermConnectionModel());
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            nArray[n++] = (Integer)iterator.next();
        }
        return nArray;
    }

    void deleted(LmpCtrlChannelModel lmpCtrlChannelModel) {
        this.updateCache();
    }

    public static LmpCtrlChannelModels getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    public String toString() {
        return "LmpCtrlChannels#" + this.index;
    }

    private class Create
    extends NonCachedValue {
        public Create(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xLmpException {
            return new Integer(LmpCtrlChannelModels.this.getLmpMgrRef().createControlChannelEx((sControlChannelAttrsEx)object));
        }

        public Object outer() {
            return LmpCtrlChannelModels.this;
        }
    }

    private class Delete
    extends NonCachedValue {
        public Delete(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xLmpException {
            LmpCtrlChannelModels.this.getLmpMgrRef().deleteControlChannel((Integer)object);
        }

        public Object outer() {
            return LmpCtrlChannelModels.this;
        }
    }

    private class Get
    extends CachedValue {
        public Get(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xLmpException {
            return LmpCtrlChannelModels.this.getLmpMgrRef().getControlChannels();
        }

        public Object outer() {
            return LmpCtrlChannelModels.this;
        }
    }
}

