/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eEdAdminStateCmd;
import cerent.cms.idl.Common.sServiceState;
import cerent.cms.idl.Equipment.IModule;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqState;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sMfgData_2_01;
import cerent.cms.idl.Equipment.xInvalidState;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xNotSupportedOnEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IMfgData;
import cerent.cms.model.IServiceState;
import cerent.cms.model.InvalidState;
import cerent.cms.model.MfgDataHelper;
import cerent.cms.model.Model;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ServiceStateFactory;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.event.AttributeValue;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.util.SDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omg.CORBA.UserException;

public class MfgEntityModel
extends EntityModel
implements IMfgData {
    private MfgDataHelper mfgData = null;
    protected EqState eqState = new EqState("ModuleModel.eqState");
    protected AdminState adminState = new AdminState("ModuleModel.adminState");
    protected ServiceState serviceState = new ServiceState("ModuleModel.serviceState");
    protected InventoryCode inventoryCode = new InventoryCode("ModuleModel.inventoryCode");
    private InUse inUse = new InUse("ModuleModel.InUse");

    public MfgEntityModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        this(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(MfgEntityModel.class));
    }

    public MfgEntityModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2, SDebug sDebug) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, sDebug);
    }

    protected synchronized MfgDataHelper getMfgDataHelper() {
        if (this.mfgData == null) {
            this.mfgData = new MfgDataHelper(this.getIModuleRef(), this);
        }
        return this.mfgData;
    }

    protected IModule getIModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getIModuleRef();
    }

    public void setInventoryCode(String string) throws ProvisionError {
        try {
            this.inventoryCode.set(string);
        }
        catch (xProvisionError xProvisionError2) {
            throw new ProvisionError((UserException)xProvisionError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setInventoryCode", userException);
        }
    }

    public sMfgData_2_01 getMfgData() {
        return this.getMfgDataHelper().getMfgData();
    }

    public void setMfgData(sMfgData_2_01 sMfgData_2_012) {
        this.getMfgDataHelper().setMfgData(sMfgData_2_012);
    }

    public Map getExtraInfoMap() {
        return this.getMfgDataHelper().getExtraInfoMap();
    }

    public void setExtraInfoMap(Map map) {
        this.getMfgDataHelper().setExtraInfoMap(map);
    }

    public eEqState getState() throws AbstractCmsObjectNotExistException {
        try {
            return (eEqState)this.eqState.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getState", userException);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
            eEqState eEqState2 = (eEqState)this.eqState.getCachedValue();
            return eEqState2;
        }
    }

    public eAdminState getAdminStateEnum() throws AbstractCmsObjectNotExistException {
        try {
            return (eAdminState)this.adminState.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getAdminStateEnum", userException);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
            throw abstractCmsObjectNotExistException;
        }
    }

    public void setAdminState(eAdminState eAdminState2) throws InvalidState, UnsupportedOperation {
        try {
            this.adminState.set(eAdminState2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xNotSupportedOnEquipment xNotSupportedOnEquipment2) {
            throw new UnsupportedOperation((UserException)xNotSupportedOnEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setAdminState", userException);
        }
    }

    public sServiceState getServiceState() throws AbstractCmsObjectNotExistException {
        try {
            return (sServiceState)this.serviceState.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getServiceStateEnum", userException);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
            throw abstractCmsObjectNotExistException;
        }
    }

    public IServiceState getServiceSt() throws AbstractCmsObjectNotExistException {
        return ServiceStateFactory.getServiceState(this.getServiceState());
    }

    public int getAdminState() throws AbstractCmsObjectNotExistException {
        eAdminState eAdminState2 = this.getAdminStateEnum();
        return eAdminState2 == null ? -1 : eAdminState2.value();
    }

    public boolean isInUse() throws AbstractCmsObjectNotExistException {
        try {
            return (Boolean)this.inUse.get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getAdminStateEnum", userException);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
            throw abstractCmsObjectNotExistException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resurrect() {
        Map.Entry entry2;
        ArrayList arrayList;
        Serializable serializable3;
        TreeMap treeMap;
        Serializable serializable2;
        TreeSet<EntityModel> treeSet = new TreeSet<EntityModel>(comparator);
        ArrayList<EntityModel> arrayList2 = new ArrayList<EntityModel>();
        treeSet.add(this);
        arrayList2.add(this);
        while (arrayList2.size() > 0) {
            serializable2 = (EntityModel)arrayList2.remove(0);
            treeMap = ((EntityModel)serializable2).children;
            synchronized (treeMap) {
                for (Serializable serializable3 : ((EntityModel)serializable2).children) {
                    treeSet.add((EntityModel)serializable3);
                    arrayList2.add((EntityModel)serializable3);
                }
            }
        }
        serializable2 = new TreeSet(new EntityModel.ChildComparator());
        ((TreeSet)serializable2).addAll(treeSet);
        treeMap = ((TreeSet)serializable2).iterator();
        while (treeMap.hasNext()) {
            arrayList = (EntityModel)treeMap.next();
            arrayList.setChanged();
            arrayList.notifyObservers(ModelUpdateType.DELETED);
        }
        treeMap = new TreeMap(new EntityModel.ParentComparator());
        arrayList = null;
        serializable3 = new TreeSet(new EntityModel.ParentComparator());
        ((TreeSet)serializable3).addAll(treeSet);
        Iterator iterator = ((TreeSet)serializable3).iterator();
        while (iterator.hasNext()) {
            entry2 = (EntityModel)iterator.next();
            EntityModel entityModel = ((EntityModel)((Object)entry2)).parent;
            if (entityModel == null) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(entry2);
            } else {
                ArrayList arrayList3 = (ArrayList)treeMap.get(entityModel);
                if (arrayList3 == null) {
                    arrayList3 = new ArrayList();
                    treeMap.put(entityModel, arrayList3);
                }
                arrayList3.add(entry2);
            }
            if (entry2 instanceof MfgEntityModel) {
                ((MfgEntityModel)((Object)entry2)).eqState.update();
            }
            ((Model)((Object)entry2)).init0();
        }
        if (arrayList != null) {
            iterator = this.node.getChassisModelsInstance();
            entry2 = arrayList.iterator();
            while (entry2.hasNext()) {
                ((ChassisModels)((Object)iterator)).addChassis((IChassisModel)entry2.next());
            }
        }
        for (Map.Entry entry2 : treeMap.entrySet()) {
            ((EntityModel)entry2.getKey()).sendUpdates((ArrayList)entry2.getValue());
        }
    }

    private void checkForStateChange(eEqState eEqState2) {
        block6: {
            try {
                eEqState eEqState3 = this.getState();
                if (eEqState2 != eEqState3) {
                    if (eEqState3 == eEqState.DELETED) {
                        this.deleteLocal();
                        this.updateStructure();
                    } else if (eEqState2 == eEqState.DELETED) {
                        this.resurrect();
                    }
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.db.on) break block6;
                SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
            }
        }
    }

    protected void changedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        ArrayList arrayList = objectMessageInfo.getChangedValues();
        if (arrayList.isEmpty()) {
            eEqState eEqState2 = this.getState();
            this.updateLocal();
            this.checkForStateChange(eEqState2);
        } else {
            for (AttributeValue attributeValue : arrayList) {
                switch (attributeValue.getName()) {
                    case 0: {
                        this.serviceState.setValueExternally(attributeValue.getValue());
                    }
                }
            }
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        }
    }

    protected void deletedReceived(CmsObservable cmsObservable, ObjectMessageInfo objectMessageInfo) {
        block2: {
            super.deletedReceived(cmsObservable, objectMessageInfo);
            try {
                eEqState eEqState2 = this.getState();
                this.eqState.update();
                this.checkForStateChange(eEqState2);
            }
            catch (Exception exception) {
                if (!this.db.on) break block2;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    protected void updateLocal() {
        this.getMfgDataHelper().update();
        this.eqState.update();
        this.adminState.update();
        this.serviceState.update();
        this.inUse.update();
        this.setChanged();
        super.updateLocal();
    }

    public void dispose() {
        if (this.mfgData != null) {
            this.mfgData.dispose();
        }
        this.eqState.dispose();
        this.adminState.dispose();
        this.serviceState.dispose();
        this.inUse.dispose();
        super.dispose();
    }

    public String getLocation() {
        String string = this.getNodeModel().isMultishelf() ? this.getShelfId() + "-" : "";
        string = string + "Chassis";
        if (this.node.getPlatform().getFanCount() > 1 && EntityModel.eqType2Name(this.getNodeModelDelegate().getTDMTerminology(), this.getEqType()).equals("FAN_TRAY")) {
            string = "Fan_Slot_" + this.getPositionInParent();
        }
        if (this.getNodeModel().isMultishelf()) {
            IChassisModel iChassisModel = this.getChassis();
            string = string + " " + iChassisModel.getRackLocation();
        }
        return string;
    }

    public String toString() {
        return "MfgEntityModel[" + this.toShortString() + "]";
    }

    private class AdminState
    extends CachedValue {
        public AdminState(String string) {
            super(MfgEntityModel.this.node, string);
        }

        protected void setValue(Object object) throws xNotSupportedOnEquipment, xInvalidState, xWrongEquipmentType, xNoSuchEquipment {
            eAdminState eAdminState2 = (eAdminState)object;
            MfgEntityModel.this.getIModuleRef().setAdminState(MfgEntityModel.this.entityIndex, eAdminState2, eEdAdminStateCmd.EDSTATE_ED);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return MfgEntityModel.this.getIModuleRef().getAdminState(MfgEntityModel.this.entityIndex);
        }
    }

    private class EqState
    extends CachedValue {
        public EqState(String string) {
            super(MfgEntityModel.this.node, string);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return MfgEntityModel.this.getIModuleRef().state(MfgEntityModel.this.entityIndex);
        }
    }

    private class InUse
    extends CachedValue {
        private InUse(String string) {
            super(MfgEntityModel.this.node, string);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return MfgEntityModel.this.getIModuleRef().inUse(MfgEntityModel.this.entityIndex);
        }
    }

    private class InventoryCode
    extends NonCachedValue {
        public InventoryCode(String string) {
            super(MfgEntityModel.this.node, string);
        }

        protected void setValue(Object object) throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            MfgEntityModel.this.getIModuleRef().setInventoryCode(MfgEntityModel.this.entityIndex, (String)object);
        }

        protected Object getValue() throws UserException {
            return MfgEntityModel.this.getIModuleRef().mfgData_2_01(MfgEntityModel.this.entityIndex);
        }
    }

    class ServiceState
    extends CachedValue {
        public ServiceState(String string) {
            super(MfgEntityModel.this.node, string);
        }

        protected Object getValue() throws xWrongEquipmentType, xNoSuchEquipment {
            return MfgEntityModel.this.getIModuleRef().serviceState(MfgEntityModel.this.entityIndex);
        }
    }
}

