/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.ModelSingletonCollection;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.SDebug;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSingletonFactory<E> {
    protected Class<E> c;
    protected Constructor<E> ctor;
    protected ModelSingletonCollection singletons;
    private static String PREFIX = "com.cisco.";
    private static final int COM_CISCO_CTC_LEN = PREFIX.length();
    private static SDebug db = new SDebug("NodeSingletonFactory");

    public static String getPlatformKey(Class clazz) {
        int n;
        String string = "";
        String string2 = clazz.getName();
        if (string2.startsWith(PREFIX)) {
            n = string2.indexOf(".", COM_CISCO_CTC_LEN);
            if (n < 0) {
                throw new IllegalArgumentException("Platform specific class " + string2 + " must have a dot after the package prefix: " + PREFIX);
            }
        } else {
            throw new IllegalArgumentException("Platform specific class " + string2 + " must start with package name: " + PREFIX);
        }
        string = string2.substring(COM_CISCO_CTC_LEN, n);
        return string;
    }

    protected NodeSingletonFactory() {
    }

    public NodeSingletonFactory(String string, Class<E> clazz) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("key must be a non-zero length string");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("class must be non-null");
        }
        this.c = clazz;
        this.initSingletons(string);
        this.initCtor();
    }

    public NodeSingletonFactory(Class<E> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("class must be non-null");
        }
        this.c = clazz;
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        String string2 = string.substring(n + 1);
        this.initSingletons(string2);
        this.initCtor();
    }

    protected void initCtor() {
        try {
            this.ctor = this.c.getDeclaredConstructor(NodeModelDelegate.class);
            this.ctor.setAccessible(true);
        }
        catch (Exception exception) {
            this.handleException("cannot find a 1-arg NMD ctor for " + this.c, exception);
            throw new IllegalArgumentException(exception);
        }
    }

    private void initSingletons(String string) {
        this.singletons = ModelSingletonCollection.getMSCInstanceByName((String)string);
    }

    protected E newInstance(NodeModelDelegate nodeModelDelegate) throws Exception {
        return this.ctor.newInstance(nodeModelDelegate);
    }

    protected void handleException(String string, Exception exception) {
        if (db.on()) {
            db.println("Handling error: " + string);
            SDebug.printStackTrace((Throwable)exception);
        }
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getInstance(NodeModelDelegate nodeModelDelegate) {
        E e = null;
        Class<E> clazz = this.c;
        synchronized (clazz) {
            e = this.c.cast(this.singletons.get((Object)nodeModelDelegate));
            if (e == null && !nodeModelDelegate.isDestroyed()) {
                try {
                    e = this.newInstance(nodeModelDelegate);
                    this.singletons.add((Object)nodeModelDelegate, e);
                }
                catch (Exception exception) {
                    this.handleException("error creating node singleton instance of " + this.c + " for node: " + nodeModelDelegate.getName(), exception);
                }
            }
        }
        return e;
    }
}

