/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetMedia.eOverheadChannelType;
import cerent.cms.idl.SonetTopology.OverheadFactory;
import cerent.cms.idl.SonetTopology.OverheadTermination;
import cerent.cms.idl.SonetTopology.sOverheadTermItem;
import cerent.cms.model.ConnectionModel;
import cerent.cms.model.Connections;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.OhAbstractConnections;
import cerent.cms.model.OhConnectionModelsDelegate;
import cerent.cms.model.OhIpTunnelTermModel;
import cerent.cms.model.OhTermModel;
import java.util.ArrayList;
import java.util.List;
import org.omg.CORBA.UserException;

public class OhTerms
extends OhAbstractConnections {
    private static final String MY_DEBUG_KEY = "OhTerms";
    GetOhTermItems getOhTermItems;
    GetConnectionObjIndex getConnectionObjIndex;

    public OhTerms(OhConnectionModelsDelegate ohConnectionModelsDelegate) {
        super(ohConnectionModelsDelegate, MY_DEBUG_KEY);
        this.getOhTermItems = new GetOhTermItems(this.node, "OhTerms.GetOhTermItems");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "OhTerms.getConnectionObjIndex");
    }

    public ObjectType getObjectType() {
        return ObjectType.ObjectOverheadTermList;
    }

    protected OverheadFactory getOverheadFactoryRef() {
        return ((OhConnectionModelsDelegate)this.node.getOhConnectionModels()).getOverheadFactoryRef();
    }

    protected Object[] getConnectionItems() {
        try {
            return (Object[])this.getOhTermItems.get();
        }
        catch (UserException userException) {
            throw NodeModelDelegate.doUnknown(this.db, "getConnectionItems", userException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getIdlObjIdx(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof sOverheadTermItem) {
            return new Integer(((sOverheadTermItem)object).objIndex);
        }
        if (object instanceof OverheadTermination) {
            Integer n = null;
            try {
                OhTerms ohTerms = this;
                synchronized (ohTerms) {
                    n = (Integer)this.getConnectionObjIndex.get(object);
                }
            }
            catch (UserException userException) {
                OhAbstractConnections.ConnDebug.printStackTrace((Throwable)userException);
            }
            return n;
        }
        throw new IllegalArgumentException("The idlConn needs to be either sOverheadTermItem or OverheadTermination objects");
    }

    protected ConnectionModel createConnectionModel(NodeModelDelegate nodeModelDelegate, Object object) {
        if (object instanceof OverheadTermination) {
            return this.createTermModel(nodeModelDelegate, (OverheadTermination)object);
        }
        if (object instanceof sOverheadTermItem) {
            return this.createTermModelFromItem(nodeModelDelegate, (sOverheadTermItem)object);
        }
        throw new IllegalStateException("Unknown idlConnection object");
    }

    private ConnectionModel createTermModel(NodeModelDelegate nodeModelDelegate, OverheadTermination overheadTermination) {
        if (overheadTermination.term().channel.type == eOverheadChannelType.SDCC_IPTUNNEL) {
            return new OhIpTunnelTermModel(nodeModelDelegate, overheadTermination, (Connections)this);
        }
        return new OhTermModel(nodeModelDelegate, overheadTermination, (Connections)this);
    }

    private ConnectionModel createTermModelFromItem(NodeModelDelegate nodeModelDelegate, sOverheadTermItem sOverheadTermItem2) {
        if (sOverheadTermItem2.term.channel.type == eOverheadChannelType.SDCC_IPTUNNEL) {
            return new OhIpTunnelTermModel(nodeModelDelegate, sOverheadTermItem2, (Connections)this);
        }
        return new OhTermModel(nodeModelDelegate, sOverheadTermItem2, (Connections)this);
    }

    public List getNonDccTermModels(IChassisModel iChassisModel) {
        ArrayList<OhTermModel> arrayList = new ArrayList<OhTermModel>();
        int n = iChassisModel.getShelfId();
        for (OhTermModel ohTermModel : this.cloneConnectionModels().values()) {
            int n2 = ohTermModel.getChannelType();
            if (n2 == 0 || n2 == 4 || n2 == 10 || ohTermModel.getShelfId() != n) continue;
            arrayList.add(ohTermModel);
        }
        return arrayList;
    }

    protected class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) {
            int n = ((OverheadTermination)object).objIndex();
            return new Integer(n);
        }

        public Object outer() {
            return OhTerms.this;
        }
    }

    private class GetOhTermItems
    extends NonCachedValue {
        public GetOhTermItems(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue() {
            return OhTerms.this.getOverheadFactoryRef().overheadTermItemList();
        }

        public Object outer() {
            return OhTerms.this;
        }
    }
}

