/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Equipment.PassiveModule;
import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.Equipment.sPassiveUnitPosition;
import cerent.cms.idl.Equipment.sShelfPosition;
import cerent.cms.idl.Equipment.xNoSuchEquipment;
import cerent.cms.idl.Equipment.xWrongEquipmentType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.OpticsTopology.sOpticalPatchCord;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ChassisModels;
import cerent.cms.model.EntityTableModel;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IChassisModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IShelfViewModel;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.OpticsPortModel;
import cerent.cms.model.PassiveChassisModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.model.event.ObjectMessageInfoFactory;
import cerent.util.SDebug;
import cerent.util.view.fv.helper.OpticalPatchCord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.StringTokenizer;
import org.omg.CORBA.UserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PassiveModuleModel
extends ModuleModel {
    private DescriptionCV descriptionCV;
    private PositionCV positionCV;
    private PassiveChassisModel container;
    private sShelfPosition myLastPos;
    private static final String DESCR = "DESCR";
    private static final String COMP = "COMP";
    private static final String TYPE = "TYPE";
    private static final String SIZE = "SIZE";
    private static final String NSLOTS = "NSLOTS";
    private static final String MSLOTS = "MSLOTS";

    public PassiveModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2, nodeModelDelegate.getChildDebug(PassiveModuleModel.class));
        this.descriptionCV = new DescriptionCV(this.node, "PassiveModuleModel.description");
        this.positionCV = new PositionCV(this.node, "PassiveModuleModel.position");
    }

    @Override
    public void init() {
        super.init();
        try {
            ChassisModels chassisModels = this.node.getChassisModelsInstance();
            sPassiveUnitPosition sPassiveUnitPosition2 = this.getPosition();
            short s = (short)this.getEntityIndex();
            short s2 = this.getRUOccupied();
            short s3 = this.getNumberOfSlots();
            boolean bl = this.isInnerUnit();
            Object object = chassisModels.getChassisByPosition(sPassiveUnitPosition2.rackNumber, sPassiveUnitPosition2.positionInRack);
            if ((object == null || !(object instanceof PassiveChassisModel)) && bl) {
                for (IShelfViewModel iShelfViewModel : chassisModels.getShelfViewModels()) {
                    if (!(iShelfViewModel instanceof PassiveChassisModel) || !this.hasPassiveContainer((PassiveChassisModel)iShelfViewModel) || ((PassiveChassisModel)iShelfViewModel).getInnerChild() != null) continue;
                    object = iShelfViewModel;
                    break;
                }
            }
            if (object == null || !(object instanceof PassiveChassisModel)) {
                chassisModels.provisionShelf(s, sPassiveUnitPosition2.rackNumber, sPassiveUnitPosition2.positionInRack, s2, s3, eEqType.PASSIVE_CHASSIS);
                object = chassisModels.getShelfViewByShelfId(s);
            }
            Object object2 = (PassiveChassisModel)object;
            if (bl) {
                if (((PassiveChassisModel)object2).getInnerChild() != null) {
                    chassisModels.provisionShelf(s, sPassiveUnitPosition2.rackNumber, (short)0, s2, s3, eEqType.PASSIVE_CHASSIS);
                    object2 = (PassiveChassisModel)chassisModels.getShelfViewByShelfId(s);
                    sPassiveUnitPosition2.slotNumber = 1;
                }
            } else if (sPassiveUnitPosition2.slotNumber <= 0 || sPassiveUnitPosition2.slotNumber > ((PassiveChassisModel)object2).getNumberOfSlots() || ((PassiveChassisModel)object2).getChildOfSlotNumber(sPassiveUnitPosition2.slotNumber) != null) {
                int n = 0;
                for (int i = 1; i <= ((PassiveChassisModel)object2).getNumberOfSlots(); ++i) {
                    if (((PassiveChassisModel)object2).getChildOfSlotNumber(i) != null) continue;
                    sPassiveUnitPosition2.slotNumber = (short)i;
                    n = 1;
                    break;
                }
                if (n == 0) {
                    chassisModels.provisionShelf(s, sPassiveUnitPosition2.rackNumber, (short)0, s2, s3, eEqType.PASSIVE_CHASSIS);
                    object2 = (PassiveChassisModel)chassisModels.getShelfViewByShelfId(s);
                    sPassiveUnitPosition2.slotNumber = 1;
                }
            }
            this.myLastPos = ((PassiveChassisModel)object2).getInternalPosition();
            this.setPosition(this.myLastPos.rackNumber, this.myLastPos.positionInRack, sPassiveUnitPosition2.slotNumber);
            this.container = object2;
            this.container.update((Observable)((Object)this), 2);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
    }

    private boolean hasPassiveContainer(PassiveChassisModel passiveChassisModel) {
        eEqType[] eEqTypeArray;
        for (eEqType eEqType2 : eEqTypeArray = PassiveModuleModel.getPassiveContainesEqTypeArray()) {
            if (passiveChassisModel.getChildOfEqType(eEqType2) == null) continue;
            return true;
        }
        return false;
    }

    public String getDescription() throws NoSuchInterface {
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(DESCR);
        return string != null ? string : "";
    }

    public void setDescription(String string) throws NoSuchEquipment {
        Map<String, String> map = this.getDescriptionMap();
        map.put(DESCR, string);
        this.setDescriptionMap(map);
    }

    public String getDCUCompensation() throws NoSuchInterface {
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(COMP);
        return string != null ? string + " ps/nm" : "";
    }

    public void setDCUCompensation(String string) throws NoSuchEquipment {
        Map<String, String> map = this.getDescriptionMap();
        map.put(COMP, string);
        this.setDescriptionMap(map);
    }

    private short getRUOccupied() {
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 != eEqType.MECH_UNIT) {
            return PassiveChassisModel.getRUOccupied(eEqType2);
        }
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(SIZE);
        return string != null ? Short.parseShort(string) : (short)1;
    }

    private short getNumberOfSlots() {
        eEqType eEqType2 = this.getEqTypeEnum();
        if (eEqType2 != eEqType.MECH_UNIT) {
            return (short)PassiveChassisModel.getNumberOfSlots(eEqType2);
        }
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(MSLOTS);
        return string != null ? Short.parseShort(string) : (short)1;
    }

    private Map<String, String> getDescriptionMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String string = (String)this.descriptionCV.get();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
                if (!stringTokenizer2.hasMoreTokens()) continue;
                String string2 = stringTokenizer2.nextToken();
                String string3 = "";
                if (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                } else {
                    string3 = string2;
                    string2 = DESCR;
                }
                hashMap.put(string2, string3);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return hashMap;
    }

    private void setDescriptionMap(Map<String, String> map) throws NoSuchEquipment {
        try {
            this.descriptionCV.set(PassiveModuleModel.formatMap(map));
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPosition", userException);
        }
    }

    private static String formatMap(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    private sPassiveUnitPosition getPosition() throws NoSuchEquipment {
        try {
            return (sPassiveUnitPosition)this.positionCV.get();
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPosition", userException);
        }
    }

    public int getSlotPosition() {
        try {
            return this.getPosition().slotNumber;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void setPosition(short s, short s2, short s3) throws NoSuchEquipment {
        try {
            sPassiveUnitPosition sPassiveUnitPosition2 = this.getPosition();
            if (sPassiveUnitPosition2.rackNumber != s || sPassiveUnitPosition2.positionInRack != s2 || sPassiveUnitPosition2.slotNumber != s3) {
                sPassiveUnitPosition2 = new sPassiveUnitPosition(s, s2, s3);
                this.positionCV.set(sPassiveUnitPosition2);
            }
        }
        catch (xNoSuchEquipment xNoSuchEquipment2) {
            throw new NoSuchEquipment((UserException)xNoSuchEquipment2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPosition", userException);
        }
    }

    public static eEqType[] getPassiveEqTypeArray() {
        return new eEqType[]{eEqType.PASSIVE_MD_40_EVEN, eEqType.PASSIVE_MD_40_ODD, eEqType.PASSIVE_MD_ID_50, eEqType.PASSIVE_DCU, eEqType.PASSIVE_PP_4_SMR, eEqType.PASSIVE_PP_MESH_4, eEqType.PASSIVE_PP_MESH_8};
    }

    private static eEqType[] getMechUnitsEqTypeArray() {
        return new eEqType[]{eEqType.MECH_UNIT};
    }

    public static eEqType[] getPassiveNoInnersEqTypeArray() {
        return new eEqType[]{eEqType.PASSIVE_MD_40_EVEN, eEqType.PASSIVE_MD_40_ODD, eEqType.PASSIVE_DCU, eEqType.PASSIVE_PP_4_SMR, eEqType.PASSIVE_PP_MESH_4, eEqType.PASSIVE_PP_MESH_8};
    }

    public static eEqType[] getPassiveContainesEqTypeArray() {
        return new eEqType[]{eEqType.PASSIVE_MD_40_EVEN, eEqType.PASSIVE_MD_40_ODD};
    }

    public static PassiveModuleModel getPassiveUnitById(NodeModelDelegate nodeModelDelegate, int n) {
        IChassisModel iChassisModel = nodeModelDelegate.getChassisModelsInstance().getChassisByShelfId(1);
        List list = iChassisModel.getChildren();
        for (IEntityModel iEntityModel : list) {
            if (!(iEntityModel instanceof PassiveModuleModel) || ((PassiveModuleModel)iEntityModel).getID() != n) continue;
            return (PassiveModuleModel)iEntityModel;
        }
        return null;
    }

    public static PassiveModuleModel[] getPassiveUnitByType(NodeModelDelegate nodeModelDelegate, int n) {
        IChassisModel iChassisModel = nodeModelDelegate.getChassisModelsInstance().getChassisByShelfId(1);
        ArrayList<PassiveModuleModel> arrayList = new ArrayList<PassiveModuleModel>();
        List list = iChassisModel.getChildren();
        for (IEntityModel iEntityModel : list) {
            if (!(iEntityModel instanceof PassiveModuleModel) || ((PassiveModuleModel)iEntityModel).getEqType() != n) continue;
            arrayList.add((PassiveModuleModel)iEntityModel);
        }
        return arrayList.toArray(new PassiveModuleModel[0]);
    }

    public static boolean isEqTypeSupported(eEqType eEqType2) {
        for (eEqType eEqType3 : PassiveModuleModel.getPassiveEqTypeArray()) {
            if (!eEqType3.equals(eEqType2)) continue;
            return true;
        }
        for (eEqType eEqType3 : PassiveModuleModel.getMechUnitsEqTypeArray()) {
            if (!eEqType3.equals(eEqType2)) continue;
            return true;
        }
        return false;
    }

    public static void provisionPassiveModule(EntityTableModel entityTableModel, int n, eEqType eEqType2, String string, short s, short s2, boolean bl, short s3, short s4, short s5, short s6) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (eEqType2 == eEqType.MECH_UNIT) {
            if (string == null || string.length() == 0) {
                throw new Exception("A description is required for generic mechanical unit");
            }
            hashMap.put(TYPE, string);
        } else if (string != null) {
            hashMap.put(DESCR, string);
        }
        if (s3 > 1) {
            hashMap.put(SIZE, Short.toString(s3));
        }
        if (s4 > 1) {
            hashMap.put(MSLOTS, Short.toString(s4));
        }
        if (s6 > 1) {
            hashMap.put(NSLOTS, Short.toString(s6));
        }
        s2 = bl ? ChassisModels.convertToRelativeRackPosition(s2) : ChassisModels.convertToRUPosition(s2);
        entityTableModel.provisionPassiveModule(n, eEqType2, PassiveModuleModel.formatMap(hashMap), s, s2, s5);
    }

    @Override
    public int getShelfId() {
        return 0;
    }

    @Override
    public int getSlot() {
        return 0;
    }

    @Override
    public boolean isResettable() {
        return false;
    }

    @Override
    public int getID() {
        return this.getPositionInParent() - 32;
    }

    public String getIDString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getID());
        if (this.container != null && this.node.isMultishelf()) {
            stringBuilder.append(" ");
            stringBuilder.append(this.container.getRackLocation());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getLocation() {
        return "Unit-" + this.getIDString();
    }

    @Override
    public String getEqLabel() {
        if (this.getEqTypeEnum() != eEqType.MECH_UNIT) {
            return super.getEqLabel();
        }
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(TYPE);
        return string != null ? string : "Mechanical Unit";
    }

    @Override
    public String getEqTypeName() {
        if (this.getEqTypeEnum() != eEqType.MECH_UNIT) {
            return super.getEqTypeName();
        }
        Map<String, String> map = this.getDescriptionMap();
        String string = map.get(TYPE);
        return string != null ? string : "Mechanical Unit";
    }

    public String getChassisLocation() {
        short s;
        if (this.container != null && this.node.isMultishelf() && (s = this.container.getRackNumber()) != 0) {
            return "Rack " + s + ", Pos. " + this.container.getRackPosition();
        }
        return "N/A";
    }

    public String getExtraInfo() {
        if (this.getEqType() == 312) {
            try {
                return this.getDCUCompensation();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        portModelArray = OpticsPortModel.isPortSupported(eEqType2) ? this.getChildrenOfType(eEqType2).toArray(new OpticsPortModel[0]) : super.getPortModels(eEqType2);
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    @Override
    public boolean isOpticsCard() {
        return true;
    }

    public OpticsPortModel[] getOpticsChildren() {
        ArrayList<PortModel> arrayList = new ArrayList<PortModel>();
        for (eEqType eEqType2 : OpticsPortModel.getSupportePortTypes()) {
            arrayList.addAll(Arrays.asList(this.getPortModels(eEqType2)));
        }
        return arrayList.toArray(new OpticsPortModel[0]);
    }

    protected PassiveModule getPassiveModuleRef() {
        return this.getNodeModelDelegate().getIorRepository().getPassiveModuleRef();
    }

    @Override
    public String toString() {
        return "Passive" + super.toString() + " @ [R" + this.myLastPos.rackNumber + ",P" + this.myLastPos.positionInRack + "]";
    }

    @Override
    public boolean isPassiveModule() {
        return true;
    }

    public boolean isInnerUnit() {
        return this.getEqType() == 310;
    }

    @Override
    public sOpticalPatchCord[] getDWDMPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        NodeModelDelegate nodeModelDelegate = this.getNodeModelDelegate();
        if (this.parent != null) {
            int n = this.parent.getIndex();
            return nodeModelDelegate.getOpticalPatchCordModel().getOptLinkModelByCard(new Integer(n));
        }
        return null;
    }

    @Override
    public OpticalPatchCord[] getAllOpticalPatchCords() throws NumberFormatException, FeatureUnsupported, NoSuchInterface {
        sOpticalPatchCord[] sOpticalPatchCordArray = this.getDWDMPatchCords();
        OpticalPatchCord[] opticalPatchCordArray = new OpticalPatchCord[sOpticalPatchCordArray.length];
        for (int i = 0; i < sOpticalPatchCordArray.length; ++i) {
            sOpticalPatchCord sOpticalPatchCord2 = sOpticalPatchCordArray[i];
            int n = sOpticalPatchCord2.type.value();
            int n2 = sOpticalPatchCord2.creationType.value();
            int n3 = sOpticalPatchCord2.bandId.value();
            opticalPatchCordArray[i] = new OpticalPatchCord(sOpticalPatchCord2.creationTime, sOpticalPatchCord2.index, sOpticalPatchCord2.from, sOpticalPatchCord2.to, n, n2, n3, sOpticalPatchCord2.lambda.value());
        }
        return opticalPatchCordArray;
    }

    @Override
    public void dispose() {
        if (this.container != null) {
            this.container.update((Observable)((Object)this), 0);
        }
        this.descriptionCV.dispose();
        this.positionCV.dispose();
        super.dispose();
    }

    @Override
    protected void updateLocal() {
        if (this.db.on()) {
            this.db.println("updateLocal(): entry");
        }
        sShelfPosition sShelfPosition2 = this.container.getInternalPosition();
        boolean bl = this.myLastPos.rackNumber != sShelfPosition2.rackNumber || this.myLastPos.positionInRack != sShelfPosition2.positionInRack;
        this.descriptionCV.update();
        this.positionCV.update();
        super.updateLocal();
        if (bl) {
            this.myLastPos = sShelfPosition2;
            OpticsPortModel[] opticsPortModelArray = this.getOpticsChildren();
            ObjectMessageInfo objectMessageInfo = ObjectMessageInfoFactory.getObjectMessageInfo(this.node, ObjectType.ObjectNone, this.entityIndex, ObjectType.ObjectNone, this.entityIndex, this.entityIndex, eUpdateType.ObjectChangedMsg, 0L, 0L);
            for (OpticsPortModel opticsPortModel : opticsPortModelArray) {
                opticsPortModel.update((Observable)((Object)this), objectMessageInfo);
            }
        }
        if (this.db.on()) {
            this.db.println("updateLocal(): exit");
        }
    }

    @Override
    protected boolean isProtectionStateSupported() {
        return false;
    }

    private class DescriptionCV
    extends CachedValue {
        private DescriptionCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            return PassiveModuleModel.this.getPassiveModuleRef().description(PassiveModuleModel.this.entityIndex);
        }

        protected void setValue(Object object) throws xWrongEquipmentType, xNoSuchEquipment {
            String string = (String)object;
            PassiveModuleModel.this.getPassiveModuleRef().setDescription(PassiveModuleModel.this.entityIndex, string);
        }
    }

    private class PositionCV
    extends CachedValue {
        private PositionCV(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xProvisionError, xWrongEquipmentType, xNoSuchEquipment {
            return PassiveModuleModel.this.getPassiveModuleRef().position(PassiveModuleModel.this.entityIndex);
        }

        protected void setValue(Object object) throws xWrongEquipmentType, xNoSuchEquipment {
            sPassiveUnitPosition sPassiveUnitPosition2 = (sPassiveUnitPosition)object;
            PassiveModuleModel.this.getPassiveModuleRef().setPosition(PassiveModuleModel.this.entityIndex, sPassiveUnitPosition2);
        }
    }
}

